
#include <poly_spline.h>

static int clip_minx = 0, clip_miny = 0, clip_maxx = 319, clip_maxy = 199;

//
//	Bresenham's line with Sutherland-Cohen's clipping algorithm 
//

enum sc_clipping_region_bitmask {
	CLIP_INSIDE = 0,
	CLIP_TOP = 1,
	CLIP_BOTTOM = 2,
	CLIP_LEFT = 4,
	CLIP_RIGHT = 8
};


inline unsigned sc_clipregmask( int x, int y )
{
        unsigned mask = CLIP_INSIDE;
        if ( y > clip_maxy )
             mask = CLIP_TOP;
        else if ( y < clip_miny )
	     mask = CLIP_BOTTOM;
	if ( x > clip_maxx )
	     mask |= CLIP_RIGHT;
	else if ( x < clip_minx )
	     mask |= CLIP_LEFT;
	return mask;
}

void alpha_sc_line( int x1, int y1, int x2, int y2, int32 c, ZBUF *buf, int32 *area )
{
	int x, y;
	int len, ack = 0;

	unsigned mask1 = sc_clipregmask( x1, y1 );
	unsigned mask2 = sc_clipregmask( x2, y2 );

	while ( 1 ) {

	      if ( (mask1 == CLIP_INSIDE) && (mask2 == CLIP_INSIDE) ) {
		   ack = 1;
		   break;
	      } else if ( (mask1 & mask2) != CLIP_INSIDE )
		   break;
	      else {
		   unsigned m = mask1 != CLIP_INSIDE ? mask1 : mask2;
		   if ( m & CLIP_TOP ) {
			x = x1+(x2-x1)*(clip_maxy-y1)/(y2-y1);
			y = clip_maxy;
		   } else if ( m & CLIP_BOTTOM ) {
			x = x1+(x2-x1)*(clip_miny-y1)/(y2-y1);
                        y = clip_miny;
                   } else if ( m & CLIP_RIGHT ) {
                        x = clip_maxx;
			y = y1+(y2-y1)*(clip_maxx-x1)/(x2-x1);
		   } else if ( m & CLIP_LEFT ) {
			x = clip_minx;
			y = y1+(y2-y1)*(clip_minx-x1)/(x2-x1);
		   }

		   if ( m == mask1 )
			mask1 = sc_clipregmask( x1 = x, y1 = y );
		   else
			mask2 = sc_clipregmask( x2 = x, y2 = y );
	      }
	}

	if ( !ack )
	     return;

	int d, xi1, xi2, yi1, yi2, di1, di2;
	int dtx = abs(x2-x1);
	int dty = abs(y2-y1);

	if ( dtx < dty ) {
		len = dty+1;
		di1 = dtx<<1;
		di2 = (dtx-dty)<<1;
		d = di1-dty;
		xi1 = 0;
		yi1 = 320;
		xi2 = 1;
		yi2 = 320;
	} else {
		len = dtx+1;
		di1 = dty<<1;
		di2 = (dty-dtx)<<1;
		d = di1-dtx;
		xi1 = 1;
		yi1 = 0;
		xi2 = 1;
		yi2 = 320;
	}

	if ( x1 > x2 ) {
		xi1 = -xi1;
		xi2 = -xi2;
	}

	if ( y1 > y2 ) {
		yi1 = -yi1;
		yi2 = -yi2;
	}

	x = x1;
	y = y1*320;

	while ( len-- ) {

		area[y+x] = c;

		if ( d < 0 ) {
			d += di1;
			x += xi1;
			y += yi1;
		} else {
			d += di2;
			x += xi2;
			y += yi2;
		};
	}

}

//
//
//

/*void sc_polyline( const Poly_Point p[], int num, unsigned c, ZBUF *buffer )
{
        int i = 0;
        for ( int j = 1; j < num; j++ ) {
                sc_line( p[i].x, p[i].y, p[j].x, p[j].y, c, buffer, area );
                i = j;
        }
}

// 
//
//

void sc_polygon( const Poly_Point p[], int num, unsigned c, ZBUF *buffer )
{
        int i = 0;
        for ( int j = 1; j < num; j++ ) {
                sc_line( p[i].x, p[i].y, p[j].x, p[j].y, c, buffer );
                i = j;
        }
        sc_line( p[0].x, p[0].y, p[i].x, p[i].y, c, buffer );
}
*/
