
/*
 *
 * 	R E A L T I M E   R A Y T R A C E R	(shared header)
 *
 *		written by brioche of aspirine
 *			xdefrang@csi.com
 */

#ifndef _RAY_H_INCLUDED
#define _RAY_H_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <errno.h>

#include <ptc.h>

#define __QUADRATIC_SHORTCUT__
#define __MOTION_BLUR__

#ifndef M_PI
#define M_PI            3.14159f
#endif

#define INFINITE        (float)(1.0e+8)
#define SQR(x)		((x)*(x))

/*
 *
 *      B A S I C   R A Y T R A C I N G   S T U F F
 *
 */


typedef struct {
	float   x, y, z;
} VECTOR;

typedef struct {
	float   r, g, b;
} RGB;

typedef struct {
	VECTOR loc, dir;
} RAY;
				 
/*
 *
 *      M O D E L S
 *
 */

typedef enum {
	MDL_PLANE = 1,
	MDL_SPHERE = 2,
	MDL_ELLIPSOID = 3,
	MDL_PLANE_TEXT = 21,
	MDL_SPHERE_TEXT = 22,
	MDL_ELLIPSOID_TEXT = 23
} MODEL_ID;

typedef struct {
	MODEL_ID id;
	void     *model_info;
} MODEL;

typedef struct {
	float   A, B, C, D;
	RGB     color;
	float	reflect;
} MODEL_PLANE;

typedef struct {
	VECTOR  loc;
	float   rad;
	RGB     color;
	float	reflect;
} MODEL_SPHERE;

typedef struct {
	VECTOR  loc, exc;
	float   rad;
	RGB     color;
	float	reflect;
} MODEL_ELLIPSOID;

typedef struct {
	float   A, B, C, D;
	RGB     *texmap;
	float	reflect;
} MODEL_PLANE_TEXT;

typedef struct {
	VECTOR  loc;
	float   rad;
	RGB     *texmap;
	float	reflect;
} MODEL_SPHERE_TEXT;

typedef struct {
	VECTOR  loc, exc;
	float   rad;
	RGB     *texmap;
	float	reflect;
} MODEL_ELLIPSOID_TEXT;

/*
 *
 *      R E N D E R I N G   S T U F F
 *
 */

typedef enum {
	RND_STD = 0,
	RND_REFLECT = 1,
	RND_SHADOWS = 2
} RENDER_FLAGS;

typedef struct {
	int r, g, b;        
} GRID_ITEM;

typedef struct {
	int width, height, depth;
	float viewer_dist;
} VIEWPORT;

typedef struct camera {
	VECTOR  rvp, lap;
	float   roll;
} CAMERA;

/*
 *
 *      K E Y F R A M I N G   S T U F F
 *
 */

typedef struct key_float {
	int     obj;
	float   val;
} KEY_FLOAT;

typedef struct key_vector {
	int     obj;
	VECTOR  val;
} KEY_VECTOR;

typedef enum {
	KEY_CAM = 1,
	KEY_LOC = 2,
	KEY_RAD = 3,
	KEY_EXC = 4
} KEY_ID;

typedef struct key {
	KEY_ID id;
	float time;
	CAMERA cam;
} KEY;


typedef struct scene {
	unsigned flags;
	VECTOR light;
	CAMERA cam;
	int num_objects, num_keys, curr_key;
	MODEL *objects;
	KEY keys[10];
} SCENE;

/*
 *
 *      P R O T O T Y P E S
 *
 */

/* declared in render.c */
extern GRID_ITEM grid[81][36];

#ifdef __cplusplus
extern "C" {
#endif

/* vector.c */
float length( VECTOR *v );
float normalize( VECTOR *v );
float dotproduct( VECTOR *va, VECTOR *vb );
VECTOR crossproduct( VECTOR *va, VECTOR *vb );

/* loader.c */
RGB *load_texture( const  char *filename );
int load_scene( const char *filename, VIEWPORT *vp, SCENE *scn );
/* void unload_scene( SCENE *scn ); */

/* generic.c */
float model_distance( RAY ray, MODEL obj );
void model_hitnormal( MODEL obj, VECTOR hit, VECTOR *norm );
RGB model_hitcolor( MODEL obj, VECTOR hit, VECTOR norm );
float model_reflect( MODEL obj );

/* plane.c */
float plane_distance( RAY ray, MODEL_PLANE obj );
void plane_hitnormal( MODEL_PLANE obj, VECTOR hit, VECTOR *norm );
RGB plane_text_hitcolor( MODEL_PLANE_TEXT obj, VECTOR hit );

/* sphere.c */
float sphere_distance( RAY ray, MODEL_SPHERE obj );
void sphere_hitnormal( MODEL_SPHERE obj, VECTOR hit, VECTOR *norm );
RGB sphere_text_hitcolor( MODEL_SPHERE_TEXT obj, VECTOR norm );

/* ellipsd.c */
float ellipsoid_distance( RAY ray, MODEL_ELLIPSOID obj );
void ellipsoid_hitnormal( MODEL_ELLIPSOID obj, VECTOR hit, VECTOR *norm );
RGB ellipsoid_text_hitcolor( MODEL_ELLIPSOID_TEXT obj, VECTOR norm );

/* render.c */
void render( SCENE scn, VIEWPORT vp );

/* interp.c */
void interp_grid( unsigned int *buff );

/* keyf.c */

extern int end_of_track;

int keyf_load( const char *filename, SCENE *scn );
void keyf_init( SCENE *scn );
void keyf_update( SCENE *scn );

#ifdef __cplusplus
};
#endif

#endif /* _RAY_H_INCLUDED */

