
/*
 *
 *      C O R E   R A Y - T R A C I N G    E N G I N E
 *
 */

#include "ray.h"

GRID_ITEM grid[81][36];

static RGB trace_ray( SCENE scn, RAY ray, int rec_lvl )
{
        VECTOR hit, norm;
        RAY refray, lightray;
        float lightdist;
        RGB col, tmp_col;
        float rho;
        float dist, tmp_dist;
	float p, q;
        int i, index;

        /* find distance to closest intersected object  */

        dist = INFINITE;
        for( i = 0; i < scn.num_objects; i++ ) {
                tmp_dist = model_distance( ray, scn.objects[i] );
                if( (tmp_dist != INFINITE) && (tmp_dist < dist) ) {
                        dist = tmp_dist;
                        index = i;
                }
        }

        /* if ray is going out in space then terminate recursion */

        if( dist == INFINITE ) {
		col.r = col.g = col.b = 0.0f;
                return col;
	}
 	
        /* build hit ray */

        hit.x = ray.loc.x+dist*ray.dir.x;
        hit.y = ray.loc.y+dist*ray.dir.y;
        hit.z = ray.loc.z+dist*ray.dir.z;

        /* build light ray */

        lightray.loc = scn.light;
        lightray.dir.x = hit.x-scn.light.x;
        lightray.dir.y = hit.y-scn.light.y;
        lightray.dir.z = hit.z-scn.light.z;
        lightdist = normalize( &lightray.dir )-0.01f;

        model_hitnormal( scn.objects[index], hit, &norm );
        
        /* use angle between hitnormal and lightray as shading gradiant */

        rho = dotproduct( &norm, &lightray.dir );
	tmp_col = model_hitcolor( scn.objects[index], hit, norm ); 

	col.r = (rho*0.3f)+(tmp_col.r*0.7f);
        col.g = (rho*0.3f)+(tmp_col.g*0.7f);
        col.b = (rho*0.3f)+(tmp_col.b*0.7f);

	/* handle shadows */
        if( scn.flags & RND_SHADOWS ) {
                /* trace shadow - check if lightray collides with some other objects before it reaches my hitpoint... */
                for( i = 0; i < scn.num_objects; i++ ) {
                        tmp_dist = model_distance( lightray, scn.objects[i] );
                        if( tmp_dist < lightdist ) {
                                col.r *= 1.0f/1.6f;
                                col.g *= 1.0f/1.6f;
                                col.b *= 1.0f/1.6f;
                                break;
                        }
                }
        }
       
	/* handle reflections */
        if ( scn.flags & RND_REFLECT ) {

		if ( rec_lvl && (p = model_reflect( scn.objects[index] )) ) {       

                        /* build a reflection ray */
                        rho = 2.0f*dotproduct( &norm, &ray.dir );         
                        refray.dir.x = ray.dir.x-rho*norm.x;
                        refray.dir.y = ray.dir.y-rho*norm.y;
                        refray.dir.z = ray.dir.z-rho*norm.z;               
                        
                        /* set one unit away so we skip intercept with our self */
                        refray.loc.x = hit.x+refray.dir.x;
                        refray.loc.y = hit.y+refray.dir.y;
                        refray.loc.z = hit.z+refray.dir.z;
        
                        /* shoot reflection ray */
                        tmp_col = trace_ray( scn, refray, rec_lvl-1 );

			q = 1.0f-p;
                        col.r = (tmp_col.r*p)+(col.r*q);
                        col.g = (tmp_col.g*p)+(col.g*q);
                        col.b = (tmp_col.b*p)+(col.b*q);
                }
        }

        /* ray is traced and color is found */
        return col;
}

static unsigned clip_component( float c, unsigned max )
{
	if ( c > 1.0 )
		return max;
	else if ( c < 0.0 )
		return 0;
	else
		return (unsigned)(c*(float)max);
}

/*
 *	R E N D E R I N G   L O O P
 */

void render( SCENE scn, VIEWPORT vp )
{
        RAY ray;
        VECTOR vup, U, V, N, tmp;
	RGB col;
        int x, y;
        float mx, my, xt, yt;

        /* build camera viewing matrix (U,V,N) */
       
	mx = M_PI-scn.cam.roll; 
        xt = cos( mx );
        yt = sin( mx );

        vup.x = xt+yt;
        vup.y = xt-yt;
        vup.z = 0.0;

	if ( !N.x && !N.z ) {
		vup.x = -N.y;
		vup.y = vup.z = 0;
	} else {
		vup.y = 1.0;
		vup.x = vup.z = 0;
	}

/*
	vup.x = yt;
	vup.y = 0;
	vup.z = -xt;

	vup.x = vup.z = 1;
	vup.y = 0;

	vup.x = vup.z = 0;
	vup.y = -1;
*/
        N.x = scn.cam.rvp.x-scn.cam.lap.x;
        N.y = scn.cam.rvp.y-scn.cam.lap.y;
        N.z = scn.cam.rvp.z-scn.cam.lap.z;
        normalize( &N );

        U = crossproduct( &N, &vup );
        normalize( &U );

        V = crossproduct( &N, &U );

        /* origin of the ray according to camera */
        ray.loc.x = vp.viewer_dist*N.x+scn.cam.rvp.x;
        ray.loc.y = vp.viewer_dist*N.y+scn.cam.rvp.y;
        ray.loc.z = vp.viewer_dist*N.z+scn.cam.rvp.z;

	mx = vp.width*0.5f;
	my = vp.height*0.5f;
        for( y = 0; y < vp.height; y++ ) {

                /* precompute constant values for this line */
                yt = (float)(y)-my;

                tmp.x = yt*V.x+scn.cam.rvp.x;
                tmp.y = yt*V.y+scn.cam.rvp.y;
                tmp.z = yt*V.z+scn.cam.rvp.z;
                    
                for ( x = 0; x < vp.width; x++ ) {
                        
                        xt = (float)(x)-mx;
                
                        ray.dir.x = (xt*U.x+tmp.x)-ray.loc.x;
                        ray.dir.y = (xt*U.y+tmp.y)-ray.loc.y;
                        ray.dir.z = (xt*U.z+tmp.z)-ray.loc.z;
                        normalize( &ray.dir );
                         
                        col = trace_ray( scn, ray, 1 );

			grid[x][y].r = clip_component( col.r, 255 );
                        grid[x][y].g = clip_component( col.g, 255 );
                        grid[x][y].b = clip_component( col.b, 255 );
                }
        }
}
