
/*
 *
 *      M O D E L - S P H E R E
 *
 */

#include "ray.h"

float sphere_distance( RAY ray, MODEL_SPHERE obj )
{
        float B, C, D, sD, t, t0, t1;

        B = 2.0f * (ray.dir.x*(ray.loc.x-obj.loc.x)+ 
                    ray.dir.y*(ray.loc.y-obj.loc.y)+ 
                    ray.dir.z*(ray.loc.z-obj.loc.z));
        
        C = SQR(ray.loc.x-obj.loc.x)+
            SQR(ray.loc.y-obj.loc.y)+
            SQR(ray.loc.z-obj.loc.z)-SQR(obj.rad);
                
        D = SQR(B)-4*C;
        
        if ( D >= 0.0f ) {
                sD = sqrt( D );

#ifndef __QUADRATIC_SHORTCUT__
                t0 = (-B-sD)*0.5f;
                t1 = (-B+sD)*0.5f;
                
                if ( (t0 > 0) || (t1 > 0) ) {
                        t = INFINITE;

                        if ( t0 > 0 )
                                t = t0;
                        if ( (t1 < t0) && (t1 >= 0) )
                                t = t1;
                        
                        return t;
                }
#else
                return (t = (-B-sD)*0.5f) > 0.0 ? t : INFINITE;
#endif
        }
        
        return INFINITE;
}

void sphere_hitnormal( MODEL_SPHERE obj, VECTOR hit, VECTOR *norm )
{
        float tmp = 1.0f/obj.rad;
        norm->x = (obj.loc.x-hit.x)*tmp;
        norm->y = (obj.loc.y-hit.y)*tmp;
        norm->z = (obj.loc.z-hit.z)*tmp;
}

RGB sphere_text_hitcolor( MODEL_SPHERE_TEXT obj, VECTOR norm )
{
        float u, v;
        u = fabs(norm.z*0.2*256.0);
        v = fabs(atan2(norm.y,norm.x)*256.0/M_PI);
        return obj.texmap[(int)v*256+(int)u];
}
