
/*
 *
 *      V E C T O R   R O U T I N E S
 *
 */

#include "ray.h"

float length( VECTOR *v )
{
        return sqrt(SQR(v->x)+SQR(v->y)+SQR(v->z));
}

/* side-effect : returns length of the vector before being normalized */
float normalize( VECTOR *v )
{
        float k, p;
        if ( (k = length( v )) == 0.0f ) {
                v->x = v->y = v->z = 0.0f;
                return 0.0f;
        }
        p = 1.0f/k;
        v->x *= p;
        v->y *= p;
        v->z *= p;
        return k;
}

float dotproduct( VECTOR *va, VECTOR *vb )
{
        return va->x*vb->x + va->y*vb->y + va->z*vb->z;
}

VECTOR crossproduct( VECTOR *va, VECTOR *vb )
{
        VECTOR v;
        v.x = va->y*vb->z - va->z*vb->y;
        v.y = va->z*vb->x - va->x*vb->z;
        v.z = va->x*vb->y - va->y*vb->x;
        return v;
}
