#ifndef _SPLINES_H_
#define _SPLINES_H_

#include <math3d.h>

typedef struct { float x, y, z; } BSPLINE;

void _bspline( VERTEX *, int, int, BSPLINE *);

inline void _bspline( VERTEX *point, int POINTS, int STEPS, BSPLINE *bspline)
{
	int	bl_i;
	bl_i = 0;
	for( int k=1 ; k <= POINTS-2; k++) // note! start from 1, not 0 
	{
		float 	t , t2, t3, k1, k2, k3 ;

		t=0.0;

		while( t < 1.0 )
		{
			t2 = t*t; 	// some precalculation 
			t3 = t*t*t; 	// more precalculation :) 
	                k1 = 1-3*t+3*t2-t3; 
	                k2 = 4-6*t2+3*t3; 
	                k3 = 1+3*t+3*t2-3*t3; 
	                bspline[bl_i].x = 1/6.0*(k1*point[k-1].x+ 
	                		  k2*point[k].x+ 
	                        	  k3*point[k+1].x+ 
	                        	  t3*point[k+2].x); 
	                bspline[bl_i].y = 1/6.0*(k1*point[k-1].y+ 
	                        	  k2*point[k].y+ 
	                     		  k3*point[k+1].y+ 
	                        	  t3*point[k+2].y); 
			bspline[bl_i].z = 1/6.0*(k1*point[k-1].z+ 
	                        	  k2*point[k].z+ 
	                        	  k3*point[k+1].z+ 
	                        	  t3*point[k+2].z); 
	                bl_i++; 
	                t=t+1.0/STEPS;
		}
	}
}
#endif /* _SPLINES_H_ */
