
#include <zone.h>
#include "Lerp.h"
#include "rgb32.h"


VERTEX  point_table[ 8 ] = { /* */
			{ -70.0, -70.0,  70.0 },
			{  70.0,  70.0, -70.0 },
			{ -70.0,  70.0,  70.0 },
			{ -70.0, -70.0, -70.0 },
			{  70.0, -70.0,  70.0 },
			{ -70.0,  70.0, -70.0 },
			{  70.0, -70.0, -70.0 },
			{  70.0,  70.0,  70.0 }},
	r_point[ 8 ];
VERTEX  spline_table[ 8 ] = { /* little spline-key-points */
			{ -70.0, -70.0,  70.0 },
			{  70.0,  70.0, -70.0 },
			{ -70.0,  70.0,  70.0 },
			{ -70.0, -70.0, -70.0 },
			{  70.0, -70.0,  70.0 },
			{ -70.0,  70.0, -70.0 },
			{  70.0, -70.0, -70.0 },
			{  70.0,  70.0,  70.0 }},
	spline_r_point[ 8 ];
VERTEX  cube_table[ 16 ] = { /* little cube The One*/
			{  70.0,  70.0, -70.0 },
			{  70.0, -70.0, -70.0 },
			{ -70.0, -70.0, -70.0 },
			{ -70.0,  70.0, -70.0 },
			{  70.0,  70.0,  70.0 },
			{  70.0, -70.0,  70.0 },
			{ -70.0, -70.0,  70.0 },
			{ -70.0,  70.0,  70.0 },
			{  70.0, -70.0, -70.0 },
			{  70.0,  70.0, -70.0 },
			{  70.0,  70.0,  70.0 },
			{  70.0, -70.0,  70.0 },
			{  -70.0, -70.0, -70.0 },
			{  -70.0,  70.0, -70.0 },
			{  -70.0,  70.0,  70.0 },
			{  -70.0, -70.0,  70.0 }},
	cube_r_point[ 16 ];
int32   xres = 320;
int32   yres = 200;
MATRIX  m, p1, p2, p3, p4, p5, p6, p7, p8;
ZBUFFER zb[ 320 * 200 ] ;
int     points = 8;
angle   ax = 0.0, ay = 0.0, az = 0.0;
int     steps = 300;
uint    x, y, pixel, c;
uint    color = 255;
float   FOCUS = 50.0, DEPTH = 134.0;
int     i;
int32   xcentre = 160 , ycentre = 100;
BSPLINE bspline[ 8 * 300 ];

int32   pixcolor = 0xffffff;
int32   cubcolor = 0xffffff;
char    maxdepth = -70;
int32   colpal[256];

/*********************************/
void init_spline(void){

        // clear the zbuffer...
        zb_clear( zb, xres * yres);

        // set here the number of steps you want...between cube-key-points
        _bspline( point_table, points, steps, bspline);

	// create color fading palette for the spline...
	float r = (float)((pixcolor&0xff0000)>>16), cr = (float)(( pixcolor & 0xff0000)>>16 )/400.0;
	float g = (float)((pixcolor&0xff00)>>8), cg = (float)(( pixcolor & 0xff00)>>8 )/400.0;
	float b = (float)(pixcolor&0xff), cb = (float)( pixcolor & 0xff )/400.0;
/*
	for ( int tmp = 0 ; tmp < 256 ; tmp++ ){
		colpal[ tmp ] = ( ((int32)(r)<<16)|((int32)(g)<<8)|(int32)(b));
		r -= cr ; 
		b -= cb; 
		g -= cg ; 
	}
*/
	Lerp<float> red( 128, 255, 256 ); 	
	Lerp<float> green( 194, 255, 256 ); 	
	Lerp<float> blue( 184, 255, 256 ); 	
	for ( int c = 0; c < 256; c++, red.next(), green.next(), blue.next() )
		colpal[256-c] = rgb32( red.value(), green.value(), blue.value() );
}

void update_spline(float tim){

	float timing = tim * 50.0;

	ax = timing ; ay = -timing*0.95 ; az = timing;
	buildmatrix( &m, ax, ay, az );
	buildmatrix( &p1, ax, ay, az );
	ax = -timing ; ay = timing/1.4 ; az = (timing+50.0)*1.02;
	buildmatrix( &p2, ax, ay, az );
	ax = timing*0.51 ; ay = timing*1.005 ; az = timing*0.42;
	buildmatrix( &p3, ax, ay, az);
	ax = timing*1.51 ; ay = timing*1.005 ; az = timing/0.42;
	buildmatrix( &p4, ax, ay, az);
	ax = timing*-1.51 ; ay = timing*1.005 ; az = timing*1.42;
	buildmatrix( &p5, ax, ay, az);
	ax = timing*0.01 ; ay = timing*1.505 ; az = timing*0.42;
	buildmatrix( &p6, ax, ay, az);
	ax = timing-0.51 ; ay = timing+1.805 ; az = timing*1.82;
	buildmatrix( &p7, ax, ay, az);
	ax = timing*0.81 ; ay = timing/1.005 ; az = timing+0.42;
	buildmatrix( &p8, ax, ay, az);
	//rotvertex(8, (VERTEX*)point_table, &m, (VERTEX*)r_point);
	rotvertex(16, cube_table, &m, (VERTEX*)cube_r_point);
	rot1vertex( point_table, &p1, (VERTEX*)r_point);
	rot1vertex( (VERTEX*)&point_table[1], &p1, (VERTEX*)&r_point[1]);
	rot1vertex( (VERTEX*)&point_table[2], &p2, (VERTEX*)&r_point[2]);
	rot1vertex( (VERTEX*)&point_table[3], &p3, (VERTEX*)&r_point[3]);
	rot1vertex( (VERTEX*)&point_table[4], &p4, (VERTEX*)&r_point[4]);
	rot1vertex( (VERTEX*)&point_table[5], &p5, (VERTEX*)&r_point[5]);
	rot1vertex( (VERTEX*)&point_table[6], &p6, (VERTEX*)&r_point[6]);
	rot1vertex( (VERTEX*)&point_table[7], &p7, (VERTEX*)&r_point[7]);
	/* recalc the spline (8*200 points...) */
	_bspline( r_point, points, steps, bspline);
}

void draw_spline(int32 *area){
	
	uint opx, opy, opz;
	uint nface;

	for( nface = 0 ; nface < 16 ; nface +=4 ){

		opx = (uint)((cube_r_point[3+nface].x * FOCUS)/(cube_r_point[3+nface].z + DEPTH )) + xcentre;
		opy = (uint)((cube_r_point[3+nface].y * FOCUS)/(cube_r_point[3+nface].z + DEPTH )) + ycentre;

		for(i = 0 ; i < 4 /*points*/ ; i++)
	        {
			x = (uint)((cube_r_point[i+nface].x * FOCUS)/(cube_r_point[i+nface].z + DEPTH )) + xcentre;
			y = (uint)((cube_r_point[i+nface].y * FOCUS)/(cube_r_point[i+nface].z + DEPTH )) + ycentre;
	
			alpha_sc_line( x, y, opx, opy, cubcolor, (ZBUF*)zb , area);
			opx = x ; opy = y ; 
		
	        }
	}
	/* Draw the bspline. */
	for(i = 0 ; i <= ( steps *( points-2 )) ; i++)
	{
	        x = (uint)((bspline[i].x * FOCUS)/(bspline[i].z + DEPTH)) + xcentre;
	        y = (uint)((bspline[i].y * FOCUS)/(bspline[i].z + DEPTH)) + ycentre;
	
	        /* slow pixel per pixel clipping method...sorry... */
	        if( (x<xres) && (y<yres) )
	        {
	                uint coord = x+(y*320);
	                if( zb[coord].z > (int) bspline[i].z )
	                {
	                        c = ( (uint)-bspline[i].z - 130 ) & 0xff;
		                        pixel = (c<<16) | (c<<8) | c;
       	                 	zb[coord].z = (int) bspline[i].z;
        	                area[coord] = colpal[(int32)((bspline[i].z ) + 128) & 0xff];
        	        }
        	}
	}
	//zb_clash( zb, xres * yres, area );
	zb_clear( zb, xres * yres );
	
}
