#include <stdio.h>
#define W 320
#define H 200


Uint32 * buffer;
Uint32 *mask;	

Uint32 spradd[400];
// Copy buffer/buffer

void fill_buffer(Uint32 *src, Uint32 *dest)
{
 memcpy(dest, src, 256000); 
}


// Fade from black to image
void fade_in(Uint32 *src, Uint32 *dest, unsigned char value)
{
	int i=0;
	unsigned char r,v,b;

for(i = 0; i<64000; i++)
{

r = (src[i] & 16711780) >> 16;
v = (src[i] & 65280) >> 8;
b =  src[i] & 255;

r = r - (r*value/128);
v = v - (v*value/128);
b = b - (b*value/128);



dest[i] = (r<<16) + (v<<8) + b;


}


}


// Zoom of an image
void Zoom (Uint32 *Source, Uint32 *Dest, int x1, int y1, int x2, int y2)
{ 

  int x,y,i,j,offset;
  int deltaX,deltaY;

  deltaX=((x2-x1+1)<<16)/320;
  deltaY=((y2-y1+1)<<16)/200;
  x1=x1<<16;
  y=y1<<16;

  for(j=0; j<200; j++)
   { offset=(y>>16)*320;
     x=x1;
     for(i=0; i<320; i++)
     { 
       *Dest++=*(Source+offset+(x>>16));
       x+=deltaX;
     }
     y+=deltaY;
   }
}


// Fade of two image using 'value' coefficient
void fade2img(Uint32 *src1, Uint32 *src2 , Uint32 *dest, unsigned char value)
{
int i=0;
unsigned char r,v,b, r1, v1, b1;

for(i = 0; i<64000; i++)
{

r = (src1[i] & 16711780) >> 16;
v = (src1[i] & 65280) >> 8;
b =  src1[i] & 255;

r1 = (src2[i] & 16711780) >> 16;
v1 = (src2[i] & 65280) >> 8;
b1 =  src2[i] & 255;



r = (r*value/100)+(r1*(100-value)/100);
v = (v*value/100)+(v1*(100-value)/100);
b = (b*value/100)+(b1*(100-value)/100);


dest[i] = (r<<16) + (v<<8) + b;


}


}



int
put_sprite (int px, int py, int taille, Uint32 * buf, int T)
{
  int x, y, offset, offset2, r, v, b, r1, v1, b1;
  int T2 = 256 - T;

  for (y = 0; y < taille; y++)
    {

      for (x = 0; x < taille; x++)
	{

	  offset = (y + py - (taille / 2)) * 320 + (x + px - (taille / 2));

	  if (x + px - (taille / 2) < 319)
	    if (x + px - (taille / 2) > 0)
	      if (offset < 64000)
		if (offset > 0)
		  {
		    offset2 = y * taille + x;
		    if (buf[offset2])
		      {
			r = (buffer[offset] & 16711780) >> 16;
			v = (buffer[offset] & 65280) >> 8;
			b = buffer[offset] & 255;
			r1 = (buf[offset2] & 16711780) >> 16;
			v1 = (buf[offset2] & 65280) >> 8;
			b1 = buf[offset2] & 255;
			r = (r1 * T / 100 + r * T2 / 100) + (r * 2);
			v = (v1 * T / 100 + v * T2 / 100) + (v * 2);
			b = (b1 * T / 100 + b * T2 / 100) + (b * 2);
			if (r > 255)
			  r = 255;
			if (v > 255)
			  v = 255;
			if (b > 255)
			  b = 255;


			buffer[offset] = (r << 16) + (v << 8) + b;
		      }
		  }
	}
    }

}



void Pixel (float x, float y, Uint32 coul, int value)
{
int x2, y2, index;
unsigned char r,v,b, r1, v1, b1;
x2 = (int) x;
y2 = (int) y;
index= y2*320+x2;

if((x2<319)&(x2>0)&(y2<200)&(y2>0))
{
if((index<64000) & (index>0))
{
r1 = (buffer[index] & 16711780) >> 16;
v1 = (buffer[index] & 65280) >> 8;
b1 =  buffer[index] & 255;

r = (coul & 16711780) >> 16;
v = (coul & 65280) >> 8;
b =  coul & 255;

r = (r*value/255)+(r1*(255-value)/255);
v = (v*value/255)+(v1*(255-value)/255);
b = (b*value/255)+(b1*(255-value)/255);

coul=(r<<16) + (v<<8) + b;
if(mask[index]==0)
{
buffer[index]=coul;
buffer[index+1]=coul;
buffer[index-1]=coul;
buffer[(y2+1)*W+x2]=coul;
buffer[(y2-1)*W+x2]=coul;
}
}
}
}	

void Pixel2 (float x, float y, Uint32 coul, int value)
{
int x2, y2, index;
unsigned char r,v,b, r1, v1, b1;
x2 = (int) x;
y2 = (int) y;
index= y2*320+x2;

if((x2<319)&(x2>0)&(y2<200)&(y2>0))
{
if((index<64000) & (index>0))
{

buffer[index]=(100<<16)+(100<<8)+100;

}
}
}	







void spradd_init(int tx, int ty,int tr)
{
int i, dist, rx,ry;
int bx=tx/2;
int by=ty/2;


for(rx=0;rx<tr;rx++)
for(ry=0;ry<tr;ry++)
{   
dist=sqrt(((rx-bx)*(rx-bx))+((ry-by)*(ry-by)));
if(dist>5)
goto fin;
spradd[ry*10+rx]= 255-(dist*255/5);
//printf("dist = %d\n",dist);
fin:
}


}

void put_spradd(int px, int py)
{
int coul;
int x, y;

for(y=0;y<10;y++)
for(x=0;x<10;x++)
{
if((x+px>0) & (x+px<320) & (y+py>0) & (y+py<200))
{
coul = (buffer[(y+py)*320+(x+px)]&255) + (spradd[y*10+x]&255);

if(coul>255)
coul = 255;

buffer[(y+py)*320+(x+px)] = (coul<<16)+(coul<<8)+coul;
}
}




}

void blur()
{
int x,y;
Uint32 couleur, couleur2, couleur3;
int r,v,b,r2,v2,b2,r3,v3,b3;
int offset;

for(x=1;x<320;x++)
     for(y=0;y<200;y++)
     {
	
	offset=((y*W)+x);
	
	couleur=buffer[offset];
        
	r=(couleur&16711780)>>16;
	v=(couleur&65280)>>8;
	b=(couleur&255);
	
	couleur2=buffer[offset+1];
	
	r2=(couleur2&16711780)>>16;
	v2=(couleur2&65280)>>8;
	b2=(couleur2&255);
	
	couleur3=buffer[offset+1];
	
	r3=(couleur3&16711780)>>16;
	v3=(couleur3&65280)>>8;
	b3=(couleur3&255);
	
	
	r=((r+r2+r3)/3);
	v=((v+v2+v3)/3);
	b=((b+b2+b3)/3);
	
	
	if(r!=0)
	  r--;
	if(v!=0)
	  v--;
	if(b!=0)
	  b--;
	
	
	couleur=(r<<16)+(v<<8)+(b);
	
	buffer[offset]=couleur;
	
     }

}

void blurplouc()
{
int x,y;
Uint32 couleur, couleur2, couleur3;
int r,v,b,r2,v2,b2,r3,v3,b3;
int offset;

for(x=1;x<319;x++)
     for(y=0;y<200;y++)
     {
	
	offset=((y*W)+x);
	
	couleur=buffer[offset];
        
	r=(couleur&16711780)>>16;
	v=(couleur&65280)>>8;
	b=(couleur&255);
	
	couleur2=buffer[offset+1];
	
	r2=(couleur2&16711780)>>16;
	v2=(couleur2&65280)>>8;
	b2=(couleur2&255);
	
	couleur3=buffer[offset-1];
	
	r3=(couleur3&16711780)>>16;
	v3=(couleur3&65280)>>8;
	b3=(couleur3&255);
	
	
	r=((r+r2+r3)/3);
	v=((v+v2+v3)/3);
	b=((b+b2+b3)/3);
	
	
	if(r!=0)
	  r--;
	if(v!=0)
	  v--;
	if(b!=0)
	  b--;
	
	
	couleur=(r<<16)+(v<<8)+(b);
	
	buffer[offset]=couleur;
	
     }

}








void putsprite(Uint32 *buf, int x, int y, int tx, int ty)
{
int sy,sx;

for(sy=0;sy<ty;sy++)
for(sx=0;sx<tx;sx++)
if((sx<320) & (sy<200) & (sx>0) & (sy>0) & (buf[sx+sy*tx]!=0))
buffer[(sx+x)+(sy+y)*W] = buf[sx+sy*tx];



}
