
char tabs[17*64];

int highscore = 0;
char good[64];

int piece[4*8*2] =
    {0,0,0,1,1,1,1,2,
     1,0,0,1,1,1,0,2,
     0,1,1,0,1,1,2,0,
     0,0,1,0,1,1,2,1};

int placeit(char* tab, int x, int y, char nb)
{
    if ((x>7) || (y>7)) return 0;
    if (tab[8*y+x] != '-') return 0;
    tab[8*y+x] = nb;
    return 1;
}

int count2(char* tab, int x, int y, char nb)
{
    if ((x<0) || (x>7) || (y<0) || (y>7)) return 1;
    if (tab[8*y+x] == nb) return 0;
    return (tab[8*y+x] != '-');
}


int count(char* tab, int x, int y, char nb)
{
    int res = 0;
    int dx,dy;
    
    for (dx=-1;dx<2;dx++) for (dy=-1;dy<2;dy++)
    {
	res += count2(tab, x+dx, y+dy, nb);
    }
    
    return res;
}


int getscore(char* tab, int x, int y, int nb, int* _piece)
{
    int a, res;

    for (a=0;a<4;a++)
    {
        if (!placeit(tab, x+_piece[2*a], y+_piece[2*a+1], nb)) return -1;
    }
    
    res = 0;
    for (a=0;a<4;a++)
    {
	res += count(tab, x+_piece[2*a], y+_piece[2*a+1], nb);
    }
    return res;
}


void doit(char* tab, char nb, int score, char* next)
{
    int x,y;
    int s;
    int bx,by,bp;
    int bs = -1;
    
    if (nb == 58) nb = 'A';
    
    if (score > highscore)
    {
	memcpy(good, tab, 64);
	highscore = score;
    }
    
    if (!*next) return;
    
    for (x=0;x<7;x++) for (y=0;y<7;y++)
    {
	memcpy(tab+64, tab, 64);
	s = getscore(tab+64, x, y, nb, piece+8*(*next-48));
	if (s>bs)
	{
	    bs = s;
	    bx = x;
	    by = y;
	    bp = *next-48;
	}
	
	memcpy(tab+64, tab, 64);
	s = getscore(tab+64, x, y, nb, piece+8*(*next-46));
	if (s>bs)
	{
	    bs = s;
	    bx = x;
	    by = y;
	    bp = *next-46;
	}
    }

    if (bs > -1)
    {    
        memcpy(tab+64, tab, 64);
        getscore(tab+64, bx, by, nb, piece+8*bp);
        doit(tab+64, nb+1, score+4, next+1);
    }
}


int main(int argc, char *argv[])
{
    int x,y;
    
    memset(tabs, '-', 64);
    doit(tabs, '0', 0, argv[1]);
    
    for (y=0;y<8;y++)
    {
	for (x=0;x<8;x++) printf("%c", good[8*y+x]);
	printf("\n");
    }
    return 0;
}