#include "wav.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "filereader.h"
#include "utils.h"

/*struct of a wave*/
/* 
char[4]    -> bytes "RIFF" signature
long       -> file size
char[4]    -> "WAVE" signature (RIFF type)
char[4]    -> chunk ID in this case(i think) is "fmt "
long 	   -> chunk size	
short	   -> format tag	
short	   -> number of channels
long	   -> num of samples per sec
long 	   -> avg bytes per sec
short	   -> block align
short	   -> bits per sample
char[4]    -> chunk ID in this case (i think) is "data"
long       -> chunk size that mean size of data
char*      -> data :)
*/






int read_WAV (sound_t *temp,file_t foo)
{
   unsigned char ubuf[4];
   temp->data=(char*)malloc(foo.size*2);
   /* le a assinatura RIFF*/
   if (strncmp(foo.data,"RIFF",4)!=0)
   {	
	PERROR("Load_WAV: This is not a wave file\n");
	exit(1);
    }
   foo.data+=4;
   /*le o tamanho do sample*/
   strncpy(ubuf,foo.data,4);
   temp->samplesize=(ubuf[3]<<24) |(ubuf[2]<<16) | (ubuf[1]<<8) |ubuf[0];
   foo.data+=4;
   /*le a assinatura WAVE*/
   if (strncmp(foo.data,"WAVE",4)!=0)
   {	
	PERROR("Load_WAV: This is not a WAV file\n");
	exit(1);
   }
   foo.data+=14;
   /*channels*/
   strncpy(ubuf,foo.data,2);
   temp->channels=((ubuf[1]<<8) |ubuf[0]);
   foo.data+=2;
   /*samples per sec*/
   strncpy(ubuf,foo.data,4);
   temp->samplerate=((ubuf[3]<<24) |(ubuf[2]<<16) | (ubuf[1]<<8) |ubuf[0]);
   foo.data+=10;
   /*bits per sample*/
   strncpy(ubuf,foo.data,2);
   temp->bits=((ubuf[1]<<8) |ubuf[0]);
   foo.data+=10;
   /*copy DATA*/
   memcpy(temp->data,foo.data,temp->samplesize);
   return 0;
}
