/*

some quick math functions (cos/sin) replacements for use with internal LUT


swivel | CSR
swivel@csrmusic.org

*/

#include	<stdio.h>
#include	<math.h>


float 		*costable, *sintable;




int init_math(void)
{
	int	i;
	double	r = 0;

	costable = (float *)calloc(4, 3600);
	if( costable == NULL ) {
		return 0;
	}

	sintable = (float *)calloc(4, 3600);
	if( sintable == NULL ) {
		return 0;
	}

	
	for( i = 0; i < 3600; i++) {
		costable[i] = (float)cos(r);
		r += .01;
	}

	r = 0;
	for( i = 0; i < 3600; i++) {
		sintable[i] = (float)sin(r);
		r += .01;
	}

	return 1;
}



float fastcos(int R)
{

	return(costable[abs(R % 3600)]);
}


float fastsin(int R)
{

	return(sintable[abs(R % 3600)]);
}
