/*
code for introduction of loop


swivel | CSR
swivel@csrmusic.org
*/

#include	<stdio.h>
#include	"sprite.h"
#include	"../prefs.h"
#include	"gfx.h"
#include	"fastmath.h"
#include	"bumpmap.h"

extern int effekt;
extern int noexit;

void intro(unsigned char *screen, unsigned char *temp1, unsigned char *temp2)
{
	struct PALETTE 	*pal, *active_pal;
	struct SPRITE 	*sprites[3]; /* logo/presents/loop */
	unsigned char 	*swap, *blankcolors;
	int		fadeleft = 1, i = 0, l = 0;
	char 		*wait[4];

	/* our nifty little text thingy to show we are alive */
	wait[0] = "-\0";
	wait[1] = "/\0";
	wait[2] = "|\0";
	wait[3] = "\\\0";

	sprites[0] = load_sprite("data/csr.img");
	sprites[1] = load_sprite("data/presents.img");
	sprites[2] = load_sprite("data/loop.img");
	pal = load_palette("data/spiralpal.pal");

	blankcolors = (unsigned char *)calloc(1, 256 * 3);
	active_pal = new_palette_struct();	
	active_pal->data = blankcolors;
	active_pal->quantity = 256;
	active_pal->type = PCVGA8BIT;

	/* set blank pallete */
	set_palette(active_pal);

	printf("Waiting for libmikmod...");
	while(noexit) {
		i++;
		printf("\n%s", wait[i % 4]);
		usleep(1);
	}

	i = 0;
	noexit = 1;

	while( i < 3 ) {
		while(noexit) {
			draw_sprite_trans_center(sprites[i], screen, VWIDTH, VHEIGHT);

			blur_opt(screen, temp1, VWIDTH * VHEIGHT);


			swap = screen;
			screen = temp1;
			temp1 = swap;

			draw_screen(screen);
		
			if(fadeleft) {
				fadeleft = fade_pal(active_pal->data, pal->data,
						    pal->quantity, 10);
				set_palette(active_pal);
				if(!fadeleft) {
					unload_palette(pal);
					unload_palette(active_pal);
				}
			}

			usleep(100);
		}

		unload_sprite(sprites[i]);
		i++;
		noexit = 1;
	}

	return;
}
