
/* swivel | CSR */
/* swivel@csrmusic.org */

#include	<stdio.h>
#include	"rotate.h"
#include	"fastmath.h"
#include	"sprite.h"
#include	"gfx.h"
#include	"../prefs.h"




extern int effekt;
extern int noexit;

void rotozoom(unsigned char *screen, unsigned char *temp1, unsigned char *temp2)
{
	unsigned char 	*blankcolors;
	struct SPRITE 	*image;
	struct PALETTE 	*pal, *active_pal;
	unsigned char 	*buffer;
	int 		i, fadeleft = 1;

	int		R = 50;
	int  		prate = 3;
	float		Z = .6;
	int		zrate = 1;


	active_pal = get_palette();

	image = load_sprite("data/penguin.img");
	pal = load_palette("data/penguin.pal");
	blankcolors = (unsigned char *)calloc(1, 256 * 3);

	buffer = image->data;

	while(fadeleft) {
		fadeleft = fade_pal(active_pal->data, blankcolors, 256, 10);
		set_palette(active_pal);
		usleep(1);
	}
	
	fadeleft = 1;
	noexit = 1;
	while(noexit) {

		R += prate; 

		zrate += 1;

		Z = fastcos(zrate) * 4;

		rotate(buffer, R, Z, screen, VWIDTH, VHEIGHT);

		draw_screen(screen);

		if(effekt) {
			effekt = 0;

			if(prate < 0) {
				prate = 3;
			} else {
				prate = -3;
			}
		}

		if(fadeleft) {
			fadeleft=fade_pal(active_pal->data, pal->data, pal->quantity, 10);
			set_palette(active_pal);
			if(!fadeleft)
				unload_palette(pal);
		}

		usleep(100);
	}

	free(blankcolors);
	unload_sprite(image);

	return;
}
