/*
Ŀ
 Procesado Digital de Imgenes 
 Cdigo: Dave/PhyMosys         
 Fecha: 19-7-98                
 Descr. Operaciones de punto.  
 Email: dave@bglinks.com       

*/

#include "stdio.h"
#include "alloc.h"
#include "dos.h"

char *bitmap;
char *bitmap2;

main()
{
    coge_mem();
    modo_video(0x13);
    lee_bitmap();
    pon_paleta();
    pon_bitmap(bitmap);         /* grfico original */
    getch();

    complementa(bitmap,bitmap2);
    pon_bitmap(bitmap2);            /* negativo del original */
    getch();

    binariza(bitmap,bitmap2,80);    /* binarizacin con diferentes */
    pon_bitmap(bitmap2);            /* niveles de threshold        */
    getch();
    binariza(bitmap,bitmap2,100);
    pon_bitmap(bitmap2);
    getch();
    binariza(bitmap,bitmap2,120);
    pon_bitmap(bitmap2);
    getch();
    suma(bitmap,bitmap2,64);        /* incremento lineal de luminancia */
    pon_bitmap(bitmap2);
    getch();

    modo_video(3);
    deja_mem();
}

coge_mem()
{
    if((bitmap=malloc(64000))==NULL){ printf("No hay memoria!"); exit(0); }
    if((bitmap2=malloc(64000))==NULL){ printf("No hay memoria!"); exit(0); }
}

modo_video(char modo)
{
    _AX=modo;
    geninterrupt(0x10);
}

lee_bitmap()
{
    FILE *archivo;
    unsigned char byte;

    if((archivo=fopen("lisaw.phy", "rb"))==NULL){
        printf("No puedo abrir el archivo!\n");
        exit(0);
    }
    fread(bitmap,64000,1,archivo);
    fclose(archivo);
}

pon_bitmap(char *origen)
{
    char *vidptr;
    unsigned int n;
    vidptr=(char *)0xA0000000;

    for(n=0;n<64000;n++){
    vidptr[n]=origen[n];
    }
}

complementa(char *origen, char *destino)
{
    unsigned int x,y;

    for(x=0;x<320;x++)
    {
        for(y=0;y<200;y++)
        {
        destino[(y*320)+x]=255-origen[(y*320)+x];
        }
    }

    /* ste algoritmo tambin se puede escribir as:
        for(x=0;x<(320*200);x++){destino[x]=255-origen[x]; }
        siendo as mucho ms eficiente.
    */
}

binariza(char *origen, char *destino, unsigned char threshold)
{
    int x,y;
    for(x=0;x<320;x++){
        for(y=0;y<200;y++){
            if(origen[(y*320)+x]>=threshold)
            {
                destino[(y*320)+x]=255;     /* mx. ==> L */
            }

            else
            {
                destino[(y*320)+x]=0;       /* mn. ==> 0 */
            }
        }
    }
}

suma(char *origen, char *destino, unsigned char k)
{
    int x,y;
    unsigned int col;
    unsigned char sal;
    for(x=0;x<320;x++){
        for(y=0;y<200;y++){
            sal=origen[(y*320)+x];
            col=sal+k;
            if(col>255){ sal=255; } /* si supera L, entonces ajusta a L */
            else { sal=col; }       /* sino, dibjalo directamente */
            destino[(y*320)+x]=sal;
        }
    }
}

deja_mem()
{
    free(bitmap);
    free(bitmap2);
}

pon_paleta()
{
    /* genero una paleta de grises */
    unsigned niv;
    int col;
    float nivr;
    niv=0;
    nivr=0.0;

    for(col=0;col<256;col++){
        outportb(0x3c8,col);        /* puerto DAC */
        outportb(0x3c9,niv);
        outportb(0x3c9,niv);
        outportb(0x3c9,niv);
        nivr+=0.25; /* (64/256)=0.25 , incremento */
        niv=nivr;
    }
}
