/*************************************************************************************************
*
*	Title:	Virtual Video
*
*	Desc:	Provides a Virtual Video framework for a simple 2D frame buffer
*	
*	Note:	
*			
**************************************************************************************************/

#include <Windows.h>
#include "VVideo.h"
#include "GDI.h"

/*************************************************************************************************/
// Defines
/*************************************************************************************************/

/*************************************************************************************************/
// Globals
/*************************************************************************************************/

// Interface
Open_f			*VV_Open		= NULL;
Close_f			*VV_Close		= NULL;
GetAddress_f	*VV_GetAddress	= NULL;
Flip_f			*VV_Flip		= NULL;

/*************************************************************************************************/
// Module Data
/*************************************************************************************************/

// the list
static Driver_t		m_DriverList[ 1 ] = 
			{
				{	"GDI",
					GDI_Open,
					GDI_Close,
					GDI_GetAddress,
					GDI_Flip,
				}
			};

static int		m_NumberDrivers = 1;

// current driver
static int		m_CurrentDriver = -1;

/*************************************************************************************************/
// Functions
/*************************************************************************************************/

/*************************************************************************************************
*
*	Function:	VV_Init()
*
*	Desc:		Initlizes anything
*
*	Notes:		1) Currently this is nothing, but will used soon
*
***************************************************************************************************/
void VV_Init( void )
{
}

/*************************************************************************************************
*
*	Function:	VV_Kill()
*
*	Desc:		Kills anything
*
*	Notes:		1) this also is nothing. wow. spectacular
*
***************************************************************************************************/
void VV_Kill( void )
{
	// was a selected
	if( VV_Close != NULL)
	{
		// close the current driver	
		VV_Close();
	}
}

/*************************************************************************************************
*
*	Function:	VV_GetNumberDrivers()
*
*	Desc:		Gets the number of drivers we have
*
*	Notes:		
*
***************************************************************************************************/
int VV_GetNumberDrivers( void )
{
	return m_NumberDrivers;
}

/*************************************************************************************************
*
*	Function:	VV_GetCurrentrDrivers()
*
*	Desc:		Gets the currently selected driver
*
*	Notes:		1) returns -1 if no driver has been selected
*
***************************************************************************************************/
int VV_GetCurrentDriver( void )
{
	return m_CurrentDriver;
}

/*************************************************************************************************
*
*	Function:	VV_GetDriverDesc()
*
*	Desc:		Gets a description on the specified driver
*
*	Notes:		
*
***************************************************************************************************/
char *VV_GetDriverDesc( int DriverNo )
{
	// Bounds check
	if ( (DriverNo < 0) || (DriverNo >= m_NumberDrivers) ) return NULL;

	// get Drivers decription
	return m_DriverList[ DriverNo ].Description;
}

/*************************************************************************************************
*
*	Function:	VV_SetDriver()
*
*	Desc:		Sets the current driver
*
*	Notes:		
*
***************************************************************************************************/
void VV_SetDriver( int DriverNo )
{
	// Bounds check
	if ( (DriverNo < 0) || (DriverNo >= m_NumberDrivers) ) return;

	// has a previous driver been set?
	if (VV_Close != NULL)
	{
		// need to shut down the previous driver
		VV_Close();
	}

	// set functions
	VV_Open			= m_DriverList[ DriverNo ].Open;
	VV_Close		= m_DriverList[ DriverNo ].Close;
	VV_GetAddress	= m_DriverList[ DriverNo ].GetAddress;
	VV_Flip			= m_DriverList[ DriverNo ].Flip;

	// Initlize the driver
	VV_Open();

	// save driver no
	m_CurrentDriver = DriverNo;
}