;ENTRY.ASM	7/31/1999	Program to encode/decode text/morse code
;
				.RADIX 16
;
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;*******************************************************************************
;	Copyright (c) Lawrence E. Boothby, 1999, All rights reserved.
;		Contract programming - boothbyl@reed.edu
;					      ^ a lower case L, not 1
;*******************************************************************************
Start:		MOV	BP,OFFSET GetAndPutChar
		CALL	BP		;get first character of input
		CMP	AL,"_"		;a character not in text
		XCHG	DI,AX		;save  AL with first character read
		;now using DI to save current separator (space or "/")
		MOV	AH,2A		;BOM = "_._._" = 0010 1010
		JZ	Morse2Text
;*************************************** TRANSLATE TEXT TO MORSE ***************
		CALL	OutputMorse	;		   ^sentinel bit
		MOV	AL,"/"
NotSeparator: ; MOV	AH,[BP+DI -(1+"`" + OFFSET GetAndPutChar-OFFSET Last)]
		MOV	AH,[BP+DI-0E] ;force 3 byte version (instead of +FFF2)
		CALL	BP
		MOV	AL,11		;symbol separator, " " - 0F
Slash:		ADD	AL,0F
NewWord:	XCHG	DI,AX
		DEC	BX		;each CALL BP has set BX<--0001
		CALL	BP		;get next input character
	    ;	CMP	AL,20		;done in getchar now
		JZ	Slash		;converts " " to "/" (no space at EOF)
		XCHG	DI,AX
		INC	CX
		LOOP	NotSeparator	;INC, LOOP = JCXNZ
;*******************************************************************************
TextEOF:	MOV	AX,3570		;AH = 35 = "._._." = 00110101
					;	   sentinel bit^
		DB 0B2	;MOV DL,0D6 to skip next instruction (AL becomes "/")
;*******************************************************************************
DitOrDah:	DB 0D6	;SETALC		;sets all bits to CF=1 or 0
		AND	AL,71		;(71="." XOR "_") resulting in 00 or 71
		XOR	AL,58	    ;now convert 00 or 71 to ("." or "_")XOR 07
		; a variation of Ruud's SETALC, OR AL,8E, XOR AL,0A0 - thanks
		; for the idea which saves me one byte here. 7-14-1999
;*******************************************************************************
		DB 2E			;CS: = morse code for Newline (read LF)
LineFeed:	XOR	AL,07		;see my HUGICOMPO #6 ENTRY
		DB 2E			;CS:=morse code for Newline (write CR)
GetAndPutChar:	PUSH	AX		;AL = character to write, save AH
		MOV	AH,3F		;assume sti with BX=0000
		ADD	AH,BL		;but when BX=0001, make AH=40 for sto
		MOV	CL,01		;one character (CH=00)
		MOV	DX,SP		;DS:DX==>character on stack
		INT	21
		XCHG	CX,AX		;save number read or written in CX
		POP	AX		;gets character if read and restore AH
		CMP	AL,0Dh
		JZ	LineFeed	;read/write 0Dh,0Ah
OutputMorse:	SHR	AH,1		;leftmost "1" bit is sentinel
		JNZ	DitOrDah	;(does nothing when AH=00 or 01)
		; NOTE that on input, can force getchar to read and discard
		; characters when AH more than 01. If AH=2A, will discard
		; remaining 5 characters of BOM/ and return the next character.
		MOV	BL,01		;assume next will be sto
		STD			;for Morse2Text
		CMP	AL,61		;note double use of 61h as morse data
;*******************************************************************************
;	 MORSE CODE TABLE (except NewLine,"'" and "`") All data bytes represent
;	   dit=1 and dah=0 preceded by a sentinel bit and right justified. This
;	   is one of 8 similar representations (left or right justified, normal
;	   or inverse order of bits, and value of dit/dah could be reversed).
;	   This particular choice from the 8 possible was suggested by Chut who
;	   originally got the sentinel idea from me before Technolord's public
;	   entry. Earlier, I was using 8C..8C...7A......4A=DEC DX which was
;	   good for that version but less suitable to this revision.
;
		JNB	MakeUpperCase
		JMP	SHORT Okay
;
;	    ,  -  .  /	0  1  2	 3  4  5  6  7	8  9  :	 ;
	DB 4C,5E,55,36,20,21,23,27,2F,3F,3E,3C,38,30,78,6A
;
Search:		REPNZ	SCASB		;find it
		XCHG	CX,AX		;doesn't destroy CH = 00
		; for valid input, will always find so CF=0 here
		JNB	Output	;opcode, 73h doubles as morse data byte for "?"
;
;	    A  B  C  D	E  F   G  H  I	J  K  L	  M
	DB 05,1E,1A,0E,03,1Bh,0C,1F,07,11,0A,1Dh,04
;	    N  O  P  Q	R   S  T  U   V	 W  X  Y  Z
	DB 06,08,19,14,0Dh,0F,02,0Bh,17,09,16,12,1C
;*******************************************************************************
Output:		CALL	BP		;output letter or DRLF
Morse2Text:	XOR	DI,DI	;CF<--0 so JNB always taken
		DB 0B2	;MOV DL,6Dh to skip over data
		DB 6Dh			;= morse data for "`"
Last	LABEL	BYTE
DitDah:		CMC			;after RCR will have initial DI=8000
		RCR	DI,1		;accumulate morse code bits
NextMorse:	DEC	BX		;each CALL BP has set BX<--0001
		CALL	BP		;read and consider EOF,CR,LF,"_. /"
		JCXZ	Done		;if reached end of input file
	      ; CMP	AL,20		;CR & LF may exist in Morse
		JB	NextMorse	;code input for readability, discard
		JZ	Space
		ADD	AL,0D0
		JPO	DitDah
		;other case of separator = "/" , now AL=0FF
Space:		XCHG	SI,AX		;1st time get AX=0100
		ADD	AL,21
		JNC	InWord		;skip if AX=0121, 0041, or 0040
		CALL	BP		;output text word separator = space
InWord:		STC			;will right justify DI next
LeftJustify:	RCR	DI,1		;CF=1 prefixing "1" bit first RCR
		JNC	LeftJustify	;and discarding final "1" suffix
		XCHG	DI,AX
		MOV	CL,"`" +01
		MOV	DI,OFFSET Last -01
		JMP	SHORT Search
;*******************************************************************************
MakeUpperCase	PROC
		AND	AL,0DF
Okay:		CMP	AL,20		;double purpose for both translations
Done:		RET
MakeUpperCase	ENDP
;*******************************************************************************
ONLY	ENDS
	END Start
