DECLARE SUB flatshade2 (xp1%, yp1%, xp2%, yp2%, xp3%, yp3%, z%, col%, segment%, offset%, zseg%, zoff%)
DECLARE SUB tmap2 (xp1%, yp1%, tpx1!, tpy1!, xp2%, yp2%, tpx2!, tpy2!, xp3%, yp3%, tpx3!, tpy3!, z%, segment%, offset%, zseg%, zoff%, image%())
DECLARE SUB voxel ()
DECLARE SUB tunnel ()
DECLARE SUB envfloor (frames%)
DECLARE SUB tmap (xp1%, yp1%, zp1%, tpx1!, tpy1!, xp2%, yp2%, zp2%, tpx2!, tpy2!, xp3%, yp3%, zp3%, tpx3!, tpy3!, segment%, offset%, zseg%, zoff%, image%())
DECLARE SUB grad2 (r1%, g1%, b1%, r2%, g2%, b2%, r3%, g3%, b3%, r4%, g4%, b4%)
DECLARE SUB teapotplasma (frames%)
DECLARE SUB flatshade (xp1%, yp1%, zp1%, xp2%, yp2%, zp2%, xp3%, yp3%, zp3%, col%, segment%, offset%, zseg%, zoff%)
DECLARE SUB drawpart2 (x%, y%, z%)
DECLARE SUB title (frames%)
DECLARE SUB pause (etime#)
DECLARE SUB floor (frames%)
DECLARE SUB drawpart (x%, y%, z%)
DECLARE SUB grad (col1%, r1%, g1%, b1%, col2%, r2%, g2%, b2%)
DECLARE SUB pal (c%, r%, g%, b%)
DECLARE FUNCTION CLOCK& ()

TYPE part
    x1 AS INTEGER
    y1 AS INTEGER
    z1 AS INTEGER
    x2 AS INTEGER
    y2 AS INTEGER
    z2 AS INTEGER
    x3 AS INTEGER
    y3 AS INTEGER
    z3 AS INTEGER
    x4 AS INTEGER
    y4 AS INTEGER
    z4 AS INTEGER
END TYPE

TYPE p3d
    x AS INTEGER
    y AS INTEGER
    z AS INTEGER
END TYPE

TYPE p2d
    x AS SINGLE
    y AS SINGLE
    z AS SINGLE
END TYPE

TYPE poly
    p1 AS INTEGER
    p2 AS INTEGER
    p3 AS INTEGER
END TYPE

CONST pi = 3.141592
CONST numparts = 15
CONST numparts2 = 5
CONST numparts3 = 7
CONST sight = 63

SCREEN 13
RANDOMIZE TIMER
DEFINT A-Z
COLOR 255

DIM SHARED light(-31 TO 31, -31 TO 31) AS INTEGER
FOR y = -31 TO 31
    FOR x = -31 TO 31
        light(y, x) = 255 - 8 * SQR(y * y + x * x)
        IF light(y, x) < 0 THEN light(y, x) = 0
    NEXT x
NEXT y

title 400
teapotplasma 200
floor 400
tunnel
envfloor 120
teapotplasma 200
voxel

SCREEN 0
WIDTH 80
PRINT "Sliq"
PRINT "by Entropy"
PRINT "spau0022@tc.umn.edu"
PRINT "http://www.uslink.net/~insty/"
PRINT "ICQ: 52012626"

DATA " "
DATA " "
DATA " "
DATA " "
DATA "Greets to"
DATA " "
DATA "pasco"
DATA "logiclrd"
DATA "liquidex"
DATA "qbprogger"
DATA "magnaunum"
DATA "gleb"
DATA "peerclive"
DATA "frozenemu"
DATA "tsugumo"
DATA " "
DATA " "
DATA " "
DATA ""

FUNCTION CLOCK&

DEF SEG = 0
Ticks& = PEEK(&H46C)
Ticks& = Ticks& + 256& * PEEK(&H46D)
Ticks& = Ticks& + 65536 * PEEK(&H46E)
DEF SEG

OUT &H43, &H4
LSB = INP(&H40)
HSB = 255 - INP(&H40)

CLOCK& = Ticks& * 256 + HSB

END FUNCTION

SUB delay (sec#)

ti# = CLOCK / 4660.859#
DO
LOOP UNTIL CLOCK / 4660.859# >= ti# + sec#

END SUB

SUB drawpart (x, y, z)

zp! = 100 / (z + 100)
xp = x * zp! + 160
yp = y * zp! + 100
size = 8 * zp! - 1
y1 = yp - size
y2 = yp + size
x1 = xp - size
x2 = xp + size
dp = 319 + x1 - x2
p = 320 * y1 + x1 + offset
by! = -31
dby! = 63 / (size + size + 1)
dbx! = dby!
FOR y3 = y1 TO y2
    IF y3 > 199 THEN EXIT SUB
    IF y3 > -1 THEN
        by2 = INT(by!)
        bx! = -31
        FOR x3 = x1 TO x2
            IF x3 > 319 THEN EXIT SUB
            IF x3 > -1 THEN
                col = light(by2, INT(bx!)) + PEEK(p)
                IF col > 255 THEN col = 255
                POKE p, col
            END IF
            bx! = bx! + dbx!
            p = p + 1
        NEXT x3
        p = p + dp
    ELSE
        p = p + 320
    END IF
    by! = by! + dby!
NEXT y3

END SUB

SUB drawpart2 (x, y, z)

zp! = 100 / (z + 100)
xp = x * zp! + 160
yp = y * zp! + 100
size = 8 * zp! - 1
y1 = yp - size
y2 = yp + size
x1 = xp - size
x2 = xp + size
dp = 319 + x1 - x2
p = 320 * y1 + x1 + offset
by! = -31
dby! = 63 / (size + size + 1)
dbx! = dby!
FOR y3 = y1 TO y2
    IF y3 > 199 THEN EXIT SUB
    IF y3 > -1 THEN
        by2 = INT(by!)
        bx! = -31
        FOR x3 = x1 TO x2
            IF x3 > 319 THEN EXIT SUB
            IF x3 > -1 THEN
                oldcol = PEEK(p)
                col = 16 * ((light(by2, INT(bx!)) \ 16) + oldcol \ 16)
                IF col > 240 THEN col = 240 + (col - 240) \ 16
                col = col + (oldcol AND 15)
                IF col > 255 THEN col = 255
                POKE p, col
            END IF
            bx! = bx! + dbx!
            p = p + 1
        NEXT x3
        p = p + dp
    ELSE
        p = p + 320
    END IF
    by! = by! + dby!
NEXT y3

END SUB

SUB envfloor (frames)

DIM numpoints AS INTEGER
DIM numpolys AS INTEGER

DIM sz AS SINGLE
DIM cz AS SINGLE

DIM arccos(-256 TO 256) AS INTEGER
FOR a = -256 TO 256
    c1! = 0
    c2! = 360
    DO
        c3! = (c2! + c1!) / 2
        c! = COS(c3! * pi / 180) * 256
        IF c! < a THEN c2! = c3! ELSE c1! = c3!
    LOOP UNTIL c2! - c1! < 1
    arccos(a) = 255 - c3! * 2
    IF arccos(a) < 0 THEN arccos(a) = 0
NEXT a
DIM sins(0 TO 255) AS SINGLE
DIM coss(0 TO 255) AS SINGLE
FOR s = 0 TO 255
    sins(s) = SIN(s * pi / 128)
    coss(s) = COS(s * pi / 128)
NEXT

OPEN "teapot.plg" FOR INPUT AS 1
LINE INPUT #1, lbuf$
lbuf$ = LTRIM$(lbuf$)
lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - INSTR(lbuf$, " "))
lbuf$ = LTRIM$(lbuf$)
numpoints = VAL(LEFT$(lbuf$, INSTR(lbuf$, " ")))
lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - INSTR(lbuf$, " "))
lbuf$ = LTRIM$(lbuf$)
numpolys = VAL(lbuf$)

DIM points(numpoints) AS p3d
DIM polys(numpolys) AS poly
DIM projpoints(numpoints) AS p3d
DIM normals(numpolys) AS p3d
DIM pointnormals(numpoints) AS p3d
DIM enviropointnormals(numpoints) AS p2d

FOR p = 1 TO numpoints
    LINE INPUT #1, lbuf$
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    points(p).x = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    points(p).z = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    IF lps THEN
        points(p).y = VAL(LEFT$(lbuf$, lps))
    ELSE
        points(p).y = VAL(lbuf$)
    END IF
NEXT p

FOR p = 1 TO numpolys
    LINE INPUT #1, lbuf$
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    IF nop = 4 THEN
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p1 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p2 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p3 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p4 = VAL(lbuf$) + 1
        polys(p).p1 = p1
        polys(p).p2 = p2
        polys(p).p3 = p4
        p = p + 1
        polys(p).p1 = p2
        polys(p).p2 = p3
        polys(p).p3 = p4
    ELSE
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        polys(p).p1 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        polys(p).p2 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        polys(p).p3 = VAL(lbuf$) + 1
    END IF
NEXT p
CLOSE

maxx = points(1).x
minx = points(1).x
maxy = points(1).y
miny = points(1).y
maxz = points(1).z
minz = points(1).z
FOR p = 1 TO numpoints
    IF maxx < points(p).x THEN maxx = points(p).x
    IF minx > points(p).x THEN minx = points(p).x
    IF maxy < points(p).y THEN maxy = points(p).y
    IF miny > points(p).y THEN miny = points(p).y
    IF maxz < points(p).z THEN maxz = points(p).z
    IF minz > points(p).z THEN minz = points(p).z
NEXT
normx! = (maxx + minx) / 2
normy! = (maxy + miny) / 2
normz! = (maxz + minz) / 2
IF maxx > maxy THEN s1! = maxx ELSE s1! = maxy
IF s1! < maxz THEN s1! = maxz
IF s1! <> 0 THEN s2! = 50 / s1! ELSE s2! = 1
FOR p = 1 TO numpoints
    points(p).x = (points(p).x - normx!) * s2!
    points(p).y = (points(p).y - normy!) * s2!
    points(p).z = (points(p).z - normz!) * s2!
NEXT

FOR p = 1 TO numpolys
    x1 = points(polys(p).p1).x
    y1 = points(polys(p).p1).y
    z1 = points(polys(p).p1).z
    x2 = points(polys(p).p2).x
    y2 = points(polys(p).p2).y
    z2 = points(polys(p).p2).z
    x3 = points(polys(p).p3).x
    y3 = points(polys(p).p3).y
    z3 = points(polys(p).p3).z
    xc1 = x2 - x1
    yc1 = y2 - y1
    zc1 = z2 - z1
    xc2 = x3 - x1
    yc2 = y3 - y1
    zc2 = z3 - z1
    normals(p).x = yc1 * zc2 - zc1 * yc2
    normals(p).y = zc1 * xc2 - xc1 * zc2
    normals(p).z = xc1 * yc2 - yc1 * xc2
    mag! = SQR(normals(p).x ^ 2 + normals(p).y ^ 2 + normals(p).z ^ 2)
    IF mag! = 0 THEN mag! = 1
    normals(p).x = normals(p).x / mag! * 256
    normals(p).y = normals(p).y / mag! * 256
    normals(p).z = normals(p).z / mag! * 256
NEXT p

FOR p = 1 TO numpoints
    pointnormals(p).x = 0
    pointnormals(p).y = 0
    pointnormals(p).z = 0
    FOR p2 = 1 TO numpolys
        IF polys(p2).p1 = p OR polys(p2).p2 = p OR polys(p3).p2 = p THEN
            pointnormals(p).x = pointnormals(p).x + normals(p2).x
            pointnormals(p).y = pointnormals(p).y + normals(p2).y
            pointnormals(p).z = pointnormals(p).z + normals(p2).z
        END IF
    NEXT p2
    mag! = SQR(pointnormals(p).x ^ 2 + pointnormals(p).y ^ 2 + pointnormals(p).z ^ 2)
    IF mag! = 0 THEN mag! = 1
    pointnormals(p).x = pointnormals(p).x / mag! * 256
    pointnormals(p).y = pointnormals(p).y / mag! * 256
    pointnormals(p).z = pointnormals(p).z / mag! * 256
NEXT p

grad 0, 0, 0, 0, 63, 0, 31, 63
grad 64, 0, 31, 63, 127, 63, 63, 63
grad 128, 0, 0, 0, 255, 63, 63, 63

DIM image(127, 127) AS INTEGER
DEF SEG = VARSEG(image(0, 0))
BLOAD "envmap.bsv", VARPTR(image(0, 0))
DEF SEG

DIM tile(8193) AS INTEGER
DEF SEG = VARSEG(tile(0))
BLOAD "tmap.bsv", VARPTR(tile(0))
DEF SEG
tseg = VARSEG(tile(2))
toff = VARPTR(tile(2))

DIM temp(0 TO 319) AS INTEGER

'$DYNAMIC
DIM buffer(32001) AS INTEGER
DIM zbuf(32001) AS INTEGER
'$STATIC
buffer(0) = 2560
buffer(1) = 200
segment = VARSEG(buffer(2))
offset = VARPTR(buffer(2))
zbuf(0) = 2560
zbuf(1) = 200
zseg = VARSEG(zbuf(2))
zoff = VARPTR(zbuf(2))

px1 = 0
py1 = 0
pz1 = 0
px2 = px1 + RND * 256 - 128
py2 = py1 + RND * 256 - 128
pz2 = pz1 + RND * 256 - 128
px3 = px2 + RND * 256 - 128
py3 = py2 + RND * 256 - 128
pz3 = pz2 + RND * 256 - 128
px4 = px3 + RND * 256 - 128
py4 = py3 + RND * 256 - 128
pz4 = pz3 + RND * 256 - 128

t2 = 0
t! = TIMER
DO
    t1# = CLOCK / 4660.859#
    a! = (100 - t2) / 100
    b! = t2 / 100
    xc! = px1 * a! * a! * a! + 3 * px2 * a! * a! * b! + 3 * px3 * a! * b! * b! + px4 * b! * b! * b!
    yc! = py1 * a! * a! * a! + 3 * py2 * a! * a! * b! + 3 * py3 * a! * b! * b! + py4 * b! * b! * b!
    zang = (pz1 * a! * a! * a! + 3 * pz2 * a! * a! * b! + 3 * pz3 * a! * b! * b! + pz4 * b! * b! * b!) AND 255
    IF t2 = 100 THEN
        px1 = px4
        px2 = px1 - px3 + px4
        px3 = px2 + RND * 256 - 128
        px4 = px3 + RND * 256 - 128
        py1 = py4
        py2 = py1 - py3 + py4
        py3 = py2 + RND * 256 - 128
        py4 = py3 + RND * 256 - 128
        pz1 = pz4
        pz2 = pz1 - pz3 + pz4
        pz3 = pz2 + RND * 256 - 128
        pz4 = pz3 + RND * 256 - 128
        t2 = 0
    END IF
    t2 = t2 + 1
    sz = sins(zang)
    cz = coss(zang)
    DEF SEG = segment
    FOR p = offset + 32000 TO offset + 32320
        POKE p, 0
    NEXT p
    p = 32320 + offset
    p2 = 31680 + offset
    dc! = .01
    FOR y = 1 TO 99
        ty! = 100 / y
        ty2! = (10000 / y - 100) / 4
        tycz! = ty2! * cz
        tysz! = ty2! * sz
        DEF SEG = tseg
        tx2! = -40 * ty!
        dtx2! = ty! / 4
        FOR x = 0 TO 319
            tx3 = (tx2! * cz + tysz! + xc!) AND 127
            ty3 = (tycz! - tx2! * sz + yc!) AND 127
            temp(x) = PEEK(128 * ty3 + tx3 + toff) * dc!
            IF temp(x) > 127 THEN temp(x) = 127
            tx2! = tx2! + dtx2!
        NEXT x
        DEF SEG = segment
        x = 0
        FOR b = 1 TO 40
            POKE p, temp(x)
            POKE p + 1, temp(x + 1)
            POKE p + 2, temp(x + 2)
            POKE p + 3, temp(x + 3)
            POKE p + 4, temp(x + 4)
            POKE p + 5, temp(x + 5)
            POKE p + 6, temp(x + 6)
            POKE p + 7, temp(x + 7)
            POKE p2, temp(x)
            POKE p2 + 1, temp(x + 1)
            POKE p2 + 2, temp(x + 2)
            POKE p2 + 3, temp(x + 3)
            POKE p2 + 4, temp(x + 4)
            POKE p2 + 5, temp(x + 5)
            POKE p2 + 6, temp(x + 6)
            POKE p2 + 7, temp(x + 7)
            x = x + 8
            p = p + 8
            p2 = p2 + 8
        NEXT b
        p2 = p2 - 640
        dc! = dc! + .01
    NEXT y
    DEF SEG = segment
    xrot = (xrot + 1) AND 255
    yrot = (yrot + 1) AND 255
    zrot = (zrot + 1) AND 255
    sx! = sins(xrot)
    cx! = coss(xrot)
    sy! = sins(yrot)
    cy! = coss(yrot)
    sz! = sins(zrot)
    cz! = coss(zrot)
    cubex1! = cy! * cz!
    cubey1! = -cy! * sz!
    cubez1! = sy!
    cubex2! = sx! * sy! * cz! + cx! * sz!
    cubey2! = cx! * cz! - sx! * sy! * sz!
    cubez2! = -sx! * cy!
    cubex3! = sx! * sz! - cx! * sy! * cz!
    cubey3! = sx! * cz! + cx! * sy! * sz!
    cubez3! = cx! * cy!
    REDIM zbuf(32001) AS INTEGER
    zbuf(0) = 2560
    zbuf(1) = 200
    FOR p = 1 TO numpoints
        x = points(p).x
        y = points(p).y
        z = points(p).z
        xr! = x * cubex1! + y * cubex2! + z * cubex3!
        yr! = x * cubey1! + y * cubey2! + z * cubey3!
        zr! = x * cubez1! + y * cubez2! + z * cubez3!
        projpoints(p).z = zr! + 100
        projpoints(p).x = 200 * xr! \ (zr! + 100) + 160
        projpoints(p).y = 200 * yr! \ (zr! + 100) + 100
        x = pointnormals(p).x
        y = pointnormals(p).y
        z = pointnormals(p).z
        xr! = x * cubex1! + y * cubex2! + z * cubex3!
        yr! = x * cubey1! + y * cubey2! + z * cubey3!
        zr! = x * cubez1! + y * cubez2! + z * cubez3!
        mag! = SQR(xr! * xr! + yr! * yr! + zr! * zr!)
        enviropointnormals(p).x = 32 * xr! / mag! + 64
        enviropointnormals(p).y = 32 * yr! / mag! + 64
    NEXT p
    FOR p = 1 TO numpolys
        p1 = polys(p).p1
        p2 = polys(p).p2
        p3 = polys(p).p3
        x1 = projpoints(p1).x
        y1 = projpoints(p1).y
        x2 = projpoints(p2).x
        y2 = projpoints(p2).y
        x3 = projpoints(p3).x
        y3 = projpoints(p3).y
        IF (y1 - y2) * (x2 - x3) > (x1 - x2) * (y2 - y3) THEN
            tx1! = enviropointnormals(p1).x
            ty1! = enviropointnormals(p1).y
            tx2! = enviropointnormals(p2).x
            ty2! = enviropointnormals(p2).y
            tx3! = enviropointnormals(p3).x
            ty3! = enviropointnormals(p3).y
            z1 = projpoints(p1).z
            z2 = projpoints(p2).z
            z3 = projpoints(p3).z
            z = (z1 + z2 + z3) \ 3
            tmap2 x1, y1, tx1!, ty1!, x2, y2, tx2!, ty2!, x3, y3, tx3!, ty3!, z, segment, offset, zseg, zoff, image()
        END IF
    NEXT p
    PUT (0, 0), buffer, PSET
    f = f + 1
    'pause t1# + .1
LOOP UNTIL f = frames OR INKEY$ <> ""

END SUB

SUB flatshade (xp1, yp1, zp1, xp2, yp2, zp2, xp3, yp3, zp3, col, segment, offset, zseg, zoff)

IF xp1 <= xp2 THEN
    IF xp1 <= xp3 THEN
        x1 = xp1: y1 = yp1: z1 = zp1
        IF xp2 < xp3 THEN
            x2 = xp2: y2 = yp2: z2 = zp2
            x3 = xp3: y3 = yp3: z3 = zp3
        ELSE
            x2 = xp3: y2 = yp3: z2 = zp3
            x3 = xp2: y3 = yp2: z3 = zp2
        END IF
    ELSE
        x1 = xp3: y1 = yp3: z1 = zp3
        x2 = xp1: y2 = yp1: z2 = zp1
        x3 = xp2: y3 = yp2: z3 = zp2
    END IF
ELSE
    IF xp2 <= xp3 THEN
        x1 = xp2: y1 = yp2: z1 = zp2
        IF xp1 < xp3 THEN
            x2 = xp1: y2 = yp1: z2 = zp1
            x3 = xp3: y3 = yp3: z3 = zp3
        ELSE
            x2 = xp3: y2 = yp3: z2 = zp3
            x3 = xp1: y3 = yp1: z3 = zp1
        END IF
    ELSE
        x1 = xp3: y1 = yp3: z1 = zp3
        x2 = xp2: y2 = yp2: z2 = zp2
        x3 = xp1: y3 = yp1: z3 = zp1
    END IF
END IF

IF x3 = x1 THEN
    EXIT SUB
ELSE
    xchng1 = x3 - x1
    xchng2 = x2 - x1
    xchng3 = x3 - x2
    yslope1! = (y3 - y1) / xchng1
    yt1! = y1
    izslope1! = (z3 - z1) / xchng1
    iz1! = z1
    IF xchng2 THEN
        yslope2! = (y2 - y1) / xchng2
        yt2! = y1
        izslope2! = (z2 - z1) / xchng2
        iz2! = z1
        FOR x = x1 TO x2
            iyt1 = CINT(yt1!)
            iyt2 = CINT(yt2!)
            dy = SGN(iyt2 - iyt1)
            IF dy THEN
                izslope3! = (iz2! - iz1!) / (iyt2 - iyt1)
                iz! = iz1!
                FOR y = iyt1 TO iyt2 STEP dy
                    IF (y > 199 AND dy = 1) OR (y < 0 AND dy = -1) THEN EXIT FOR
                    IF y < 200 AND y > -1 THEN
                        z = iz!
                        p = x + 320 * y + zoff
                        DEF SEG = zseg
                        IF PEEK(p) > z OR PEEK(p) = 0 THEN
                            POKE p, z
                            DEF SEG = segment
                            POKE p, col
                        ELSE
                            DEF SEG = segment
                        END IF
                    END IF
                    iz! = iz! + izslope3! * dy
                NEXT y
            END IF
            yt1! = yt1! + yslope1!
            yt2! = yt2! + yslope2!
            iz1! = iz1! + izslope1!
            iz2! = iz2! + izslope2!
        NEXT x
    END IF

    IF xchng3 THEN
        yslope2! = (y3 - y2) / xchng3
        yt2! = y2
        izslope2! = (z3 - z2) / xchng3
        iz2! = z2
        FOR x = x2 + 1 TO x3
            iyt1 = CINT(yt1!)
            iyt2 = CINT(yt2!)
            dy = SGN(iyt2 - iyt1)
            IF dy THEN
                izslope3! = (iz2! - iz1!) / (iyt2 - iyt1)
                iz! = iz1!
                FOR y = iyt1 TO iyt2 STEP dy
                    IF (y > 199 AND dy = 1) OR (y < 0 AND dy = -1) THEN EXIT FOR
                    IF y < 200 AND y > -1 THEN
                        z = iz!
                        p = x + 320 * y + zoff
                        DEF SEG = zseg
                        IF PEEK(p) > z OR PEEK(p) = 0 THEN
                            POKE p, z
                            DEF SEG = segment
                            POKE p, col
                        ELSE
                            DEF SEG = segment
                        END IF
                    END IF
                    iz! = iz! + izslope3! * dy
                NEXT y
            END IF
            yt1! = yt1! + yslope1!
            yt2! = yt2! + yslope2!
            iz1! = iz1! + izslope1!
            iz2! = iz2! + izslope2!
        NEXT x
    END IF
END IF

END SUB

SUB flatshade2 (xp1, yp1, xp2, yp2, xp3, yp3, z, col, segment, offset, zseg, zoff)

IF yp1 <= yp2 THEN
    IF yp1 <= yp3 THEN
        y1 = yp1: x1 = xp1
        IF yp2 < yp3 THEN
            y2 = yp2: x2 = xp2
            y3 = yp3: x3 = xp3
        ELSE
            y2 = yp3: x2 = xp3
            y3 = yp2: x3 = xp2
        END IF
    ELSE
        y1 = yp3: x1 = xp3
        y2 = yp1: x2 = xp1
        y3 = yp2: x3 = xp2
    END IF
ELSE
    IF yp2 <= yp3 THEN
        y1 = yp2: x1 = xp2
        IF yp1 < yp3 THEN
            y2 = yp1: x2 = xp1
            y3 = yp3: x3 = xp3
        ELSE
            y2 = yp3: x2 = xp3
            y3 = yp1: x3 = xp1
        END IF
    ELSE
        y1 = yp3: x1 = xp3
        y2 = yp2: x2 = xp2
        y3 = yp1: x3 = xp1
    END IF
END IF

IF y3 = y1 THEN
    EXIT SUB
ELSE
    ychng1 = y3 - y1
    ychng2 = y2 - y1
    ychng3 = y3 - y2
    xslope1! = (x3 - x1) / ychng1
    xt1! = x1
    IF ychng2 THEN
        xslope2! = (x2 - x1) / ychng2
        xt2! = x1
        p = 320 * y1
        FOR y = y1 TO y2
            ixt1 = xt1!
            ixt2 = xt2!
            IF ixt2 < ixt1 THEN SWAP ixt1, ixt2
            p2 = p + ixt1
            FOR x = ixt1 TO ixt2
                IF x > 319 THEN EXIT FOR
                IF x > -1 THEN
                    DEF SEG = zseg
                    IF PEEK(p2) > z OR PEEK(p2) = 0 OR transparent THEN
                        POKE p2, z
                        DEF SEG = segment
                        IF transparent THEN
                            c = col \ 2 + PEEK(p2)
                            IF c > 255 THEN c = 255
                            POKE p2, c
                        ELSE
                            POKE p2, col
                        END IF
                    ELSE
                        DEF SEG = segment
                    END IF
                END IF
                p2 = p2 + 1
            NEXT x
            xt1! = xt1! + xslope1!
            xt2! = xt2! + xslope2!
            p = p + 320
        NEXT y
    END IF
    IF ychng3 THEN
        xslope2! = (x3 - x2) / ychng3
        xt2! = x2
        p = 320 * y2 + 320
        FOR y = y2 + 1 TO y3
            ixt1 = xt1!
            ixt2 = xt2!
            IF ixt2 < ixt1 THEN SWAP ixt1, ixt2
            p2 = p + ixt1
            FOR x = ixt1 TO ixt2
                IF x > 319 THEN EXIT FOR
                IF x > -1 THEN
                    DEF SEG = zseg
                    IF PEEK(p2) > z OR PEEK(p2) = 0 OR transparent THEN
                        POKE p2, z
                        DEF SEG = segment
                        IF transparent THEN
                            c = col \ 2 + PEEK(p2)
                            IF c > 255 THEN c = 255
                            POKE p2, c
                        ELSE
                            POKE p2, col
                        END IF
                    ELSE
                        DEF SEG = segment
                    END IF
                END IF
                p2 = p2 + 1
            NEXT x
            xt1! = xt1! + xslope1!
            xt2! = xt2! + xslope2!
            p = p + 320
        NEXT y
    END IF
END IF

END SUB

SUB floor (frames)

DIM zang AS INTEGER
DIM sz AS SINGLE
DIM cz AS SINGLE

grad 0, 0, 0, 0, 63, 63, 31, 0
grad 64, 63, 31, 0, 127, 63, 63, 63
grad 128, 0, 0, 0, 191, 0, 31, 63
grad 192, 0, 31, 63, 255, 63, 63, 63

DIM sins(0 TO 255) AS SINGLE
DIM coss(0 TO 255) AS SINGLE
FOR s = 0 TO 255
    sins(s) = SIN(s * pi / 128)
    coss(s) = COS(s * pi / 128)
NEXT

DIM tile(8193) AS INTEGER
DEF SEG = VARSEG(tile(0))
BLOAD "tmap.bsv", VARPTR(tile(0))
DEF SEG
tseg = VARSEG(tile(2))
toff = VARPTR(tile(2))

DIM temp(0 TO 319) AS INTEGER

DIM divs(127) AS INTEGER
FOR d = 0 TO 127
    divs(d) = INT(d * .9)
NEXT d

DIM parts(1 TO numparts, 2, 3) AS INTEGER
FOR p = 1 TO numparts
    parts(p, 0, 0) = RND * 159 + 80
    parts(p, 0, 1) = RND * 159 + 80
    parts(p, 0, 2) = RND * 159 + 80
    parts(p, 0, 3) = RND * 159 + 80
    parts(p, 1, 0) = RND * 49 + 25
    parts(p, 1, 1) = RND * 49 + 25
    parts(p, 1, 2) = RND * 49 + 25
    parts(p, 1, 3) = RND * 49 + 25
NEXT p

px1 = 0
py1 = 0
pz1 = 0
px2 = px1 + RND * 256 - 128
py2 = py1 + RND * 256 - 128
pz2 = pz1 + RND * 256 - 128
px3 = px2 + RND * 256 - 128
py3 = py2 + RND * 256 - 128
pz3 = pz2 + RND * 256 - 128
px4 = px3 + RND * 256 - 128
py4 = py3 + RND * 256 - 128
pz4 = pz3 + RND * 256 - 128

'$DYNAMIC
DIM buffer(32001) AS INTEGER
'$STATIC
buffer(0) = 2560
buffer(1) = 200
segment = VARSEG(buffer(2))
offset = VARPTR(buffer(2))

t2 = 0
DO
    t1# = CLOCK / 4660.859#
    a! = (100 - t2) / 100
    b! = t2 / 100
    xc! = px1 * a! * a! * a! + 3 * px2 * a! * a! * b! + 3 * px3 * a! * b! * b! + px4 * b! * b! * b!
    yc! = py1 * a! * a! * a! + 3 * py2 * a! * a! * b! + 3 * py3 * a! * b! * b! + py4 * b! * b! * b!
    zang = (pz1 * a! * a! * a! + 3 * pz2 * a! * a! * b! + 3 * pz3 * a! * b! * b! + pz4 * b! * b! * b!) AND 255
    IF t2 = 100 THEN
        px1 = px4
        px2 = px1 - px3 + px4
        px3 = px2 + RND * 256 - 128
        px4 = px3 + RND * 256 - 128
        py1 = py4
        py2 = py1 - py3 + py4
        py3 = py2 + RND * 256 - 128
        py4 = py3 + RND * 256 - 128
        pz1 = pz4
        pz2 = pz1 - pz3 + pz4
        pz3 = pz2 + RND * 256 - 128
        pz4 = pz3 + RND * 256 - 128
        t2 = 0
    END IF
    t2 = t2 + 1
    sz = sins(zang)
    cz = coss(zang)
    DEF SEG = segment
    FOR p = offset + 32000 TO offset + 32320
        POKE p, 0
    NEXT p
    p = 32320 + offset
    dc! = .005
    FOR y = 1 TO 99
        ty! = 100 / y
        ty2! = (10000 / y - 100) / 4
        tycz! = ty2! * cz
        tysz! = ty2! * sz
        DEF SEG = tseg
        tx2! = -40 * ty!
        dtx2! = ty! / 4
        FOR x = 0 TO 319
            tx3 = (tx2! * cz + tysz! + xc!) AND 127
            ty3 = (tycz! - tx2! * sz + yc!) AND 127
            temp(x) = PEEK(128 * ty3 + tx3 + toff) * dc! + 128
            tx2! = tx2! + dtx2!
        NEXT x
        DEF SEG = segment
        x = 0
        FOR b = 1 TO 40
            POKE p, temp(x)
            POKE p + 1, temp(x + 1)
            POKE p + 2, temp(x + 2)
            POKE p + 3, temp(x + 3)
            POKE p + 4, temp(x + 4)
            POKE p + 5, temp(x + 5)
            POKE p + 6, temp(x + 6)
            POKE p + 7, temp(x + 7)
            x = x + 8
            p = p + 8
        NEXT b
        dc! = dc! + .005
    NEXT y
    t = t + 1
    FOR p = 1 TO numparts
        a! = (100 - t) / 100
        b! = t / 100
        x = parts(p, 0, 0) * a! * a! * a! + 3 * parts(p, 0, 1) * a! * a! * b! + 3 * parts(p, 0, 2) * a! * b! * b! + parts(p, 0, 3) * b! * b! * b!
        y = parts(p, 1, 0) * a! * a! * a! + 3 * parts(p, 1, 1) * a! * a! * b! + 3 * parts(p, 1, 2) * a! * b! * b! + parts(p, 1, 3) * b! * b! * b!
        IF t = 100 THEN
            parts(p, 0, 0) = parts(p, 0, 3)
            parts(p, 0, 1) = parts(p, 0, 0) - parts(p, 0, 2) + parts(p, 0, 3)
            parts(p, 0, 2) = RND * 159 + 80
            parts(p, 0, 3) = RND * 159 + 80
            parts(p, 1, 0) = parts(p, 1, 3)
            parts(p, 1, 1) = parts(p, 1, 0) - parts(p, 1, 2) + parts(p, 1, 3)
            parts(p, 1, 2) = RND * 49 + 25
            parts(p, 1, 3) = RND * 49 + 25
        END IF
        p2 = 320 * y + x + offset
        col = PEEK(p2 - 321) + 7: IF col > 127 THEN col = 127
        POKE p2 - 321, col
        col = PEEK(p2 - 320) + 15: IF col > 127 THEN col = 127
        POKE p2 - 320, col
        col = PEEK(p2 - 319) + 7: IF col > 127 THEN col = 127
        POKE p2 - 319, col
        col = PEEK(p2 - 1) + 15: IF col > 127 THEN col = 127
        POKE p2 - 1, col
        col = PEEK(p2) + 31: IF col > 127 THEN col = 127
        POKE p2, col
        col = PEEK(p2 + 1) + 15: IF col > 127 THEN col = 127
        POKE p2 + 1, col
        col = PEEK(p2 + 319) + 7: IF col > 127 THEN col = 127
        POKE p2 + 319, col
        col = PEEK(p2 + 320) + 15: IF col > 127 THEN col = 127
        POKE p2 + 320, col
        col = PEEK(p2 + 321) + 7: IF col > 127 THEN col = 127
        POKE p2 + 321, col
    NEXT p
    IF t = 100 THEN t = 0
    PUT (0, 0), buffer, PSET
    FOR p = offset + 321 TO offset + 31678
        col = divs(PEEK(p))
        POKE p, col
    NEXT p
    f = f + 1
    'pause t1# + .02
LOOP UNTIL f = frames OR INKEY$ <> ""

END SUB

SUB floorceiling (frames)

DIM zang AS INTEGER
DIM sz AS SINGLE
DIM cz AS SINGLE

grad 0, 0, 0, 0, 127, 0, 31, 63
grad 128, 0, 31, 63, 255, 63, 63, 63

DIM sins(0 TO 255) AS SINGLE
DIM coss(0 TO 255) AS SINGLE
FOR s = 0 TO 255
    sins(s) = SIN(s * pi / 128)
    coss(s) = COS(s * pi / 128)
NEXT

DIM tile(8193) AS INTEGER
DEF SEG = VARSEG(tile(0))
BLOAD "tmap.bsv", VARPTR(tile(0))
DEF SEG
tseg = VARSEG(tile(2))
toff = VARPTR(tile(2))

DIM temp(0 TO 319) AS INTEGER

DIM parts(1 TO numparts, 2, 3) AS INTEGER
FOR p = 1 TO numparts
    parts(p, 0, 0) = RND * 159
    parts(p, 0, 1) = RND * 159
    parts(p, 0, 2) = RND * 159
    parts(p, 0, 3) = RND * 159
    parts(p, 1, 0) = RND * 99
    parts(p, 1, 1) = RND * 99
    parts(p, 1, 2) = RND * 99
    parts(p, 1, 3) = RND * 99
    parts(p, 2, 0) = RND * 99
    parts(p, 2, 1) = RND * 99
    parts(p, 2, 2) = RND * 99
    parts(p, 2, 3) = RND * 99
NEXT p

px1 = 0
py1 = 0
pz1 = 0
px2 = px1 + RND * 256 - 128
py2 = py1 + RND * 256 - 128
pz2 = pz1 + RND * 256 - 128
px3 = px2 + RND * 256 - 128
py3 = py2 + RND * 256 - 128
pz3 = pz2 + RND * 256 - 128
px4 = px3 + RND * 256 - 128
py4 = py3 + RND * 256 - 128
pz4 = pz3 + RND * 256 - 128

'$DYNAMIC
DIM buffer(32001) AS INTEGER
'$STATIC
buffer(0) = 2560
buffer(1) = 200
segment = VARSEG(buffer(2))
offset = VARPTR(buffer(2))

t2 = 0
DO
    t1# = CLOCK / 4660.859#
    a! = (100 - t2) / 100
    b! = t2 / 100
    xc! = px1 * a! * a! * a! + 3 * px2 * a! * a! * b! + 3 * px3 * a! * b! * b! + px4 * b! * b! * b!
    yc! = py1 * a! * a! * a! + 3 * py2 * a! * a! * b! + 3 * py3 * a! * b! * b! + py4 * b! * b! * b!
    zang = (pz1 * a! * a! * a! + 3 * pz2 * a! * a! * b! + 3 * pz3 * a! * b! * b! + pz4 * b! * b! * b!) AND 255
    IF t2 = 100 THEN
        px1 = px4
        px2 = px1 - px3 + px4
        px3 = px2 + RND * 256 - 128
        px4 = px3 + RND * 256 - 128
        py1 = py4
        py2 = py1 - py3 + py4
        py3 = py2 + RND * 256 - 128
        py4 = py3 + RND * 256 - 128
        pz1 = pz4
        pz2 = pz1 - pz3 + pz4
        pz3 = pz2 + RND * 256 - 128
        pz4 = pz3 + RND * 256 - 128
        t2 = 0
    END IF
    t2 = t2 + 1
    sz = sins(zang)
    cz = coss(zang)
    DEF SEG = segment
    FOR p = offset + 32000 TO offset + 32320
        POKE p, 0
    NEXT p
    p = 32320 + offset
    p2 = 31680 + offset
    FOR y = 1 TO 99
        ty! = 100 / y
        ty2! = (10000 / y - 100) / 4
        tycz! = ty2! * cz
        tysz! = ty2! * sz
        dc! = y / 100
        IF dc! > 0 THEN
            DEF SEG = tseg
            tx2! = -40 * ty!
            dtx2! = ty! / 4
            FOR x = 0 TO 319
                tx3 = (tx2! * cz + tysz! + xc!) AND 127
                ty3 = (tycz! - tx2! * sz + yc!) AND 127
                temp(x) = PEEK(128 * ty3 + tx3 + toff) * dc!
                tx2! = tx2! + dtx2!
            NEXT x
            DEF SEG = segment
            x = 0
            FOR b = 1 TO 40
                POKE p, temp(x)
                POKE p + 1, temp(x + 1)
                POKE p + 2, temp(x + 2)
                POKE p + 3, temp(x + 3)
                POKE p + 4, temp(x + 4)
                POKE p + 5, temp(x + 5)
                POKE p + 6, temp(x + 6)
                POKE p + 7, temp(x + 7)
                POKE p2, temp(x)
                POKE p2 + 1, temp(x + 1)
                POKE p2 + 2, temp(x + 2)
                POKE p2 + 3, temp(x + 3)
                POKE p2 + 4, temp(x + 4)
                POKE p2 + 5, temp(x + 5)
                POKE p2 + 6, temp(x + 6)
                POKE p2 + 7, temp(x + 7)
                x = x + 8
                p = p + 8
                p2 = p2 + 8
            NEXT b
        ELSE
            p2 = p2 + 320
            p = p + 320
        END IF
        p2 = p2 - 640
    NEXT y
    t = t + 1
    FOR p = 1 TO numparts
        a! = (100 - t) / 100
        b! = t / 100
        x = parts(p, 0, 0) * a! * a! * a! + 3 * parts(p, 0, 1) * a! * a! * b! + 3 * parts(p, 0, 2) * a! * b! * b! + parts(p, 0, 3) * b! * b! * b! - 80
        y = parts(p, 1, 0) * a! * a! * a! + 3 * parts(p, 1, 1) * a! * a! * b! + 3 * parts(p, 1, 2) * a! * b! * b! + parts(p, 1, 3) * b! * b! * b! - 50
        z = parts(p, 2, 0) * a! * a! * a! + 3 * parts(p, 2, 1) * a! * a! * b! + 3 * parts(p, 2, 2) * a! * b! * b! + parts(p, 2, 3) * b! * b! * b!
        IF t = 100 THEN
            parts(p, 0, 0) = parts(p, 0, 3)
            parts(p, 0, 1) = parts(p, 0, 0) - parts(p, 0, 2) + parts(p, 0, 3)
            parts(p, 0, 2) = RND * 159
            parts(p, 0, 3) = RND * 159
            parts(p, 1, 0) = parts(p, 1, 3)
            parts(p, 1, 1) = parts(p, 1, 0) - parts(p, 1, 2) + parts(p, 1, 3)
            parts(p, 1, 2) = RND * 99
            parts(p, 1, 3) = RND * 99
            parts(p, 2, 0) = parts(p, 2, 3)
            parts(p, 2, 1) = parts(p, 2, 0) - parts(p, 2, 2) + parts(p, 2, 3)
            parts(p, 2, 2) = RND * 99
            parts(p, 2, 3) = RND * 99
        END IF
        drawpart x, y, z
    NEXT p
    IF t = 100 THEN t = 0
    PUT (0, 0), buffer, PSET
    f = f + 1
    'pause t1# + .03
LOOP UNTIL f = frames OR INKEY$ <> ""

END SUB

SUB grad (col1, r1, g1, b1, col2, r2, g2, b2)

cols = col2 - col1 + 1
rstep# = (r2 - r1 + 1) / cols
gstep# = (g2 - g1 + 1) / cols
bstep# = (b2 - b1 + 1) / cols
r# = r1
g# = g1
b# = b1
FOR col = col1 TO col2
    r# = r# + rstep#
    g# = g# + gstep#
    b# = b# + bstep#
    IF r# > 63 THEN r# = 63
    IF r# < 0 THEN r# = 0
    IF g# > 63 THEN g# = 63
    IF g# < 0 THEN g# = 0
    IF b# > 63 THEN b# = 63
    IF b# < 0 THEN b# = 0
    pal col, CINT(r#), CINT(g#), CINT(b#)
NEXT

END SUB

SUB grad2 (r1, g1, b1, r2, g2, b2, r3, g3, b3, r4, g4, b4)

rd1 = (r3 - r1) / 16
rd2 = (r4 - r2) / 16
gd1 = (g3 - g1) / 16
gd2 = (g4 - g2) / 16
bd1 = (b3 - b1) / 16
bd2 = (b4 - b2) / 16

rg1 = r1
rg2 = r2
gg1 = g1
gg2 = g2
bg1 = b1
bg2 = b2
FOR g = 1 TO 16
        rg1 = rg1 + rd1
        rg2 = rg2 + rd2
        gg1 = gg1 + gd1
        gg2 = gg2 + gd2
        bg1 = bg1 + bd1
        bg2 = bg2 + bd2
        c1 = 16 * g - 16
        c2 = 16 * g - 1
        grad c1, rg1, gg1, bg1, c2, rg2, gg2, bg2
NEXT g

END SUB

SUB pal (c, r, g, b)

OUT &H3C8, c
OUT &H3C9, r
OUT &H3C9, g
OUT &H3C9, b

END SUB

SUB pause (etime#)

DO
LOOP UNTIL CLOCK / 4660.859# >= etime#

END SUB

SUB plasma (frames)

'$DYNAMIC
DIM buffer(32001) AS INTEGER
'$STATIC
buffer(0) = 2560
buffer(1) = 200
segment = VARSEG(buffer(2))
offset = VARPTR(buffer(2))

DIM sins1(-360 TO 720) AS INTEGER
DIM coss1(-360 TO 720) AS INTEGER
DIM sins2(-360 TO 720) AS INTEGER
DIM coss2(-360 TO 720) AS INTEGER
DIM sins3(-360 TO 720) AS INTEGER
DIM coss3(-360 TO 720) AS INTEGER
DIM sins4(-360 TO 720) AS INTEGER
DIM coss4(-360 TO 720) AS INTEGER
FOR s = -360 TO 720
    sins1(s) = 128 * SIN(s * pi / 256)
    coss1(s) = 128 * COS(s * pi / 256)
    sins2(s) = 128 * SIN(s * pi / 128)
    coss2(s) = 128 * COS(s * pi / 128)
    sins3(s) = 128 * SIN(s * pi / 64)
    coss3(s) = 128 * COS(s * pi / 64)
    sins4(s) = 128 * SIN(s * pi / 32)
    coss4(s) = 128 * COS(s * pi / 32)
NEXT s

grad 0, 0, 0, 0, 63, 63, 31, 0
grad 64, 63, 31, 0, 127, 63, 63, 63
grad 128, 63, 63, 63, 191, 0, 31, 63
grad 192, 0, 31, 63, 255, 0, 0, 0

t# = TIMER
DO
    t1# = CLOCK / 4660.859#
    s1 = (s1 + 1) AND 511
    c1 = (c1 + 1) AND 511
    s2 = (s2 - 1) AND 255
    c2 = (c2 + 1) AND 255
    s3 = (s3 + 1) AND 127
    c3 = (c3 - 1) AND 127
    s4 = (s4 - 1) AND 63
    c4 = (c4 + 1) AND 63
    p = offset
    DEF SEG = segment
    FOR y = 0 TO 24
        cy = sins1(y + s1) + coss2(y + c2) + coss3(y + c3) + sins4(y + s4)
        FOR x = 0 TO 39
            col = cy + coss1(x + c1) + sins2(x + s2) + sins3(x + s3) + coss4(x + y + c4)
            size = (col \ 32) AND 7
            IF size > 3 THEN size = 7 - size
            p2 = p + 321 * (4 - size)
            FOR y2 = 0 TO size + size
                FOR x2 = 0 TO size + size
                    POKE p2 + x2, col
                NEXT x2
                p2 = p2 + 320
            NEXT y2
            p = p + 8
        NEXT x
        p = p + 2240
    NEXT y
    PUT (0, 0), buffer, PSET
    REDIM buffer(32001) AS INTEGER
    buffer(0) = 2560
    buffer(1) = 200
    segment = VARSEG(buffer(2))
    offset = VARPTR(buffer(2))
    f = f + 1
    'pause t1# + .03
LOOP UNTIL f = frames OR INKEY$ <> ""

END SUB

SUB teapot (frames)

DIM numpoints AS INTEGER
DIM numpolys AS INTEGER

DIM arccos(-256 TO 256) AS INTEGER
FOR a = -256 TO 256
    c1! = 0
    c2! = 360
    DO
        c3! = (c2! + c1!) / 2
        c! = COS(c3! * pi / 180) * 256
        IF c! < a THEN c2! = c3! ELSE c1! = c3!
    LOOP UNTIL c2! - c1! < 1
    arccos(a) = 255 - c3! * 2
    IF arccos(a) < 0 THEN arccos(a) = 0
NEXT a

DIM sins(-360 TO 360) AS SINGLE
DIM coss(-360 TO 360) AS SINGLE
FOR s = -360 TO 360
    sins(s) = SIN(s * pi / 180)
    coss(s) = COS(s * pi / 180)
NEXT

OPEN "teapot.plg" FOR INPUT AS 1
LINE INPUT #1, lbuf$
lbuf$ = LTRIM$(lbuf$)
lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - INSTR(lbuf$, " "))
lbuf$ = LTRIM$(lbuf$)
numpoints = VAL(LEFT$(lbuf$, INSTR(lbuf$, " ")))
lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - INSTR(lbuf$, " "))
lbuf$ = LTRIM$(lbuf$)
numpolys = VAL(lbuf$)

DIM points(numpoints) AS p3d
DIM rotpoints(numpoints) AS p3d
DIM polys(numpolys) AS poly
DIM normals(numpolys) AS p3d
DIM rotnormals(numpolys) AS p3d
DIM projpoints(numpoints) AS p2d

FOR p = 1 TO numpoints
    LINE INPUT #1, lbuf$
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    points(p).x = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    points(p).z = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    IF lps THEN
        points(p).y = VAL(LEFT$(lbuf$, lps))
    ELSE
        points(p).y = VAL(lbuf$)
    END IF
NEXT p

FOR p = 1 TO numpolys
    LINE INPUT #1, lbuf$
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    IF nop = 4 THEN
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p1 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p2 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p3 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p4 = VAL(lbuf$) + 1
        polys(p).p1 = p1
        polys(p).p2 = p2
        polys(p).p3 = p4
        p = p + 1
        polys(p).p1 = p2
        polys(p).p2 = p3
        polys(p).p3 = p4
    ELSE
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        polys(p).p1 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        polys(p).p2 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        polys(p).p3 = VAL(lbuf$) + 1
    END IF
NEXT p
CLOSE

maxx! = points(1).x
minx! = points(1).x
maxy! = points(1).y
miny! = points(1).y
maxz! = points(1).z
minz! = points(1).z
FOR p = 1 TO numpoints
    IF maxx! < points(p).x THEN maxx! = points(p).x
    IF minx! > points(p).x THEN minx! = points(p).x
    IF maxy! < points(p).y THEN maxy! = points(p).y
    IF miny! > points(p).y THEN miny! = points(p).y
    IF maxz! < points(p).z THEN maxz! = points(p).z
    IF minz! > points(p).z THEN minz! = points(p).z
NEXT
normx! = (maxx! + minx!) / 2
normy! = (maxy! + miny!) / 2
normz! = (maxz! + minz!) / 2
IF maxx! > maxy! THEN s1! = maxx! ELSE s1! = maxy!
IF s1! < maxz! THEN s1! = maxz!
IF s1! <> 0 THEN s2! = 50 / s1! ELSE s2! = 1
FOR p = 1 TO numpoints
    points(p).x = (points(p).x - normx!) * s2!
    points(p).y = (points(p).y - normy!) * s2!
    points(p).z = (points(p).z - normz!) * s2!
NEXT

FOR p = 1 TO numpolys
    x1! = points(polys(p).p1).x
    y1! = points(polys(p).p1).y
    z1! = points(polys(p).p1).z
    x2! = points(polys(p).p2).x
    y2! = points(polys(p).p2).y
    z2! = points(polys(p).p2).z
    x3! = points(polys(p).p3).x
    y3! = points(polys(p).p3).y
    z3! = points(polys(p).p3).z
    xc1! = x2! - x1!
    yc1! = y2! - y1!
    zc1! = z2! - z1!
    xc2! = x3! - x1!
    yc2! = y3! - y1!
    zc2! = z3! - z1!
    normals(p).x = yc1! * zc2! - zc1! * yc2!
    normals(p).y = zc1! * xc2! - xc1! * zc2!
    normals(p).z = xc1! * yc2! - yc1! * xc2!
    mag! = SQR(normals(p).x ^ 2 + normals(p).y ^ 2 + normals(p).z ^ 2)
    IF mag! = 0 THEN mag! = 1
    normals(p).x = normals(p).x / mag! * 256
    normals(p).y = normals(p).y / mag! * 256
    normals(p).z = normals(p).z / mag! * 256
NEXT p

grad 0, 0, 0, 0, 255, 63, 63, 63

'$DYNAMIC
DIM buffer(32001) AS INTEGER
DIM zbuf(31999) AS INTEGER
'$STATIC
buffer(0) = 2560
buffer(1) = 200
segment = VARSEG(buffer(2))
offset = VARPTR(buffer(2))
zseg = VARSEG(zbuf(0))
zoff = VARPTR(zbuf(0))

t! = TIMER
DEF SEG = segment
DO
    t1# = CLOCK / 4660.859#
    xrot = (xrot + 1) MOD 360
    yrot = (yrot + 1) MOD 360
    zrot = (zrot + 1) MOD 360
    sx! = sins(xrot)
    cx! = coss(xrot)
    sy! = sins(yrot)
    cy! = coss(yrot)
    sz! = sins(zrot)
    cz! = coss(zrot)
    cubex1! = cy! * cz!
    cubey1! = -cy! * sz!
    cubez1! = sy!
    cubex2! = sx! * sy! * cz! + cx! * sz!
    cubey2! = cx! * cz! - sx! * sy! * sz!
    cubez2! = -sx! * cy!
    cubex3! = sx! * sz! - cx! * sy! * cz!
    cubey3! = sx! * cz! + cx! * sy! * sz!
    cubez3! = cx! * cy!
    REDIM buffer(32001) AS INTEGER
    buffer(0) = 2560
    buffer(1) = 200
    segment = VARSEG(buffer(2))
    offset = VARPTR(buffer(2))
    REDIM zbuf(31999) AS INTEGER
    zseg = VARSEG(zbuf(0))
    zoff = VARPTR(zbuf(0))
    FOR p = 1 TO numpoints
        x! = points(p).x
        y! = points(p).y
        z! = points(p).z
        xr! = x! * cubex1! + y! * cubex2! + z! * cubex3!
        yr! = x! * cubey1! + y! * cubey2! + z! * cubey3!
        zr! = x! * cubez1! + y! * cubez2! + z! * cubez3!
        rotpoints(p).x = xr!
        rotpoints(p).y = yr!
        rotpoints(p).z = zr!
        projpoints(p).x = 200 * xr! \ (zr! + 100) + 160
        projpoints(p).y = 200 * yr! \ (zr! + 100) + 100
    NEXT p
    FOR p = 1 TO numpolys
        x! = normals(p).x
        y! = normals(p).y
        z! = normals(p).z
        rotnormals(p).x = x! * cubex1! + y! * cubex2! + z! * cubex3!
        rotnormals(p).y = x! * cubey1! + y! * cubey2! + z! * cubey3!
        rotnormals(p).z = x! * cubez1! + y! * cubez2! + z! * cubez3!
    NEXT p
    FOR p = 1 TO numpolys
        p1 = polys(p).p1
        p2 = polys(p).p2
        p3 = polys(p).p3
        x1 = projpoints(p1).x
        y1 = projpoints(p1).y
        x2 = projpoints(p2).x
        y2 = projpoints(p2).y
        x3 = projpoints(p3).x
        y3 = projpoints(p3).y
        IF (y1 - y2) * (x2 - x3) > (x1 - x2) * (y2 - y3) THEN
            z1 = rotpoints(p1).z + 100
            z2 = rotpoints(p2).z + 100
            z3 = rotpoints(p3).z + 100
            flatshade x1, y1, z1, x2, y2, z2, x3, y3, z3, arccos((rotnormals(p).x - rotnormals(p).z) / 1.414), segment, offset, zseg, zoff
        END IF
    NEXT p
    PUT (0, 0), buffer, PSET
    f = f + 1
    'pause t1# + .03
LOOP UNTIL f = frames OR INKEY$ <> ""

END SUB

SUB teapotplasma (frames)

DIM numpoints AS INTEGER
DIM numpolys AS INTEGER

DIM arccos(-512 TO 512) AS INTEGER
FOR a = -512 TO 512
    c1! = 0
    c2! = 360
    DO
        c3! = (c2! + c1!) / 2
        c! = COS(c3! * pi / 180) * 256
        IF c! < a THEN c2! = c3! ELSE c1! = c3!
    LOOP UNTIL c2! - c1! < 1
    arccos(a) = 255 - c3!
    IF arccos(a) < 128 THEN arccos(a) = 128
    IF arccos(a) > 255 THEN arccos(a) = 255
NEXT a

DIM sins(255) AS SINGLE
DIM coss(255) AS SINGLE
FOR s = 0 TO 255
    sins(s) = SIN(s * pi / 127)
    coss(s) = COS(s * pi / 127)
NEXT

OPEN "teapot.plg" FOR INPUT AS 1
LINE INPUT #1, lbuf$
lbuf$ = LTRIM$(lbuf$)
lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - INSTR(lbuf$, " "))
lbuf$ = LTRIM$(lbuf$)
numpoints = VAL(LEFT$(lbuf$, INSTR(lbuf$, " ")))
lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - INSTR(lbuf$, " "))
lbuf$ = LTRIM$(lbuf$)
numpolys = VAL(lbuf$)

DIM points(numpoints) AS p3d
DIM rotpoints(numpoints) AS p3d
DIM polys(numpolys) AS poly
DIM normals(numpolys) AS p3d
DIM rotnormals(numpolys) AS p3d
DIM projpoints(numpoints) AS p2d

FOR p = 1 TO numpoints
    LINE INPUT #1, lbuf$
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    points(p).x = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    points(p).z = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    IF lps THEN
        points(p).y = VAL(LEFT$(lbuf$, lps))
    ELSE
        points(p).y = VAL(lbuf$)
    END IF
NEXT p

FOR p = 1 TO numpolys
    LINE INPUT #1, lbuf$
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    IF nop = 4 THEN
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p1 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p2 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p3 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p4 = VAL(lbuf$) + 1
        polys(p).p1 = p1
        polys(p).p2 = p2
        polys(p).p3 = p4
        p = p + 1
        polys(p).p1 = p2
        polys(p).p2 = p3
        polys(p).p3 = p4
    ELSE
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        polys(p).p1 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        polys(p).p2 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        polys(p).p3 = VAL(lbuf$) + 1
    END IF
NEXT p
CLOSE

DIM sins1(-360 TO 720) AS INTEGER
DIM coss1(-360 TO 720) AS INTEGER
DIM sins2(-360 TO 720) AS INTEGER
DIM coss2(-360 TO 720) AS INTEGER
DIM sins3(-360 TO 720) AS INTEGER
DIM coss3(-360 TO 720) AS INTEGER
FOR s = -360 TO 720
    sins1(s) = 64 * SIN(s * pi / 256)
    coss1(s) = 64 * COS(s * pi / 256)
    sins2(s) = 64 * SIN(s * pi / 128)
    coss2(s) = 64 * COS(s * pi / 128)
    sins3(s) = 64 * SIN(s * pi / 64)
    coss3(s) = 64 * COS(s * pi / 64)
NEXT s

maxx! = points(1).x
minx! = points(1).x
maxy! = points(1).y
miny! = points(1).y
maxz! = points(1).z
minz! = points(1).z
FOR p = 1 TO numpoints
    IF maxx! < points(p).x THEN maxx! = points(p).x
    IF minx! > points(p).x THEN minx! = points(p).x
    IF maxy! < points(p).y THEN maxy! = points(p).y
    IF miny! > points(p).y THEN miny! = points(p).y
    IF maxz! < points(p).z THEN maxz! = points(p).z
    IF minz! > points(p).z THEN minz! = points(p).z
NEXT
normx! = (maxx! + minx!) / 2
normy! = (maxy! + miny!) / 2
normz! = (maxz! + minz!) / 2
IF maxx! > maxy! THEN s1! = maxx! ELSE s1! = maxy!
IF s1! < maxz! THEN s1! = maxz!
IF s1! <> 0 THEN s2! = 50 / s1! ELSE s2! = 1
FOR p = 1 TO numpoints
    points(p).x = (points(p).x - normx!) * s2!
    points(p).y = (points(p).y - normy!) * s2!
    points(p).z = (points(p).z - normz!) * s2!
NEXT

FOR p = 1 TO numpolys
    x1! = points(polys(p).p1).x
    y1! = points(polys(p).p1).y
    z1! = points(polys(p).p1).z
    x2! = points(polys(p).p2).x
    y2! = points(polys(p).p2).y
    z2! = points(polys(p).p2).z
    x3! = points(polys(p).p3).x
    y3! = points(polys(p).p3).y
    z3! = points(polys(p).p3).z
    xc1! = x2! - x1!
    yc1! = y2! - y1!
    zc1! = z2! - z1!
    xc2! = x3! - x1!
    yc2! = y3! - y1!
    zc2! = z3! - z1!
    normals(p).x = yc1! * zc2! - zc1! * yc2!
    normals(p).y = zc1! * xc2! - xc1! * zc2!
    normals(p).z = xc1! * yc2! - yc1! * xc2!
    mag! = SQR(normals(p).x ^ 2 + normals(p).y ^ 2 + normals(p).z ^ 2)
    IF mag! = 0 THEN mag! = 1
    normals(p).x = normals(p).x / mag! * 256
    normals(p).y = normals(p).y / mag! * 256
    normals(p).z = normals(p).z / mag! * 256
NEXT p

grad 0, 0, 0, 0, 31, 63, 31, 0
grad 32, 63, 31, 0, 63, 63, 63, 63
grad 64, 63, 63, 63, 95, 0, 31, 63
grad 96, 0, 31, 63, 127, 0, 0, 0
grad 128, 63, 63, 63, 255, 0, 0, 0

'$DYNAMIC
DIM buffer(32001) AS INTEGER
DIM zbuf(31999) AS INTEGER
'$STATIC
buffer(0) = 2560
buffer(1) = 200
segment = VARSEG(buffer(2))
offset = VARPTR(buffer(2))
zseg = VARSEG(zbuf(0))
zoff = VARPTR(zbuf(0))

t! = TIMER
DEF SEG = segment
DO
    t1# = CLOCK / 4660.859#
    REDIM buffer(32001) AS INTEGER
    buffer(0) = 2560
    buffer(1) = 200
    segment = VARSEG(buffer(2))
    offset = VARPTR(buffer(2))
    REDIM zbuf(31999) AS INTEGER
    zseg = VARSEG(zbuf(0))
    zoff = VARPTR(zbuf(0))
    s1 = (s1 + 1) AND 511
    c1 = (c1 + 1) AND 511
    s2 = (s2 - 1) AND 255
    c2 = (c2 + 1) AND 255
    s3 = (s3 + 1) AND 127
    c3 = (c3 - 1) AND 127
    s4 = (s4 - 1) AND 63
    c4 = (c4 + 1) AND 63
    p = offset
    DEF SEG = segment
    FOR y = 0 TO 24
        cy = sins1(y + s1) + coss2(y + c2) + coss3(y + c3)
        FOR x = 0 TO 39
            col = (cy + coss1(x + c1) + sins2(x + s2) + sins3(x + s3)) AND 127
            size = col \ 16
            IF size > 3 THEN size = 7 - size
            p2 = p + 321 * (4 - size)
            FOR y2 = 0 TO size + size
                FOR x2 = 0 TO size + size
                    POKE p2 + x2, col
                NEXT x2
                p2 = p2 + 320
            NEXT y2
            p = p + 8
        NEXT x
        p = p + 2240
    NEXT y
    xrot = (xrot + 1) AND 255
    yrot = (yrot + 1) AND 255
    zrot = (zrot + 1) AND 255
    sx! = sins(xrot)
    cx! = coss(xrot)
    sy! = sins(yrot)
    cy! = coss(yrot)
    sz! = sins(zrot)
    cz! = coss(zrot)
    cubex1! = cy! * cz!
    cubey1! = -cy! * sz!
    cubez1! = sy!
    cubex2! = sx! * sy! * cz! + cx! * sz!
    cubey2! = cx! * cz! - sx! * sy! * sz!
    cubez2! = -sx! * cy!
    cubex3! = sx! * sz! - cx! * sy! * cz!
    cubey3! = sx! * cz! + cx! * sy! * sz!
    cubez3! = cx! * cy!
    FOR p = 1 TO numpoints
        x! = points(p).x
        y! = points(p).y
        z! = points(p).z
        xr! = x! * cubex1! + y! * cubex2! + z! * cubex3!
        yr! = x! * cubey1! + y! * cubey2! + z! * cubey3!
        zr! = x! * cubez1! + y! * cubez2! + z! * cubez3!
        rotpoints(p).x = xr!
        rotpoints(p).y = yr!
        rotpoints(p).z = zr!
        projpoints(p).x = 200 * xr! \ (zr! + 100) + 160
        projpoints(p).y = 200 * yr! \ (zr! + 100) + 100
    NEXT p
    FOR p = 1 TO numpolys
        x! = normals(p).x
        y! = normals(p).y
        z! = normals(p).z
        rotnormals(p).x = x! * cubex1! + y! * cubex2! + z! * cubex3!
        rotnormals(p).y = x! * cubey1! + y! * cubey2! + z! * cubey3!
        rotnormals(p).z = x! * cubez1! + y! * cubez2! + z! * cubez3!
    NEXT p
    FOR p = 1 TO numpolys
        p1 = polys(p).p1
        p2 = polys(p).p2
        p3 = polys(p).p3
        x1 = projpoints(p1).x
        y1 = projpoints(p1).y
        x2 = projpoints(p2).x
        y2 = projpoints(p2).y
        x3 = projpoints(p3).x
        y3 = projpoints(p3).y
        IF (y1 - y2) * (x2 - x3) > (x1 - x2) * (y2 - y3) THEN
            z1 = rotpoints(p1).z + 100
            z2 = rotpoints(p2).z + 100
            z3 = rotpoints(p3).z + 100
            z = (z1 + z2 + z3) \ 3
            flatshade2 x1, y1, x2, y2, x3, y3, z, arccos((rotnormals(p).x - rotnormals(p).y) / 1.414), segment, offset, zseg, zoff
        END IF
    NEXT p
    PUT (0, 0), buffer, PSET
    f = f + 1
    'pause t1# + .03
LOOP UNTIL f = frames OR INKEY$ <> ""

END SUB

SUB title (frames)

'grad 0, 0, 0, 0, 255, 63, 63, 63
grad 0, 63, 63, 63, 255, 0, 0, 0

DIM sliq(31999) AS INTEGER
tseg = VARSEG(sliq(0))
toff = VARPTR(sliq(0))
DEF SEG = tseg
BLOAD "sliq.bsv", toff
DEF SEG

DIM parts(1 TO numparts2, 1, 3) AS INTEGER
FOR p = 1 TO numparts2
    parts(p, 0, 0) = RND * 319
    parts(p, 0, 1) = RND * 319
    parts(p, 0, 2) = RND * 319
    parts(p, 0, 3) = RND * 319
    parts(p, 1, 0) = RND * 199
    parts(p, 1, 1) = RND * 199
    parts(p, 1, 2) = RND * 199
    parts(p, 1, 3) = RND * 199
NEXT p

'$DYNAMIC
DIM buffer(32001) AS INTEGER
'$STATIC
buffer(0) = 2560
buffer(1) = 200
segment = VARSEG(buffer(2))
offset = VARPTR(buffer(2))

DO
    t1# = CLOCK / 4660.859#
    DEF SEG = segment
    t = t + 1
    FOR p = 1 TO numparts2
        a! = (100 - t) / 100
        b! = t / 100
        x = parts(p, 0, 0) * a! * a! * a! + 3 * parts(p, 0, 1) * a! * a! * b! + 3 * parts(p, 0, 2) * a! * b! * b! + parts(p, 0, 3) * b! * b! * b!
        y = parts(p, 1, 0) * a! * a! * a! + 3 * parts(p, 1, 1) * a! * a! * b! + 3 * parts(p, 1, 2) * a! * b! * b! + parts(p, 1, 3) * b! * b! * b!
        IF t = 100 THEN
            parts(p, 0, 0) = parts(p, 0, 3)
            parts(p, 0, 1) = parts(p, 0, 0) - parts(p, 0, 2) + parts(p, 0, 3)
            parts(p, 0, 2) = RND * 319
            parts(p, 0, 3) = RND * 319
            parts(p, 1, 0) = parts(p, 1, 3)
            parts(p, 1, 1) = parts(p, 1, 0) - parts(p, 1, 2) + parts(p, 1, 3)
            parts(p, 1, 2) = RND * 199
            parts(p, 1, 3) = RND * 199
        END IF
        y1 = y - 31
        y2 = y + 31
        x1 = x - 31
        x2 = x + 31
        dp = 319 + x1 - x2
        p2 = 320 * y1 + x1 + offset
        p3 = 320 * y1 + x1 + toff
        by = -31
        FOR y3 = y1 TO y2
            IF y3 > 199 THEN EXIT FOR
            IF y3 > -1 THEN
                bx = -31
                FOR x3 = x1 TO x2
                    IF x3 > -1 AND x3 < 320 THEN
                        DEF SEG = tseg
                        maxcol = PEEK(p3)
                        col = light(by, bx) / 256 * maxcol
                        DEF SEG = segment
                        col = col + PEEK(p2)
                        IF col > maxcol THEN col = maxcol
                        POKE p2, col
                    END IF
                    bx = bx + 1
                    p2 = p2 + 1
                    p3 = p3 + 1
                NEXT x3
                p2 = p2 + dp
                p3 = p3 + dp
            ELSE
                p2 = p2 + 320
                p3 = p3 + 320
            END IF
            by = by + 1
        NEXT y3
    NEXT p
    IF t = 100 THEN t = 0
    PUT (0, 0), buffer, PSET
    REDIM buffer(32001) AS INTEGER
    buffer(0) = 2560
    buffer(1) = 200
    segment = VARSEG(buffer(2))
    offset = VARPTR(buffer(2))
    f = f + 1
    'pause t1# + .03
LOOP UNTIL f = frames OR INKEY$ <> ""

END SUB

SUB tmap (xp1, yp1, zp1, tpx1!, tpy1!, xp2, yp2, zp2, tpx2!, tpy2!, xp3, yp3, zp3, tpx3!, tpy3!, segment, offset, zseg, zoff, image())

IF xp1 <= xp2 THEN
    IF xp1 <= xp3 THEN
        x1 = xp1: y1 = yp1: z1 = zp1: tx1! = tpx1!: ty1! = tpy1!
        IF xp2 < xp3 THEN
            x2 = xp2: y2 = yp2: z2 = zp2: tx2! = tpx2!: ty2! = tpy2!
            x3 = xp3: y3 = yp3: z3 = zp3: tx3! = tpx3!: ty3! = tpy3!
        ELSE
            x2 = xp3: y2 = yp3: z2 = zp3: tx2! = tpx3!: ty2! = tpy3!
            x3 = xp2: y3 = yp2: z3 = zp2: tx3! = tpx2!: ty3! = tpy2!
        END IF
    ELSE
        x1 = xp3: y1 = yp3: z1 = zp3: tx1! = tpx3!: ty1! = tpy3!
        x2 = xp1: y2 = yp1: z2 = zp1: tx2! = tpx1!: ty2! = tpy1!
        x3 = xp2: y3 = yp2: z3 = zp2: tx3! = tpx2!: ty3! = tpy2!
    END IF
ELSE
    IF xp2 <= xp3 THEN
        x1 = xp2: y1 = yp2: z1 = zp2: tx1! = tpx2!: ty1! = tpy2!
        IF xp1 < xp3 THEN
            x2 = xp1: y2 = yp1: z2 = zp1: tx2! = tpx1!: ty2! = tpy1!
            x3 = xp3: y3 = yp3: z3 = zp3: tx3! = tpx3!: ty3! = tpy3!
        ELSE
            x2 = xp3: y2 = yp3: z2 = zp3: tx2! = tpx3!: ty2! = tpy3!
            x3 = xp1: y3 = yp1: z3 = zp1: tx3! = tpx1!: ty3! = tpy1!
        END IF
    ELSE
        x1 = xp3: y1 = yp3: z1 = zp3: tx1! = tpx3!: ty1! = tpy3!
        x2 = xp2: y2 = yp2: z2 = zp2: tx2! = tpx2!: ty2! = tpy2!
        x3 = xp1: y3 = yp1: z3 = zp1: tx3! = tpx1!: ty3! = tpy1!
    END IF
END IF

IF x3 = x1 THEN
    EXIT SUB
ELSE
    xchng1! = 1 / (x3 - x1)
    yslope1! = (y3 - y1) * xchng1!
    yt1! = y1
    zslope1! = (z3 - z1) * xchng1!
    z1! = z1
    txslope1! = (tx3! - tx1!) * xchng1!
    txt1! = tx1!
    tyslope1! = (ty3! - ty1!) * xchng1!
    tyt1! = ty1!
    IF x2 > x1 THEN
        xchng2! = 1 / (x2 - x1)
        yslope2! = (y2 - y1) * xchng2!
        yt2! = y1
        zslope2! = (z2 - z1) * xchng2!
        z2! = z1
        txslope2! = (tx2! - tx1!) * xchng2!
        txt2! = tx1!
        tyslope2! = (ty2! - ty1!) * xchng2!
        tyt2! = ty1!
        FOR x = x1 TO x2
            iyt1 = INT(yt1!)
            iyt2 = INT(yt2!)
            dy = SGN(iyt2 - iyt1)
            IF dy THEN
                diy! = 1 / (iyt2 - iyt1) * dy
                zslope3! = (z2! - z1!) * diy!
                z! = z1!
                txslope3! = (txt2! - txt1!) * diy!
                tx! = txt1!
                tyslope3! = (tyt2! - tyt1!) * diy!
                ty! = tyt1!
                p = 320 * iyt1 + x + zoff
                p2 = p - zoff + offset
                dp = 320 * dy
                FOR y = iyt1 TO iyt2 STEP dy
                    IF y < 200 AND y > -1 THEN
                        z = z!
                        DEF SEG = zseg
                        oldz = PEEK(p)
                        IF oldz > z OR oldz = 0 THEN
                            POKE p, z
                            DEF SEG = segment
                            col = image(ty! AND 127, tx! AND 127)
                            POKE p2, col
                        END IF
                    END IF
                    p = p + dp
                    p2 = p2 + dp
                    z! = z! + zslope3!
                    tx! = tx! + txslope3!
                    ty! = ty! + tyslope3!
                NEXT
            END IF
            yt1! = yt1! + yslope1!
            yt2! = yt2! + yslope2!
            z1! = z1! + zslope1!
            z2! = z2! + zslope2!
            txt1! = txt1! + txslope1!
            txt2! = txt2! + txslope2!
            tyt1! = tyt1! + tyslope1!
            tyt2! = tyt2! + tyslope2!
        NEXT
    END IF
    IF x3 > x2 THEN
        xchng3! = 1 / (x3 - x2)
        yslope2! = (y3 - y2) * xchng3!
        yt2! = y2
        zslope2! = (z3 - z2) * xchng3!
        z2! = z2
        txslope2! = (tx3! - tx2!) * xchng3!
        txt2! = tx2!
        tyslope2! = (ty3! - ty2!) * xchng3!
        tyt2! = ty2!
        FOR x = x2 + 1 TO x3
            iyt1 = INT(yt1!)
            iyt2 = INT(yt2!)
            dy = SGN(iyt2 - iyt1)
            IF dy THEN
                diy! = 1 / (iyt2 - iyt1) * dy
                zslope3! = (z2! - z1!) * diy!
                z! = z1!
                txslope3! = (txt2! - txt1!) * diy!
                tx! = txt1!
                tyslope3! = (tyt2! - tyt1!) * diy!
                ty! = tyt1!
                p = 320 * iyt1 + x + zoff
                p2 = p - zoff + offset
                dp = 320 * dy
                FOR y = iyt1 TO iyt2 STEP dy
                    IF y < 200 AND y > -1 THEN
                        z = z!
                        DEF SEG = zseg
                        oldz = PEEK(p)
                        IF oldz > z OR oldz = 0 THEN
                            POKE p, z
                            DEF SEG = segment
                            col = image(ty! AND 127, tx! AND 127)
                            POKE p2, col
                        END IF
                    END IF
                    p = p + dp
                    p2 = p2 + dp
                    z! = z! + zslope3!
                    tx! = tx! + txslope3!
                    ty! = ty! + tyslope3!
                NEXT
            END IF
            yt1! = yt1! + yslope1!
            yt2! = yt2! + yslope2!
            z1! = z1! + zslope1!
            z2! = z2! + zslope2!
            txt1! = txt1! + txslope1!
            txt2! = txt2! + txslope2!
            tyt1! = tyt1! + tyslope1!
            tyt2! = tyt2! + tyslope2!
        NEXT x
    END IF
END IF

END SUB

SUB tmap2 (xp1, yp1, tpx1!, tpy1!, xp2, yp2, tpx2!, tpy2!, xp3, yp3, tpx3!, tpy3!, z, segment, offset, zseg, zoff, image())

IF yp1 <= yp2 THEN
    IF yp1 <= yp3 THEN
        y1 = yp1: x1 = xp1: tx1! = tpx1!: ty1! = tpy1!
        IF yp2 < yp3 THEN
            y2 = yp2: x2 = xp2: tx2! = tpx2!: ty2! = tpy2!
            y3 = yp3: x3 = xp3: tx3! = tpx3!: ty3! = tpy3!
        ELSE
            y2 = yp3: x2 = xp3: tx2! = tpx3!: ty2! = tpy3!
            y3 = yp2: x3 = xp2: tx3! = tpx2!: ty3! = tpy2!
        END IF
    ELSE
        y1 = yp3: x1 = xp3: tx1! = tpx3!: ty1! = tpy3!
        y2 = yp1: x2 = xp1: tx2! = tpx1!: ty2! = tpy1!
        y3 = yp2: x3 = xp2: tx3! = tpx2!: ty3! = tpy2!
    END IF
ELSE
    IF yp2 <= yp3 THEN
        y1 = yp2: x1 = xp2: tx1! = tpx2!: ty1! = tpy2!
        IF yp1 < yp3 THEN
            y2 = yp1: x2 = xp1: tx2! = tpx1!: ty2! = tpy1!
            y3 = yp3: x3 = xp3: tx3! = tpx3!: ty3! = tpy3!
        ELSE
            y2 = yp3: x2 = xp3: tx2! = tpx3!: ty2! = tpy3!
            y3 = yp1: x3 = xp1: tx3! = tpx1!: ty3! = tpy1!
        END IF
    ELSE
        y1 = yp3: x1 = xp3: tx1! = tpx3!: ty1! = tpy3!
        y2 = yp2: x2 = xp2: tx2! = tpx2!: ty2! = tpy2!
        y3 = yp1: x3 = xp1: tx3! = tpx1!: ty3! = tpy1!
    END IF
END IF

IF y3 = y1 THEN
    EXIT SUB
ELSE
    ychng1 = y3 - y1
    ychng2 = y2 - y1
    ychng3 = y3 - y2
    xslope1! = (x3 - x1) / ychng1
    xt1! = x1
    txslope1! = (tx3! - tx1!) / ychng1
    txt1! = tx1!
    tyslope1! = (ty3! - ty1!) / ychng1
    tyt1! = ty1!
    IF ychng2 THEN
        xslope2! = (x2 - x1) / ychng2
        xt2! = x1
        txslope2! = (tx2! - tx1!) / ychng2
        txt2! = tx1!
        tyslope2! = (ty2! - ty1!) / ychng2
        tyt2! = ty1!
        p = 320 * y1
        FOR y = y1 TO y2
            ixt1 = xt1!
            ixt2 = xt2!
            itx1! = txt1!
            itx2! = txt2!
            ity1! = tyt1!
            ity2! = tyt2!
            IF ixt2 < ixt1 THEN SWAP ixt1, ixt2: SWAP itx1!, itx2!: SWAP ity1!, ity2!
            txslope3! = (itx2! - itx1!) / (ixt2 - ixt1 + 1)
            tx! = itx1!
            tyslope3! = (ity2! - ity1!) / (ixt2 - ixt1 + 1)
            ty! = ity1!
            p2 = p + ixt1
            FOR x = ixt1 TO ixt2
                IF x > 319 THEN EXIT FOR
                IF x > -1 THEN
                    DEF SEG = zseg
                    IF PEEK(p2) > z OR PEEK(p2) = 0 THEN
                        POKE p2, z
                        DEF SEG = segment
                        col = image(ty! AND 127, tx! AND 127)
                        POKE p2, col
                    ELSE
                        DEF SEG = segment
                    END IF
                END IF
                tx! = tx! + txslope3!
                ty! = ty! + tyslope3!
                p2 = p2 + 1
            NEXT x
            xt1! = xt1! + xslope1!
            xt2! = xt2! + xslope2!
            txt1! = txt1! + txslope1!
            txt2! = txt2! + txslope2!
            tyt1! = tyt1! + tyslope1!
            tyt2! = tyt2! + tyslope2!
            p = p + 320
        NEXT y
    END IF
    IF ychng3 THEN
        xslope2! = (x3 - x2) / ychng3
        xt2! = x2
        txslope2! = (tx3! - tx2!) / ychng3
        txt2! = tx2!
        tyslope2! = (ty3! - ty2!) / ychng3
        tyt2! = ty2!
        p = 320 * y2 + 320
        FOR y = y2 + 1 TO y3
            ixt1 = xt1!
            ixt2 = xt2!
            itx1! = txt1!
            itx2! = txt2!
            ity1! = tyt1!
            ity2! = tyt2!
            IF ixt2 < ixt1 THEN SWAP ixt1, ixt2: SWAP itx1!, itx2!: SWAP ity1!, ity2!
            txslope3! = (itx2! - itx1!) / (ixt2 - ixt1 + 1)
            tx! = itx1!
            tyslope3! = (ity2! - ity1!) / (ixt2 - ixt1 + 1)
            ty! = ity1!
            p2 = p + ixt1
            FOR x = ixt1 TO ixt2
                IF x > 319 THEN EXIT FOR
                IF x > -1 THEN
                    DEF SEG = zseg
                    IF PEEK(p2) > z OR PEEK(p2) = 0 THEN
                        POKE p2, z
                        DEF SEG = segment
                        col = image(ty! AND 127, tx! AND 127)
                        POKE p2, col
                    ELSE
                        DEF SEG = segment
                    END IF
                END IF
                tx! = tx! + txslope3!
                ty! = ty! + tyslope3!
                p2 = p2 + 1
            NEXT x
            xt1! = xt1! + xslope1!
            xt2! = xt2! + xslope2!
            txt1! = txt1! + txslope1!
            txt2! = txt2! + txslope2!
            tyt1! = tyt1! + tyslope1!
            tyt2! = tyt2! + tyslope2!
            p = p + 320
        NEXT y
    END IF
END IF

END SUB

SUB tunnel STATIC

grad 0, 0, 0, 0, 127, 47, 39, 0
grad 128, 47, 39, 0, 255, 63, 63, 63

DIM zang AS INTEGER
DIM sz AS SINGLE
DIM cz AS SINGLE

DIM tile(8193) AS INTEGER
DEF SEG = VARSEG(tile(0))
BLOAD "tmap.bsv", VARPTR(tile(0))
DEF SEG
tseg = VARSEG(tile(2))
toff = VARPTR(tile(2))
DIM temp(-160 TO -1, 3) AS INTEGER

pi64! = 128 / pi
DIM arctan(-100 TO -1, -160 TO -1) AS INTEGER
FOR y = -100 TO -1
    FOR x = -160 TO -1
        arctan(y, x) = ATN(y / x) * pi64!
    NEXT x
NEXT y

DIM parts(1 TO numparts3, 2, 3) AS INTEGER
FOR p = 1 TO numparts3
    parts(p, 0, 0) = RND * 159
    parts(p, 0, 1) = RND * 159
    parts(p, 0, 2) = RND * 159
    parts(p, 0, 3) = RND * 159
    parts(p, 1, 0) = RND * 99
    parts(p, 1, 1) = RND * 99
    parts(p, 1, 2) = RND * 99
    parts(p, 1, 3) = RND * 99
    parts(p, 2, 0) = RND * 99
    parts(p, 2, 1) = RND * 99
    parts(p, 2, 2) = RND * 99
    parts(p, 2, 3) = RND * 99
NEXT p

'$DYNAMIC
DIM buffer(32001) AS INTEGER
'$STATIC
buffer(0) = 2560
buffer(1) = 200
segment = VARSEG(buffer(2))
offset = VARPTR(buffer(2))

t# = TIMER
DO
    t1# = CLOCK / 4660.859#
    p = 160
    yy = 10000
    FOR y = -100 TO -1
        DEF SEG = tseg
        xx& = 25600
        FOR x = -160 TO -1
            d = SQR(yy + xx&)
            IF d > 1 THEN
                p2 = 128 * ((5000 \ d + zoff) AND 127) + toff
                ang = arctan(y, x)
                ang2 = 128 - ang + aoff - d
                ang3 = ang2 - 128
                ang = ang + aoff - d
                ang4 = ang + 128
                temp(x, 0) = PEEK((ang AND 127) + p2) * d \ 256
                temp(x, 1) = PEEK((ang2 AND 127) + p2) * d \ 256
                temp(x, 2) = temp(x, 1)
                temp(x, 3) = temp(x, 0)
            END IF
            xx& = xx& + x + x + 1
        NEXT x
        DEF SEG = segment
        FOR x = -160 TO -1
            POKE p + x + offset, temp(x, 0)
            POKE p - x - 1 + offset, temp(x, 1)
            POKE 64000 - p + x + offset, temp(x, 2)
            POKE 63999 - p - x + offset, temp(x, 3)
        NEXT x
        p = p + 320
        yy = yy + y + y + 1
    NEXT y
    t = t + 1
    FOR p = 1 TO numparts3
        a! = (100 - t) / 100
        b! = t / 100
        x = parts(p, 0, 0) * a! * a! * a! + 3 * parts(p, 0, 1) * a! * a! * b! + 3 * parts(p, 0, 2) * a! * b! * b! + parts(p, 0, 3) * b! * b! * b! - 80
        y = parts(p, 1, 0) * a! * a! * a! + 3 * parts(p, 1, 1) * a! * a! * b! + 3 * parts(p, 1, 2) * a! * b! * b! + parts(p, 1, 3) * b! * b! * b! - 50
        z = parts(p, 2, 0) * a! * a! * a! + 3 * parts(p, 2, 1) * a! * a! * b! + 3 * parts(p, 2, 2) * a! * b! * b! + parts(p, 2, 3) * b! * b! * b!
        IF t = 100 THEN
            parts(p, 0, 0) = parts(p, 0, 3)
            parts(p, 0, 1) = parts(p, 0, 0) - parts(p, 0, 2) + parts(p, 0, 3)
            parts(p, 0, 2) = RND * 159
            parts(p, 0, 3) = RND * 159
            parts(p, 1, 0) = parts(p, 1, 3)
            parts(p, 1, 1) = parts(p, 1, 0) - parts(p, 1, 2) + parts(p, 1, 3)
            parts(p, 1, 2) = RND * 99
            parts(p, 1, 3) = RND * 99
            parts(p, 2, 0) = parts(p, 2, 3)
            parts(p, 2, 1) = parts(p, 2, 0) - parts(p, 2, 2) + parts(p, 2, 3)
            parts(p, 2, 2) = RND * 99
            parts(p, 2, 3) = RND * 99
        END IF
        drawpart x, y, z
    NEXT p
    IF t = 100 THEN t = 0
    PUT (0, 0), buffer, PSET
    f = f + 1
    aoff = aoff + 2
    zoff = zoff + 2
    'pause t1# + .03
LOOP UNTIL f = 400 OR INKEY$ <> ""

END SUB

SUB voxel

DIM font(201, 39) AS INTEGER
DEF SEG = VARSEG(font(0, 0))
BLOAD "letters.bsv", VARPTR(font(0, 0))
DEF SEG
fseg = VARSEG(font(2, 0))
foff = VARPTR(font(2, 0))

DIM map(127, 127) AS INTEGER
size = 128
rand = 224
DO
    size = size \ 2
    rand = rand - 64
    IF rand < 0 THEN rand = 0
    FOR y = 0 TO 127 STEP size
        y1 = (y - size) AND 127
        y2 = (y + size) AND 127
        FOR x = 0 TO 127 STEP size
            x1 = (x - size) AND 127
            x2 = (x + size) AND 127
            newmap = (map(x1, y) + map(x2, y) + map(x, y) + map(x, y1) + map(x, y2)) \ 5 + INT(RND * rand * 2 - rand)
            FOR x3 = x TO x + size - 1
                FOR y3 = y TO y + size - 1
                    map(x3, y3) = newmap
                NEXT y3
            NEXT x3
        NEXT x
    NEXT y
LOOP UNTIL size = 1

'$DYNAMIC
DIM buffer(32001) AS INTEGER
'$STATIC
DIM segment AS INTEGER
DIM offset AS INTEGER
buffer(0) = 2560
buffer(1) = 200
segment = VARSEG(buffer(2))
offset = VARPTR(buffer(2))

grad 0, 0, 0, 0, 127, 63, 63, 63
grad 128, 0, 0, 0, 255, 0, 31, 63

DIM bright(0 TO sight) AS INTEGER
FOR b = 0 TO sight
    bright(b) = 127 - 127 * b / sight
NEXT b

DIM sins(0 TO 255) AS SINGLE
DIM coss(0 TO 255) AS SINGLE
FOR s = 0 TO 255
    sins(s) = SIN(s * pi / 128)
    coss(s) = COS(s * pi / 128)
NEXT

px1 = 0
py1 = 0
pz1 = 0
px2 = px1 + RND * 256 - 128
py2 = py1 + RND * 256 - 128
pz2 = pz1 + RND * 256 - 128
px3 = px2 + RND * 256 - 128
py3 = py2 + RND * 256 - 128
pz3 = pz2 + RND * 256 - 128
px4 = px3 + RND * 256 - 128
py4 = py3 + RND * 256 - 128
pz4 = pz3 + RND * 256 - 128

xc! = 80
yc! = 50
xcam = xc! AND 127
ycam = yc! AND 127
zang = 0
t2 = 0
char = -11
t! = TIMER
DO
    t1# = CLOCK / 4660.859#
    a! = (100 - t2) / 100
    b! = t2 / 100
    xc! = px1 * a! * a! * a! + 3 * px2 * a! * a! * b! + 3 * px3 * a! * b! * b! + px4 * b! * b! * b!
    yc! = py1 * a! * a! * a! + 3 * py2 * a! * a! * b! + 3 * py3 * a! * b! * b! + py4 * b! * b! * b!
    zang = (pz1 * a! * a! * a! + 3 * pz2 * a! * a! * b! + 3 * pz3 * a! * b! * b! + pz4 * b! * b! * b!) AND 255
    IF t2 = 100 THEN
        px1 = px4
        px2 = px1 - px3 + px4
        px3 = px2 + RND * 256 - 128
        px4 = px3 + RND * 256 - 128
        py1 = py4
        py2 = py1 - py3 + py4
        py3 = py2 + RND * 256 - 128
        py4 = py3 + RND * 256 - 128
        pz1 = pz4
        pz2 = pz1 - pz3 + pz4
        pz3 = pz2 + RND * 256 - 128
        pz4 = pz3 + RND * 256 - 128
        t2 = 0
    END IF
    t2 = t2 + 1
    xcam = xc! AND 127
    ycam = yc! AND 127
    zcam = map(xcam, ycam)
    DEF SEG = segment
    da! = -64
    IF trans THEN
        FOR xs = 0 TO 159
            dx! = sins((zang + da!) AND 255)
            dy! = coss((zang + da!) AND 255)
            x! = xcam
            y! = ycam
            ys = 199
            d = 0
            DO
                d = d + 1
                x! = x! + dx!
                y! = y! + dy!
                x2 = x! AND 127
                y2 = y! AND 127
                h = map(x2, y2)
                yproj = 50 * ((zcam - h) / 3 + 8) \ d + 100
                IF yproj <= ys THEN
                    p = offset + xs + xs + 320 * yproj
                    FOR yy = yproj TO ys
                        IF yy > 199 THEN EXIT FOR
                        IF yy > -1 THEN
                            col = PEEK(p) + (bright(d) \ 4)
                            IF col > 127 THEN col = 127
                            POKE p, col
                            col = PEEK(p + 1) + (bright(d) \ 4)
                            IF col > 127 THEN col = 127
                            POKE p + 1, col
                        END IF
                        p = p + 320
                    NEXT yy
                    ys = yproj - 1
                ELSE
                    p = offset + xs + xs + 320 * ys
                    FOR yy = ys TO yproj
                        IF yy > 199 THEN EXIT FOR
                        IF yy > -1 THEN
                            col = PEEK(p) + (bright(d) \ 4)
                            IF col > 127 THEN col = 127
                            POKE p, col
                            col = PEEK(p + 1) + (bright(d) \ 4)
                            IF col > 127 THEN col = 127
                            POKE p + 1, col
                        END IF
                    NEXT yy
                    ys = yproj + 1
                END IF
            LOOP UNTIL d = sight
            da! = da! + .8
        NEXT xs
    ELSE
        FOR xs = 0 TO 159
            dx! = sins((zang + da!) AND 255)
            dy! = coss((zang + da!) AND 255)
            x! = xcam
            y! = ycam
            ys = 199
            d = 0
            DO
                d = d + 1
                x! = x! + dx!
                y! = y! + dy!
                x2 = x! AND 127
                y2 = y! AND 127
                h = map(x2, y2)
                yproj = 50 * ((zcam - h) / 3 + 8) \ d + 100
                IF yproj <= ys THEN
                    p = offset + xs + xs + 320 * yproj
                    FOR yy = yproj TO ys
                        IF yy > -1 THEN
                            POKE p, bright(d)
                            POKE p + 1, bright(d)
                        END IF
                        p = p + 320
                    NEXT yy
                    ys = yproj - 1
                END IF
            LOOP UNTIL d = sight
            da! = da! + .8
        NEXT xs
    END IF
    IF text = 0 THEN
        greet = greet + 1
        READ text$
        text$ = UCASE$(text$)
        pg& = offset + 320& * INT(RND * 100 + 50) + (RND * (310 - 20 * LEN(text$) + 5))
    END IF
    text = (text + 1) AND 15
    IF text > 7 THEN tb = 15 - text ELSE tb = text
    p = pg&
    FOR c = 1 TO LEN(text$)
        ch = ASC(MID$(text$, c, 1))
        IF ch > 64 AND ch < 91 THEN
            ch2 = ch - 65
        ELSEIF ch > 47 AND ch < 58 THEN
            ch2 = ch - 22
        ELSEIF ch > 43 AND ch < 47 THEN
            ch2 = ch - 8
        ELSEIF ch = 35 THEN
            ch2 = 39
        ELSE
            ch2 = -1
        END IF
        IF ch2 > -1 THEN
            p2 = p
            fp = foff + ch2 * 404
            FOR fy = 0 TO 19
                FOR fx = 0 TO 19
                    DEF SEG = fseg
                    col = (PEEK(fp) * tb \ 8) + 128
                    IF col = 128 THEN col = 0
                    DEF SEG = segment
                    col = col + PEEK(p2 + fx)
                    IF col > 255 THEN col = 255
                    POKE p2 + fx, col
                    fp = fp + 1
                NEXT fx
                p2 = p2 + 320
            NEXT fy
        END IF
        p = p + 20
    NEXT c
    PUT (0, 0), buffer, PSET
    REDIM buffer(32001) AS INTEGER
    buffer(0) = 2560
    buffer(1) = 200
    segment = VARSEG(buffer(2))
    offset = VARPTR(buffer(2))
    f = f + 1
    IF f MOD 100 > 90 THEN trans = 1 - trans
    'pause t1# + .03
LOOP UNTIL text$ = "" OR INKEY$ <> ""

END SUB

