// -*- C++ -*-
//
// $Id: exception.h,v 1.2 2000/04/15 13:09:53 alcibiade Exp $
//
// Copyleft (c) 2000, Brioche/Aspirine <brioche@linuxbe.org>
// 
// A standard library exception class look-alike for the system which
// are not fully compliant with the ANSI C++ norm.
//
// Comment out this class if you're the very lucky owner of a
// more or less ANSI compliant compiler.
//



#ifndef _EXCEPTION_H_INCLUDED
#define _EXCEPTION_H_INCLUDED



#include <iostream>



class exception {

  char* _what;

public:

  exception(char* description = "") : _what(description) {}

  const char* what() const { return _what; }

  friend ostream& operator << (ostream& os, const exception& e);

};



inline ostream& operator << (ostream& os, const exception& e)
{
  return os << e.what();
}



#endif // _EXCEPTION_H_INCLUDED

