// PDX-TG version 1.0 *ALPHA* Argument sizeof correction not implemented
// This is a somewhat older version of my texture generator, as if I'd give
// my cool stuff to you weasels ;)

typedef signed char schar; 
typedef unsigned char byte;

#define random(n) (rand() % n)

class RGBTriplet
{
public:
   byte *R, *G, *B;
};

class RGB888
{
public:
   RGBTriplet t;
   RGB888();
   ~RGB888();
   int Allocate();
   void Delete();
   void Clear();
};

class Generate : public RGB888
{
   char Operation;
   byte FixRange(int Value);
   byte FixCoord(int Coord);
   void WritePixel(int Index, int R, int G, int B);
public:
   Generate();          
   void SetOperation(char WhichOne);
   void SinePlasma(int SinPeriod, int CosPeriod, int SinCoeff, int CosCoeff, int XPhase, int YPhase, float BR, float BG, float BB);
   void XSineDistort(int Period, int SineCoeff, int Phase);
   void YSineDistort(int Period, int SineCoeff, int Phase);
   void MapDistort(RGBTriplet Map, float Divisor);
   void Glass(RGBTriplet Under);
   void Whirl(int WhirlX, int WhirlY, int Radius, float Whirls);
   void Random(int XSize, int YSize, byte RClamp, byte GClamp, byte BClamp, byte RSame, byte GSame, byte BSame);
   void Invert();
   void Copy(RGBTriplet Src);
   void Shade(RGBTriplet Src, float RCoeff, float GCoeff, float BCoeff);
   void AlphaBlend(RGBTriplet Src, float Alpha);  
   void Blend(RGBTriplet Src, float Frac1, float Frac2);
   void ChannelExchange(byte R, byte G, byte B);
   void AdjustIntensity(int R, int G, int B);
   void FastSmooth(int HowManyTimes);
   void Edges(schar XDir, schar YDir, float Contrast);
   void ShadeMap(int Xpos, int Ypos, int Radius, float RCoeff, float GCoeff, float BCoeff);
   void PlasmaClouds(int Roughness);
};
                    
void To16BPP(RGBTriplet Src, unsigned short *Texture16BPP);

// This just saturates any operation, if I have 128 + 250 it equals 255
// similarly 50 - 200 = 0, basically it keeps stuff in interval [0...256)
byte Generate::FixRange(int Value)
{
   return Value > 255 ? 255 : (Value < 0 ? 0 : Value);
}

// This is for fixing coordinates into 256x256 textures :
// 255 + 50 = 50. 50 - 100 = 205.
// It's very handy.
byte Generate::FixCoord(int Coord)
{
   return Coord > 255 ? Coord % 256 : (Coord < 0 ? Coord + 256 : Coord);
}

// Writes a pixel to the texture using the current operation.
void Generate::WritePixel(int Index, int R, int G, int B)
{
   if(Operation == '=') // plain old equals
   {
      t.R[Index] = FixRange(R);
      t.G[Index] = FixRange(G);
      t.B[Index] = FixRange(B);
   }
   if(Operation == '+') // add the stuff to this index
   {
      t.R[Index] = FixRange(R + t.R[Index]);
      t.G[Index] = FixRange(G + t.G[Index]);
      t.B[Index] = FixRange(B + t.B[Index]);
   }
   if(Operation == '*') // I almost never use this one
   {
      t.R[Index] = FixRange(R * t.R[Index]);
      t.G[Index] = FixRange(G * t.R[Index]); 
      t.B[Index] = FixRange(B * t.R[Index]);
   }
   if(Operation == '-') // subtract...
   {
      t.R[Index] -= FixRange(t.R[Index] - R);
      t.G[Index] -= FixRange(t.G[Index] - G);
      t.B[Index] -= FixRange(t.B[Index] - B);
   }
// still playing with these two...
/*
   if(Operation == '0')
   {
      if(!t.R[Index] && !t.B[Index] && !t.G[Index])
      {
         t.R[Index] = FixRange(R);
         t.G[Index] = FixRange(G);
         t.B[Index] = FixRange(B);
      }
   }
   if(Operation == '9')
   {
      if(!t.R[Index]) t.R[Index] = FixRange(R);
      if(!t.G[Index]) t.G[Index] = FixRange(G);
      if(!t.B[Index]) t.B[Index] = FixRange(B);
   }
*/
   return;
}

Generate::Generate()
{
   Operation = '=';
   Allocate();
   memset(t.R, 0, 65536);
   memset(t.G, 0, 65536);
   memset(t.B, 0, 65536);
   return;
}

void Generate::SetOperation(char WhichOne)
{
   Operation = WhichOne;
   return;
}

// plasma!
void Generate::SinePlasma(int SinPeriod, int CosPeriod, int SinCoeff, int CosCoeff, int XPhase, int YPhase, float BR, float BG, float BB)
{
   int SinTab[256], CosTab[256];                        
   float SinVal = 0, CosVal = 0, SinDelta = 2 * PI / (float) SinPeriod;
   float CosDelta = 2 * PI / (float) CosPeriod;
   for(int i = 0; i < 256; i++, SinVal += SinDelta, CosVal += CosDelta)
   {
      SinTab[i] = sin(SinVal) * SinCoeff + SinCoeff;
      CosTab[i] = cos(CosVal) * CosCoeff + CosCoeff;
   }
   int Y, PlasmaValue;                            
   for(int X = 0; X < 256; X++) for(Y = 0; Y < 256; Y++)
   {      
      PlasmaValue = FixRange((CosTab[Y] + SinTab[X]) / 2);
      // hugi reader:
      // You notice that I have added x/y phase to the coordinates of the
      // pixels that's because it's equivalent to doing it the other way,
      // because what we have is a plot of sin (and cos) and to adjust the
      // phase all we have to do is add a value to the beginning offset of
      // where we draw it. We can't do this we x/y sine distort though because
      // although we'd end up with the distortion in the right places it'd be
      // on the wrong rows or columns resp. (depending on x/y sinedistort)
      // of the image. Phew.
      WritePixel((FixCoord(Y + YPhase) << 8) + FixCoord(X + XPhase),
                 BR * PlasmaValue,
                 BG * PlasmaValue,
                 BB * PlasmaValue);
   }
   return;
}

void Generate::XSineDistort(int Period, int SineCoeff, int Phase)
{  
   RGB888 Tp;
   // interpolate from 0 -> 2 pi in period steps:
   float Delta = 2 * PI / (float) Period;

   // compute fraction of total (2pi) the phase is by finding what fraction
   // of the period it is:
   float Value = (Phase / (float) Period) * 2 * PI;

   // Distort holds the distortion for the first line when the loop begins.

   int X, Distort = SineCoeff * sin(Value), XIndex;
   for(int Y = 0; Y < 256; Y++, Distort = SineCoeff * sin(Value += Delta))
      for(X = 0; X < 256; X++)
      {
         XIndex = FixCoord(X + Distort);
         Tp.t.R[Y * 256 + X] = t.R[Y * 256 + XIndex];
         Tp.t.G[Y * 256 + X] = t.G[Y * 256 + XIndex];
         Tp.t.B[Y * 256 + X] = t.B[Y * 256 + XIndex];
      }
// Copy it.
   for(X = 0; X < 65536; X++) WritePixel(X, Tp.t.R[X], Tp.t.G[X], Tp.t.B[X]);
   Tp.Delete();
   return;
}
  
void Generate::YSineDistort(int Period, int SineCoeff, int Phase)
{
// left as an exercise to you, just copy XSineDistort a bit.
   return;
}   

// note to hugi reader: sign of "Whirls" defines direction.
void Generate::Whirl(int WhirlX, int WhirlY, int Radius, float Whirls)
{                                    
   RGB888 tp;
   for(int X = 0; X < 256; X++) for(int Y = 0; Y < 256; Y++)
   {
      float Dist = sqrt((X - WhirlX) * (X - WhirlX) + (Y - WhirlY) * (Y - WhirlY));
      // no distortion if outside of whirl radius.
      if(Dist > Radius) Dist = 0;
      else Dist = (Radius - Dist) * (Radius - Dist) / (float) Radius;
      float Angle = 2 * PI * (Dist / (float) (Radius / (float) Whirls));
      int Xpos = ((X - WhirlX) * cos(Angle)) - ((Y - WhirlX) * sin(Angle)) + WhirlX;
      int Ypos = ((Y - WhirlY) * cos(Angle)) + ((X - WhirlY) * sin(Angle)) + WhirlY;
      int WhirlOffset = FixCoord(Ypos) * 256 + FixCoord(Xpos);
      int NormalOffset = Y * 256 + X;
      tp.t.R[NormalOffset] = t.R[WhirlOffset];
      tp.t.G[NormalOffset] = t.G[WhirlOffset];
      tp.t.B[NormalOffset] = t.B[WhirlOffset];
   }
   Copy(tp.t);
   tp.Delete();
   return;
}

// This shouldn't be called MapDistort. 
void Generate::MapDistort(RGBTriplet Map, float Divisor)
{
   RGB888 Temp;
   for(int i = 0; i < 65536; i++)
   {                           
      Temp.t.R[i] = t.R[(int) (Map.R[i] / Divisor)];
      Temp.t.G[i] = t.G[(int) (Map.G[i] / Divisor)];
      Temp.t.B[i] = t.B[(int) (Map.B[i] / Divisor)];
   }
   Copy(Temp.t);
   Temp.Delete();
   return;
}

// Simple glass effect. Note: Use smooth textures.
void Generate::Glass(RGBTriplet Under)
{
   RGB888 Temp;

   int X, Y, XInd1, YInd1, XInd2, YInd2;
   int Rx, Ry, Gx, Gy, Bx, By, Ind;
   for(Y = 0; Y < 256; Y++) for(X = 0; X < 256; X++)
   {
      XInd1 = Y * 256 + FixCoord(X - 1);         
      XInd2 = Y * 256 + FixCoord(X + 1);
      YInd1 = FixCoord(Y - 1) * 256 + X;
      YInd2 = FixCoord(Y + 1) * 256 + X;
      Rx = FixCoord(X + Under.R[XInd1] - Under.R[XInd2]);
      Ry = FixCoord(Y + Under.R[YInd1] - Under.R[YInd2]);
      Gx = FixCoord(X + Under.G[XInd1] - Under.G[XInd2]);
      Gy = FixCoord(Y + Under.G[YInd1] - Under.G[YInd2]);
      Bx = FixCoord(X + Under.B[XInd1] - Under.B[XInd2]);
      By = FixCoord(Y + Under.B[YInd1] - Under.B[YInd2]);
      Ind = Y * 256 + X;
      Temp.t.R[Ind] = t.R[(Ry << 8) + Rx];
      Temp.t.G[Ind] = t.G[(Gy << 8) + Gx];
      Temp.t.B[Ind] = t.B[(By << 8) + Bx];
	}
   Copy(Temp.t);
   Temp.Delete();
   return;
}

void Generate::Random(int XSize, int YSize, byte RClamp, byte GClamp, byte BClamp, byte RSame, byte GSame, byte BSame)
{
   int Y, X2, Y2, Index;
   byte R, G, B;
   for(int X = 0; X < 256; X += XSize) for(Y = 0; Y < 256; Y += YSize)
   {
      R = rand() % RClamp;
      G = rand() % GClamp;
      B = rand() % BClamp;
      // These lines make certain random values the same as  other ones
      // so we can get non-random mixes of colours, like grey random patterns
      // or gold or magenta ones. If RGBSame are left at 0, 1 and 2 then
      // we'll just get a pure random pattern in the ranges of our clamps.
      if(RSame == 1) R = G;
      if(RSame == 2) R = B; 
      if(RSame == 4) R = 0;
      if(GSame == 0) G = R;
      if(GSame == 2) G = B; 
      if(GSame == 4) G = 0;
      if(BSame == 0) B = R;
      if(BSame == 1) B = G; 
      if(BSame == 4) B = 0;
      for(X2 = X; X2 < X + XSize; X2++) for(Y2 = Y; Y2 < Y + YSize; Y2++)
         WritePixel((Y2 << 8) + X2, R, G, B);
   }
   return;
}

// This function reverses the bits of the image.
void Generate::Invert()
{
   for(int i = 0; i < 65536; i++)
      WritePixel(i, (byte) ~t.R[i], (byte) ~t.G[i], (byte) ~t.B[i]);
   return;
}

void Generate::FastSmooth(int HowManyTimes)
{
   int i;
   for(int j = 0; j < HowManyTimes; j++)
   {
      // This starts at the second line and goes till the second last for
      // tileability (no need to do it for the x's)
      for(i = 256; i < 65280; i++)
      {
         WritePixel(i,
         (t.R[i - 1] + t.R[i + 1] + t.R[i - 256] + t.R[i + 256]) >> 2,
         (t.G[i - 1] + t.G[i + 1] + t.G[i - 256] + t.G[i + 256]) >> 2,
         (t.B[i - 1] + t.B[i + 1] + t.B[i - 256] + t.B[i + 256]) >> 2);
      }
      // smooth the first line
      for(i = 0; i < 256; i++)
      {                                     
         WritePixel(i,
         (t.R[i - 1] + t.R[i + 1] + t.R[65280 + i] + t.R[i + 256]) >> 2,
         (t.G[i - 1] + t.G[i + 1] + t.G[65280 + i] + t.G[i + 256]) >> 2,
         (t.B[i - 1] + t.B[i + 1] + t.B[65280 + i] + t.B[i + 256]) >> 2);
      }
      // smooth the last line
      for(i = 65280; i < 65536; i++)
      {                                     
         WritePixel(i, 
         (t.R[i - 1] + t.R[i + 1] + t.R[i - 256] + t.R[i - 65280]) >> 2,
         (t.G[i - 1] + t.G[i + 1] + t.G[i - 256] + t.G[i - 65280]) >> 2,
         (t.B[i - 1] + t.B[i + 1] + t.B[i - 256] + t.B[i - 65280]) >> 2);
      }
   }
   return;
}

void Generate::AlphaBlend(RGBTriplet Src, float Alpha)
{
   // simple alpha blend, no overflows possible when alpha is 0...1
   for(int i = 0; i < 65536; i++)
   {
      WritePixel(i, (Src.R[i] * (1 - Alpha)) + (t.R[i] * Alpha),
                    (Src.G[i] * (1 - Alpha)) + (t.G[i] * Alpha),
                    (Src.B[i] * (1 - Alpha)) + (t.B[i] * Alpha));
   }
   return;
} 

void Generate::Blend(RGBTriplet Src, float Frac1, float Frac2)
{
// again, an exercise, it's the same as alpha blend but with two
// fractions. (change 1 - alpha to frac1)
   return;
}

// A "bonus"  this swaps the RGB components of an image with each other.
// Sometimes it's handy. 
void Generate::ChannelExchange(byte R, byte G, byte B)
{
   
   RGB888 tp;
   for(int i = 0; i < 65536; i++)
   {
      // RGB channels are assigned numbers 0, 1, 2 resp.
      // And then we give those numbers when swapping.
      if(R == 1) tp.t.R[i] = t.G[i];
      if(R == 2) tp.t.R[i] = t.B[i];
      else tp.t.R[i] = t.R[i];
      if(G == 0) tp.t.G[i] = t.R[i];
      if(G == 2) tp.t.G[i] = t.B[i];
      else tp.t.G[i] = t.G[i];
      if(B == 0) tp.t.B[i] = t.R[i];
      if(B == 1) tp.t.B[i] = t.G[i];
      else tp.t.B[i] = t.B[i];
   }
   Copy(tp.t);
   tp.Delete();
   return;
}

// Just add a bias to each colour, don't forget these can be negative too.
void Generate::AdjustIntensity(int R, int G, int B)
{
   for(int i = 0; i < 65536; i++)
      WritePixel(i, t.R[i] + R, t.G[i] + G, t.B[i] + B);
   return;
}

void Generate::Shade(RGBTriplet Src, float RCoeff, float GCoeff, float BCoeff)
{
   float Fraction;
   int R, G, B;
   for(int i = 0; i < 65536; i++)
   {
      // Work out what fraction this pixel is of the total (255)
      // Then use that fraction to shade the other layer, I let you
      // specify RGBCoeff to brighten it.
      Fraction = RCoeff * t.R[i] / (float) 255;
      R = Src.R[i] * Fraction;
      Fraction = GCoeff * t.G[i] / (float) 255;
      G = Src.G[i] * Fraction;
      Fraction = BCoeff * t.B[i] / (float) 255;
      B = Src.B[i] * Fraction;
      WritePixel(i, R, G, B);
   }
   return;      
}

// This is some kind of edges/contrast filter I thought up,
// it's explained in the tut.
void Generate::Edges(schar XDir, schar YDir, float Contrast)
{
   RGB888 tp;
   for(int X = 0; X < 256; X++)
      for(int Y = 0; Y < 256; Y++)
      {
         int SecIndex = FixCoord(Y + YDir) * 256 + FixCoord(X + XDir);
         int PriIndex = Y * 256 + X;

         int Diff = abs(t.R[PriIndex] - t.R[SecIndex]);
         tp.t.R[PriIndex] = FixRange(t.R[PriIndex] + Contrast * Diff);

         Diff = abs(t.G[PriIndex] - t.G[SecIndex]);
         tp.t.G[PriIndex] = FixRange(t.G[PriIndex] + Contrast * Diff);

         Diff = abs(t.B[PriIndex] - t.B[SecIndex]);
         tp.t.B[PriIndex] = FixRange(t.B[PriIndex] + Contrast * Diff);
      }
   Copy(tp.t);
   tp.Delete();
   return;
}

// Generate a circular gradient of colours, RGB Coeff are basically only
// good when they are either 1 or 0.
void Generate::ShadeMap(int Xpos, int Ypos, int Radius, float RCoeff, float GCoeff, float BCoeff)
{
   int R;
   for(int X = 0; X < 256; X++)
      for(int Y = 0; Y < 256; Y++)
      {
         R = sqrt(((X - Xpos) * (X - Xpos)) + ((Y - Ypos) * (Y - Ypos)));
         if(R > Radius) continue;
         WritePixel((Y << 8) + X,
         (byte) (256 - ((1 + (255 * R) / Radius) * RCoeff)),
         (byte) (256 - ((1 + (255 * R) / Radius) * GCoeff)),
         (byte) (256 - ((1 + (255 * R) / Radius) * BCoeff)));
      }
   return;
}

void Generate::Copy(RGBTriplet Src)
{
   for(int i = 0; i < 65536; i++) WritePixel(i, Src.R[i], Src.G[i], Src.B[i]);
   return;
}

// sorry my version of this is still buggy, I don't want to spread it.
void Generate::PlasmaClouds(int Roughness)
{
   return;
}
// This file was getting really big, so I removed some of the RGB888
// stuff, it's like pseudo-code above. Anyway, this is for learning not
// ripping.

// allocate mem+clear
RGB888::RGB888()
{
   
   return;
}

// deletes mem if it is not free
RGB888::~RGB888()
{
}

// convert+copy
void To16BPP(RGBTriplet Src, unsigned short *Texture16BPP)
{
   for(int i = 0; i < 65536; i++)
      Texture16BPP[i] = ((Src.R[i] >> 3) << 11) + ((Src.G[i] >> 2) << 5) + (Src.B[i] >> 3);
   return;
}
