

   thread2:

   ;this thread is multithreading-friendly because it releases CPU time
   ;by itself if it does no longer require it, so increasing its priority
   ;makes its excecution smoother without stealing the other threads time
   ;(remove the next 3 lines if you want)

   push dword THREAD_PRIORITY_ABOVE_NORMAL ;boost the priority a bit
   push dword [thread2handle]
   call [SetThreadPriority]

   ;initialize timer, the multimedia timer is used here for higher accuracy
        
   push dword 20            ;minimum timer resolution (in msec)
   call [timeBeginPeriod]
   push dword TIME_PERIODIC
   push dword 0             ;data passed to callback proc - not needed here
   push dword resumethread2 ;callback proc
   push dword 20            ;timer event accuracy (in msec)
   push dword 25            ;timer delay in msec: call every 25 msec (40 Hz)
   call [timeSetEvent]
   mov [mmtimerhandle],eax   

	thread2loop:

	call drawmoon

        push dword [thread2handle]
        call [SuspendThread]    ;release cpu time until the thread gets resumed

	cmp dword [thread2exit],0
	jz near thread2loop

   ;thread terminates, uninitialisating timer

   push dword [mmtimerhandle]
   call [timeKillEvent]
   push dword 20
   call [timeEndPeriod]

   xor eax,eax  ;return code
   ret


;timer callback function resuming thread2

resumethread2:
 push dword [thread2handle]
 call [ResumeThread]
ret 20

segment .data USE32

thread2exit   dd 0
thread2id     dd 0
thread2handle dd 0

mmtimerhandle dd 0
moonpos dd 0

segment .code USE32


;this just draws the gfx
;advances the sprites position by 4 pixels

drawmoon:

mov esi,[moonpos]
add esi,640*480*4
mov ebx,[moonpos]
call redrawbackground

add dword [moonpos],4*4
cmp dword [moonpos],640*4
jb nomoonxend
mov dword [moonpos],0
nomoonxend:

mov esi,640*480*4*2+64*64*4
mov ebx,[moonpos]
mov ecx,64*64
call drawsprite

ret