;
;
;       Stoopid 170 byte 'raw-2-inc' utility by TAD ( tad_uk@bigfoot.com )
;
; notes:
;       This is a slightly bigger & more user friendly version of RAW2.ASM
;       (also included in this .ZIP file). This version does not assume
;       the file handle = 5 or any of the startup register values. It also
;       has the usage text message which indicates whether the infile was
;       found and could be opened.
;
; compile:
;               TASM /m9 raw2inc
;               TLINK /t raw2inc                ; compile as .COM !!
;
;
; usage:
;               RAW2INC  infile  > outfile      ; redirect STDOUT
;
; example:
;               RAW2INC  mydata.dat  >mydata.db
;       or
;               RAW2INC  mydata.dat             ; to preview the output
;
;

        .MODEL TINY
        .CODE
        ORG     256
go:
        mov     ax, 3D00h               ; Open file, 00 access
        sub     bx, bx
        mov     bl, [bx+80h]
        mov     [bx+81h], al            ; mark end of filename with 00
        mov     dx, 0082h
        int     21h
        jc      fail
        xchg    ax, bx                  ; (BX) = file handle
lp:     mov     ah, 3Fh
        mov     dx, ax                  ; [DS:3Fxx] --> temp read buffer
        mov     cx, 8
        int     21h                     ; read upto 8 bytes
        xchg    ax, cx
        jcxz    quit                    ; 0 bytes read (EOF) ?
        lea     di, txt+5
        mov     si, dx
prt:    mov     al, '0'
        stosb
        lodsb                           ; get byte to convert
        aam     16                      ; AH=hi nibble, AL=lo nibble
hex:    xchg    ah, al                  ; output hi-nibble(AH) first
        cmp     al, 0Ah                 ; \
        sbb     al, 69h                 ;   convert(AL) into ASCII char
        das                             ; / "0123456789ABCDEF"
        stosb
        xor     ch, cl
        jnz     hex                     ; toggle nz/nz (loop 2x)
        mov     ax, ',h'
        stosw                           ; add ',h'
        loop    prt
        mov     ax, 0924h               ; (AL)=char '$', (AH)=func 9
        dec     di
        stosb                           ; mark end with '$'
        lea     dx, txt
        int     21h                     ; print the string to screen
        jmp     lp
fail:
        lea     dx, usage               ; display usage
        mov     ah, 09h
        int     21h
quit:
        ret

usage   db      13,10,'RAW-2-INC utility by TAD'
        db      13,10,'usage:'
        db      13,10,9,'RAW2INC infile >outfile   (redirect STDOUT)'
        db      13,10,'$'

txt     db      13,10,'db',9            ; new-line string
        END     go
