// Computes the entropy of a file.
#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include <mem.h>

int main(int argc, char **argv)
{
   if(argc < 2)
   {
      cout <<  "You must specify an input file.";
      return 0;
   }
   ifstream InputFile(argv[1], ios::in | ios::binary, 0);
   InputFile.seekg(0, ios::end);
   int InputLength = InputFile.tellg();
   InputFile.seekg(0, ios::beg);
   float Probabilities[256];
   int Old[256];
   memset(Probabilities, 0, 256 * sizeof(float));
   for(int i = 0; i < InputLength; i++) Probabilities[InputFile.get()]++;
   for(i = 0; i < 256; i++) Old[i] = Probabilities[i];
   for(i = 0; i < 256; i++) Probabilities[i] /= (float) InputLength;
   float Expected = 0;
   for(i = 0; i < 256; i++)
   {
      if(!Probabilities[i]) continue;
/*      cout << "The probability of symbol: \'"
      << (char) i << "\' is " << Probabilities[i] << endl;
      cout << "The entropy of symbol    : \'" << (char) i << "\' is " <<
      -log2(Probabilities[i]) << endl;*/
      Expected += -log2(Probabilities[i]) * Old[i];
   }
   cout << (Expected / (float) 8);
   InputFile.close();
   return 0;
}
