
//
// The first listing.
// Using High-Resolution Timer.
//


// our render function
void RenderProcedure( void )
{	
	static bool				bFirstTime = true;		// just a simple flag
	static LONGLONG			llQPFTicksPerSec  = 0;	// frequency of HRT
	static LONGLONG			llLastElapsedTime = 0;	// last elapsed time...
	static LARGE_INTEGER	qwTime;					// you will see...

	// first time initialising
	if( bFirstTime )
	{
		bFirstTime = false;

		LARGE_INTEGER qwTicksPerSec; // !! LARGE_int
		
		// Use QueryPerformanceFrequency() to get frequency of timer.
		// If QPF is not supported, we will discusse it next...
		if( !QueryPerformanceFrequency( &qwTicksPerSec ) )
			throw "No QPT";  // or smth...

		llQPFTicksPerSec = qwTicksPerSec.QuadPart;
	}

	// Now, get "time"
	QueryPerformanceCounter( &qwTime );

	// calculate the current elapsed time
    double fElapsedTime = (double) ( qwTime.QuadPart - llLastElapsedTime ) / (double) llQPFTicksPerSec;
    
	if( fElapsedTime < 1.0 )	// one second
		return;

	// set new 'last elapsed time'
	llLastElapsedTime = qwTime.QuadPart;

	//
	// Do smth.... the frame (or frames!!) has/have skipped since last call
	//
}
