
;---------------------------------------------Direct Draw structure definitions
DDCOLORKEY STRUC
dwColorSpaceLowValue  DD ?
dwColorSpaceHighValue DD ?
DDCOLORKEY ENDS

; Used to pass override information to the DIRECTDRAWSURFACE ; callback Blt.
DDBLTFX STRUC
dwSize                   DD ?
dwDDFX                   DD ?
dwROP                    DD ?
dwDDROP                  DD ?
dwRotationAngle          DD ?
dwZBufferOpCode          DD ?
dwZBufferLow             DD ?
dwZBufferHigh            DD ?
dwZBufferBaseDest        DD ?
dwZDestConstBitDepth     DD ?
dwZDestConst             DD ?
dwZSrcConstBitDepth      DD ?
dwZSrcConst              DD ?
dwAlphaEdgeBlendBitDepth DD ?
dwAlphaEdgeBlend         DD ?
dwBltFxReserved          DD ?
dwAlphaDestConstBitDepth DD ?
dwAlphaDestConst         DD ?
dwAlphaSrcConstBitDepth  DD ?
dwAlphaSrcConst          DD ?
dwFillColor              DD ?
ddckDestColorkey         DB size DDCOLORKEY dup (?)
ddckSrcColorkey          DB size DDCOLORKEY dup (?)
DDBLTFX ENDS

lpDDSZBufferDest equ dwZDestConst
lpDDSZBufferSrc equ dwZSrcConst
lpDDSAlphaDest equ dwAlphaDestConst
lpDDSAlphaSrc equ dwAlphaSrcConst
dwFillDepth equ dwFillColor
lpDDSPattern equ dwFillColor


DDSCAPS STRUC
dwCaps DD ?
DDSCAPS ENDS


DD_ROP_SPACE EQU (256/32)

IFDEF DIRECTDRAW_VERSION0500h

DDCAPS_DX3 STRUC
dwSize                         DD ? ;size of DDDRIVERCAPS
dwDX3Caps                      DD ? ;changed from dwCaps,
dwCaps2                        DD ? ;because of global structure members...
dwCKeyCaps                     DD ?
dwFXCaps                       DD ?
dwFXAlphaCaps                  DD ?
dwPalCaps                      DD ?
dwSVCaps                       DD ?
dwAlphaBltConstBitDepths       DD ? ;DDBD_2,4,8
dwAlphaBltPixelBitDepths       DD ? ;DDBD_1,2,4,8
dwAlphaBltSurfaceBitDepths     DD ? ;DDBD_1,2,4,8
dwAlphaOverlayConstBitDepths   DD ? ;DDBD_2,4,8
dwAlphaOverlayPixelBitDepths   DD ? ;DDBD_1,2,4,8
dwAlphaOverlaySurfaceBitDepths DD ? ;DDBD_1,2,4,8
dwZBufferBitDepths             DD ? ;DDBD_8,16,24,32
dwVidMemTotal                  DD ?
dwVidMemFree                   DD ?
dwMaxVisibleOverlays           DD ?
dwCurrVisibleOverlays          DD ?
dwNumFourCCCodes               DD ?
dwAlignBoundarySrc             DD ?
dwAlignSizeSrc                 DD ?
dwAlignBoundaryDest            DD ?
dwAlignSizeDest                DD ?
dwAlignStrideAlign             DD ?
dwRops                         DD DD_ROP_SPACE dup (?)
ddsCaps                        DB size DDSCAPS dup (?)
dwMinOverlayStretch            DD ? ;min overlay stretch factor *1000
dwMaxOverlayStretch            DD ? ;max overlay stretch factor *1000
dwMinLiveVideoStretch          DD ? ;min live video stretch factor *1000
dwMaxLiveVideoStretch          DD ? ;max live video stretch factor *1000
dwMinHwCodecStretch            DD ? ;min hardware codec stretch factor *1000
dwMaxHwCodecStretch            DD ? ;max hardware codec stretch factor *1000
dwReserved1                    DD ?
dwReserved2                    DD ?
dwReserved3                    DD ?
dwSVBCaps                      DD ?
dwSVBCKeyCaps                  DD ?
dwSVBFXCaps                    DD ?
dwSVBRops                      DD DD_ROP_SPACE dup (?)
dwVSBCaps                      DD ?
dwVSBCKeyCaps                  DD ?
dwVSBFXCaps                    DD ?
dwVSBRops                      DD DD_ROP_SPACE dup (?)
dwSSBCaps                      DD ?
dwSSBCKeyCaps                  DD ?
dwSSBFXCaps                    DD ?
dwSSBRops                      DD DD_ROP_SPACE dup (?)
dwReserved4                    DD ?
dwReserved5                    DD ?
dwReserved6                    DD ?
DDCAPS_DX3 ENDS

ENDIF

DDCAPS STRUC
dwSize                         DD ? ; 0 ize of DDDRIVERCAPS
dwDX5Caps                      DD ? ; 4 altered - DX5 added, global members
dwCaps2                        DD ? ; 8
dwCKeyCaps                     DD ? ; c
dwFXCaps                       DD ? ;10
dwFXAlphaCaps                  DD ? ;14
dwPalCaps                      DD ? ;18
dwSVCaps                       DD ? ;1c
dwAlphaBltConstBitDepths       DD ? ;20 DDBD_2,4,8
dwAlphaBltPixelBitDepths       DD ? ;24 DDBD_1,2,4,8
dwAlphaBltSurfaceBitDepths     DD ? ;28 DDBD_1,2,4,8
dwAlphaOverlayConstBitDepths   DD ? ;30 DDBD_2,4,8
dwAlphaOverlayPixelBitDepths   DD ? ;30 DDBD_1,2,4,8
dwAlphaOverlaySurfaceBitDepths DD ? ;34 DDBD_1,2,4,8
dwZBufferBitDepths             DD ? ;38 DDBD_8,16,24,32
dwVidMemTotal                  DD ? ;3c
dwVidMemFree                   DD ? ;40
dwMaxVisibleOverlays           DD ? ;44
dwCurrVisibleOverlays          DD ? ;48
dwNumFourCCCodes               DD ? ;4c
dwAlignBoundarySrc             DD ? ;50
dwAlignSizeSrc                 DD ? ;54
dwAlignBoundaryDest            DD ? ;58
dwAlignSizeDest                DD ? ;5c
dwAlignStrideAlign             DD ? ;60
dwRops                         DD DD_ROP_SPACE dup (?) ;64
ddsCaps                        DB size DDSCAPS dup (?) ;84
dwMinOverlayStretch            DD ? ;88 min * 1000
dwMaxOverlayStretch            DD ? ;8c max * 1000
dwMinLiveVideoStretch          DD ? ;90 min * 1000
dwMaxLiveVideoStretch          DD ? ;94 max * 1000
dwMinHwCodecStretch            DD ? ;98 min * 1000
dwMaxHwCodecStretch            DD ? ;9c max * 1000
dwReserved1                    DD ? ;a0
dwReserved2                    DD ? ;a4
dwReserved3                    DD ? ;a8
dwSVBCaps                      DD ? ;ac
dwSVBCKeyCaps                  DD ? ;b0
dwSVBFXCaps                    DD ? ;b4
dwSVBRops                      DD DD_ROP_SPACE dup (?) ;b8
dwVSBCaps                      DD ? ;d8
dwVSBCKeyCaps                  DD ? ;dc
dwVSBFXCaps                    DD ? ;e0
dwVSBRops                      DD DD_ROP_SPACE dup (?) ;e4
dwSSBCaps                      DD ? ;104
dwSSBCKeyCaps                  DD ? ;108
dwSSBFXCaps                    DD ? ;10c
dwSSBRops                      DD DD_ROP_SPACE dup (?) ;110
IFDEF DIRECTDRAW_VERSION0500h
dwMaxVideoPorts                DD ? ;130
dwCurrVideoPorts               DD ? ;134
dwSVBCaps2                     DD ? ;138
dwNLVBCaps                     DD ? ;13c
dwNLVBCaps2                    DD ? ;140
dwNLVBCKeyCaps                 DD ? ;144
dwNLVBFXCaps                   DD ? ;148
dwNLVBRops                     DD DD_ROP_SPACE ;14c
ENDIF
IFNDEF DIRECTDRAW_VERSION0500h
dwReserved4                    DD ? ;130
dwReserved5                    DD ? ;134
dwReserved6                    DD ? ;138
ENDIF
DDCAPS ENDS

DDPIXELFORMAT STRUC
dwSize            DD ?
dwpixFlags        DD ? ;altered from dwFlags because struct members global
dwFour            DD ?
dwRGBBitCount     DD ?
dwRBitMask        DD ?
dwGBitMask        DD ?
dwBBitMask        DD ?
dwRGBAlphaBitMask DD ?
DDPIXELFORMAT ENDS

dwYUVBitCount equ dwRGBBitCount
dwZBufferBitDepth equ dwRGBBitCount
dwAlphaBitDepth equ dwRGBBitCount
dwYBitMask equ dwRBitMask
dwUBitMask equ dwGBitMask
dwVBitMask equ dwBBitMask
dwYUVAlphaBitMask equ dwRGBAlphaBitMask

DDSURFACEDESC STRUC
dwSize              DD ?
dwsurfFlags         DD ? ;altered: surf added
dwHeight            DD ?
dwWidth             DD ?
lPitch              DD ?
dwBackBufferCount   DD ?
dwMipMapCount       DD ? ;altered: surf added
dwsurfAlphaBitDepth DD ? ;altered: surf added
dwReserved          DD ?
lpSurface           DD ?
ddckCKDestOverlay   DB size DDCOLORKEY dup (?)
ddckCKDestBlt       DB size DDCOLORKEY dup (?)
ddckCKSrcOverlay    DB size DDCOLORKEY dup (?)
ddckCKSrcBlt        DB size DDCOLORKEY dup (?)
ddpfPixelFormat     DB size DDPIXELFORMAT dup (?)
ddssurfCaps         DB size DDSCAPS dup (?)
DDSURFACEDESC ENDS

dwsurfZBufferBitDepth equ dwMipMapCount
dwsurfRefreshRate equ dwMipMapCount

;------------------------------------------------------------------------------
DDSD_CAPS EQU 00000001h
DDSD_HEIGHT EQU 00000002h
DDSD_WIDTH EQU 00000004h
DDSD_PITCH EQU 00000008h
DDSD_BACKBUFFERCOUNT EQU 00000020h
DDSD_ZBUFFERBITDEPTH EQU 00000040h
DDSD_ALPHABITDEPTH EQU 00000080h
DDSD_LPSURFACE EQU 00000800h
DDSD_PIXELFORMAT EQU 00001000h
DDSD_CKDESTOVERLAY EQU 00002000h
DDSD_CKDESTBLT EQU 00004000h
DDSD_CKSRCOVERLAY EQU 00008000h
DDSD_CKSRCBLT EQU 00010000h
DDSD_MIPMAPCOUNT EQU 00020000h
DDSD_REFRESHRATE EQU 00040000h
DDSD_LINEARSIZE EQU 00080000h
DDSD_ALL EQU 000ff9eeh

;---------------DIRECTDRAWSURFACE CAPABILITY FLAGS---------------------
DDSCAPS_RESERVED1 EQU 00000001h
DDSCAPS_ALPHA EQU 00000002h
DDSCAPS_BACKBUFFER EQU 00000004h
DDSCAPS_COMPLEX EQU 00000008h
DDSCAPS_FLIP EQU 00000010h
DDSCAPS_FRONTBUFFER EQU 00000020h
DDSCAPS_OFFSCREENPLAIN EQU 00000040h
DDSCAPS_OVERLAY EQU 00000080h
DDSCAPS_PALETTE EQU 00000100h
DDSCAPS_PRIMARYSURFACE EQU 00000200h
DDSCAPS_PRIMARYSURFACELEFT EQU 00000400h
DDSCAPS_SYSTEMMEMORY EQU 00000800h
DDSCAPS_TEXTURE EQU 00001000h
DDSCAPS_3DDEVICE EQU 00002000h
DDSCAPS_VIDEOMEMORY EQU 00004000h
DDSCAPS_VISIBLE EQU 00008000h
DDSCAPS_WRITEONLY EQU 00010000h
DDSCAPS_ZBUFFER EQU 00020000h
DDSCAPS_OWNDC EQU 00040000h
DDSCAPS_LIVEVIDEO EQU 00080000h
DDSCAPS_HWCODEC EQU 00100000h
DDSCAPS_MODEX EQU 00200000h
DDSCAPS_MIPMAP EQU 00400000h
DDSCAPS_RESERVED2 EQU 00800000h
DDSCAPS_ALLOCONLOAD EQU 04000000h
DDSCAPS_VIDEOPORT EQU 08000000h
DDSCAPS_LOCALVIDMEM EQU 10000000h
DDSCAPS_NONLOCALVIDMEM EQU 20000000h
DDSCAPS_STANDARDVGAMODE EQU 40000000h
DDSCAPS_OPTIMIZED EQU 80000000h

;---------------DIRECTDRAW DRIVER CAPABILITY FLAGS------------------------
DDCAPS_3D EQU 000000001h
DDCAPS_ALIGNBOUNDARYDEST EQU 000000002h
DDCAPS_ALIGNSIZEDEST EQU 000000004h
DDCAPS_ALIGNBOUNDARYSRC EQU 000000008h
DDCAPS_ALIGNSIZESRC EQU 000000010h
DDCAPS_ALIGNSTRIDE EQU 000000020h
DDCAPS_BLT EQU 000000040h
DDCAPS_BLTQUEUE EQU 000000080h
DDCAPS_BLTFOURCC EQU 000000100h
DDCAPS_BLTSTRETCH EQU 000000200h
DDCAPS_GDI EQU 000000400h
DDCAPS_OVERLAY EQU 000000800h
DDCAPS_OVERLAYCANTCLIP EQU 000001000h
DDCAPS_OVERLAYFOURCC EQU 000002000h
DDCAPS_OVERLAYSTRETCH EQU 000004000h
DDCAPS_PALETTE EQU 000008000h
DDCAPS_PALETTEVSYNC EQU 000010000h
DDCAPS_READSCANLINE EQU 000020000h
DDCAPS_STEREOVIEW EQU 000040000h
DDCAPS_VBI EQU 000080000h
DDCAPS_ZBLTS EQU 000100000h
DDCAPS_ZOVERLAYS EQU 000200000h
DDCAPS_COLORKEY EQU 000400000h
DDCAPS_ALPHA EQU 000800000h
DDCAPS_COLORKEYHWASSIST EQU 001000000h
DDCAPS_NOHARDWARE EQU 002000000h
DDCAPS_BLTCOLORFILL EQU 004000000h
DDCAPS_BANKSWITCHED EQU 008000000h
DDCAPS_BLTDEPTHFILL EQU 010000000h
DDCAPS_CANCLIP EQU 020000000h
DDCAPS_CANCLIPSTRETCHED EQU 040000000h
DDCAPS_CANBLTSYSMEM EQU 080000000h

;=== MORE DIRECTDRAW DRIVER CAPABILITY FLAGS (dwCaps2) ===
DDCAPS2_CERTIFIED EQU 000000001h
DDCAPS2_NO2DDURING3DSCENE EQU 000000002h
DDCAPS2_VIDEOPORT EQU 000000004h
DDCAPS2_AUTOFLIPOVERLAY EQU 000000008h
DDCAPS2_CANBOBINTERLEAVED EQU 000000010h
DDCAPS2_CANBOBNONINTERLEAVED EQU 000000020h
DDCAPS2_COLORCONTROLOVERLAY EQU 000000040h
DDCAPS2_COLORCONTROLPRIMARY EQU 000000080h
DDCAPS2_CANDROPZ16BIT EQU 000000100h
DDCAPS2_NONLOCALVIDMEM EQU 000000200h
DDCAPS2_NONLOCALVIDMEMCAPS EQU 000000400h
DDCAPS2_NOPAGELOCKREQUIRED EQU 000000800h
DDCAPS2_WIDESURFACES EQU 000001000h
DDCAPS2_CANFLIPODDEVEN EQU 000002000h

;-------------DIRECTDRAW FX ALPHA CAPABILITY FLAGS--------
DDFXALPHACAPS_BLTALPHAEDGEBLEND EQU 000000001h
DDFXALPHACAPS_BLTALPHAPIXELS EQU 000000002h
DDFXALPHACAPS_BLTALPHAPIXELSNEG EQU 000000004h
DDFXALPHACAPS_BLTALPHASURFACES EQU 000000008h
DDFXALPHACAPS_BLTALPHASURFACESNEG EQU 000000010h
DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND EQU 000000020h
DDFXALPHACAPS_OVERLAYALPHAPIXELS EQU 000000040h
DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG EQU 000000080h
DDFXALPHACAPS_OVERLAYALPHASURFACES EQU 000000100h
DDFXALPHACAPS_OVERLAYALPHASURFACESNEG EQU 000000200h

;----------DIRECTDRAW FX CAPABILITY FLAGS-----------------
DDFXCAPS_BLTARITHSTRETCHY EQU 000000020h
DDFXCAPS_BLTARITHSTRETCHYN EQU 000000010h
DDFXCAPS_BLTMIRRORLEFTRIGHT EQU 000000040h
DDFXCAPS_BLTMIRRORUPDOWN EQU 000000080h
DDFXCAPS_BLTROTATION EQU 000000100h
DDFXCAPS_BLTROTATION90 EQU 000000200h
DDFXCAPS_BLTSHRINKX EQU 000000400h
DDFXCAPS_BLTSHRINKXN EQU 000000800h
DDFXCAPS_BLTSHRINKY EQU 000001000h
DDFXCAPS_BLTSHRINKYN EQU 000002000h
DDFXCAPS_BLTSTRETCHX EQU 000004000h
DDFXCAPS_BLTSTRETCHXN EQU 000008000h
DDFXCAPS_BLTSTRETCHY EQU 000010000h
DDFXCAPS_BLTSTRETCHYN EQU 000020000h
DDFXCAPS_OVERLAYARITHSTRETCHY EQU 000040000h
DDFXCAPS_OVERLAYARITHSTRETCHYN EQU 000000008h
DDFXCAPS_OVERLAYSHRINKX EQU 000080000h
DDFXCAPS_OVERLAYSHRINKXN EQU 000100000h
DDFXCAPS_OVERLAYSHRINKY EQU 000200000h
DDFXCAPS_OVERLAYSHRINKYN EQU 000400000h
DDFXCAPS_OVERLAYSTRETCHX EQU 000800000h
DDFXCAPS_OVERLAYSTRETCHXN EQU 001000000h
DDFXCAPS_OVERLAYSTRETCHY EQU 002000000h
DDFXCAPS_OVERLAYSTRETCHYN EQU 004000000h
DDFXCAPS_OVERLAYMIRRORLEFTRIGHT EQU 008000000h
DDFXCAPS_OVERLAYMIRRORUPDOWN EQU 010000000h

;-----------DIRECTDRAW STEREO VIEW CAPABILITIES------------
DDSVCAPS_ENIGMA EQU 000000001h
DDSVCAPS_FLICKER EQU 000000002h
DDSVCAPS_REDBLUE EQU 000000004h
DDSVCAPS_SPLIT EQU 000000008h

;---------DIRECTDRAWPALETTE CAPABILITIES-------------------
DDPCAPS_4BIT EQU 000000001h
DDPCAPS_8BITENTRIES EQU 000000002h
DDPCAPS_8BIT EQU 000000004h
DDPCAPS_INITIALIZE EQU 000000008h
DDPCAPS_PRIMARYSURFACE EQU 000000010h
DDPCAPS_PRIMARYSURFACELEFT EQU 000000020h
DDPCAPS_ALLOW256 EQU 000000040h
DDPCAPS_VSYNC EQU 000000080h
DDPCAPS_1BIT EQU 000000100h
DDPCAPS_2BIT EQU 000000200h

;--------------DIRECTDRAW BITDEPTH CONSTANTS----------------
DDBD_1 EQU 000004000h
DDBD_2 EQU 000002000h
DDBD_4 EQU 000001000h
DDBD_8 EQU 000000800h
DDBD_16 EQU 000000400h
DDBD_24 EQU 000000200h
DDBD_32 EQU 000000100h

;------------DIRECTDRAWSURFACE SET/GET COLOR KEY FLAGS---------------
DDCKEY_COLORSPACE EQU 000000001h
DDCKEY_DESTBLT EQU 000000002h
DDCKEY_DESTOVERLAY EQU 000000004h
DDCKEY_SRCBLT EQU 000000008h
DDCKEY_SRCOVERLAY EQU 000000010h

;------------DIRECTDRAW COLOR KEY CAPABILITY FLAGS-------------------
DDCKEYCAPS_DESTBLT EQU 000000001h
DDCKEYCAPS_DESTBLTCLRSPACE EQU 000000002h
DDCKEYCAPS_DESTBLTCLRSPACEYUV EQU 000000004h
DDCKEYCAPS_DESTBLTYUV EQU 000000008h
DDCKEYCAPS_DESTOVERLAY EQU 000000010h
DDCKEYCAPS_DESTOVERLAYCLRSPACE EQU 000000020h
DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV EQU 000000040h
DDCKEYCAPS_DESTOVERLAYONEACTIVE EQU 000000080h
DDCKEYCAPS_DESTOVERLAYYUV EQU 000000100h
DDCKEYCAPS_SRCBLT EQU 000000200h
DDCKEYCAPS_SRCBLTCLRSPACE EQU 000000400h
DDCKEYCAPS_SRCBLTCLRSPACEYUV EQU 000000800h
DDCKEYCAPS_SRCBLTYUV EQU 000001000h
DDCKEYCAPS_SRCOVERLAY EQU 000002000h
DDCKEYCAPS_SRCOVERLAYCLRSPACE EQU 000004000h
DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV EQU 000008000h
DDCKEYCAPS_SRCOVERLAYONEACTIVE EQU 000010000h
DDCKEYCAPS_SRCOVERLAYYUV EQU 000020000h
DDCKEYCAPS_NOCOSTOVERLAY EQU 000040000h

;-------------DIRECTDRAW PIXELFORMAT FLAGS-------------------
DDPF_ALPHAPIXELS EQU 000000001h
DDPF_ALPHA EQU 000000002h
DDPF_FOURCC EQU 000000004h
DDPF_PALETTEINDEXED4 EQU 000000008h
DDPF_PALETTEINDEXEDTO8 EQU 000000010h
DDPF_PALETTEINDEXED8 EQU 000000020h
DDPF_RGB EQU 000000040h
DDPF_COMPRESSED EQU 000000080h
DDPF_RGBTOYUV EQU 000000100h
DDPF_YUV EQU 000000200h
DDPF_ZBUFFER EQU 000000400h
DDPF_PALETTEINDEXED1 EQU 000000800h
DDPF_PALETTEINDEXED2 EQU 000001000h
DDPF_ZPIXELS EQU 000002000h

;-----------------DIRECTDRAW ENUMSURFACES FLAGS--------------------
DDENUMSURFACES_ALL EQU 000000001h
DDENUMSURFACES_MATCH EQU 000000002h
DDENUMSURFACES_NOMATCH EQU 000000004h
DDENUMSURFACES_CANBECREATED EQU 000000008h
DDENUMSURFACES_DOESEXIST EQU 000000010h

;----------------DIRECTDRAW SETDISPLAYMODE FLAGS-------------------------
DDSDM_STANDARDVGAMODE EQU 000000001h

;---------------DIRECTDRAW ENUMDISPLAYMODES FLAGS-------------------------
DDEDM_REFRESHRATES EQU 000000001h
DDEDM_STANDARDVGAMODES EQU 000000002h

;------------------SETCOOPERATIVELEVEL FLAGS--------------------------
DDSCL_FULLSCREEN EQU 00000001h
DDSCL_ALLOWREBOOT EQU 00000002h
DDSCL_NOWINDOWCHANGES EQU 00000004h
DDSCL_NORMAL EQU 00000008h
DDSCL_EXCLUSIVE EQU 00000010h
DDSCL_ALLOWMODEX EQU 00000040h

;--------------DIRECTDRAW BLT FLAGS----------------------------
DDBLT_ALPHADEST EQU 000000001h
DDBLT_ALPHADESTCONSTOVERRIDE EQU 000000002h
DDBLT_ALPHADESTNEG EQU 000000004h
DDBLT_ALPHADESTSURFACEOVERRIDE EQU 000000008h
DDBLT_ALPHAEDGEBLEND EQU 000000010h
DDBLT_ALPHASRC EQU 000000020h
DDBLT_ALPHASRCCONSTOVERRIDE EQU 000000040h
DDBLT_ALPHASRCNEG EQU 000000080h
DDBLT_ALPHASRCSURFACEOVERRIDE EQU 000000100h
DDBLT_ASYNC EQU 000000200h
DDBLT_COLORFILL EQU 000000400h
DDBLT_DDFX EQU 000000800h
DDBLT_DDROPS EQU 000001000h
DDBLT_KEYDEST EQU 000002000h
DDBLT_KEYDESTOVERRIDE EQU 000004000h
DDBLT_KEYSRC EQU 000008000h
DDBLT_KEYSRCOVERRIDE EQU 000010000h
DDBLT_ROP EQU 000020000h
DDBLT_ROTATIONANGLE EQU 000040000h
DDBLT_ZBUFFER EQU 000080000h
DDBLT_ZBUFFERDESTCONSTOVERRIDE EQU 000100000h
DDBLT_ZBUFFERDESTOVERRIDE EQU 000200000h
DDBLT_ZBUFFERSRCCONSTOVERRIDE EQU 000400000h
DDBLT_ZBUFFERSRCOVERRIDE EQU 000800000h
DDBLT_WAIT EQU 001000000h
DDBLT_DEPTHFILL EQU 002000000h

;----------------BLTFAST FLAGS--------------------------
DDBLTFAST_NOCOLORKEY EQU 000000000
DDBLTFAST_SRCCOLORKEY EQU 000000001
DDBLTFAST_DESTCOLORKEY EQU 000000002
DDBLTFAST_WAIT EQU 000000010

;-----------------FLIP FLAGS----------------------------
DDFLIP_WAIT EQU 000000001h
DDFLIP_EVEN EQU 000000002h
DDFLIP_ODD EQU 000000004h

;------DIRECTDRAW SURFACE OVERLAY FLAGS-----------------
DDOVER_ALPHADEST EQU 000000001h
DDOVER_ALPHADESTCONSTOVERRIDE EQU 000000002h
DDOVER_ALPHADESTNEG EQU 000000004h
DDOVER_ALPHADESTSURFACEOVERRIDE EQU 000000008h
DDOVER_ALPHAEDGEBLEND EQU 000000010h
DDOVER_ALPHASRC EQU 000000020h
DDOVER_ALPHASRCCONSTOVERRIDE EQU 000000040h
DDOVER_ALPHASRCNEG EQU 000000080h
DDOVER_ALPHASRCSURFACEOVERRIDE EQU 000000100h
DDOVER_HIDE EQU 000000200h
DDOVER_KEYDEST EQU 000000400h
DDOVER_KEYDESTOVERRIDE EQU 000000800h
DDOVER_KEYSRC EQU 000001000h
DDOVER_KEYSRCOVERRIDE EQU 000002000h
DDOVER_SHOW EQU 000004000h
DDOVER_ADDDIRTYRECT EQU 000008000h
DDOVER_REFRESHDIRTYRECTS EQU 000010000h
DDOVER_REFRESHALL EQU 000020000h
DDOVER_DDFX EQU 000080000h
DDOVER_AUTOFLIP EQU 000100000h
DDOVER_BOB EQU 000200000h
DDOVER_OVERRIDEBOBWEAVE EQU 000400000h
DDOVER_INTERLEAVED EQU 000800000h

;-----------DIRECTDRAWSURFACE LOCK FLAGS---------------------
DDLOCK_SURFACEMEMORYPTR EQU 000000000h
DDLOCK_WAIT EQU 000000001h
DDLOCK_EVENT EQU 000000002h
DDLOCK_READONLY EQU 000000010h
DDLOCK_WRITEONLY EQU 000000020h
DDLOCK_NOSYSLOCK EQU 000000800h

;---------DIRECTDRAWSURFACE BLT FX FLAGS---------------------
DDBLTFX_ARITHSTRETCHY EQU 000000001h
DDBLTFX_MIRRORLEFTRIGHT EQU 000000002h
DDBLTFX_MIRRORUPDOWN EQU 000000004h
DDBLTFX_NOTEARING EQU 000000008h
DDBLTFX_ROTATE180 EQU 000000010h
DDBLTFX_ROTATE270 EQU 000000020h
DDBLTFX_ROTATE90 EQU 000000040h
DDBLTFX_ZBUFFERRANGE EQU 000000080h
DDBLTFX_ZBUFFERBASEDEST EQU 000000100h

;-----------DIRECTDRAWSURFACE OVERLAY FX FLAGS---------------
DDOVERFX_ARITHSTRETCHY EQU 000000001h
DDOVERFX_MIRRORLEFTRIGHT EQU 000000002h
DDOVERFX_MIRRORUPDOWN EQU 000000004h

;----------DIRECTDRAW WAITFORVERTICALBLANK FLAGS--------------
DDWAITVB_BLOCKBEGIN EQU 000000001h
DDWAITVB_BLOCKBEGINEVENT EQU 000000002h
DDWAITVB_BLOCKEND EQU 000000004h

;------------DIRECTDRAW GETFLIPSTATUS FLAGS-------------------
DDGFS_CANFLIP EQU 000000001h
DDGFS_ISFLIPDONE EQU 000000002h

;-------------DIRECTDRAW GETBLTSTATUS FLAGS-------------------
DDGBS_CANBLT EQU 000000001h
DDGBS_ISBLTDONE EQU 000000002h

;--------------DIRECTDRAW ENUMOVERLAYZORDER FLAGS-------------
DDENUMOVERLAYZ_BACKTOFRONT EQU 000000000h
DDENUMOVERLAYZ_FRONTTOBACK EQU 000000001h

;-------------DIRECTDRAW UPDATEOVERLAYZORDER FLAGS------------
DDOVERZ_SENDTOFRONT EQU 000000000h
DDOVERZ_SENDTOBACK EQU 000000001h
DDOVERZ_MOVEFORWARD EQU 000000002h
DDOVERZ_MOVEBACKWARD EQU 000000003h
DDOVERZ_INSERTINFRONTOF EQU 000000004h
DDOVERZ_INSERTINBACKOF EQU 000000005h

;------DIRECTDRAW RETURN CODES--------------------------------
DD_OK EQU 0

;-------DIRECTDRAW ENUMCALLBACK RETURN VALUES-------------------------------
DDENUMRET_CANCEL EQU 0
DDENUMRET_OK EQU 1

;-------DIRECTDRAW ERRORS----------------------------------------------------
DDERR_ALREADYINITIALIZED           EQU 88760005h ;MAKE_DDHRESULT( 5 )
DDERR_CANNOTATTACHSURFACE          EQU 8876000ah ;MAKE_DDHRESULT( 10 )
DDERR_CANNOTDETACHSURFACE          EQU 88760014h ;MAKE_DDHRESULT( 20 )
DDERR_CURRENTLYNOTAVAIL            EQU 88760028h ;MAKE_DDHRESULT( 40 )
DDERR_EXCEPTION                    EQU 88760037h ;MAKE_DDHRESULT( 55 )
DDERR_GENERIC                      EQU 80004005h ;defined as E_FAIL
DDERR_HEIGHTALIGN                  EQU 8876005ah ;MAKE_DDHRESULT( 90 )
DDERR_INCOMPATIBLEPRIMARY          EQU 8876005fh ;MAKE_DDHRESULT( 95 )
DDERR_INVALIDCAPS                  EQU 88760064h ;MAKE_DDHRESULT( 100 )
DDERR_INVALIDCLIPLIST              EQU 8876006eh ;MAKE_DDHRESULT( 110 )
DDERR_INVALIDMODE                  EQU 88760078h ;MAKE_DDHRESULT( 120 )
DDERR_INVALIDOBJECT                EQU 88760082h ;MAKE_DDHRESULT( 130 )
DDERR_INVALIDPARAMS                EQU 80070057h ;defined as E_INVALIDARG
DDERR_INVALIDPIXELFORMAT           EQU 88760091h ;MAKE_DDHRESULT( 145 )
DDERR_INVALIDRECT                  EQU 88760096h ;MAKE_DDHRESULT( 150 )
DDERR_LOCKEDSURFACES               EQU 887600a0h ;MAKE_DDHRESULT( 160 )
DDERR_NO3D                         EQU 887600aah ;MAKE_DDHRESULT( 170 )
DDERR_NOALPHAHW                    EQU 887600b4h ;MAKE_DDHRESULT( 180 )
DDERR_NOCLIPLIST                   EQU 887600cdh ;MAKE_DDHRESULT( 205 )
DDERR_NOCOLORCONVHW                EQU 887600d2h ;MAKE_DDHRESULT( 210 )
DDERR_NOCOOPERATIVELEVELSET        EQU 887600d4h ;MAKE_DDHRESULT( 212 )
DDERR_NOCOLORKEY                   EQU 887600d7h ;MAKE_DDHRESULT( 215 )
DDERR_NOCOLORKEYHW                 EQU 887600dch ;MAKE_DDHRESULT( 220 )
DDERR_NODIRECTDRAWSUPPORT          EQU 887600deh ;MAKE_DDHRESULT( 222 )
DDERR_NOEXCLUSIVEMODE              EQU 887600e1h ;MAKE_DDHRESULT( 225 )
DDERR_NOFLIPHW                     EQU 887600e6h ;MAKE_DDHRESULT( 230 )
DDERR_NOGDI                        EQU 887600f0h ;MAKE_DDHRESULT( 240 )
DDERR_NOMIRRORHW                   EQU 887600fah ;MAKE_DDHRESULT( 250 )
DDERR_NOTFOUND                     EQU 887600ffh ;MAKE_DDHRESULT( 255 )
DDERR_NOOVERLAYHW                  EQU 88760104h ;MAKE_DDHRESULT( 260 )
DDERR_NORASTEROPHW                 EQU 88760118h ;MAKE_DDHRESULT( 280 )
DDERR_NOROTATIONHW                 EQU 88760122h ;MAKE_DDHRESULT( 290 )
DDERR_NOSTRETCHHW                  EQU 88760136h ;MAKE_DDHRESULT( 310 )
DDERR_NOT4BITCOLOR                 EQU 8876013ch ;MAKE_DDHRESULT( 316 )
DDERR_NOT4BITCOLORINDEX            EQU 8876013dh ;MAKE_DDHRESULT( 317 )
DDERR_NOT8BITCOLOR                 EQU 88760140h ;MAKE_DDHRESULT( 320 )
DDERR_NOTEXTUREHW                  EQU 8876014ah ;MAKE_DDHRESULT( 330 )
DDERR_NOVSYNCHW                    EQU 8876014fh ;MAKE_DDHRESULT( 335 )
DDERR_NOZBUFFERHW                  EQU 88760154h ;MAKE_DDHRESULT( 340 )
DDERR_NOZOVERLAYHW                 EQU 8876015eh ;MAKE_DDHRESULT( 350 )
DDERR_OUTOFCAPS                    EQU 88760168h ;MAKE_DDHRESULT( 360 )
DDERR_OUTOFMEMORY                  EQU 8007000eh ;defined as E_OUTOFMEMORY
DDERR_OUTOFVIDEOMEMORY             EQU 8876017ch ;MAKE_DDHRESULT( 380 )
DDERR_OVERLAYCANTCLIP              EQU 8876017eh ;MAKE_DDHRESULT( 382 )
DDERR_OVERLAYCOLORKEYONLYONEACTIVE EQU 88760180h ;MAKE_DDHRESULT( 384 )
DDERR_PALETTEBUSY                  EQU 88760183h ;MAKE_DDHRESULT( 387 )
DDERR_COLORKEYNOTSET               EQU 88760190h ;MAKE_DDHRESULT( 400 )
DDERR_SURFACEALREADYATTACHED       EQU 8876019ah ;MAKE_DDHRESULT( 410 )
DDERR_SURFACEALREADYDEPENDENT      EQU 887601a4h ;MAKE_DDHRESULT( 420 )
DDERR_SURFACEBUSY                  EQU 887601aeh ;MAKE_DDHRESULT( 430 )
DDERR_CANTLOCKSURFACE              EQU 887601b3h ;MAKE_DDHRESULT( 435 )
DDERR_SURFACEISOBSCURED            EQU 887601b8h ;MAKE_DDHRESULT( 440 )
DDERR_SURFACELOST                  EQU 887601c2h ;MAKE_DDHRESULT( 450 )
DDERR_SURFACENOTATTACHED           EQU 887601cch ;MAKE_DDHRESULT( 460 )
DDERR_TOOBIGHEIGHT                 EQU 887601d6h ;MAKE_DDHRESULT( 470 )
DDERR_TOOBIGSIZE                   EQU 887601e0h ;MAKE_DDHRESULT( 480 )
DDERR_TOOBIGWIDTH                  EQU 887601eah ;MAKE_DDHRESULT( 490 )
DDERR_UNSUPPORTED                  EQU 80004001h ;defined as E_NOTIMPL
DDERR_UNSUPPORTEDFORMAT            EQU 887601feh ;MAKE_DDHRESULT( 510 )
DDERR_UNSUPPORTEDMASK              EQU 88760208h ;MAKE_DDHRESULT( 520 )
DDERR_VERTICALBLANKINPROGRESS      EQU 88760219h ;MAKE_DDHRESULT( 537 )
DDERR_WASSTILLDRAWING              EQU 8876021ch ;MAKE_DDHRESULT( 540 )
DDERR_XALIGN                       EQU 88760230h ;MAKE_DDHRESULT( 560 )
DDERR_INVALIDDIRECTDRAWGUID        EQU 88760231h ;MAKE_DDHRESULT( 561 )
DDERR_DIRECTDRAWALREADYCREATED     EQU 88760232h ;MAKE_DDHRESULT( 562 )
DDERR_NODIRECTDRAWHW               EQU 88760233h ;MAKE_DDHRESULT( 563 )
DDERR_PRIMARYSURFACEALREADYEXISTS  EQU 88760234h ;MAKE_DDHRESULT( 564 )
DDERR_NOEMULATION                  EQU 88760235h ;MAKE_DDHRESULT( 565 )
DDERR_REGIONTOOSMALL               EQU 88760236h ;MAKE_DDHRESULT( 566 )
DDERR_CLIPPERISUSINGHWND           EQU 88760237h ;MAKE_DDHRESULT( 567 )
DDERR_NOCLIPPERATTACHED            EQU 88760238h ;MAKE_DDHRESULT( 568 )
DDERR_NOHWND                       EQU 88760239h ;MAKE_DDHRESULT( 569 )
DDERR_HWNDSUBCLASSED               EQU 8876023ah ;MAKE_DDHRESULT( 570 )
DDERR_HWNDALREADYSET               EQU 8876023bh ;MAKE_DDHRESULT( 571 )
DDERR_NOPALETTEATTACHED            EQU 8876023ch ;MAKE_DDHRESULT( 572 )
DDERR_NOPALETTEHW                  EQU 8876023dh ;MAKE_DDHRESULT( 573 )
DDERR_BLTFASTCANTCLIP              EQU 8876023eh ;MAKE_DDHRESULT( 574 )
DDERR_NOBLTHW                      EQU 8876023fh ;MAKE_DDHRESULT( 575 )
DDERR_NODDROPSHW                   EQU 88760240h ;MAKE_DDHRESULT( 576 )
DDERR_OVERLAYNOTVISIBLE            EQU 88760241h ;MAKE_DDHRESULT( 577 )
DDERR_NOOVERLAYDEST                EQU 88760242h ;MAKE_DDHRESULT( 578 )
DDERR_INVALIDPOSITION              EQU 88760243h ;MAKE_DDHRESULT( 579 )
DDERR_NOTAOVERLAYSURFACE           EQU 88760244h ;MAKE_DDHRESULT( 580 )
DDERR_EXCLUSIVEMODEALREADYSET      EQU 88760245h ;MAKE_DDHRESULT( 581 )
DDERR_NOTFLIPPABLE                 EQU 88760246h ;MAKE_DDHRESULT( 582 )
DDERR_CANTDUPLICATE                EQU 88760247h ;MAKE_DDHRESULT( 583 )
DDERR_NOTLOCKED                    EQU 88760248h ;MAKE_DDHRESULT( 584 )
DDERR_CANTCREATEDC                 EQU 88760249h ;MAKE_DDHRESULT( 585 )
DDERR_NODC                         EQU 8876024ah ;MAKE_DDHRESULT( 586 )
DDERR_WRONGMODE                    EQU 8876024bh ;MAKE_DDHRESULT( 587 )
DDERR_IMPLICITLYCREATED            EQU 8876024ch ;MAKE_DDHRESULT( 588 )
DDERR_NOTPALETTIZED                EQU 8876024dh ;MAKE_DDHRESULT( 589 )
DDERR_UNSUPPORTEDMODE              EQU 8876024eh ;MAKE_DDHRESULT( 590 )
DDERR_NOMIPMAPHW                   EQU 8876024fh ;MAKE_DDHRESULT( 591 )
DDERR_INVALIDSURFACETYPE           EQU 88760250h ;MAKE_DDHRESULT( 592 )
DDERR_NOOPTIMIZEHW                 EQU 88760258h ;MAKE_DDHRESULT( 600 )
DDERR_NOTLOADED                    EQU 88760259h ;MAKE_DDHRESULT( 601 )
DDERR_DCALREADYCREATED             EQU 8876026ch ;MAKE_DDHRESULT( 620 )
DDERR_NONONLOCALVIDMEM             EQU 88760276h ;MAKE_DDHRESULT( 630 )
DDERR_CANTPAGELOCK                 EQU 88760280h ;MAKE_DDHRESULT( 640 )
DDERR_CANTPAGEUNLOCK               EQU 88760294h ;MAKE_DDHRESULT( 660 )
DDERR_NOTPAGELOCKED                EQU 887602a8h ;MAKE_DDHRESULT( 680 )
DDERR_MOREDATA                     EQU 887602b2h ;MAKE_DDHRESULT( 690 )
DDERR_VIDEONOTACTIVE               EQU 887602b7h ;MAKE_DDHRESULT( 695 )
DDERR_DEVICEDOESNTOWNSURFACE       EQU 887602bbh ;MAKE_DDHRESULT( 699 )
DDERR_NOTINITIALIZED               EQU 800401f0h ;defined as CO_E_NOTINITIALIZED

;-------------------METHODS-----------------------------
;IDirectDraw
;IUnknown methods
DDQUERYINTERFACE EQU 0
DDADDREF EQU 4
DDRELEASE EQU 8
;IDirectDraw methods
DDCOMPACT EQU 12
DDCREATECLIPPER EQU 16
DDCREATEPALETTE EQU 20
DDCREATESURFACE EQU 24
DDDUPLICATESURFACE EQU 28
DDENUMDISPLAYMODES EQU 32
DDENUMSYURFACES EQU 36
DDFLIPTOGDISURFACE EQU 40
DDGETCAPS EQU 44
DDGETDISPLAYMODE EQU 48
DDGETFOURCCCODES EQU 52
DDGETGDISURFACE EQU 56
DDGETMONITORFREQUENCY EQU 60
DDGETSCANLINE EQU 64
DDGETVERTICALBLANKSTATUS EQU 68
DDINITIALIZE EQU 72
DDRESTOREDISPLAYMODE EQU 76
DDSETCOOPERATIVELEVEL EQU 80
DDSETDISPLAYMODE EQU 84
DDWAITFORVERTICALBLANK EQU 88
;IDirectDraw2
DD2GETAVAILABLEVIDMEM EQU 92

;IDirectDrawPalette
;IUnknown methods
DDPQUERYINTERFACE EQU 0
DDPADDREF EQU 4
DDPRELEASE EQU 8
;IDirectDrawPalette methods
DDPDGETCAPS EQU 12
DDPGETENTRIES EQU 16
DDPINITIALIZE EQU 20
DDPSETENTRIES EQU 24

;IDirectDrawSurface and related interfaces
;IUnknown methods
DDSQUERYINTERFACE EQU 0
DDSADDREF EQU 4
DDSRELEASE EQU 8
;IDirectDrawSurface methods
DDSADDATTACHEDSURFACE EQU 12
DDSADDOVERLAYDIRTYRECT EQU 16
DDSBLT EQU 20
DDSBLTBATCH EQU 24
DDSBLTFASTBLT EQU 28
DDSDELETATTACHEDSURFACE EQU 32
DDSENUMATTACHEDSURFACES EQU 36
DDSENUMOVERLAYZORDERS EQU 40
DDSFLIP EQU 44
DDSGETATTACHEDSURFACE EQU 48
DDSGETBLTSTATUS EQU 52
DDSGETCAPS EQU 56
DDSGETCLIPPER EQU 60
DDSGETCOLORKEY EQU 64
DDSGETDC EQU 68
DDSGETFLIPSTATUS EQU 72
DDSGETOVERLAYPOSITION EQU 76
DDSGETPALETTE EQU 80
DDSGETPIXELFORMAT EQU 84
DDSGETSURFACEDESC EQU 88
DDSINITIALIZE EQU 92
DDSISLOST EQU 96
DDSLOCK EQU 100
DDSRELEASEDC EQU 104
DDSRESTORE EQU 108
DDSSETCLIPPER EQU 112
DDSSETCOLORKEY EQU 116
DDSSETOVERLAYPOSITION EQU 120
DDSSETPALETTE EQU 124
DDSUNLOCK EQU 128
DDSUPDATEOVERLAY EQU 132
DDSUPDATEOVERLAYDISPLAY EQU 136
DDSUPDATEOVERLAYZORDER EQU 140
;IDirectDrawSurface2
DDS2GETDDINTERFACE EQU 144
DDS2PAGELOCK EQU 148
DDS2PAGEUNLOCK EQU 152
;IDirectDrawSurface3
DDS3SETSURFACEDESC EQU 156

;IDirectDrawClipper
;IUnknown methods
DDCQUERYINTERFACE EQU 0
DDCADDREF EQU 4
DDCRELEASE EQU 8
;IDirectDrawClipper methods
DDCGETCLIPLIST EQU 12
DDCGETHWND EQU 16
DDCINITIALIZE EQU 20
DDCISCLIPLISTCHANGED EQU 24
DDCSETCLIPLIST EQU 28
DDCSETHWND EQU 32

;IDirectDrawColorControl
;IUnknown methods
DDCCQUERYINTERFACE EQU 0
DDCCADDREF EQU 4
DDCCRELEASE EQU 8
;IDirectDrawColorControl methods
DDGETCOLORCONTROLS EQU 12
DDSETCOLORCONTROLS EQU 16
