#include <stdio.h>
#include <math.h>
#include "mode13h.h"

typedef struct {
  int r; // Strahl-Radius von der Licht-Quelle
  int v; // Verschiebung im Sinus(Cosinus) bei der Darstellung 
}po;

po p[256]; // Anzahl d. Strahlen
int x_arr[512][440];
int y_arr[512][440];

char dst[64000];
char lq[225];
char texture[64000];

int ff=0;
int lx,ly=0;         // Licht-Pos.
int x,y,i,j,b,k=0;   // Sklaven...
int xx,yy=0;         // Neue Strahl-Pos.
int xp,yp=0;

void main(void) {
printf("\nWait...");
printf("\n ");

init_light(); // Effekt initialisieren
mode(0x13);
for (i=0;i<=255;i++) setpal(i,i/4,i/4,i/4);

while (!kbhit()) {
 i+=1;
 if (i>=255) i=1;
 b+=2;
 if (b>=255) b=1;
 lx=160+x_arr[i][100];
 ly=100+y_arr[i][50];
 map_lq(lx,ly,dst); 

  for (j=0;j<=255;j++) {
    ff=!ff;
     if (ff) k=b+p[j].v;
     if (!ff) k=i+p[j].v;

     xp=lx+x_arr[k][p[j].r];
     yp=ly+y_arr[k][p[j].r];  
      if (xp>=319) xp=319;
      if (xp<=1) xp=1;
      if (yp>=199) yp=199;
      if (yp<=1) yp=1;
    line(lx+7,ly+7,xp,yp,254,texture,dst);
  }
 blur(dst);
 flip(dst,mlfb);
 clearvs(dst);
} 
mode(0x3);
}

void init_light(void) { 
 for (j=0;j<=439;j++) {
   for (i=0;i<=512;i++) {
     x_arr[i][j]=cos(i*pi/128)*j;
     y_arr[i][j]=sin(i*pi/128)*j;
   }
 }
 loadraw("example.raw",texture);
 calc_light(lq);
 for (i=0;i<=256;i++) {
   p[i].r=rand()%338+100;
   p[i].v=i;
 }
 for (i=0;i<=256;i++) p[i].r+=80;
}

void line(int x1,int y1,int x2,int y2,int color,char *texture,char *dest) {
  int gdelta,hdelta,gstep,hstep,cyc;
  int temp;
  int d=0;
  int t=0;
  int offen=0;
  int g=0;

  gdelta=x2-x1;
  hdelta=y2-y1;

  if (gdelta<0) {
    gdelta=-gdelta;
    gstep=-1;
  }
  else gstep=1;
  if (hdelta<0) {
    hdelta=-hdelta;
    hstep=-1;
  }
  else hstep=1;
  if (gdelta>hdelta) {
     cyc=gdelta >> 1;
     while (x1!=x2) {
       if ((x1>=0) && (x1<320) && (y1>=1) && (y1<199)) { 
         if (!(texture[y1*320+x1]>=1) && (g>=6) && (g<=7)) offen=1;
         if (!(texture[y1*320+x1]<=1) && (g>=6) && (g<=7)) offen=0; 
       g+=1;

       if (!offen) {
         if (!(texture[y1*320+x1]>=1) && (!d))  {
           d=1;
          pixel(dest,x1,y1,color);
        }
       if ((d) && (!(texture[y1*320+x1]>=1))) {
         pixel(dest,x1,y1,color);
       }
       if ((d) && (!(texture[y1*320+x1]<=1))) {
         t=color;
         t-=170;
         if (t<=1) t=1;
         pixel(dest,x1,y1,t);
       }
     }
    if (offen) {
      if (!(texture[y1*320+x1]>=1) && (!d))  {
         d=1;
         pixel(dest,x1,y1,color);
       }
      if ((d) && (!(texture[y1*320+x1]>=1))) {
        pixel(dest,x1,y1,color);
      }
      if ((d) && (!(texture[y1*320+x1]<=1))) {
        t=color;
        t-=80;
        if (t<=1) t=1;
        pixel(dest,x1,y1,t);
      }
    }
  }
     x1+=gstep;
     cyc+=hdelta;
     if (cyc>gdelta) {
       y1+=hstep;
       cyc-=gdelta;
      }
    }
  }
  else {
    cyc=hdelta >> 1;
    temp=gdelta;
    gdelta=hdelta;
    hdelta=temp;
    temp=gstep;
    gstep=hstep;
    hstep=temp;
    while (y1!=y2) {
    if ((x1>=0) && (x1<320) && (y1>=1) && (y1<199)) {
      if (!(texture[y1*320+x1]>=1) && (g>=6) && (g<=7)) offen=1;
      if (!(texture[y1*320+x1]<=1) && (g>=6) && (g<=7)) offen=0; 
      g+=1;
      if (!offen) {
        if (!(texture[y1*320+x1]>=1) && (!d))  {
          d=1;
          pixel(dest,x1,y1,color);
        }
        if ((d) && (!(texture[y1*320+x1]>=1))) {
          pixel(dest,x1,y1,color);
        }
        if ((d) && (!(texture[y1*320+x1]<=1))) {
          t=color;
          t-=170;
          if (t<=1) t=1;
          pixel(dest,x1,y1,t);
        }
      }
      if (offen) {
        if (!(texture[y1*320+x1]>=1) && (!d))  {
           d=1;
           pixel(dest,x1,y1,color);
         }
        if ((d) && (!(texture[y1*320+x1]>=1))) {
          pixel(dest,x1,y1,color);
        }
        if ((d) && (!(texture[y1*320+x1]<=1))) {
          t=color;
          t-=80;
          if (t<=1) t=1;
          pixel(dest,x1,y1,t);
         }
       }
     }
      y1+=gstep;
      cyc+=hdelta;
      if (cyc>gdelta) {
        x1+=hstep;
        cyc-=gdelta;
      }
    }
  }
}

void calc_light(char *dest) {
int i,y=0;
int xx,yy=0;
for (y=0;y<=7;y++) {
  for (i=0;i<=255;i++) {
     xx=x_arr[i][y];
     yy=y_arr[i][y];
     dest[(yy+7)*15+(xx+7)]=255;
    }
  }
}

void map_lq(int xx,int yy,char *dest) {
int x,y=0;
for (y=0;y<=15;y++) {
  for (x=0;x<=15;x++) {
     if ((lq[y*15+x]>=1) && ((!texture[(y+yy)*320+(x+xx)])))
     dest[(y+yy)*320+(x+xx)]=lq[y*15+x];
    }
  }
}
