// -----------------------------------------------------------------------------
//
//      Przykladowy program dolaczony do artykulu
//      ``Macierze i przeksztalcenia'' zamieszczonego w Measure#8.
//
//      Autor: Maciej Sinilo a.k.a. Yarpen/Substance/Rise.
//      Mozecie wykorzystywac ta biblioteke, gdzie chcecie, ale nie
//      obrazilbym sie, gdybyscie zamiescili jakies malutkie greetingsy.
//
//      Testowane pod WATCOMem 10.0a.
//
// -----------------------------------------------------------------------------

#include <iomanip.h>
#include <iostream.h>
#include <stdlib.h>

#include "vl_main.h"
#include "vl_mat4.h"
#include "vl_mixed.h"
#include "vl_quat.h"
#include "vl_vec2.h"
#include "vl_vec3.h"
#include "vl_vec4.h"
#include "vl_vp.h"

#define FRAND(x)        (((float)rand() / (float)RAND_MAX)*(x))    // FLOAT

// -----------------------------------------------------------------------------

int CheckPoints(const vlPnt3 *pInput, const vlPnt4 *pOutput, int cnt)
{
        vlPnt3 tmp;
        for (int i = 0; i < cnt; ++i, ++pInput, ++pOutput)
        {
                tmp.FromArray(pOutput->GetReadPtr());
                if (!AlmostEqual((*pInput), tmp, VL_EPSILON))
                        return i;
        }
        return -1;
}

// -----------------------------------------------------------------------------

void GeneratePoints(vlPnt3 *pPoints, int cnt)
{
        for (int i = cnt; i; --i, ++pPoints)
        {
                pPoints->rX() = FRAND(5000.0);
                pPoints->rY() = FRAND(5000.0);
                pPoints->rZ() = FRAND(5000.0);
        }
}



// -----------------------------------------------------------------------------

int main()
{
        // Na poczatek troche sie poprzemieszczamy pomiedzy roznymi
        // ukladami.
        vlPnt3 punkt(6, 20, 100);        // Nasz punkt wyjsciowy okreslony
                                        // w ukl. lokalnym
        vlMatrix4 rodzic;               // Macierz rodzica
        vlMatrix4 kamera;               // Macierz kamery
        vlMatrix4 lokalny;              // Macierz orientacji w ukl. lokalnym

        // Rotujemy punkt w jego wlasnym ukladzie o 60 stopni wokol 'Z'
        lokalny.MakeRotation(vlVec3(0,0,1), 60*VL_PI/180);
        // Pozycja UKLADU lokalnego w ukladzie rodzica
        lokalny.PreTranslation(vlVec3(0,0,-50));

        punkt = punkt * lokalny;

        // Rodzic obraca sie dokladnie w druga strone
        rodzic.MakeRotation(vlVec3(0,0,1), -(60*VL_PI/180));
        rodzic.PreTranslation(vlVec3(0,0,200));

        // Mamy nasz punkt w ukladzie rodzica, wyswietlmy go, powinien
        // wynosic (6,20,150) -> tym razem juz w ukladzie swiata
        punkt = punkt * rodzic;
        cout << "W ukladzie rodzica (swiata): " << punkt << endl;

        // Kamera znajduje sie nieco przed ekranem
        kamera.PreTranslation(vlVec3(0, 0, -100));

        // Przejscie do ukladu kamery
        punkt *= kamera;
        cout << "W ukladzie kamery (metoda #1): " << punkt << endl;

        // A teraz zrobmy dokladnie to samo, ale na jednym tylko
        // przeksztalceniu macierzowym
        punkt.Set(6, 20, 100);   // ustawienia wyjsciowe
        vlMatrix4 lokalnyDoKamery = lokalny * rodzic * kamera;
        punkt *= lokalnyDoKamery;
        cout << "W ukladzie kamery (metoda #2): " << punkt << endl;

        // Na koniec projekcja: 60-stopniowy FOV
        // Zakladamy rozdzielczosc 320*200
        vlPnt4 hPunkt = vlPnt4(punkt) * vlPerspective(1.0, 5000.0,
                                        60.0 * VL_PI / 180.0, 320/200);
        hPunkt.Homogenize();

        hPunkt[0] = 160.0 + hPunkt[0] * 160.0;
        hPunkt[1] = 100.0 - hPunkt[1] * 100.0;
        cout << "W ukladzie ekranu: " << vlPnt2(hPunkt[0], hPunkt[1]) << endl;

        // ------------------------------------------------
        //  Przeksztalcanie wiekszej ilosci punktow
        // ------------------------------------------------

        vlPnt3 *pInput = new vlPnt3[5000];
        vlPnt4 *pOutput = new vlPnt4[5000];
        vlMatrix4 transform(VL_MATRIX_INIT_IDENTITY);
        vlVectorProcessor *pVP = new vlVectorProcessor();

        if ((!pInput) || (!pOutput) || (!pVP))
        {
                cout << "Za malo pamieci!" << endl;
                return 1;
        }
        GeneratePoints(pInput, 5000);

        // Rotacja o 360 stopni --> powinno wrocic do stanu wyjsciowego
        transform.MakeRotation(vlVec3(1,1,1), VL_TWOPI);

        pVP->Transform_P34(transform, pInput, pOutput, 5000);

        int errNo = CheckPoints(pInput, pOutput, 5000);
        if (errNo < 0)
                cout << "Wszystkie punkty poprawne." << endl;
        else
        {
                cout << "Punkt #" << errNo << " bledny. " << vlPnt4(pInput[errNo])
                     << " != " << pOutput[errNo] << endl;
                cout << "Mozliwe inne bledy, program przerwany." << endl;
        }

        delete pVP;
        delete[] pInput;
        delete[] pOutput;

        return 0;
}