// -----------------------------------------------------------------------------
//
//      Mimic Engine
//      Copyright (C) 1997-1999 by Maciej Sinilo
//
//      MODULE  : VL_VP.CPP - Vector Processor class, basic interface and
//                default implementation (slow but still better than nothing)
//      CREATED : 24-03-99
//
// -----------------------------------------------------------------------------

#include "vl_mat4.h"
#include "vl_mixed.h"
#include "vl_vec3.h"
#include "vl_vec4.h"
#include "vl_vp.h"



// --- CLASS BODY --------------------------------------------------------------

void vlVectorProcessor::Transform_V33(const vlMatrix4& transform, const
        vlVec3* pInput, vlVec3* pOutput, int count) const
{
        for (int i = count; i; --i, ++pInput, ++pOutput)
        {
                (*pOutput) = (*pInput) * transform;
        }
}

void vlVectorProcessor::Transform_P33(const vlMatrix4& transform, const
        vlPnt3* pInput, vlPnt3* pOutput, int count) const
{
        for (int i = count; i; --i, ++pInput, ++pOutput)
        {
                (*pOutput) = (*pInput) * transform;
        }
}

void vlVectorProcessor::Transform_P44(const vlMatrix4& transform, const
        vlPnt4* pInput, vlPnt4* pOutput, int count) const
{
        for (int i = count; i; --i, ++pInput, ++pOutput)
        {
                (*pOutput) = (*pInput) * transform;
        }
}

void vlVectorProcessor::Transform_P34(const vlMatrix4& transform, const
        vlPnt3* pInput, vlPnt4* pOutput, int count) const
{
        vlPnt4 tmp;

        for (int i = count; i; --i, ++pInput, ++pOutput)
        {
                tmp = (*pInput);
                (*pOutput) = tmp * transform;
        }
}


// -----------------------------------------------------------------------------
//      VL_VP.CPP - MODULE END
// -----------------------------------------------------------------------------
