program PCXCDP4; { PC-X CD-ROM Player }

uses CRT, PCXCDU4;

var
   AudioCD  : TAudioDisk;
   pTrack   : Byte;
   Track    : TAudioTrack;
   TrackEnd : TRedBook;
   TrackLen : Longint;
   Code     : Integer;

begin
   WriteLn('PC-X CD-ROM Player - The "command line" version - PC-X magazine, Dec 1994');

   if ParamCount<>1 then
   begin
      WriteLn('Usage: PCXCDP <Track Number>');
      WriteLn;
      Halt(1);
   end;

   Val(ParamStr(1),pTrack,Code);
   if Code<>0 then
   begin
      WriteLn('Error: Illegal track number specified!');
      WriteLn;
      Halt(2);
   end;

   CDR_AudioDiskInfo(AudioCD);
   if (CDR_Status SHR 15)=1 then
   begin
      WriteLn('Error: Drive not ready!');
      WriteLn;
      Halt(3);
   end;

   with AudioCD do
   begin
      if (pTrack<LoTrack) OR (pTrack>HiTrack) then
      begin
         WriteLn('Error: Track number out of range!');
         WriteLn;
         Halt(4);
      end;
   end;

   if pTrack<AudioCD.HiTrack then
   begin
      CDR_AudioTrackInfo(pTrack+1, Track);
      TrackEnd:=Track.TrackStart;
   end
   else
      TrackEnd:=AudioCD.LeadOut;

   CDR_AudioTrackInfo(pTrack, Track);
   if (Track.TrackInfo SHR 6)=1 then
   begin
      WriteLn('Error: The specified track is a data track!');
      WriteLn;
      Halt(5);
   end;
   Track.TrackEnd:=TrackEnd;

   WriteLn('Playing track ',pTrack,'...');
   WriteLn;
   with Track do
   begin
      TrackLen:=RB2HSG(TrackEnd)-RB2HSG(TrackStart);
      CDR_PlayAudio(TrackStart.RBL,TrackLen);
   end;
end.
