DEF n =... :        -- number of writers
DEF m =... :        -- number of readers
DEF c =... :        -- number of couriers
DEF nxc = n*c :     -- number of writer-courier channels
DEF cxm = c*m :     -- number of courier-reader channels
CHAN ptoc[nxc], ctoc[cxm], ptos[n], stoc[c], ctos[n],
     stocon[m], ptosreq[n], stocreq[c],ctosreq[c], stoconreq[m] :
PAR

  -- scheduler 1

  WHILE TRUE
   VAR x, i, j :
   SEQ
    ALT k=[0 FOR n]
       ptosreq[k]?ANY        -- accept producer req
         i:=k
    ALT k=[0 FOR c]
       stocreq[k]?ANY        -- accept courier req
         j:=k
    -- calc x from i and j
    ptos[i]!x
    stoc[j]!x

  -- scheduler 2

  WHILE TRUE
   VAR x, i, j :
   SEQ
    ALT k=[0 FOR c]
       ctosreq[k]?ANY -- accept courier req
          i:=k
    ALT k=[0 FOR m]
       stoconreq[k]?ANY -- accept consumer req
          j:=k
    -- calc x from i and j
    ctos[i]!x
    stocon[j]!x

  -- producers

  PAR i=[0 FOR n]
    WHILE TRUE
          VAR x :
          SEQ
             ptosreq[i]!ANY -- request connection
             ptos[i]?x
             -- use ptoc[x]
                .
                .
  -- consumers

  PAR i=[0 FOR m]
     WHILE TRUE
        VAR x :
        SEQ
           stoconreq[i]!ANY -- request connection
           stocon[i]?x
           -- use ctoc[x]
                .
                .

  -- couriers
  PAR i=[0 FOR C]
    WHILE TRUE
       VAR x,y,z :
       SEQ
         stocreq[i]!ANY         -- req sched 1
         stoc[i]?x              -- accept channel id
         ptoc[x]?z              -- copy data
         ctosreq[i]!ANY         -- req sched 2
         ctos[i]?y              -- accept channel id
         ctoc[y]!z              -- send data
