--
-- occam 1 program for circuit of figure 7.1
-- using flush tokens for timing simulation 
--
DEF Endbuffer = -3 :
DEF flushtoken =... :        --  unique data value for token
DEF maxtime = ... :          --  maximum simulation time
DEF andgate = 1,             --  type value for and
    orgate = 2   :           --  type value for or
DEF andgatetime = ...,       --  transit time for and
    orgatetime =...  :       --  transit time for or
DEF size =...                --  maximum no. of gate inputs
CHAN Screen AT 1 :
CHAN Keyboard AT 2 :
--
-- process definitions
--
--
-- process to buffer two processes
PROC wire(CHAN in,out)=
  WHILE TRUE
     VAR buffer :
     SEQ
       in?buffer
       out!buffer
--
-- process to simulate n input 1 output gates
--
PROC n.input.1.out.gate(VALUE type,n,CHAN in[],out)=
   VAR ltemp,lvalue[size] :
   SEQ
      ltemp := 0
      SEQ i =[0 FOR n]
          lvalue[i] : = 0
      WHILE TRUE
          VAR val[size],time[size],outsent,flush,more :
          SEQ
            SEQ i=[0 FOR n]
               in[i)?val[i);time[i] -- values from inputs
            outsent : = FALSE
            flush := 0        -- no of flush tokens recd
            more := TRUE
            WHILE more
               VAR ctime,temp :
               SEQ
                  ctime := maxtime    -- init maxtime
                  SEQ j=[0 FOR n]
                     IF
                        val[j]=flushtoken
                           SKIP
                        time[j]<ctime
                           SEQ
                               ctime := time[j]
                               i:=j
                        TRUE
                           SKIP
                  lvalue[i] := val[i]
                  IF
                     type=andgate
                        SEQ
                           temp := 1
                           SEQ j=[0 FOR n]
                              temp := temp/\lvalue[j]
                           ctime := ctime + andgatetime
                     type=orgate
                        SEQ
                           temp := 0
                           SEQ j=[0 FOR n]
                              temp := temp\/lvalue[j]
                           ctime := ctime + orgatetime
                  TRUE
                     SKIP
               IF
                  temp <> ltemp          -- output changed
                     SEQ
                        outsent := TRUE
                        ltemp := temp
                        out!temp
                        out!ctime
                  TRUE
                     SKIP
               in[i]?val[i]
               IF
                  val[i]=flushtoken
                      flush := flush + 1
                  TRUE
                      in[i]?time[i]
               IF
                  flush=n
                      SEQ
                         IF
                            outsent
                                SKIP
                            TRUE
                                out!temp;ctime
                         out!flushtoken
                         more := FALSE
                  TRUE
                      SKIP  :
--
-- output process
--
PROC outputmodule(CHAN in)=
   WHILE TRUE
      VAR out,time,more :
      SEQ
         more := TRUE
         in?out;time
         WHILE more
            SEQ
               Screen!(out+'0')
               -- convert time to chars and
               -- output to screen
               Screen!#A
               Screen!#D
               Screen!Endbuffer
               in?out
               IF
                   out <> flushtoken
                      in?time
                   TRUE
                      more := FALSE   :
--
-- process to translate from single input to
-- multiple output including flushtokens
--
PROC inputmodule(VALUE ninp,CHAN intime,inchar,out[])=
   VAR outv[size]  :
   SEQ
      SEQ i=[0 FOR ninp]
         outv[i] := 0
      WHILE TRUE
         VAR time :
         SEQ
            intime?time
            SEQ i=[0 FOR ninp]
               inchar?outv[i]
               out[i]!outv[i]
               out[i]!flushtoken :
--
-- process to input a char from terminal
--
PROC input(CHAN outchar)=
   WHILE TRUE
      VAR character :
      SEQ
         Keyboard?character
         character := character - '0'
         outchar!character   :
--
-- clocking process
--
PROC tick(CHAN clock)=
   VAR time :
   SEQ
      time := 0
      WHILE TRUE
         clock!time
         time := time + 1 :
--
-- channels as in figure
--
CHAN a,b[3],d[2],e,clock
--
-- process instantiations
--
-- do processes concurrently
--
PAR
   input (a)
   inputmodule(3,clock,a,b)
   n.input.1.out.gate(andgate,2,b,d[0])
   n.input.1.out.gate(orgate,2,d,e)
   wire(b[2],d[1])
   outputmodule(e)
   tick(clock)
