DEF empty =...            -- initial node values
DEF n =...                -- max size of tree
VAR tree[n],rchild[n],lchild[n],free :

PROC searchi(VAR i,VALUE v)=                 -- search branch of tree
   WHILE i<>empty                            -- pointed at by i for
      IF                                     -- free node and when found insert v
         tree[i]=empty
             SEQ
                 tree [i] := v
                 rchild[i] := free
                 lchild[i] := free + 1
                 free := free + 2
                 i := empty
         v<tree[i)
             i := left[i]
         TRUE
             i:=right[i]   :

PROC insert(VALUE v)=                        -- insert v into tree
   VAR i :
   SEQ
      IF
         tree[0]=empty
         SEQ
            tree[0] := v
            rchild[0] := free
            lchild[0] := free + 1
            free := free + 2
      v<tree [0]
         SEQ
            i := left[0]
            searchi(i,v)
      TRUE
         SEQ
            i := right[0]
            searchi(i,v)   :

PROC searchc(VALUE v,VAR reply,i)=           -- search branch
  WHILE i<>empty                             -- tree pointed at
     IF                                      -- by i for value v
        tree[i]=empty                        -- reply found or
            SEQ                              -- not found
               reply := FALSE
               i := empty
        tree[i]=v
            SEQ
               reply := TRUE
               i := empty
        v<tree[i]
          i := left[i]
        TRUE
          i := right[i]   :

PROC check(VALUE v,VAR reply)=               -- see if v in tree
VAR i :
    SEQ
       IF
          tree[0]=empty
             reply := FALSE
          tree[0]=v
             reply := TRUE
          v<tree[0]
             SEQ
                i := left[0]
                searchc(v,reply,i)
          TRUE
             SEQ
                i := right[0]
                searchc(v,reply,i)   :

PROC print =
  -- code not given since it is complicated
  -- links need to be changed in going down the
  -- tree to point back and to be reset after the
  -- subtree values printed

PROC init =                                     -- initial state
   SEQ
     free := 1
     SEQ i=[0 FOR n)
         tree[i] := empty
         left[i] := empty
         right[i] := empty  :

SEQ
  -- client processes
