//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-09
// Revision (please increase number) : A1
// (Only increase A if it's not backwards complient.)
// _______________________________________________________________________________________
//
// Description:
//   
//  This is the main file of Shine.
//  It is the .shn parser and it also includes functionality to draw the articles.
//

#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>

#include "shine.h"
#include "sbase.h"
#include "sfont.h"
#include "sgdi.h"
#include "splugin.h"
#include "sversion.h"

//________________________________________________________________________________________________________________________________________________________________________

// Default:
#define cDefaultFont "Arial"
const cDefaultFontSize = 16;
float fontZoom = 1.0;

static bool ignoreTags = false;        // Skip <tags>
static int  linkMostRight = 0;         // xpos
static int   mainMusic = 0;            // Has the music already been loaded?

//________________________________________________________________________________________________________________________________________________________________________

int stringCompare( char* str1, char* str2, int len )
{
	for( int i=0; i<len; i++ )
	{
		if( str1[i] > str2[i] )
			return 1;

		if( str1[i] < str2[i] )
			return -1;
	}
	return 0;
}

//________________________________________________________________________________________________________________________________________________________________________

// Show small dots when loading an article :
float loadValue = 0;
bool showLoad = 1;

void loading( int step )
{
	const size = 4;
	
	int x = sgdiGetXRes();
	if( 0 == x )
		return;

	int row = (step*size) / sgdiGetXRes();
	
	int x1 = (step*size)%sgdiGetXRes();
	int y1 = row*size;
	int x2 = x1 + size-1;
	int y2 = y1 + size-1;

	sgdiBox( x1, y1, x2, y2, 0 );
}

void shineLoadReset()
{
	loadValue = 0;
}

void shineLoad()
{
	if( 1 == showLoad )
		loading( (int)(loadValue+=0.05f) );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::LoadShineData()
{
	// Load default shine gfx, scrollbar etc..

	shineLibrary* poDataLib = new shineLibrary();
	poDataLib->openArchive( "data" );

	poDataLib->seekFile( "loadplug.pcx" );
	poDataLib->readPCX( poDataLib->getFile(), ImageLoadingPlugin );

	poDataLib->seekFile( "bar.pcx" );
	poDataLib->readPCX( poDataLib->getFile(), ImageScrollBar );
	poDataLib->seekFile( "bartop.pcx" );
	poDataLib->readPCX( poDataLib->getFile(), ImageScrollBarTop );
	poDataLib->seekFile( "barbot.pcx" );
	poDataLib->readPCX( poDataLib->getFile(), ImageScrollBarBot );
	poDataLib->seekFile( "arrowup.pcx" );
	poDataLib->readPCX( poDataLib->getFile(), ImageScrollArrowUp );
	poDataLib->seekFile( "arrowdown.pcx" );
	poDataLib->readPCX( poDataLib->getFile(), ImageScrollArrowDown );
	poDataLib->seekFile( "arrowupp.pcx" );
	poDataLib->readPCX( poDataLib->getFile(), ImageScrollArrowUpPressed );
	poDataLib->seekFile( "arrowdownp.pcx" );
	poDataLib->readPCX( poDataLib->getFile(), ImageScrollArrowDownPressed );

	poDataLib->closeArchive();
	delete poDataLib;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::initPlugin( char* filename, char* param, char* link, int xpos, int ypos, int width, int height, int interval )
{
	// Insert a plugin into the linked list and give the plugin information.
	// Tell the scheduler that we have a new plugin..

	if( NULL == filename[0] )
	{
		return;
	}

	shinePlugin* Plugin = new shinePlugin();
	Plugin->width = width;
	Plugin->height = height;
	Plugin->interval = interval;
	Plugin->ID = IDCounter++;

	Plugin->Lib = LoadLibrary( filename);

    if( NULL == Plugin->Lib ) 
	{
		shineLog( SHNROW, cHigh, "plugin: %s not found", filename );
		delete Plugin;
		return;
	}

	Plugin->open   = (FUNCPTR2)GetProcAddress(Plugin->Lib,  "open");
	Plugin->update = (FUNCPTR3)GetProcAddress(Plugin->Lib,  "update");
	Plugin->close  = (FUNCPTR)GetProcAddress(Plugin->Lib,   "close");
	Plugin->event  = (FUNCPTR4)GetProcAddress(Plugin->Lib,  "event");

    if( NULL == Plugin->update )
	{
		shineLog( SHNROW, cHigh, "plugin: %s is missing the update() function", filename );
		delete Plugin;
		return;
	}

    if( NULL == Plugin->close )
	{
		shineLog( SHNROW, cHigh, "plugin: %s is missing the close() function", filename );
		delete Plugin;
		return;
	}

    if( NULL == Plugin->open )
	{
		shineLog( SHNROW, cHigh, "plugin: %s is missing the open() function", filename );
		delete Plugin;
		return;
	}

    if( NULL == Plugin->event )
	{
		shineLog( SHNROW, cHigh, "plugin: %s is missing the event() function", filename );
		delete Plugin;
		return;
	}

	Plugin->Image->setXSize( width );
	Plugin->Image->setYSize( height );
	Plugin->Image->setXRes( width );
	Plugin->Image->setYRes( height );
	Plugin->Image->setXPos( xpos );
	Plugin->Image->setYPos( ypos );
	Plugin->Image->allocate();

	oPlugins.insert( Plugin );

	rShinePluginInformation_t rShinePluginInformation;
	rShinePluginInformation.Version = cVersion;
	rShinePluginInformation.xres = width;
	rShinePluginInformation.yres = height;
	rShinePluginInformation.refreshTime = interval;
	rShinePluginInformation.backColor   = ((currentStatus.backColor&0xff)<<16)+(currentStatus.backColor&0xff00)+((currentStatus.backColor&0xff0000)>>16);
	rShinePluginInformation.color       = currentStatus.textColor;
	rShinePluginInformation.ID          = Plugin->ID;
	strcpy( rShinePluginInformation.libraryName, poLibrary->getLibraryName() );

	memcpy(rShinePluginInformation.parameter, param, cMaxPluginParameterSize );
	memcpy(rShinePluginInformation.link,      link,  cMaxPluginParameterSize );
	rShinePluginInformation.renderBuffer = Plugin->Image->getPixels();

	memset( rShinePluginInformation.renderBuffer, 0, width*height*4 );

	// Fill plugin background with image..
	int xa = 50;
	int ya = 50;

	if( xa > width )
		xa = width;

	if( ya > height )
		ya = height;

	for( int i=0; i<ya; i++ )
	{
		for( int j=0; j<xa; j++ )
		{
			rShinePluginInformation.renderBuffer[j+i*width] = ImageLoadingPlugin[j+i*50];
		}
	}


	// Close down the article file, to allow the plugin to load data from it. Then open it again.
	if( NULL != poLibrary )
	{
		poLibrary->closeArchive();
	}

	Plugin->open( rShinePluginInformation );

	if( NULL != poLibrary )
	{
		poLibrary->openArchive( rShinePluginInformation.libraryName );
	}
	
	// Add the plugin to the scheduler
	shineTimerEvent* Event = new shineTimerEvent();
	Event->poPlugin = Plugin;
	Event->interval = interval;
	oScheduler.addTimer( Event );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::addArea( int x1, int y1, int x2, int y2, bool inverted )
{
	// Add an area to the linked-list
	shineArea* Area = new shineArea();
	Area->x1 = x1;
	Area->y1 = y1;
	Area->x2 = x2;
	Area->y2 = y2;
	Area->inverted = inverted;
	oAreas.insert( Area );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::load( char* filename )
{
	// Load file from disk
	ignoreTags = false;

	shineLoadReset();
	FILE* f;
	shineLog( SHNROW, cMsg, "Loading article %s", filename );

	if( NULL != poLibrary )
	{
		if( false == poLibrary->isOpened )
		{
			shineLog( SHNROW, cFatErr, "shineArticle::load() Archive not opened" );
		}
		else
		{
			poLibrary->seekFile( filename );
			f = poLibrary->getFile();

			if( NULL != f )
			{
				dataLength = poLibrary->fileSize;
				shineLog( SHNROW, cMsg, "file size: %d", dataLength );
				data = new char[dataLength];
				memset( data, 1, dataLength );
				fread( data, dataLength, 1, f );

			}
		}
	}
	else
	{

		f = fopen( filename, "rt" );

		if ( NULL == f )
		{
			shineLog( SHNROW, cFatErr, "Error! Cannot open file %s", filename );
		}
		else
		{
			fseek( f, 0, SEEK_END );
			dataLength = ftell( f );
			rewind( f );

			data = new char[dataLength];
			memset( data, 1, dataLength );

			fread( data, dataLength, 1, f );

			fclose( f );
		}
	}

	preProcess();
	formatArticle();
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::preProcess()
{
	// Get number of rows (non clipped), and copy the rows into rows[].

	int i;

	numRows = 0;

	// Get the number of rows in the article.
	for( i=0; i<dataLength; i++ )
	{
		if( '\n' == data[i] )
		{
			numRows++;
			data[i] = 0;
		}
	}

	shineLog( SHNROW, cMsg, "Processing article. Length : %d, Rows : %d", dataLength, numRows );

	rows = new char[cMaxLineWidth * numRows];

	// Copy all rows into the row list. And discard unsupported characters.. TAB, ENTER ...
	int rowPos = 0;
	int rowWidth = 0;
	char* prevRow = data;

	for( i=0; i<dataLength; i++, rowWidth++ )
	{
		if( 0 == data[i] )
		{
			shineLoad();
			strcpy ( rows + rowPos * cMaxLineWidth, prevRow );

			if ( i + 1 > dataLength )
				return;

			prevRow = &data[i+1];
			rowPos++;
			rowWidth = 0;
		}

		if( 9 == data[i] )
		{
			data[i] = ' ';
		}

		if( 13 == data[i] )
		{
			data[i] = ' ';
		}
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::formatArticle()
{
	// Parse article..
	// Remove <tags> from the text data, and add the raw text into oRows.

	shineLog( SHNROW, cMsg, "Formatting article" );

	int ypos = 0;
	static char word[cMaxLineWidth];
	static char tag[cMaxLineWidth];

	height = 0;

	currentStatus.backColor = RGB(  32,  33,  35 );
	currentStatus.textColor = RGB( 145, 175, 195 );
	currentStatus.linkColor = RGB( 255, 255, 200 );
	currentStatus.fontHeight = (int)(cDefaultFontSize*fontZoom);
	currentStatus.fontWidth = 0;
	currentStatus.fontWeight = 300;
	currentStatus.fontItalic = 0;
	currentStatus.fontUnderline = 0;
	strcpy( currentStatus.fontName, cDefaultFont );

	oPlugins.clear();
	oRows.clear();
	oAreas.clear();
	addArea( cBorders, INT_MIN, sgdiGetXRes()-cBorders-cBorders, INT_MAX, 1 );

	oFont.setFace( currentStatus.fontName, currentStatus.fontWidth, currentStatus.fontHeight, currentStatus.fontWeight, currentStatus.fontItalic, currentStatus.fontUnderline );
	
	int xPos = cBorders;
	int yPos = cBorders;

	for( int row=0; row<numRows; row++ )
	{
		shineLoad();
		int pos = 0;
		int oldpos = 0;

		//yPos += oFont.getHeight( rows+row*cMaxLineWidth );
		yPos += oFont.getHeight( "123shine" );
		xPos = oAreas.pFirst->x1;

		/*

		// INSTERT DEFINES AND SUCH..

		*/

		while ( 1 )
		{
			int reallyOldPos = oldpos;

			int pos2 = oFont.find( rows+row*cMaxLineWidth+oldpos, ' ' );
			if( -1 == pos2 )
			{
				break;
			}
			pos += pos2;

			if ( 0 < pos-oldpos )
			{

				memcpy( word, rows+row*cMaxLineWidth+oldpos, pos-oldpos );
				word[pos-oldpos] = 0;
				oldpos = pos;

				shineLog( SHNROW, cSuperDebug, "Found word : \"%s\"", word );

				int rc = oFont.find2( word, '<' );

				// Get the most right pos of a link. If the row is breaking somewhere, the area should cover everything
				if( linkMostRight < xPos )
					linkMostRight = xPos;

				if( rc != -1 )
				{
					// There is a tag. 
					// Increase xPos for all spaces before '<'
					for( int i=0; i<rc; i++ )
					{
						xPos += oFont.getWidth( " " );
					}

					int startTag = reallyOldPos+rc;
					int endTag   = oFont.find2( rows+row*cMaxLineWidth+startTag, '>' );

					if ( -1 == endTag )
						break;

					endTag+=startTag;

					memcpy( tag, rows+row*cMaxLineWidth+startTag, endTag-startTag+1 );
					tag[endTag-startTag+1] = 0;

					int rc = 0;
					rc = parse( tag, &xPos, &yPos );

					if ( 1 == rc )
					{
						memcpy( rows+row*cMaxLineWidth+startTag, rows+row*cMaxLineWidth+endTag+1, cMaxLineWidth-endTag+1 );
						pos = startTag;
						oldpos = pos;
						continue;
					}
				}

				// Clip the word to all areas
				bool clipped = false;
				int x1 = xPos;
				int y1 = yPos;
				int x2 = x1 + oFont.getWidth( word );
				int y2 = y1 + oFont.getHeight( word );

				do
				{
					shineArea* poArea = oAreas.pFirst;
					x1 = xPos;
					y1 = yPos;
					x2 = x1 + oFont.getWidth( word );
					y2 = y1 + oFont.getHeight( word );

					while( NULL != poArea )
					{
						clipped = false;

						if ( 1 == poArea->inverted )
						{
							if ( poArea->x1 > x1 && 
								( y1 > poArea->y1 && y1 < poArea->y2 ) || ( y2 > poArea->y2 && y2 < poArea->y2 ) )
							{
								x1 = poArea->x1;
								x2 = x1 + oFont.getWidth( word );
								clipped = true;
							}

							if ( poArea->x2 < x2 &&
								( y1 > poArea->y1 && y1 < poArea->y2 ) || ( y2 > poArea->y2 && y2 < poArea->y2 ) )
							{
								x1 = poArea->x1;
								x2 = x1 + oFont.getWidth( word );
								yPos += oFont.getHeight( word );
								xPos = poArea->x1;
								clipped = true;
							}
						}
						else
						{
							if ( ( ( poArea->x1 < x1 && poArea->x2 > x1 ) || ( poArea->x1 < x2 && poArea->x2 > x2 ) ) &&
								( y1 > poArea->y1 && y1 < poArea->y2 ) || ( y2 > poArea->y2 && y2 < poArea->y2 ) )
							{
								x1 = poArea->x2;
								xPos = x1;
								//poArea = oAreas.pFirst;
								//continue;
								clipped = true;
							}
						}

						poArea = poArea->pNext;
					}
				}
				while( clipped );

				xPos += oFont.getWidth( word );
				
				// Add the word to the list of words..
				shineRow* poRow = new shineRow();
				poRow->setText( word );
				poRow->xpos   = x1;
				//poRow->xpos   = xPos;
				poRow->ypos   = yPos;
				poRow->width  = oFont.getWidth( word );
				poRow->height = oFont.getHeight( word );
				poRow->Status = currentStatus;
				oRows.insert( poRow );

				int h = ( ( yPos + poRow->height ) ) + cBorders + cBorders;
				if( h > height ) 
					height = h;
			}
			if ( 0 == rows[row*cMaxLineWidth+oldpos] )
			{
				break;
			}
		}
	}

	if( height < 0 )
	{
		height = 0;
	}
	
}

//________________________________________________________________________________________________________________________________________________________________________

static int lastRow;
static int firstRow;

void shineArticle::draw( int x1, int y1, int x2, int y2, HDC hdc, int yScroll, int thisScroll )
{
	// Draw/Update the article..

	currentStatus.textColor = RGB(   0,   0,   0 );
	currentStatus.linkColor = RGB(   0,   0, 255 );
	currentStatus.fontHeight = (int)(cDefaultFontSize*fontZoom);
	currentStatus.fontWidth = 0;
	currentStatus.fontWeight = 300;
	currentStatus.fontItalic = 0;
	currentStatus.fontUnderline = 0;
	strcpy( currentStatus.fontName, cDefaultFont );

	oScheduler.setYScroll( yScroll );

	// calculate update area
	if ( 0 != thisScroll )
	{
		if ( 0 < thisScroll )
		{
			y1 = lastRow-thisScroll;
		}
		else
		{
			y2 = y1-thisScroll;
		}
		shineLog( SHNROW, cDebug, "Updating Article - Area : %d %d %d %d", x1, y1, x2, y2 );
	}
	else
	{
		shineLog( SHNROW, cMsg, "Drawing Article" );
	}


	if( NULL == backgroundImage.getPixels() )
	{
		sgdiBox( x1, y1, x2-cBorders, y2, currentStatus.backColor );
	}
	else // Draw background with an image.
	{
		//sgdiBox( x1, y1, x2-cBorders, y2, currentStatus.backColor );
		int width;
		int height;

		// Stretching background test

		if( 1 )
		{
			y1 = 0;
			y2 = sgdiGetYRes();
			width = sgdiGetXRes();
			height = sgdiGetYRes();

			BITMAPINFO* bi = backgroundImage.getBitmapInfo();
			int backgroundWidth = bi->bmiHeader.biWidth;
			int backgroundHeight = bi->bmiHeader.biHeight;

			bi->bmiHeader.biWidth = width;
			bi->bmiHeader.biHeight = height;

			SetDIBitsToDevice( sgdiGetDc(), 0,0, width-cBorders, height, 0,0, 0, height, sgdiGetBuffer(), bi, DIB_RGB_COLORS );

			bi->bmiHeader.biWidth = backgroundWidth;
			bi->bmiHeader.biHeight = backgroundHeight;

			//StretchDIBits( sgdiGetDc(), 0, 0, sgdiGetXRes(), sgdiGetYRes(), 0, 0, width, height, backgroundImage.getPixels(), backgroundImage.getBitmapInfo(), DIB_RGB_COLORS, SRCCOPY);
		}

		// TILING BACKGROUND BETA TEST..__________________________________________________________________________________________________
/*
		if( 0 == yScroll ) // Update everything
		{
			MessageBeep( 0 );
			int numx = 1 + ( sgdiGetXRes() / backgroundImage.getXRes() );
			int numy = 1 + ( sgdiGetYRes() / backgroundImage.getYRes() );

			// update the whole screen with text later on aswell.
			width = sgdiGetXRes();
			height = sgdiGetYRes();

			shineLog( SHNROW, cDebug, "Updating Background" );

			for( int y=0; y<numy; y++ )
			{
				for( int x=0; x<numx; x++ )
				{
					//StretchDIBits( sgdiGetDc(), x*backgroundImage.getXRes(), y*backgroundImage.getYRes(), width, height, 0, 0, width, height, backgroundImage.getPixels(), backgroundImage.getBitmapInfo(), DIB_RGB_COLORS, SRCCOPY);
					StretchDIBits( sgdiGetDc(), x*backgroundImage.getXRes(), y*backgroundImage.getYRes(), backgroundImage.getXRes(), backgroundImage.getYRes(), 0, 0, backgroundImage.getXRes(), backgroundImage.getYRes(), backgroundImage.getPixels(), backgroundImage.getBitmapInfo(), DIB_RGB_COLORS, SRCCOPY);
				}
			}

		}
		else
		{
			width = x2-x1;
			height = y2-y1;

			pBackgroundArea = new long[width*height];
			BITMAPINFO* bi = backgroundImage.getBitmapInfo();

			int backgroundWidth = bi->bmiHeader.biWidth;
			int backgroundHeight = bi->bmiHeader.biHeight;

			bi->bmiHeader.biWidth = width;
			bi->bmiHeader.biHeight = height;

			shineLog( SHNROW, cDebug, "Update Area = %d %d", width, height );

			int yPicOffset = ((sgdiGetYRes()+yScroll)%backgroundImage.getYRes());

			shineLog( SHNROW, cDebug, "--------------------------------------------------> (%d  %d) %d", sgdiGetYRes(), backgroundImage.getYRes(), yPicOffset );

			// Generate background pic
			for( int ay=0; ay<height; ay+=backgroundImage.getYRes() )
			{
				for( int ax=0; ax<width; ax+=backgroundImage.getXRes() )
				{
					int w = backgroundImage.getXRes();
					int h = backgroundImage.getYRes();

					if( w+ax > (width-1) )
					{
						w = width - ax-1;
					}

					if( h+ay > (height-1) )
					{
						h = height - ay-1;
					}

					for( int y=0, y2=h; y<h; y++, y2-- )
					{
						for( int x=0; x<w; x++ )
						{
							long knullhomo = backgroundImage.getPixels()[x+((y+yPicOffset)%backgroundImage.getYRes())*backgroundImage.getXRes()];
							pBackgroundArea[x+ax+(y2+ay)*width] = knullhomo;
						}
					}
				}
			}
			if( thisScroll > 0 ) // scroll up
			{
				//yPicOffset = ( sgdiGetYRes() + yScroll ) % backgroundImage.getYRes();
				SetDIBitsToDevice( sgdiGetDc(), 0,sgdiGetYRes()-thisScroll, width, height, 0,0, 0, height, pBackgroundArea, bi, DIB_RGB_COLORS );
 			}
			else // scroll down
			{
				//yPicOffset = ((sgdiGetYRes()%backgroundImage.getYRes())+yScroll)%backgroundImage.getYRes();
				SetDIBitsToDevice( sgdiGetDc(), 0,0, width, height, 0,0, 0, height, pBackgroundArea, bi, DIB_RGB_COLORS );
			}

			bi->bmiHeader.biWidth = backgroundWidth;
			bi->bmiHeader.biHeight = backgroundHeight;
			delete [] pBackgroundArea;
		}
*/
	}
	// END background _____________________________________________________________________________________________________________________________________
	
	int ypos = 0;

	// DRAW IMAGES
	shineImage* poImage = oImages.pFirst;
	while ( NULL != poImage )
	{
		poImage->blit( poImage->getXPos(), poImage->getYPos()-yScroll, sgdiGetDc() );
		poImage = poImage->pNext;
	}

	// DRAW PLUGINS
	shinePlugin* poPlugin = oPlugins.pFirst;
	while ( NULL != poPlugin )
	{
		poImage = poPlugin->Image;
		poImage->blit( poImage->getXPos(), poImage->getYPos()-yScroll, sgdiGetDc() );
		shineLog( SHNROW, cDebug, "Drawing plugin " );

		poPlugin = poPlugin->pNext;
	}

	// DRAW TEXT
	shineRow* poThis = oRows.pFirst;

	while ( NULL != poThis )
	{
		// + poThis->height
		if ( y1 <= poThis->ypos-yScroll+poThis->height && y2 >= poThis->ypos-yScroll )
		{
			if( memcmp( &poThis->Status, &currentStatus, sizeof( shineStatus ) ) )
			{
				currentStatus = poThis->Status;
				oFont.deInit();
				oFont.setFace( poThis->Status.fontName, poThis->Status.fontWidth, poThis->Status.fontHeight, poThis->Status.fontWeight, poThis->Status.fontItalic, poThis->Status.fontUnderline );
			}

			oFont.drawText( poThis->getText(), poThis->xpos, poThis->ypos-yScroll, poThis->Status.textColor, hdc );
			lastRow = poThis->ypos-yScroll;
		}

		poThis = poThis->pNext;
	}

	// Draw the scrollbar:
	float heightOfBar = 1.0f;
	int offset = 0;
	int pixelHeight = sgdiGetYRes();
	float maxY = (float)(sgdiGetYRes()-cScrollHeight-cScrollHeight);

	if( 0 < ( height-maxY ) )
	{
		heightOfBar = (float)sgdiGetYRes() / (float)(sgdiGetYRes() + ( height-sgdiGetYRes() ));
		pixelHeight = (int)(heightOfBar * maxY);
		offset = (int)( ( (float)yScroll / (float)( height-sgdiGetYRes() ) ) * ( maxY - pixelHeight ) );
	}

	drawScrollBar( offset+cScrollHeight, offset+pixelHeight+cScrollHeight, 0 );

	// Free memory and run deconstructors..
}

//________________________________________________________________________________________________________________________________________________________________________

int shineArticle::getScrollStart()
{
	return barStart;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineArticle::getScrollEnd()
{
	return barEnd;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::drawScrollBar( int start, int end, int pressed )
{
	if( start < cScrollHeight )
	{
		start = cScrollHeight;
	}
	
	if( end > sgdiGetYRes()-cScrollHeight-3 )
	{
		end = sgdiGetYRes()-cScrollHeight-3;
	}

	barStart = start;
	barEnd   = end;
	
	sgdiBox( sgdiGetXRes()-cScrollWidth, 0,    sgdiGetXRes(), start,			RGB( 155, 150, 145 ) );
	sgdiBox( sgdiGetXRes()-cScrollWidth, end,  sgdiGetXRes(), sgdiGetYRes(),	RGB( 155, 150, 145 ) );
	//sgdiBox( sgdiGetXRes()-cScrollWidth, start,sgdiGetXRes(), end,				RGB( 228, 228, 228 ) );

	backgroundImage.updateBitmapInfo();
	BITMAPINFO* bi = backgroundImage.getBitmapInfo();
	int backgroundWidth = bi->bmiHeader.biWidth;
	int backgroundHeight = bi->bmiHeader.biHeight;

	bi->bmiHeader.biWidth = cScrollWidth;
	bi->bmiHeader.biHeight = cScrollHeight;

	if( 1 == pressed )
	{
		SetDIBitsToDevice( sgdiGetDc(), sgdiGetXRes()-cScrollWidth, 0, cScrollWidth,cScrollHeight, 0,0, 0, cScrollHeight, ImageScrollArrowUpPressed,   bi, DIB_RGB_COLORS );
	}
	else
	{
		SetDIBitsToDevice( sgdiGetDc(), sgdiGetXRes()-cScrollWidth, 0, cScrollWidth,cScrollHeight, 0,0, 0, cScrollHeight, ImageScrollArrowUp,   bi, DIB_RGB_COLORS );
	}

	if( 2 == pressed )
	{
		SetDIBitsToDevice( sgdiGetDc(), sgdiGetXRes()-cScrollWidth,sgdiGetYRes()-cScrollHeight, cScrollWidth,cScrollHeight, 0,0, 0, cScrollHeight, ImageScrollArrowDownPressed, bi, DIB_RGB_COLORS );
	}
	else
	{
		SetDIBitsToDevice( sgdiGetDc(), sgdiGetXRes()-cScrollWidth,sgdiGetYRes()-cScrollHeight, cScrollWidth,cScrollHeight, 0,0, 0, cScrollHeight, ImageScrollArrowDown, bi, DIB_RGB_COLORS );
	}

	bi->bmiHeader.biHeight = 3;
	SetDIBitsToDevice( sgdiGetDc(), sgdiGetXRes()-cScrollWidth,start,	cScrollWidth,3, 0,0, 0, 3, ImageScrollBarTop, bi, DIB_RGB_COLORS );
	SetDIBitsToDevice( sgdiGetDc(), sgdiGetXRes()-cScrollWidth,end,		cScrollWidth,3, 0,0, 0, 3, ImageScrollBarBot, bi, DIB_RGB_COLORS );

	for( int i=start+3; i<end; i+=3 )
	{
		SetDIBitsToDevice( sgdiGetDc(), sgdiGetXRes()-cScrollWidth,i,	cScrollWidth,3, 0,0, 0, 3, ImageScrollBar, bi, DIB_RGB_COLORS );
	}

	bi->bmiHeader.biWidth = backgroundWidth;
	bi->bmiHeader.biHeight = backgroundHeight;

}

//________________________________________________________________________________________________________________________________________________________________________

int shineArticle::getHeight()
{
	return height - sgdiGetYRes();
}

//________________________________________________________________________________________________________________________________________________________________________

void shineRow::setText( char* text )
{
	strcpy( row, text );
}

//________________________________________________________________________________________________________________________________________________________________________

char* shineRow::getText()
{
	return row;
}

//________________________________________________________________________________________________________________________________________________________________________

// When there is a link. textColor is set to linkColor. prevColor is the previous textColor. When the link ends, the color is set back.
static long prevColor = 0;

bool shineArticle::parse( char* tag, int* textX, int* textY )
{
	// Check <tags>

	shineLog( SHNROW, cHDebug, "parse() Tag=%s", tag );
	bool rc = 0;

	if( 0 == stringCompare( "</pre>", tag, strlen( "</pre>" ) ) )
	{
		ignoreTags = false;
		rc = 1;
	}

	if( 0 == stringCompare( "<pre>", tag, strlen( "<pre>" ) ) )
	{
		ignoreTags = true;
		rc = 1;
	}

	if( true == ignoreTags )
	{
		return rc;
	}

	if( 0 == stringCompare( "<col", tag, strlen( "<col" ) ) )
	{
		int r,g,b;
		int pos = 0;
		pos += oFont.find2( tag+pos, '=' ) + 1;
		r = atoi( tag+pos );
		pos += oFont.find2( tag+pos, ',' ) + 1;
		g = atoi( tag+pos );
		pos += oFont.find2( tag+pos, ',' ) + 1;
		b = atoi( tag+pos );

		currentStatus.textColor = RGB( r, g, b );
		shineLog( SHNROW, cHDebug, "Color tag found (r=%d g=%d b=%d) ", r, g, b );
		rc = 1;
	}

	if( 0 == stringCompare( "<lcol", tag, strlen( "<lcol" ) ) )
	{
		int r,g,b;
		int pos = 0;
		pos += oFont.find2( tag+pos, '=' ) + 1;
		r = atoi( tag+pos );
		pos += oFont.find2( tag+pos, ',' ) + 1;
		g = atoi( tag+pos );
		pos += oFont.find2( tag+pos, ',' ) + 1;
		b = atoi( tag+pos );

		currentStatus.linkColor = RGB( r, g, b );
		shineLog( SHNROW, cHDebug, "Link Color tag found (r=%d g=%d b=%d) ", r, g, b );
		rc = 1;
	}

	if( 0 == stringCompare( "<bcol", tag, strlen( "<bcol" ) ) )
	{
		int r,g,b;
		int pos = 0;
		pos += oFont.find2( tag+pos, '=' ) + 1;
		r = atoi( tag+pos );
		pos += oFont.find2( tag+pos, ',' ) + 1;
		g = atoi( tag+pos );
		pos += oFont.find2( tag+pos, ',' ) + 1;
		b = atoi( tag+pos );

		currentStatus.backColor = RGB( r, g, b );
		shineLog( SHNROW, cHDebug, "Back Color tag found (r=%d g=%d b=%d) ", r, g, b );
		rc = 1;
	}

	if( 0 == stringCompare( "<i>", tag, strlen( "<i>" ) ) )
	{
		currentStatus.fontItalic = 1;
		rc = 1;
	}

	if( 0 == stringCompare( "</i>", tag, strlen( "</i>" ) ) )
	{
		currentStatus.fontItalic = 0;
		rc = 1;
	}

	if( 0 == stringCompare( "<b>", tag, strlen( "<b>" ) ) )
	{
		currentStatus.fontWeight = 800;
		rc = 1;
	}

	if( 0 == stringCompare( "</b>", tag, strlen( "</b>" ) ) )
	{
		currentStatus.fontWeight = 300;
		rc = 1;
	}

	if( 0 == stringCompare( "<u>", tag, strlen( "<u>" ) ) )
	{
		currentStatus.fontUnderline = 1;
		rc = 1;
	}

	if( 0 == stringCompare( "</u>", tag, strlen( "</u>" ) ) )
	{
		currentStatus.fontUnderline = 0;
		rc = 1;
	}

	if( 0 == stringCompare( "<td>", tag, strlen( "<td>" ) ) )
	{
		currentStatus.tableColCount++;
		int left  = cBorders + ((currentStatus.tableOriginalX2 / currentStatus.tableCols) * (currentStatus.tableColCount-1)); 
		int right = (currentStatus.tableOriginalX2 / currentStatus.tableCols) * currentStatus.tableColCount; 

		shineLog( SHNROW, cHDebug, "TABLE : col=%d [%d-%d] ", currentStatus.tableColCount, left, right );

		*textX = left;
		*textY = currentStatus.tableYStart;

		shineArea* Area = oAreas.pFirst;
		Area->x1 = left;
		Area->x2 = right;
		rc = 1;
	}

	if( 0 == stringCompare( "</td>", tag, strlen( "</td>" ) ) )
	{
		rc = 1;
	}

	if( 0 == stringCompare( "<table", tag, strlen( "<table" ) ) )
	{
		int pos = 0;
		pos += strlen( "<table" );
		rc = 1;
		currentStatus.tableCols = 1;
		currentStatus.tableYStart = *textY;

		pos = oFont.find( tag, "cols=" );
		if ( -1 != pos )
		{
			pos +=  strlen( "cols=" );
			currentStatus.tableCols = atoi( tag+pos );

			shineArea* Area = oAreas.pFirst;
			currentStatus.tableOriginalX1 = Area->x1;
			currentStatus.tableOriginalX2 = Area->x2;
			currentStatus.tableColCount = 0;
		}
	}

	if( 0 == stringCompare( "</table", tag, strlen( "</table" ) ) )
	{
		int pos = 0;
		pos += strlen( "</table" );
		rc = 1;

		*textY = height;

		shineArea* Area = oAreas.pFirst;
		Area->x1 = currentStatus.tableOriginalX1;
		Area->x2 = currentStatus.tableOriginalX2;
	}

	if( 0 == stringCompare( "<bgr=", tag, strlen( "<bgr=" ) ) )
	{
		int pos = 0;
		pos += strlen( "<bgr=" );

		int endPos = oFont.find( tag+pos, '>' );
		if ( -1 != endPos )
		{
			char temp[256];
			endPos += pos;

			memcpy( temp, tag+pos, endPos-pos );
			temp[endPos-pos] = 0;

			if( NULL == poLibrary )
			{
				backgroundImage.loadJPEG( temp );
			}
			else
			{
				backgroundImage.loadJPEG( poLibrary, temp );
			}

			float xslope = (float)backgroundImage.getXRes()/sgdiGetXRes();
			float yslope = (float)backgroundImage.getYRes()/sgdiGetYRes();
			float xs=0,ys=0;

			for( int y=0; y<sgdiGetYRes(); y++, ys+=yslope, xs=0 )
			{
				for( int x=0; x<sgdiGetXRes(); x++, xs+=xslope )
				{
					long hora = backgroundImage.getPixels()[(int)xs+((int)ys)*backgroundImage.getXRes()];
					sgdiGetBuffer()[x+y*sgdiGetXRes()] = hora;
				}
			}

			ScrollArticle = 0;

			rc = 1;
			shineLog( SHNROW, cDebug, "Background image=%s", temp );
		}
	}

	if( 0 == stringCompare( "<mainmusic=", tag, strlen( "<mainmusic=" ) ) )
	{
		int pos = 0;
		pos += strlen( "<mainmusic=" );

		int endPos = oFont.find( tag+pos, '>' );
		if ( -1 != endPos )
		{
			char temp[256];
			endPos += pos;

			memcpy( temp, tag+pos, endPos-pos );
			temp[endPos-pos] = 0;

			rc = 1;
			shineLog( SHNROW, cHDebug, "Loading main tune: %s", temp );
			if( 0 == mainMusic )
			{
				FollowLink( temp, 1 );
				mainMusic = 1;
			}
		}
	}

	if( 0 == stringCompare( "<autolink=", tag, strlen( "<autolink=" ) ) )
	{
		int pos = 0;
		pos += strlen( "<autolink=" );

		int endPos = oFont.find( tag+pos, '>' );
		if ( -1 != endPos )
		{
			char temp[256];
			endPos += pos;

			memcpy( temp, tag+pos, endPos-pos );
			temp[endPos-pos] = 0;

			rc = 1;
			shineLog( SHNROW, cHDebug, "Following link : %s", temp );
			FollowLink( temp, 1 );
		}
	}

	if( 0 == stringCompare( "<link=", tag, strlen( "<link=" ) ) )
	{
		int pos = 0;
		pos += strlen( "<link=" );

		int endPos = oFont.find( tag+pos, '>' );
		if ( -1 != endPos )
		{
			endPos += pos;

			memcpy( currentStatus.linkName, tag+pos, endPos-pos );
			currentStatus.linkName[endPos-pos] = 0;

			currentStatus.linkArea.left = *textX;
			currentStatus.linkArea.top = *textY;

			linkMostRight = *textX;

			prevColor = currentStatus.textColor;
			currentStatus.textColor = currentStatus.linkColor;
			currentStatus.fontUnderline = 1;
			rc = 1;

			shineLog( SHNROW, cHDebug, "Link=%s", currentStatus.linkName );
		}
	}

	if( 0 == stringCompare( "</link>", tag, strlen( "</link>" ) ) )
	{
		shineLink* Link = new shineLink();

		currentStatus.linkArea.right = linkMostRight;
		currentStatus.linkArea.bottom = *textY+oFont.getHeight( "ag" );

		currentStatus.textColor = prevColor;
		currentStatus.fontUnderline = 0;

		Link->setLink( currentStatus.linkName, currentStatus.linkArea );
		oLinks.insert( Link );

		shineLog( SHNROW, cHDebug, "Link=%s x1=%d y1=%d x2=%d y2=%d", currentStatus.linkName, currentStatus.linkArea.left, currentStatus.linkArea.top, currentStatus.linkArea.right,
			currentStatus.linkArea.bottom);
		rc=1;
	}

	if( 0 == stringCompare( "<font", tag, strlen( "<font" ) ) )
	{
		int pos = 0;

		pos = oFont.find( tag, "face=\"" );
		if ( -1 != pos )
		{
			pos +=  strlen( "face=\"" );
			int endPos = oFont.find( tag+pos, '\"' ) + pos;
			if ( -1 != endPos )
			{
				memcpy( currentStatus.fontName, tag+pos, endPos-pos );
				currentStatus.fontName[endPos-pos] = 0;
			}
		}

		pos = oFont.find( tag, "height=" );

		if ( -1 != pos )
		{
			pos +=  strlen( "height=" );
			currentStatus.fontHeight = (int)(atoi( tag+pos )*fontZoom);
		}

		pos = oFont.find( tag, "width=" );
		if ( -1 != pos )
		{
			pos +=  strlen( "width=" );
			currentStatus.fontWidth = atoi( tag+pos );
		}

		oFont.setFace( currentStatus.fontName, currentStatus.fontWidth, currentStatus.fontHeight, currentStatus.fontWeight, currentStatus.fontItalic, currentStatus.fontUnderline );
		shineLog( SHNROW, cHDebug, "Font tag found (face=%s width=%d height=%d)", currentStatus.fontName, currentStatus.fontWidth, currentStatus.fontHeight );
		rc = 1;
	}

	if( 0 == stringCompare( "<plugin", tag, strlen( "<plugin" ) ) )
	{
		int pos = 0;
		int x = 50;
		int y = 50;
		int interval = 2000;

		char filename[256];
		char param[cMaxPluginParameterSize];
		char link[cMaxPluginParameterSize];
		memset( filename, 0, 256 );
		memset( param,    0, cMaxPluginParameterSize );
		memset( link,     0, cMaxPluginParameterSize );

		int xpos = *textX;
		int ypos = *textY;
		
		pos = oFont.find( tag, "file=\"" );
		if ( -1 != pos )
		{
			pos +=  strlen( "file=\"" );
			int endPos = oFont.find( tag+pos, '\"' ) + pos;
			if ( -1 != endPos )
			{
				memcpy( filename, tag+pos, endPos-pos );
			}
		}

		pos = oFont.find( tag, "param=\"" );
		if ( -1 != pos )
		{
			pos +=  strlen( "param=\"" );
			int endPos = oFont.find( tag+pos, '\"' ) + pos;
			if ( -1 != endPos )
			{
				memcpy( param, tag+pos, endPos-pos );
			}
		}

		pos = oFont.find( tag, "link=\"" );
		if ( -1 != pos )
		{
			pos +=  strlen( "link=\"" );
			int endPos = oFont.find( tag+pos, '\"' ) + pos;
			if ( -1 != endPos )
			{
				memcpy( link, tag+pos, endPos-pos );
			}
		}

		pos = oFont.find( tag, "width=" );
		if ( -1 != pos )
		{
			pos +=  strlen( "width=" );
			if( '%' == tag[pos] )
			{
				x = sgdiGetXRes()-cBorders;
				xpos = 0;
			}
			else
			{
				x = (int)(atoi( tag+pos ));
			}
		}

		pos = oFont.find( tag, "height=" );
		if ( -1 != pos )
		{
			pos +=  strlen( "height=" );
			if( '%' == tag[pos] )
			{
				y = sgdiGetYRes();
				ypos = 0;
			}
			else
			{
				y = (int)(atoi( tag+pos ));
			}
		}

		pos = oFont.find( tag, "xpos=" );
		if ( -1 != pos )
		{
			pos +=  strlen( "xpos=" );
			xpos = (int)(atoi( tag+pos ));
		}

		pos = oFont.find( tag, "ypos=" );
		if ( -1 != pos )
		{
			pos +=  strlen( "ypos=" );
			ypos = (int)(atoi( tag+pos ));
		}

		pos = oFont.find( tag, "delay=" );
		if ( -1 != pos )
		{
			pos +=  strlen( "delay=" );
			interval = (int)(atoi( tag+pos ));
		}

		shineLog( SHNROW, cHDebug, "Init Plugin %s", filename );

		shineArea* Area = new shineArea();
		Area->x1 = xpos - cBorders;
		Area->y1 = ypos - cBorders;
		Area->x2 = xpos + x + cBorders;
		Area->y2 = ypos + y + cBorders;
		Area->inverted = 0;

		int h = ( Area->y2 ) + cBorders + cBorders;
		if( h > height )
			height = h;

		initPlugin( filename, param, link, xpos, ypos, x, y, interval );

		*textX += x;

		rc = 1;
	}

	if( 0 == stringCompare( "<img", tag, strlen( "<img" ) ) )
	{
		int pos = 0;
		int alignLeft = 1;
		char filename[256];
		shineImage* Image = new shineImage();

		pos = oFont.find( tag, "src=\"" );
		if ( -1 != pos )
		{
			pos +=  strlen( "src=\"" );
			int endPos = oFont.find( tag+pos, '\"' ) + pos;
			if ( -1 != endPos )
			{
				memcpy( filename, tag+pos, endPos-pos );
				filename[endPos-pos] = 0;
				if( NULL == poLibrary )
				{
					Image->loadJPEG( filename );
				}
				else
				{
					Image->loadJPEG( poLibrary, filename );
				}
			}
		}

		pos = oFont.find( tag, "width=" );
		if ( -1 != pos )
		{
			pos +=  strlen( "width=" );
			Image->setXSize( atoi( tag+pos ) );
		}

		pos = oFont.find( tag, "height=" );
		if ( -1 != pos )
		{
			pos +=  strlen( "height=" );
			Image->setYSize( atoi( tag+pos ) );
		}

		Image->setXPos( *textX );
		Image->setYPos( *textY );

		pos = oFont.find( tag, "align=center" );
		if ( -1 != pos )
		{
			alignLeft = 0;
			Image->setXPos( ( sgdiGetXRes() - Image->getXSize() - cBorders) / 2 );
		}

		pos = oFont.find( tag, "align=right" );
		if ( -1 != pos )
		{
			alignLeft = 0;
			Image->setXPos( ( sgdiGetXRes() - cBorders ) - Image->getXSize() );
		}

		//addArea( Image->getXPos(), Image->getXPos() + Image->getXSize(), Image->getYPos(), Image->getYPos() + Image->getYSize(), 0 );
		shineArea* Area = new shineArea();
		Area->x1 = Image->getXPos() - cBorders;
		Area->y1 = Image->getYPos() - cBorders;
		Area->x2 = Image->getXPos() + Image->getXSize() + cBorders;
		Area->y2 = Image->getYPos() + Image->getYSize() + cBorders;
		Area->inverted = 0;

		int h = ( Area->y2 ) + cBorders + cBorders;
		if( h > height )
			height = h;

		oAreas.insert( Area );
		oImages.insert( Image );

		if( 1 == alignLeft )
		{
			*textX += Image->getXSize();
		}

		shineLog( SHNROW, cHDebug, "Image tag found. Filename=%s Xres=%d Yres=%d Xsize=%d Ysize=%d Xpos=%d Ypos=%d",
								filename, Image->getXRes(), Image->getYRes(), Image->getXSize(), Image->getYSize(), Image->getXPos(), Image->getYPos() );
		rc = 1;
	}

	
	return rc;
}

//________________________________________________________________________________________________________________________________________________________________________

shineArticle::shineArticle()
{
	data = NULL;
	rows = NULL;
	IDCounter = 0;

	oFont.init();
	poLibrary = NULL;
	LoadShineData();
	oScheduler.init();
}

//________________________________________________________________________________________________________________________________________________________________________

shineArticle::~shineArticle()
{
	if ( NULL != data )
	{
		delete [] data;
	}

	if ( NULL != rows )
	{
		delete [] rows;
	}

	IDCounter = 0;
	oScheduler.close();

	oPlugins.clear();
	oRows.clear();
	oAreas.clear();
	oAreas.clear();
	oLinks.clear();

	oFont.deInit();
}

//________________________________________________________________________________________________________________________________________________________________________

void shineLink::setLink( char* name, RECT area )
{
	strcpy( linkName, name );
	linkArea = area;
}

//________________________________________________________________________________________________________________________________________________________________________

char* shineLink::getLink()
{
	return linkName;
}

//________________________________________________________________________________________________________________________________________________________________________

RECT shineLink::getArea()
{
	return linkArea;
}

//________________________________________________________________________________________________________________________________________________________________________

shineLink* shineArticle::checkLink( int mousex, int mousey, int yScroll, char button )
{
	// Check if there's a link at the mouse position:

	shineLink* returnLink = NULL;

	shineLog( SHNROW, cHDebug, "shineArticle::checkLink()" );
	shineLink* pFirst;

	shineLog( SHNROW, cHDebug, "shineArticle::checkLink() Looping through links.." );
	pFirst = oLinks.pFirst;
	while( NULL != pFirst )
	{
		RECT area = pFirst->getArea();
		if( area.left < mousex && area.right > mousex && area.top-yScroll < mousey && area.bottom-yScroll > mousey )
		{
			shineLog( SHNROW, cHDebug, "shineArticle::checkLink() Mouse is over a link" );
			return pFirst;
		}
		pFirst = pFirst->pNext;
	}

	shineLog( SHNROW, cHDebug, "shineArticle::checkLink() Looping through plugins.." );
	shinePlugin* pFirstPlugin;
	pFirstPlugin = oPlugins.pFirst;
	rShinePluginAction_t* rShinePluginAction = NULL;

	// Check for mouseaway
	while( NULL != pFirstPlugin )
	{
		RECT area;
		area.left   = pFirstPlugin->Image->getXPos();
		area.right  = pFirstPlugin->Image->getXPos()+pFirstPlugin->Image->getXSize();
		area.top    = pFirstPlugin->Image->getYPos();
		area.bottom = pFirstPlugin->Image->getYPos()+pFirstPlugin->Image->getYSize();
		if( !( area.left < mousex && area.right > mousex && area.top-yScroll < mousey && area.bottom-yScroll > mousey ) )
		{
			if( pFirstPlugin->eLastEvent == cSPMouseOver )
			{
				shineLog( SHNROW, cDebug, "shineArticle::checkLink() Sending cSPMouseAway event to plugin" );
				pFirstPlugin->eLastEvent = cSPMouseAway;
				rShinePluginAction = pFirstPlugin->event( cSPMouseAway, mousex, mousey, pFirstPlugin->ID );
			}
		}
		pFirstPlugin = pFirstPlugin->pNext;
	}

	// Check the rest of the events
	pFirstPlugin = oPlugins.pFirst;
	while( NULL != pFirstPlugin )
	{
		RECT area;
		area.left   = pFirstPlugin->Image->getXPos();
		area.right  = pFirstPlugin->Image->getXPos()+pFirstPlugin->Image->getXSize();
		area.top    = pFirstPlugin->Image->getYPos();
		area.bottom = pFirstPlugin->Image->getYPos()+pFirstPlugin->Image->getYSize();
		
		if( area.left < mousex && area.right > mousex && area.top-yScroll < mousey && area.bottom-yScroll > mousey )
		{
			shineLog( SHNROW, cHDebug, "shineArticle::checkLink() Mouse is over a plugin" );

			// Send events to plugins..
			if( 1 == button )
			{
				shineLog( SHNROW, cDebug, "shineArticle::checkLink() Sending cSPMouseLeft event to plugin" );
				pFirstPlugin->eLastEvent = cSPMouseLeft;
				rShinePluginAction = pFirstPlugin->event( cSPMouseLeft, mousex, mousey, pFirstPlugin->ID );
			}
			else
			{
				if( pFirstPlugin->eLastEvent != cSPMouseOver )
				{
					shineLog( SHNROW, cDebug, "shineArticle::checkLink() Sending cSPMouseOver event to plugin" );
					pFirstPlugin->eLastEvent = cSPMouseOver;
					rShinePluginAction = pFirstPlugin->event( cSPMouseOver, mousex, mousey, pFirstPlugin->ID );
				}
			}

			if( 1 == button && NULL != rShinePluginAction && cSAFollowLink == rShinePluginAction->eShineAction )
			{
				if( 0 != rShinePluginAction->u.linkFilename[0] )
				{
					shineLog( SHNROW, cDebug, "shineArticle::checkLink() Creating link from plugin %s", rShinePluginAction->u.linkFilename );
					oPluginLink.setLink( rShinePluginAction->u.linkFilename, area );
					return &oPluginLink;
					//returnLink = &oPluginLink;
				}
				else
				{
					return NULL;
				}
			}
			else
			{
				// Check if the left mouse button is pressed. If it is, we should return NULL as there wasn't any link to follow.
				// Othervise return oPluginLink to change the mouse cursor.
				if( 1 == button ) //  || NULL == rShinePluginAction
				{
					return NULL;
				}
				else
				{
					//returnLink = &oPluginLink;
					return &oPluginLink;
				}
			}

		}
		pFirstPlugin = pFirstPlugin->pNext;
	}
	return returnLink;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::setLibrary( shineLibrary *poLib )
{
	poLibrary = poLib;
}

//________________________________________________________________________________________________________________________________________________________________________

