//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-29
// Revision (please increase number) : A2
// (Only increase A if it's not backwards complient.)
// _______________________________________________________________________________________
//
// Description:
//   
//  This file has functions on how to create a font, set a font, and draw text with a font.
//
//  [2000-11-30] Fixed by Otis

#include "sfont.h"
#include "sgdi.h"
#include "sbase.h"

shineFont::shineFont()
{
	// [OTIS] init of hfont handle, to keep init() routine safe
	hfont=NULL;
	init();
}

//________________________________________________________________________________________________________________________________________________________________________

shineFont::~shineFont()
{
	deInit();
}

//________________________________________________________________________________________________________________________________________________________________________

void shineFont::init()
{
	// [OTIS] Only called in constructor. But for safety a delete switch is added
	if(hfont)
	{
		DeleteObject(hfont);
	}
	// [OTIS] Create new
	hfont = CreateFont( 7, 14, 0, 0, 400, 0, 0, 0, ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, FF_DONTCARE, "Arial" );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineFont::deInit()
{
	// [OTIS] dirty programming... safety switch added
	if(hfont)
	{
		DeleteObject( hfont );
	}

	// [OTIS] Not needed:
	//CloseHandle( hfont );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineFont::setFace( char* face, int width, int height, int weight, bool italic, bool underline )
{
	// [OTIS] dirty programming... safety switch added
	if(hfont)
	{
		DeleteObject( hfont );
	}

	/*
	HFONT CreateFont(
	  int nHeight,               // height of font
	  int nWidth,                // average character width
	  int nEscapement,           // angle of escapement
	  int nOrientation,          // base-line orientation angle
	  int fnWeight,              // font weight
	  DWORD fdwItalic,           // italic attribute option
	  DWORD fdwUnderline,        // underline attribute option
	  DWORD fdwStrikeOut,        // strikeout attribute option
	  DWORD fdwCharSet,          // character set identifier
	  DWORD fdwOutputPrecision,  // output precision
	  DWORD fdwClipPrecision,    // clipping precision
	  DWORD fdwQuality,          // output quality
	  DWORD fdwPitchAndFamily,   // pitch and family
	  LPCTSTR lpszFace           // typeface name
	);
	*/
	if( 0 == width )
	{
		width = (int)( ((float)height/2) * fontZoom );
	}

	hfont = CreateFont( height, width, 0, 0, weight, italic, underline, 0, ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, FF_DONTCARE, face );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineFont::drawText( char* text, int xPos, int yPos, long color, HDC hdc )
{
	// [OTIS] Store old font handle so we can restore it when we're done (thx Mikko)
	HGDIOBJ	hOldFont=SelectObject( hdc, hfont );
	SetTextColor( hdc, color );
	SetBkMode( hdc, TRANSPARENT );

	TextOut( hdc, xPos, yPos, text, strlen( text ) );
	
	// [OTIS] Restore old font. (thx Mikko)
	SelectObject(hdc, hOldFont);
}

//________________________________________________________________________________________________________________________________________________________________________

SIZE shineFont::getSize( char* string )
{
	SIZE sz;

	// [OTIS] Store old font handle so we can restore it when we're done (thx Mikko)
	HGDIOBJ	hOldFont=SelectObject( sgdiGetDc(), hfont );
	GetTextExtentPoint32( sgdiGetDc(), string, strlen( string ), &sz );

	// [OTIS] Restore old font. (thx Mikko)
	SelectObject(sgdiGetDc(), hOldFont);

	return sz;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineFont::getWidth( char* string )
{
	SIZE sz;
	// [OTIS] Store old font handle so we can restore it when we're done (thx Mikko)
	HGDIOBJ	hOldFont=SelectObject( sgdiGetDc(), hfont );

	GetTextExtentPoint32( sgdiGetDc(), string, strlen( string ), &sz );

	// [OTIS] Restore old font. (thx Mikko)
	SelectObject(sgdiGetDc(), hOldFont);
	return sz.cx;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineFont::getWidth( char* string, int len )
{
	SIZE sz;

	// [OTIS] Store old font handle so we can restore it when we're done (thx Mikko)
	HGDIOBJ	hOldFont=SelectObject( sgdiGetDc(), hfont );

	GetTextExtentPoint32( sgdiGetDc(), string, len, &sz );

	// [OTIS] Restore old font. (thx Mikko)
	SelectObject(sgdiGetDc(), hOldFont);

	return sz.cx;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineFont::getHeight( char* string )
{
	SIZE sz;
	// [OTIS] Store old font handle so we can restore it when we're done (thx Mikko)
	HGDIOBJ	hOldFont=SelectObject( sgdiGetDc(), hfont );

	GetTextExtentPoint32( sgdiGetDc(), string, strlen( string ), &sz );

	// [OTIS] Restore old font. (thx Mikko)
	SelectObject(sgdiGetDc(), hOldFont);

	return sz.cy;
}

//________________________________________________________________________________________________________________________________________________________________________

// Some functions to find a character/text inside a string

int shineFont::find( char* string, char* findString )
{
	if( strlen( string ) < strlen( findString ) )
		return -1;

	for( unsigned int i=0; i<strlen( string )-strlen( findString ); i++ ) 
	{
		if( 0 == stringCompare( string+i, findString, strlen( findString ) ) )
			return i;
	}
	return -1;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineFont::find( char* string, char sign )
{
	int pos = 0;

	while( sign == string[pos] || '<' == string[pos] )
	{
		pos++;
		if ( pos >= cMaxLineWidth-1 ) return -1;	
	}

	for( unsigned int i=pos; i<strlen( string ); i++ ) 
	{
		if ( i >= cMaxLineWidth-1 ) return -1;
		if ( sign == string[i] ) return i;
		
		// test..
		if ( '<' == string[i] ) return i;
	}
	return i;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineFont::find2( char* string, char sign )
{
	for( int i=0; string[i]!=0; i++ ) 
	{
		if ( i >= cMaxLineWidth-1 ) return -1;
		if ( sign == string[i] )
			return i;
	}
	return -1;
}

//________________________________________________________________________________________________________________________________________________________________________

int shineFont::findBack( char* string, char sign, int startLen )
{
	int pos = startLen;
	while( sign == string[pos] )
	{
		pos--;
		if ( 0 > pos )
			return -1;
	}

	for( int i=pos; string[i]!=sign; i-- ) if ( 0 == i ) return -1;
	return i;
}

//________________________________________________________________________________________________________________________________________________________________________
