//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-09
// Revision (please increase number) : A2
// (Only increase A if it's not backwards complient.)
//
//  [2000-11-30] Fixed by Otis
//
// _______________________________________________________________________________________

#ifndef __sgdi_h
#define __sgdi_h

//________________________________________________________________________________________________________________________________________________________________

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

//________________________________________________________________________________________________________________________________________________________________

// Return codes
const sgdiOk = 0;
const sgdiError = -1;

// Events that will be returned by sgdiGetEvent when they occurs.
enum sgdiEvent_t {
	cWindowResized, cWindowActivated, cKeyDown, cKeyUp, cExit, cNoEvent, cMouseWheel, cFocus, cMouseMove, cMouseLeftButton, cMouseRightButton, cMouseLeftButtonPress
};

//________________________________________________________________________________________________________________________________________________________________

// Internal information used by the 
struct sgdiInternal_t {
	int			keyUp;
	int			keyDown;
	bool		keyPressed;
	sgdiEvent_t Event;
	WNDCLASS	wc;
	HWND		wnd;
	BITMAPINFO  bi;
	HDC			hdc;
	int			xRes;
	int			yRes;
	int			mouseWheel;
	int			mouseX;
	int			mouseY;
};

static sgdiInternal_t sgdiInternal;

//________________________________________________________________________________________________________________________________________________________________

int sgdiOpen( char*title, int xres, int yres );
int sgdiOpenPopup( char*title, int xres, int yres );
int sgdiClose();
void sgdiSetTitle( char* title );

void sgdiScroll( int yscroll );

void sgdiClear( long color );
void sgdiBox( int x1, int y1, int x2, int y2, long color );

HDC sgdiGetDc();
// [OTIS] Added for thread
HWND sgdiGetWnd();

void sgdiWaitEvent();
int sgdiGetKey();
bool sgdiKeyPressed();

int sgdiGetXRes();
int sgdiGetYRes();

int sgdiGetMouseX();
int sgdiGetMouseY();

void sgdiClearEvent();
int sgdiGetMouseWheel();

long* sgdiGetBuffer();

//________________________________________________________________________________________________________________________________________________________________

#endif