//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-09
// Revision (please increase number) : A1
// (Only increase A if it's not backwards complient.)
// _______________________________________________________________________________________
//
// Description:
//	These functions should be edited to fit your favourite music player.
//  As an example Bass 0.8 is used.
//

#include <windows.h>
#include "sbase.h"
#include "..\bass\bass.h"

//________________________________________________________________________________________________________________________________________________________________________

// Static data for the sound player
static HMUSIC mod;
static HSTREAM str;
static bool musicInitialized = 0;
static bool musicPlaying = 0;
static int volume = 50;
static char currentFile[1024];

//________________________________________________________________________________________________________________________________________________________________________

void CALLBACK LoopSync( HSYNC handle, DWORD channel, DWORD data, DWORD user )
{
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::musicLoad( char* filename )
{
	BOOL mono = FALSE;

	strcpy( currentFile, filename );

	if( 0 == musicInitialized )
	{
		musicInit();
	}

	if( 1 == musicPlaying )
	{
		musicStop();
	}

	if( str = BASS_StreamCreateFile( FALSE, filename, 0, 0, 0) ) 
	{
		mono = BASS_ChannelGetFlags(str)&BASS_SAMPLE_MONO;
		BASS_ChannelSetSync( str, BASS_SYNC_END, 0, &LoopSync, 0);
		shineLog( SHNROW, cMsg, "Playing %s as a streaming file", filename );
	} 
	else 
	{
		if ( !( mod = BASS_MusicLoad( FALSE, filename, 0, 0, BASS_MUSIC_LOOP|BASS_MUSIC_RAMP ) ) )
		{
			shineLog( SHNROW, cMsg, "Unknown music file format" );
			return;
		}
		BASS_ChannelSetSync( mod, BASS_SYNC_END, 0, &LoopSync, 0 );
	}

	BASS_Start();

	if( str )
	{
		BASS_StreamPlay(str,FALSE,BASS_SAMPLE_LOOP);
	}
	else
	{
		BASS_MusicPlayEx( mod, 0, -1, 1 );
	}

	musicPlaying = 1;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::musicStop()
{
	BASS_Stop();
	musicPlaying = 0;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::musicInit()
{
	if( BASS_GetVersion() != MAKELONG(0,8) ) 
	{
		shineLog( SHNROW, cHigh, "Wrong BASS version. 0.8 Expected" );
		return;
	}

	if( !BASS_Init( -1, 44100, 0, GetForegroundWindow()) )
	{
		shineLog( SHNROW, cHigh, "Unable to initialize sound device" );
		return;
	}

	BASS_SetVolume( volume );

	musicInitialized = 1;
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::musicDeInit()
{
	if( 1 == musicInitialized )
	{
		BASS_Free();
		musicInitialized = 0;
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::musicResume()
{
	musicLoad( currentFile );
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::volumeInc()
{
	volume += 5;
	if( 99 < volume )
	{
		volume = 100;
	}

	if( 1 == musicInitialized )
	{
		BASS_SetVolume( volume );
	}

}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::volumeDec()
{
	volume -= 5;
	if( 0 > volume )
	{
		volume = 0;
	}

	if( 1 == musicInitialized )
	{
		BASS_SetVolume( volume );
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void shineArticle::volumeSet( int vol )
{
	if( 1 == musicInitialized )
	{
		BASS_SetVolume( volume = vol );
	}
}

//________________________________________________________________________________________________________________________________________________________________________

int getVolume()
{
	return volume;
}

//________________________________________________________________________________________________________________________________________________________________________

int getLeftChannel()
{
	if( 1 == musicInitialized )
	{
		return LOWORD(BASS_ChannelGetLevel( str?str:mod ));
	}
	else
	{
		return 0;
	}
}

//________________________________________________________________________________________________________________________________________________________________________

int getRightChannel()
{
	if( 1 == musicInitialized )
	{
		return HIWORD(BASS_ChannelGetLevel( str?str:mod ));
	}
	else
	{
		return 0;
	}
}

//________________________________________________________________________________________________________________________________________________________________________
