#include <stdlib.h>
#include <stdio.h>
#include <string.h>

static char filename[] = {"articles.s"};

bool CheckLen = false;
const int cMaxLen = 1024;

void main( int argc, char* argv[] )
{
	FILE* archiveFile;
	FILE* file;

	if( argc < 2 )
	{
		printf( "Put file on command line\n" );
	}

	// Create new lib file
	if( !strcmp( "-n", argv[1] ) )
	{
		archiveFile = fopen( filename, "wb" );

		if( NULL == archiveFile )
		{
			printf( "Cannot open %s\n", filename );
		}
		else
		{
			fclose( archiveFile );
		}
		printf( "lib::Create new library\n" );
		exit(0);
	}

	if( argc >= 3 )
	if( !strcmp( "-c", argv[2] ) )
	{
		CheckLen = true;
	}

	archiveFile = fopen( filename, "ab" );
	file		= fopen( argv[1],  "rb" );

	if( NULL == archiveFile )
	{
		printf( "Cannot open %s\n", filename );
		exit(0);
	}

	if( NULL == file )
	{
		printf( "Cannot open %s\n", argv[1] );
		fclose( archiveFile );
		exit(0);
	}

	fseek( file, 0, SEEK_END );
	int fileSize = ftell( file );
	rewind( file );

	printf( "lib::Adding file %s (%d)\n", argv[1], fileSize );
	char* buffer = new char[fileSize];

	fread( buffer, fileSize, 1, file );

	int Counter = 0;
	int tcount = 0;

	if( CheckLen )
	{
		for( int i=0; i<fileSize; i++, Counter++ )
		{
			if( 0 == buffer[i] ||	13 == buffer[i] || 10 == buffer[i] )
			{
				tcount = i;
				Counter = 0;
			}

			if( cMaxLen <= Counter )
			{
				char tempbuf[40000];
				memcpy( tempbuf, buffer+tcount, Counter-1 );
				tempbuf[Counter] = 0;
				printf( "lib::line to long (%s) : %s\n", argv[1], tempbuf );
			}
		}
	}

	// Write filename
	fwrite( argv[1], strlen(argv[1])+1, 1, archiveFile );

	// Write filesize
	fwrite( &fileSize, 4, 1, archiveFile );

	// Write file
	fwrite( buffer, fileSize, 1, archiveFile );

	delete [] buffer;

	fclose( archiveFile );
	fclose( file );
}