/*
	An example C language GIF decoder.
   	Copyright (c) 1989 Alchemy Mindworks
	Creates a binary and palette file.
*/

#include "stdio.h"
#include "dos.h"
#include "alloc.h"

extern char PALETTE[768],OUTROW[1024],COPYRIGHT[];
extern int INTERLACED,IMAGEWIDE,IMAGEDEEP;
extern int IMAGEX,IMAGEY,XLOC,YLOC;
extern int VERSION,SUBVERSION;

char *pbf=NULL;		/* pointer to line work space */

unsigned int colours=0;
char filename[65];
FILE *fp=NULL;

main(argc,argv)
	int argc;
	char *argv[];
{
	int i,e,ShowIt(),Colourize();
	int ImageDone(),BadError(),BGround();

        SetShow(ShowIt);
	SetPalette(Colourize);
	SetImage(ImageDone);
	SetError(BadError);
	SetBackground(BGround);
	if(argc > 1) {
		if((pbf=malloc(4096)) != NULL) {
			EGAgraphics();
			for(i=1;i<argc;++i) {
				strmfe(filename,argv[i],"GIF");
				if((e=UnpackGIF(filename)) == 0) {
					if(getch()==27) break;
				}
				else break;
			}
			Text();
                        printf("The image was packed with %u colours.\n",colours);
			printf("It's %u wide by %u deep.\n",IMAGEWIDE,IMAGEDEEP);
			if(e) printf("Error code %d",e);
			free(pbf);
		} else puts("Error allocating memory");
	}
}

ImageDone()
{
	fclose(fp);
	nosound();
	sound(660);
	delay(100);
	sound(880);
	delay(50);
	sound(440);
	delay(75);
	nosound();
}

Colourize(n,palette)
	int n;
	char *palette;
{
	char s[65],b[256];
	int i;

	colours=n;
	Gif2EgaPALETTE(b,palette,n);
	PaletteEGA(b,n);
	strmfe(s,filename,"PAL");
	if((fp=fopen(s,"wb")) != NULL) {
              	for(i=0;i<n;++i) {
			fputc(palette[0],fp);
			fputc(palette[1],fp);
			fputc(palette[2],fp);
			palette+=3;
		}
		fclose(fp);
	}
	else {
		Text();
		puts("Error writing palette");
		exit(1);
	}
	strmfe(s,filename,"BIN");
	if((fp=fopen(s,"wb")) == NULL) {
		Text();
		puts("Error opening binary file");
		exit(1);
	}
}

ShowIt()
{
	if(fwrite(OUTROW,1,IMAGEWIDE,fp) != IMAGEWIDE) {
		Text();
                printf("Error writing line %d\n",YLOC);
		exit(1);
	}
	Gif2Ega(pbf,OUTROW,IMAGEWIDE);
        ShowEGA(pbf,IMAGEWIDE>>3,YLOC);
}

BGround(n)
	int n;
{
	int i;

	memset(OUTROW,n,80);
	Gif2Ega(pbf,OUTROW,IMAGEWIDE);
	for(i=0;i<350;++i) ShowEGA(pbf,IMAGEWIDE>>3,i);
}

BadError(s)
	char *s;
{
	Text();
	printf("\007\007\007Fatal error - %s.\n",s);
	exit(1);
}

strmfe(new,old,ext)		/* make file name with specific extension */
	char *new,*old,*ext;
{
	while(*old != 0 && *old != '.') *new++=*old++;
	*new++='.';
	while(*ext) *new++=*ext++;
	*new=0;
}
