;This is very uncommented
;There are many libraries missing
;You will not be able to re-assemble it
;But maybe, maybe you can learn from it (if you can figure out what it does)
;The real action happens in the .inc file

;I think the major libs needed are mem allocation, e.g.:
;New: takes ecx as a byte count and returns a near pointer in eax
;Delete: deletes a block of mem at eax
;That's what I called the heap lib (although I found out today that that
;is not what a heap is.

p486    ;hey, bswap comes in handy all the time! This will run on a 386.
ideal
locals
largestack

;

o equ offset
b equ byte
w equ word
d equ dword
s equ short
n equ near
f equ far

KB      equ * 1024
MB      equ * 1024 * 1024

;

segment code32 page public use32
        assume cs:code32, ds:code32

include "\code\omn\include\macros.inc"
include "\code\omn\pmode\pmode.inc"
include "\code\omn\kb\kb.inc"
include "\code\omn\file\file.inc"

include "\code\omn\include\routines.inc"
include "\code\omn\string\string.inc"
include "\code\omn\pcx\pcx.inc"
include "\code\omn\argc\argc.inc"
include "\code\omn\heap\heap.inc"

include "\code\omn\include\mx32.inc"

public  _main

;
;This came from John McCarthy's 3dvect37

macro   wait_esc
local   cont, test_kb
; test escape key - if none, continue

        push    eax
        in      al, 60h                 ; test keyboard
        cmp     al, 1
        jne     cont

test_kb:
        in      al, 60h                 ; test keyboard
        cmp     al, 1
        je      test_kb

        pop     eax
        jmp     error

cont:
        pop     eax

endm

;

;code

align 32
_main:
        sti

        mov     eax, 00f00h
        mov     ecx, 80*25
        mov     edi, 0b8000h
        sub     edi, [_code32a]
        inc     edi

@@black:
        and     [edi], ah 
        or      [edi], al
        add     edi, 2
        dec     ecx
        jnz     @@black

        call    init_file

        endl
        msg     "                                 - Reduce v1.0 -"
        endl
        msg     "          - (c) 1996 Andrew Harvey, c9607776@helios.newcastle.edu.au -"
        endl
        msg     "                 - pmode courtesy of Tran, a.k.a. Tomas Pytel -"
        endl
        msg     "          - Spatial subdivision algorithm courtesy of Dave Pomerantz -"
        endl
        endl

        mov     ecx, [_himemtop]
        sub     ecx, [_himembase]
        call    init_heap
        jc      error

        call    reduce

        call    reset_heap
        call    reset_file

        endl
        msg     "                                     - Bye -"
        endl
        jmp     _exit

error:
        endl
        msg     "                                    - Dang! -"
        endl

        mov     eax, 00f40h
        mov     ecx, 80*25
        mov     edi, 0b8000h
        sub     edi, [_code32a]
        inc     edi

@@red:
        and     [edi], ah 
        or      [edi], al
        add     edi, 2
        dec     ecx
        jnz     @@red

        jmp     _exit

;

align 32
proc    reduce n

        msg     "Reading .CFG file"
        endl

        xor     eax, eax
        mov     edx, o cfg_file
        call    checkstr
        jc      error

        mov     edx, o cfg_file
        call    openfile
        jc      error

        call    filesize
        jc      error

        mov     ecx, eax
        call    new
        jc      error

        mov     [cfg_file_mem], eax
        mov     [cfg_file_size], ecx

        mov     edx, eax
        call    readfile
        jc      error

        call    closefile
        jc      error

        call    dump_inputfiles
        call    convert_inputfiles
        ;call    posturize_dump
        call    count_colours
        call    make_colourlist
        call    recount_colours
        call    remake_colourlist
        call    build_palette
        call    quantize_data

        ret

endp

align 4
cfg_file_mem    dd ?
cfg_file_size   dd ?
cfg_file        db 1024 dup ( ? )

;

align 32
proc    quantize_data n

        msg     "Quantizing rgb data"
        endl

        mov     esi, o palette
        mov     edi, o triplet_pal
        mov     ecx, 256

@@make_triplet_pal:
        mov     eax, [esi]
        mov     [edi], ax
        shr     eax, 8
        mov     [edi + 2], ah
        add     esi, 4
        add     edi, 3
        dec     ecx
        jnz     @@make_triplet_pal
        
        msg     " Quantizing input files"
        endl

        mov     ecx, [pcx_height]
        shl     ecx, 8
        call    new
        jc      error
        mov     [indexed_data], eax

        mov     ecx, [pcx_height]
        shl     ecx, 8
        mov     esi, [rgb_data]
        mov     edi, [indexed_data]

@@quantize_rgb:
        mov     eax, [esi]
        push    ecx esi edi
        call    quantize_colour
        pop     edi esi ecx
        mov     [edi], al
        inc     edi
        add     esi, 4
        dec     ecx
        jnz     @@quantize_rgb

        msg     "  Dumping output files"
        endl

        mov     edx, o rgb_out
        call    createfile
        jc      error
        mov     ecx, [pcx_height]
        shl     ecx, 10
        mov     edx, [rgb_data]
        call    writefile
        jc      error
        call    closefile
        jc      error

        mov     eax, [rgb_data]
        call    delete
        jc      error

        mov     ecx, [pcx_height]
        shl     ecx, 8
        lea     ecx, [ecx*2 + ecx]
        call    new
        jc      error
        mov     [output_buffer], eax

        mov     ebx, 256
        mov     ecx, [pcx_height]
        mov     esi, [indexed_data]
        mov     edi, [output_buffer]
        mov     [pcx_palptr], 0
        mov     [pcx_8palptr], o triplet_pal
        call    compress_pcx

        mov     edx, o pcx_out
        call    createfile
        jc      error
        mov     edx, [output_buffer]
        call    writefile
        jc      error
        call    closefile
        jc      error

        mov     eax, [indexed_data]
        call    delete
        jc      error

        mov     eax, [output_buffer]
        call    delete
        jc      error

        msg     " Quantizing shade tables"
        endl

        msg     "  Building shade tables"
        endl

        mov     ecx, 256 * 256 * 4
        call    new
        jc      error
        mov     [colourlist], eax

        mov     [num_colours], 256
        mov     esi, o palette
        mov     edi, [colourlist]
        mov     ecx, 256

@@transfer_palette:
        mov     eax, [esi]
        mov     [edi], eax
        add     esi, 4
        add     edi, 256 * 4
        dec     ecx
        jnz     @@transfer_palette

        call    shade_colourlist

        msg     "  Quantizing shade tables"
        endl

        mov     ecx, 256 * 256
        call    new
        jc      error
        mov     [indexed_data], eax

        mov     ecx, 256*256
        mov     esi, [colourlist]
        mov     edi, [indexed_data]

@@quantize_shade:
        mov     eax, [esi]
        push    ecx esi edi
        call    quantize_colour
        pop     edi esi ecx
        mov     [edi], al
        inc     edi
        add     esi, 4
        dec     ecx
        jnz     @@quantize_shade

        msg     "  Dumping shade tables"
        endl

        mov     edx, o rgbshade_out
        call    createfile
        jc      error
        mov     ecx, 256 * 256 * 4
        mov     edx, [colourlist]
        call    writefile
        jc      error
        call    closefile
        jc      error

        mov     eax, [colourlist]
        call    delete
        jc      error

        mov     ecx, 65536 * 2
        call    new
        jc      error
        mov     [output_buffer], eax

        mov     ebx, 256
        mov     ecx, 256
        mov     esi, [indexed_data]
        mov     edi, [output_buffer]
        mov     [pcx_palptr], 0
        mov     [pcx_8palptr], o triplet_pal
        call    compress_pcx

        mov     edx, o shade_out
        call    createfile
        jc      error
        mov     edx, [output_buffer]
        call    writefile
        jc      error
        call    closefile
        jc      error

        mov     eax, [indexed_data]
        call    delete
        jc      error
        mov     eax, [output_buffer]
        call    delete
        jc      error

        msg     " Quantizing glenz tables"
        endl

        msg     "  Building glenz tables"
        endl

        mov     ecx, 256 * 256 * 4
        call    new
        jc      error
        mov     [colourlist], eax

        mov     esi, o palette
        mov     edi, [colourlist]
        mov     edx, 256

@@glenz_1:
        mov     ebx, o palette
        mov     ecx, 256

@@glenz_2:
        mov     al, [ebx]
        add     al, [esi]
        rcr     al, 1
        mov     [edi], al
        mov     al, [ebx + 1]
        add     al, [esi + 1]
        rcr     al, 1
        mov     [edi + 1], al
        mov     al, [ebx + 2]
        add     al, [esi + 2]
        rcr     al, 1
        mov     [edi + 2], al

        add     edi, 4
        add     ebx, 4
        dec     ecx
        jnz     @@glenz_2

        add     esi, 4
        dec     edx
        jnz     @@glenz_1

        msg     "  Quantizing glenz tables"
        endl

        mov     ecx, 256 * 256
        call    new
        jc      error
        mov     [indexed_data], eax

        mov     ecx, 256*256
        mov     esi, [colourlist]
        mov     edi, [indexed_data]

@@quantize_glenz:
        mov     eax, [esi]
        push    ecx esi edi
        call    quantize_colour
        pop     edi esi ecx
        mov     [edi], al
        inc     edi
        add     esi, 4
        dec     ecx
        jnz     @@quantize_glenz

        msg     "  Dumping glenz tables"
        endl

        mov     edx, o rgbglenz_out
        call    createfile
        jc      error
        mov     ecx, 256 * 256 * 4
        mov     edx, [colourlist]
        call    writefile
        jc      error
        call    closefile
        jc      error

        mov     eax, [colourlist]
        call    delete
        jc      error

        mov     ecx, 65536 * 2
        call    new
        jc      error
        mov     [output_buffer], eax

        mov     ebx, 256
        mov     ecx, 256
        mov     esi, [indexed_data]
        mov     edi, [output_buffer]
        mov     [pcx_palptr], 0
        mov     [pcx_8palptr], o triplet_pal
        call    compress_pcx

        mov     edx, o glenz_out
        call    createfile
        jc      error
        mov     edx, [output_buffer]
        call    writefile
        jc      error
        call    closefile
        jc      error

        mov     eax, [indexed_data]
        call    delete
        jc      error
        mov     eax, [output_buffer]
        call    delete
        jc      error

        ret

endp

align 4
indexed_data    dd ?
output_buffer   dd ?
triplet_pal     db 768 dup ( 0 )

pcx_out         db "reduced.pcx", 0
rgb_out         db "reduced.raw", 0
shade_out       db "shade.pcx", 0
rgbshade_out    db "shade.raw", 0
glenz_out       db "glenz.pcx", 0
rgbglenz_out    db "glenz.raw", 0

;

;include "oct_quan.inc"         ;oct-tree quantisation, didn't work
;include "bin_quan.inc"         ;binary-tree quantisation, didn't work
include "spltquan.inc"          ;spatial sub-division, works! (Gee, its not
                                ;like oct/bin trees are spatial subdivision
                                ;or anything!!)

;

align 32
proc    remake_colourlist n

        msg     "Rebuilding colourlist"
        endl

        mov     eax, [colourlist]
        call    delete
        jc      error

        mov     ecx, [num_colours]
        mov     [colourlistlen], ecx
        shl     ecx, 2 
        call    new
        jc      error

        mov     [colourlist], eax

        msg     " Rebuilding"
        endl
        mov     esi, [colour_tree]
        mov     edi, [colourlist]
        call    rebuild_colourlist

        mov     eax, [colour_tree]
        call    delete
        jc      error

        ret

endp

;

align 32
proc    rebuild_colourlist n

        cmp     [esi + node.darker], 0
        je      @@skip_darker

        push    esi
        mov     esi, [esi + node.darker]
        call    rebuild_colourlist
        pop     esi

@@skip_darker:
        mov     eax, [esi + node.colour]
        mov     [edi], eax
        add     edi, 4

        cmp     [esi + node.brighter], 0
        je      @@skip_brighter

        push    esi
        mov     esi, [esi + node.brighter]
        call    rebuild_colourlist
        pop     esi

@@skip_brighter:
        ret

endp

;

align 32
proc    recount_colours n

        msg     "Recounting colours... "

        mov     eax, [colour_tree]
        call    delete
        jc      error

        mov     ecx, -1
        call    new
        jc      error

        mov     [colour_tree], eax
        mov     [colour_tree_end], eax
        shr     ecx, 4
        dec     ecx
        mov     [max_colours], ecx

        mov     ecx, [colourlistlen]
        mov     esi, [colourlist]

        xor     eax, eax
        mov     [num_colours], eax

        mov     eax, [esi]
        xor     ebx, ebx
        mov     edi, [colour_tree]
        mov     [edi + node.colour], eax
        mov     [edi + node.brighter], ebx
        mov     [edi + node.darker], ebx
        add     [colour_tree_end], size node
        inc     [num_colours]
        dec     ecx
        add     esi, 4

@@count_colours:
        wait_esc

        push    ecx esi
        mov     eax, [esi]
        call    add_colour
        pop     esi ecx

        mov     eax, [num_colours]
        cmp     eax, [max_colours]
        ja      error

        add     esi, 4
        dec     ecx
        jnz     @@count_colours

        mov     eax, [num_colours]
        mov     ebp, 10
        call    printnum
        endl

        mov     eax, [colour_tree]
        mov     ecx, [num_colours]
        shl     ecx, 4
        call    shrink
        jc      error

        ret

endp

;

align 32
proc    make_colourlist n

        msg     "Building and shading colourlist"
        endl

        mov     ecx, [num_colours]
        shl     ecx, 10
        call    new
        jc      error

        mov     [colourlist], eax
        shr     ecx, 2
        mov     [colourlistlen], ecx

        msg     " Building"
        endl
        mov     esi, [colour_tree]
        mov     edi, [colourlist]
        call    build_colourlist

        msg     " Shading"
        endl
        call    shade_colourlist

        mov     edx, o cl_dump
        call    createfile
        mov     ecx, [num_colours]
        shl     ecx, 10
        mov     edx, [colourlist]
        call    writefile
        call    closefile

        ret

endp

align 4
colourlist      dd ?
colourlistlen   dd ?    ;num colours in list (num_colours * 256)

cl_dump db "colours.raw", 0

;

align 32
proc    build_colourlist n

        cmp     [esi + node.darker], 0
        je      @@skip_darker

        push    esi
        mov     esi, [esi + node.darker]
        call    build_colourlist
        pop     esi

@@skip_darker:
        mov     eax, [esi + node.colour]
        mov     [edi], eax
        add     edi, 256 * 4

        cmp     [esi + node.brighter], 0
        je      @@skip_brighter

        push    esi
        mov     esi, [esi + node.brighter]
        call    build_colourlist
        pop     esi

@@skip_brighter:
        ret

endp

;

align 32
proc    shade_colourlist n
                  
        mov     esi, [colourlist]
        mov     ecx, [num_colours]

@@shade_1:
        push    ecx esi
        call    shade_colour
        pop     esi ecx
        add     esi, 256*4
        dec     ecx
        jnz     @@shade_1

        ret

endp

;

align 32
proc    shade_colour n

        xor     eax, eax
        mov     [@@r], eax
        mov     [@@g], eax
        mov     [@@b], eax

        mov     eax, [esi]
        mov     [b @@r], al
        mov     [b @@g], ah
        shr     eax, 8
        mov     [b @@b], ah

        mov     eax, 255
        mov     ebx, 255
        mov     ecx, 255
        sub     eax, [@@r]
        sub     ebx, [@@g]
        sub     ecx, [@@b]
        mov     [@@wr], eax
        mov     [@@wg], ebx
        mov     [@@wb], ecx

        xor     ebx, ebx
        mov     ecx, 128

@@do_1_black_shade:
        mov     eax, ebx
        mul     [@@r]
        shr     eax, 8
        mov     [@@newr], eax
        
        mov     eax, ebx
        mul     [@@g]
        shr     eax, 8
        mov     [@@newg], eax
        
        mov     eax, ebx
        mul     [@@b]
        shr     eax, 8
        mov     [@@newb], eax

        xor     eax, eax
        mov     ah, [b @@newb]
        shl     eax, 8
        mov     ah, [b @@newg]
        mov     al, [b @@newr]

        mov     [esi], eax

        add     ebx, 2
        add     esi, 4
        dec     ecx
        jnz     @@do_1_black_shade

        xor     ebx, ebx
        mov     ecx, 128

@@do_1_white_shade:
        mov     eax, ebx
        mul     [@@wr]
        shr     eax, 8
        add     eax, [@@r]
        mov     [@@newr], eax
        
        mov     eax, ebx
        mul     [@@wg]
        shr     eax, 8
        add     eax, [@@g]
        mov     [@@newg], eax
        
        mov     eax, ebx
        mul     [@@wb]
        shr     eax, 8
        add     eax, [@@b]
        mov     [@@newb], eax

        xor     eax, eax
        mov     ah, [b @@newb]
        shl     eax, 8
        mov     ah, [b @@newg]
        mov     al, [b @@newr]

        mov     [esi], eax

        add     ebx, 2
        add     esi, 4
        dec     ecx
        jnz     @@do_1_white_shade

        ret

align 4
@@r     dd 0
@@g     dd 0
@@b     dd 0
@@wr    dd 0
@@wg    dd 0
@@wb    dd 0
@@newr  dd 0
@@newg  dd 0
@@newb  dd 0

endp

;

struc   node
colour          dd ?
darker          dd ?
brighter        dd ?
ends

align 32
proc    count_colours n

        msg     "Counting colours... "

        mov     ecx, -1
        call    new
        jc      error

        mov     [colour_tree], eax
        mov     [colour_tree_end], eax
        shr     ecx, 4
        dec     ecx
        mov     [max_colours], ecx

        mov     ecx, [pcx_height]
        shl     ecx, 8
        mov     esi, [rgb_data]

        mov     eax, [esi]
        xor     ebx, ebx
        mov     edi, [colour_tree]
        mov     [edi + node.colour], eax
        mov     [edi + node.brighter], ebx
        mov     [edi + node.darker], ebx
        add     [colour_tree_end], size node
        inc     [num_colours]
        dec     ecx
        add     esi, 4

@@count_colours:
        push    ecx esi
        mov     eax, [esi]
        call    add_colour
        pop     esi ecx

        mov     eax, [num_colours]
        cmp     eax, [max_colours]
        ja      error

        add     esi, 4
        dec     ecx
        jnz     @@count_colours

        mov     eax, [num_colours]
        mov     ebp, 10
        call    printnum
        endl

        mov     eax, [colour_tree]
        mov     ecx, [num_colours]
        shl     ecx, 4
        call    shrink
        jc      error

        ret

endp

align 4
colour_tree     dd ?
colour_tree_end dd ?
max_colours     dd ?
num_colours     dd 0

;

align 32
proc    add_colour n

        mov     edi, [colour_tree]
        mov     edx, [colour_tree_end]

@@cmp_bit:
        cmp     eax, [edi + node.colour]
        ja      @@goto_brighter

        jb      @@goto_darker

        ret
                                 
@@goto_darker:
        mov     ebx, [edi + node.darker]
        test    ebx, ebx
        jz      @@add_darker

        mov     edi, ebx
        jmp     @@cmp_bit

@@add_darker:
        mov     [edi + node.darker], edx
        mov     [edx + node.colour], eax
        mov     [edx + node.brighter], ebx
        mov     [edx + node.darker], ebx
        add     [colour_tree_end], size node
        inc     [num_colours]
        ret

@@goto_brighter:
        mov     ebx, [edi + node.brighter]
        test    ebx, ebx
        jz      @@add_brighter

        mov     edi, ebx
        jmp     @@cmp_bit

@@add_brighter:
        mov     [edi + node.brighter], edx
        mov     [edx + node.colour], eax
        mov     [edx + node.brighter], ebx
        mov     [edx + node.darker], ebx
        add     [colour_tree_end], size node
        inc     [num_colours]
        ret

endp

;
                          
align 32
proc    posturize_dump n

        msg     "Posturizing data"
        endl

        mov     ecx, [pcx_height]
        shl     ecx, 8
        mov     esi, [rgb_data]

@@posturize:
        and     [d esi], 0fcfcfch
        add     esi, 4
        dec     ecx
        jnz     @@posturize

        ret

endp

;

align 32
proc    convert_inputfiles n

        msg     " Converting input files"
        endl

        mov     ecx, [pcx_height]
        shl     ecx, 8 + 2
        call    new
        jc      error

        mov     [rgb_data], eax

        mov     ecx, [num_input_files]
        mov     esi, o dump_ptrs
        mov     edi, [rgb_data]

@@cvt_file:
        push    esi
        mov     esi, [esi]

        msg     "  Converting file"
        endl

        call    decompress_pcx_32

        mov     eax, [pcx_y]
        shl     eax, 10
        add     edi, eax

        mov     eax, esi
        call    delete
        jc      error

        pop     esi
        add     esi, 4
        dec     ecx
        jnz     @@cvt_file

        ret

endp

align 4
rgb_data        dd ?

;

align 32
proc    dump_inputfiles

        msg     " Dumping input files"
        endl

        mov     ecx, [cfg_file_size]
        mov     esi, [cfg_file_mem]

@@get_files:
        mov     edx, o whitespace
        mov     edi, o token
        call    gettoken
        jc      @@done

        push    ecx esi

        msg     "  Checking and dumping: "
        xor     eax, eax
        xor     ecx, ecx
        mov     edx, o token
        call    strprint
        endl

        mov     edx, o token
        call    openfile
        jc      error

        call    filesize
        jc      error

        mov     ecx, eax
        call    new
        jc      error

        mov     edx, [num_input_files]
        lea     edx, [edx*4 + o dump_ptrs]
        mov     [edx], eax
        mov     edx, eax
        call    readfile
        jc      error

        call    closefile
        jc      error

        mov     esi, edx
        call    pcx_size
        jc      error

        cmp     eax, 256
        jne     error

        add     [pcx_height], ebx

        inc     [num_input_files]

        pop     esi ecx
        jmp     @@get_files

@@done:
        cmp     [num_input_files], 0
        je      error

        ret

endp

align 4
num_input_files dd 0
dump_ptrs       dd 4096 dup ( ? )
pcx_height      dd 0

token   db 1024 dup ( ? )
whitespace      db 13, 10, 26, 9, ' ', 0

;
;data

;

ends    code32
        end


