program RAWDemo;

uses crt;

var n1,n2 : word;

procedure SaveRAW(Name:string);
var f : file;

begin
  assign(f,Name);
  rewrite(f,1);                        { Datei erstellen }
  blockwrite(f,mem[$A000:0],64000);
  { Ab Adresse $A000:0 64000 Byte lesen und in die Datei schreiben }
  close(f);                            { Datei wieder schlieen }
end;

procedure LoadRAW(Name:string);
var f : file;

begin
  assign(f,Name);
  reset(f,1);                          { Datei fr Lesezugriff vorbereiten }
  blockread(f,mem[$A000:0],64000);
  { 64000 Byte aus Datei lesen und in den Bildschirmspeicher schreiben }
  close(f);
end;

procedure GetPal(col:byte;var r,g,b:byte);
begin
  port[$3C7] := Col;
  r := port[$3C9];
  g := port[$3C9];
  b := port[$3C9];
end;

procedure SetPal(col:byte;r,g,b:byte);
begin
   port[$3C8] := Col;
   port[$3C9] := r;
   port[$3C9] := g;
   port[$3C9] := b;
end;

procedure SavePal(Name:string);
var f   : file;
    n   : byte;
    RGB : array[1..3] of byte;

begin
  assign(f,Name);
  rewrite(f,1);
  for n := 0 to 255 do begin
    getpal(n,RGB[1],RGB[2],RGB[3]);
    blockwrite(f,RGB,3);
  end;
  close(f);
end;

procedure LoadPal(Name:string);
var f   : file;
    n   : byte;
    RGB : array[1..3] of byte;

begin
  assign(f,Name);
  reset(f,1);
  for n := 0 to 255 do begin
    blockread(f,RGB,3);
    setpal(n,RGB[1],RGB[2],RGB[3]);
  end;
  close(f);
end;


begin
  repeat
    clrscr;
    writeln('Bitte whlen:');
    writeln;
    writeln('1 - Bild aufbauen und BILD.RAW und BILD.PAL auf Platte schreiben');
    writeln('2 - BILD.RAW und BILD.PAL von Platte lesen und anzeigen');
    writeln('3 - Ende');
    case readkey of
      '1' : begin
              asm mov ax,13h; int 10h end;
              for n1 := 1 to 150 do                     { Palette setzen }
                SetPal(n1,30+n1 div 6,20+n1 div 7,10+n1 div 7);
              for n1 := 1 to 104 do
                SetPal(150+n1,0,20+n1 div 4,30+n1 div 5);
              for n1 := 0 to 319 do                      { Bild aufbauen }
                for n2 := 0 to 199 do
                  mem[$A000:n2*320+n1]:=151+(n1*n1+n2*n2) mod 104;
              readkey;
              SaveRAW('PART06_A.RAW');        { Bild sichern }
              SavePAL('PART06_A.PAL');        { Palette sichern }
              asm mov ax,3; int 10h end;
            end;
      '2' : begin
              asm mov ax,13h; int 10h end;
              LoadPAL('PART06_A.PAL');        { Palette laden }
              LoadRAW('PART06_A.RAW');        { Bild laden }
              readkey;
              asm mov ax,3; int 10h end;
            end;
      '3' : halt;
    end;
  until false;
end.
