{$N+,E+}
program Fraktale;

uses crt;

{ Diese Konstanten knnen verndert werden, um das Aussehen der Fraktale zu
  bestimmen. }
const Colors = 32;         { Anzahl der Farben des Fraktals }
      Width = 320;         { Breite des Fraktals }
      Height = 200;        { Hhe des Fraktals }
      Limit = 8.0;         { Berechnungsgrenze, regelt Schrfe }
      XRMin = -2.0;        { Linke Grenze des Fraktals }
      XRMax = 1.0;         { Rechte Grenze des Fraktals }
      YRMin = -1.3;        { Obere Grenze des Fraktals }
      YRMax = 1.3;         { Untere Grenze des Fraktals }

type real = double;        { Zur Optimierung der Fliekomma-Berechnungen }

var XPos,YPos : word;
    RealP,ImagP : real;
    CurrX,CurrY : real;
    a2,b2 : real;
    n : byte;

function CalcColorMandel(XPos,YPos:word) : byte;
begin
  CurrX := XPos / Width * (XRMax-XRMin) + XRMin;
  CurrY := YPos / Height * (YRMax-YRMin) + YRMin;
  RealP := 0;
  ImagP := 0;
  n := 0;
  repeat
    a2 := sqr(RealP);
    b2 := sqr(ImagP);
    ImagP := 2 * RealP * ImagP + CurrY;
    RealP := a2 - b2 + CurrX;
    inc(n);
  until (n >= Colors) or (a2+b2 >= Limit);
  CalcColorMandel := n - 1;
end;

function CalcColorJulia(XPos,YPos:word) : byte;
begin
  CurrX := 0.07;
  CurrY := -0.4;
  RealP := -2 + 0.5 + XPos / (Width/3);
  ImagP := 2 - 0.5 - YPos / (Height/3);
  n := 0;
  repeat
    a2 := sqr(ImagP) - sqr(RealP) + CurrX;
    b2 := 2 * RealP * ImagP + CurrY;
    RealP := a2;
    ImagP := b2;
    inc(n);
  until (n >= Colors) or (sqr(a2)+sqr(b2) > 4) or
        (abs(a2) > 2) or (abs(b2) > 2);
  CalcColorJulia := n - 1;
end;


begin
  asm mov ax,13h; int 10h end;   { In Mode 13h schalten }
  for YPos := 0 to Height-1 do   { Mandelbrot-Menge aufbauen }
    for XPos := 0 to Width-1 do
      mem[$A000:YPos*320+XPos] := CalcColorMandel(XPos,YPos);
  readkey;
  for YPos := 0 to Height-1 do   { Julia-Menge aufbauen }
    for XPos := 0 to Width-1 do
      mem[$A000:YPos*320+XPos] := CalcColorJulia(XPos,YPos);
  readkey;
  asm mov ax,3; int 10h end;     { Zurck zum Textmodus }
end.
