Program Load_Module_File;                    { By Vulture/Outlaw Triad }

Uses Crt,Dos;                                { Used units }

Type Sample = Array[0..65528] of Byte;       { One sample }
     Pattern = Array[0..63,0..15] of Byte;   { Define a pattern }
     Patptr = ^Pattern;                      { Pointer to pattern }

Var F: File;
    Module_Header: Array[0..1083] of Byte;   { Total module header }
    Module_Name: String[20];                 { Name of mod }
    Module_Type: String[4];                  { Module type }
    Channels: Byte;                          { # of channels }
    Song_Length: Byte;                       { Total # of patterns }
    Number_Of_Patterns: Byte;                { # of physical patterns }
    Order: Array[0..127] of Byte;            { Order to play patterns }
    Patterns: Array[0..255] of PatPtr;       { Pattern data }
    Modfile: String;                         { Physical file (path/name) }
    Mod_Loaded: Boolean;                     { True if .mod was loaded }
    Key: Char;                               { For intercepting a keypress }

    Sample_Data: Array[1..31] of Pointer;    { Pointers to actual sample data }
    Sample_Size: Array[1..31] of Word;       { Samples sizes }
    Sample_Name: Array[1..31] of String[22]; { Names of samples }
    Sample_Loopstart: Array[1..31] of Word;  { Loop start of samples }
    Sample_Looplength: Array[1..31] of Word; { Loop length of samples }
    Sample_Volume: Array[1..31] of Byte;     { Volume of samples }
    Sample_Ftune: Array[1..31] of Shortint;  { Finetune of samples }

Function FileExist(Filename: String):Boolean;     { Check for file existance }
Var S: SearchRec;
Begin
  Findfirst(Filename, Anyfile, S);
  FileExist := (DosError = 0);
End;

Function Convert_Word(w: Word): Word; Assembler;  { Converts Amiga word }
Asm
  mov ax,w
  xchg ah,al
End;

Procedure Error(Exit_String: String);             { Quit on error }
Begin
  ClrScr;
  Writeln(Exit_String);
  Close(F);
  Halt(1);
End;

Procedure Get_Sample_Info;                        { Gets sample info }
Var Loop1,Offset: Word;
    S_Name: String[22];
    S_Length: Word;
    F_Tune: Shortint;
    Volume: Byte;
    L_Start: Word;
    L_Length: Word;
Begin
  Offset := 20;                                   { Point to sample 1 }
  For Loop1 := 1 to 31 do
  Begin
    S_Name[0] := #22;
    Move(Module_Header[Offset],S_Name[1], 22);    { Get sample name }
    Move(Module_Header[Offset+22],S_Length,2);
    S_Length := Convert_Word(S_Length) shl 1;     { Get sample length }
    Move(Module_Header[Offset+24],F_Tune,1);      { Get fine tune }
    If F_Tune > 7 then Dec(F_Tune,16);
    Move(Module_Header[Offset+25],Volume,1);      { Get sample volume }
    Move(Module_Header[Offset+26],L_Start,2);
    L_Start := Convert_Word(L_Start) shl 1;       { Get loop start }
    Move(Module_Header[Offset+28],L_Length,2);
    L_Length := Convert_Word(L_Length) shl 1;     { Get loop length }

    Sample_Size[Loop1] := S_Length;               { Store in arrays }
    Sample_Name[Loop1] := S_Name;
    Sample_Loopstart[Loop1] := L_Start;
    Sample_Looplength[Loop1] := L_Length;
    Sample_Volume[Loop1] := Volume;
    Sample_Ftune[Loop1] := F_Tune;

    Inc(Offset,30);                               { Point to next sample }
  End;
End;

Procedure Get_Patterns;
Var Loop1: Word;
Begin
  For Loop1 := 0 to Number_Of_Patterns Do         { Get all patterns }
  Begin
    If MaxAvail < 1024 then Error('Not enough free memory to load patterns!');
    Getmem(Patterns[Loop1],1024);                 { Setup memory }
    Blockread(F,Patterns[Loop1]^,1024);           { Read total pattern }
  End;
End;

Procedure Get_Samples;
Var Loop1,Loop2: Word;
    P: Pointer;
Begin
  For Loop1 := 1 to 31 Do                         { Get actual samples }
  Begin
    If Sample_Size[Loop1] > 0 then                { Only if data exists }
    Begin
      If MaxAvail < Sample_Size[Loop1] then Error('Not enough free memory to load samples!');
      Getmem(P,Sample_Size[Loop1]);               { Read and convert sample }
      Blockread(F, P^, Sample_Size[Loop1]);
      For Loop2 := 0 to Sample_Size[Loop1] do Inc(Sample(P^)[Loop2],128); { Add 128 to every byte! }
      Sample_Data[Loop1] := P;                    { Store the pointer }
    End;
  End;
End;

Procedure Load_Module(Module: String);            { Loads a .mod into memory }
Var Loop1: Byte;
Begin
  If not (FileExist(Module)) then                 { File does not exist? }
  Begin
    Writeln('File does not exist!');
    Halt(1);                                      { Then quit }
  End;

  Modfile := Module;
  Assign(F, Module);                              { Else open file }
  Reset(F,1);
  Blockread(F, Module_Header, 1084);              { Read entire header }

  Module_Name[0] := #20;
  Move(Module_Header[0],Module_Name[1],20);       { Store module name }

  Move(Module_Header[950],Song_length,1);         { Store # of different patterns }
  Move(Module_Header[952],Order[0],128);          { Store playing order }
  Number_Of_Patterns := 0;
  For Loop1 := 0 to 127 do                        { Store total # of patterns to play }
    If Order[Loop1] > Number_Of_Patterns then Number_Of_Patterns := Order[Loop1];

  Module_Type[0] := #4;
  Move(Module_Header[1080],Module_Type[1],4);     { Store module type }
  If (Module_Type = 'M.K.') or
     (Module_Type = 'FLT4') or
     (Module_Type = '4CHN') then Channels := 4    { Set # of channels }
  else Error('Unsupported file format!');

  Get_Sample_Info;                                { Store sample information }
  Get_Patterns;                                   { Store pattern data }
  Get_Samples;                                    { Store the actual samples }

  Mod_Loaded := True;                             { Memory allocated }
  Close(F);
End;

Procedure Free_Module;                            { Free memory used by .mod }
Var Loop1: Word;
Begin
  For Loop1 := 0 to Number_Of_Patterns Do Freemem(Patterns[Loop1],1024);
  For Loop1 := 1 to 31 Do If Sample_Size[Loop1] > 0 then Freemem(Sample_Data[Loop1],Sample_Size[Loop1]);
  Mod_Loaded := False;                            { Module unloaded }
End;

Procedure Show_Mod_Info;
Var Loop1: Byte;
Begin
  ClrScr;
  GotoXY(1,1);
  Write('Module name       : '); Writeln(Module_Name:20);
  Write('Filename          : '); Writeln(Modfile);
  Write('Module type       : '); Writeln(Module_Type);
  Write('Channels          : '); Writeln(Channels);
  Write('Patterns to play  : '); Writeln(Song_Length);
  Write('Physical patterns : '); Writeln(Number_of_Patterns);
  Writeln;
  Write('Playing order: ');
  For Loop1 := 0 to Song_Length-1 do
  Begin
    Write(Order[Loop1]);
    If Loop1 < Song_Length then Write(',');
  End;
  Writeln;
  Writeln;
  Write('Press ESCAPE to exit...');
End;

Begin
  If Paramcount = 0 then
  Begin
    Writeln('Specify module on commandline parameter!');
    Halt(1);
  End
  Else Load_Module(Paramstr(1));

  Show_Mod_Info;
  Repeat
    Key := Readkey;
  Until Key = #27;
  Free_Module;

  ClrScr;
  Writeln('        ');
  Writeln('                    - An Outlaw Triad Production (c) 1997 -');
  Writeln;
  Writeln('                             CodeVulture');
  Writeln;
  Writeln('                            -= Outlaw Triad is =-');
  Writeln;
  Writeln('  Vulture/code  Archangel/artist  Troop/sysop  Xplorer/artist  Inopia/code');
  Writeln;
  Writeln('');
End.