@echo off
cls

@echo This batch file will recompile all the examples using the "-b" option
@echo for building. All the asm files are assembled using TASM. Be aware
@echo that the heap is reduced to zero! (see sds.doc [2.2])
@echo This operation could take a while... Press "CR" to start compilation
@echo or ^C to stop now.
pause

?"Compile the kernel ? (y/n)" goto :kc
goto :next2

:kc
@echo --- SDS --------------------------------------------------------------------
cd kernel
tasm /mx /o /w0 sds
if NOT errorlevel == 0 goto :error
tasm /mx /o /w0 sds_det
if NOT errorlevel == 0 goto :error
cd ..
cls

:next2
?"Compile the normal examples ? (y/n)" goto :ec
goto :next3

:ec
@echo --- PLAYER -----------------------------------------------------------------
tpc -b -ulib examples\players\player.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- PLAYER2 ----------------------------------------------------------------
tpc -b -ulib examples\players\player2.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- PLAYER3 ----------------------------------------------------------------
tpc -b -ulib examples\players\player3.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- PLY_FX -----------------------------------------------------------------
tpc -b -ulib examples\fx\ply_fx.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- SDMPLAY ----------------------------------------------------------------
tpc -b -ulib examples\players\sdmplay.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- M2SDM ------------------------------------------------------------------
tpc -b -ulib examples\others\m2sdm.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- BGPLAYER ---------------------------------------------------------------
tpc -b -ulib examples\players\bgplayer.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- TESTLOAD ---------------------------------------------------------------
tpc -b -ulib examples\others\testload.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- WATCH ------------------------------------------------------------------
tpc -b -ulib examples\others\watch.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- DETECT -----------------------------------------------------------------
tpc -b -ulib examples\others\detect.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- TESTSPD ----------------------------------------------------------------
tpc -b -ulib examples\others\testspd.pas
if NOT errorlevel == 0 goto :error
cls

@echo --- POLL -----------------------------------------------------------------
tpc -b -ulib examples\sync\poll.pas
if NOT errorlevel == 0 goto :error
cls

:next3

?"Compile the sync examples, too ? (y/n)" goto :all
goto :outta

:all
@echo --- Pascal sync demo -----------------------------------------------------
cd examples\sync\pas
tasm xmode
tpc -b xmode.pas
tpc -b demo.pas
if NOT errorlevel == 0 goto :error
del xmode.obj
cd ..\..\..
cls

@echo --- Assembler sync demo --------------------------------------------------
cd examples\sync\asm
tasm demo
tlink /3 demo
if NOT errorlevel == 0 goto :error
del demo.map
del demo.obj
cd ..\..\..
cls

@echo --- C++ sync demo --------------------------------------------------------
cd examples\sync\bc31
bcc -3 demo.cpp
if NOT errorlevel == 0 goto :error
del demo.obj
cd ..\..\..
cls

@echo --- PMODE sync demo -------------------------------------------------------
cd examples\sync\pmode
make
if NOT errorlevel == 0 goto :error
del *.obj
cd ..\..\..
cls

@echo --- WATCOM C++ 10.0 sync demo ---------------------------------------------
cd examples\sync\watcom
rem compile.bat
wcl386 /5r -oneatx demo.cpp
if NOT errorlevel == 0 goto :error
del *.obj
cd ..\..\..
cls

@echo ----------------------------------------------------------------------------
@echo Examples have been compiled. The TBASIC sync demo (examples\sync\tbas\demo.bas)
@echo has to be compiled separately (run "TB.EXE demo.bas"). If you don't have TB.EXE
@echo that's okay, the DEMO.EXE file is included anyway... enjoy! :-)
@echo Run batch files from examples\sync to see the poll-example programs.
goto :outta

:error
@echo ERROR!

:outta
