;-----------------------------------------------------------------------------
; Sound Deluxe System 5, a Maple Leaf production, 1996-1997
; Small demo using poll mode
;-----------------------------------------------------------------------------
;
; Original code by Vulture/Outlaw Triad, 6-9-95
; Adapted for SDS, speedups and other changes by Maple Leaf, 1997
;
;-----------------------------------------------------------------------------

polled   = 1    ; 1 for polling music
doubled  = 1    ; 1 for 2x2 "pixels"  (if your VGA is fast enough!)

IDEAL                           ; Ideal mode
P386                            ; Allow 80386 instructions
JUMPS                           ; Tasm handles out of range jumps (rulez!:))

SEGMENT CODE                    ; Code segment starts
ASSUME cs:code,ds:code          ; Let cs and ds point to code segment

ORG 0

START:                          ; Main program

if polled ne 0
    ; SDS detection shit...  --------------------------------------------
    push    0
    pop     es
    lds     si,[dword ptr es:4FCh]
    mov     eax,[si+64]         ; read magic
    cmp     eax,35534453h       ; SDS bg session ?
    je      okay1               ; yup! found!
    push    cs
    pop     ds
    mov     dx,offset no_sds
    mov     ah,9
    int     21h                 ; error message
    mov     ax,4c00h
    int     21h                 ; and get the fuck outta here
okay1:
    mov     eax,[si]
    mov     [dword ptr cs:poll],eax
    ;-------------------------------------------------------------------
endif

    call    InitVideo           ; init vga mode and palette

    mov     [DeltaX],2          ; Initial speed of rotation
    mov     [DeltaY],1          ;
    mov     [DeltaZ],-1         ;

    mov     [Xoff],256
    mov     [Yoff],256          ; Used for calculating vga-pos
    mov     [Zoff],300          ; Distance from viewer

MainLoop:

    call    MainProgram         ; this will do all the shit

    in      al,60h              ;
    cmp     al,1                ;
    jne     MainLoop            ; until ESC is pressed

    mov     ax,3
    int     10h                 ; Back to textmode
    lea     dx,[Credits]
    mov     ah,9
    int     21h

    mov     ax,4c00h            ; Return control to DOS
    int     21h                 ;

;=== Routines ================================================================

PROC InitVideo near
    mov     ax,0013h            ; Init vga
    int     10h
    mov     ax,cs
    mov     ds,ax               ; ds points to codesegment
    mov     ax,0a000h
    mov     es,ax               ; es points to vga
    lea     si,[Palette]        ; Set palette
    mov     dx,3c8h
    xor     al,al
    out     dx,al
    mov     dx,3c9h
    mov     cx,189*3
    repz    outsb
    mov     di,0
    mov     cx,32000
    mov     al,BackGround
    mov     ah,al
    rep     stosw
    retn
ENDP InitVideo

PROC Retrace                    ; Waits for vertical retrace
    mov     dx,3dah
vr1:in      al,dx
    test    al,8
    jnz     vr1                 ; Wait until Verticle Retrace starts
vr2:in      al,dx
    test    al,8
    jz      vr2                 ; Wait until Verticle Retrace ends
    ret
ENDP Retrace

PROC UpdateAngles
; Calculates new x,y,z angles
; to rotate around
    mov     ax,[XAngle]         ; Load current angles
    mov     bx,[YAngle]
    mov     cx,[ZAngle]

    add     ax,[DeltaX]         ; Add velocity
    and     ax,0FFh             ; Range from 0..255
    mov     [XAngle],ax         ; Update X
    add     bx,[DeltaY]         ; Add velocity
    and     bx,0FFh             ; Range from 0..255
    mov     [YAngle],bx         ; Update Y
    add     cx,[DeltaZ]         ; Add velocity
    and     cx,0FFh             ; Range from 0..255
    mov     [ZAngle],cx         ; Update Z
    ret
ENDP UpdateAngles

PROC GetSinCos
; Needed : bx=angle (0..255)
; Returns: ax=Sin   bx=Cos
    push    bx                  ; Save angle (use as pointer)
    add     bx,bx               ; Grab a word so bx=bx*2
    mov     ax,[SinCos + bx]    ; Get sine
    pop     bx                  ; Restore pointer into bx
    push    ax                  ; Save sine on stack
    add     bx,64               ; Add 64 to get cosine
    and     bx,0FFh             ; Range from 0..255
    add     bx,bx               ; *2 coz it's a word
    mov     ax,[SinCos + bx]    ; Get cosine
    mov     bx,ax               ; Save it   bx=Cos
    pop     ax                  ; Restore   ax=Sin
    ret
ENDP GetSinCos

PROC SetRotation
; Set sine & cosine of x,y,z
    mov     bx,[XAngle]         ; Grab angle
    call    GetSinCos           ; Get the sine&cosine
    mov     [Xsin],ax           ; Save sin
    mov     [Xcos],bx           ; Save cos

    mov     bx,[Yangle]
    call    GetSinCos
    mov     [Ysin],ax
    mov     [Ycos],bx

    mov     bx,[Zangle]
    call    GetSinCos
    mov     [Zsin],ax
    mov     [Zcos],bx
    ret
ENDP SetRotation

PROC RotatePoint            ; Rotates the point around x,y,z
; Gets original x,y,z values
; This can be done elsewhere
    movsx   ax,[Cube+si]    ; si = X        (movsx coz of byte)
    mov     [X],ax
    movsx   ax,[Cube+si+1]  ; si+1 = Y
    mov     [Y],ax
    movsx   ax,[Cube+si+2]  ; si+2 = Z
    mov     [Z],ax

; Rotate around x-axis
; YT = Y * COS(xang) - Z * SIN(xang) / 256
; ZT = Y * SIN(xang) + Z * COS(xang) / 256
; Y = YT
; Z = ZT

    mov     ax,[Y]
    mov     bx,[XCos]
    imul    bx               ; ax = Y * Cos(xang)
    mov     bp,ax
    mov     ax,[Z]
    mov     bx,[XSin]
    imul    bx               ; ax = Z * Sin(xang)
    sub     bp,ax            ; bp = Y * Cos(xang) - Z * Sin(xang)
    sar     bp,8             ; bp = Y * Cos(xang) - Z * Sin(xang) / 256
    mov     [Yt],bp

    mov     ax,[Y]
    mov     bx,[XSin]
    imul    bx               ; ax = Y * Sin(xang)
    mov     bp,ax
    mov     ax,[Z]
    mov     bx,[XCos]
    imul    bx               ; ax = Z * Cos(xang)
    add     bp,ax            ; bp = Y * SIN(xang) + Z * COS(xang)
    sar     bp,8             ; bp = Y * SIN(xang) + Z * COS(xang) / 256
    mov     [Zt],bp

    mov     ax,[Yt]          ; Switch values
    mov     [Y],ax
    mov     ax,[Zt]
    mov     [Z],ax

; Rotate around y-axis
; XT = X * COS(yang) - Z * SIN(yang) / 256
; ZT = X * SIN(yang) + Z * COS(yang) / 256
; X = XT
; Z = ZT

    mov     ax,[X]
    mov     bx,[YCos]
    imul    bx               ; ax = X * Cos(yang)
    mov     bp,ax
    mov     ax,[Z]
    mov     bx,[YSin]
    imul    bx               ; ax = Z * Sin(yang)
    sub     bp,ax            ; bp = X * Cos(yang) - Z * Sin(yang)
    sar     bp,8             ; bp = X * Cos(yang) - Z * Sin(yang) / 256
    mov     [Xt],bp

    mov     ax,[X]
    mov     bx,[YSin]
    imul    bx               ; ax = X * Sin(yang)
    mov     bp,ax
    mov     ax,[Z]
    mov     bx,[YCos]
    imul    bx               ; ax = Z * Cos(yang)
    add     bp,ax            ; bp = X * SIN(yang) + Z * COS(yang)
    sar     bp,8             ; bp = X * SIN(yang) + Z * COS(yang) / 256
    mov     [Zt],bp

    mov     ax,[Xt]          ; Switch values
    mov     [X],ax
    mov     ax,[Zt]
    mov     [Z],ax

; Rotate around z-axis
; XT = X * COS(zang) - Y * SIN(zang) / 256
; YT = X * SIN(zang) + Y * COS(zang) / 256
; X = XT
; Y = YT

    mov     ax,[X]
    mov     bx,[ZCos]
    imul    bx               ; ax = X * Cos(zang)
    mov     bp,ax
    mov     ax,[Y]
    mov     bx,[ZSin]
    imul    bx               ; ax = Y * Sin(zang)
    sub     bp,ax            ; bp = X * Cos(zang) - Y * Sin(zang)
    sar     bp,8             ; bp = X * Cos(zang) - Y * Sin(zang) / 256
    mov     [Xt],bp

    mov     ax,[X]
    mov     bx,[ZSin]
    imul    bx               ; ax = X * Sin(zang)
    mov     bp,ax
    mov     ax,[Y]
    mov     bx,[ZCos]
    imul    bx               ; ax = Y * Cos(zang)
    add     bp,ax            ; bp = X * SIN(zang) + Y * COS(zang)
    sar     bp,8             ; bp = X * SIN(zang) + Y * COS(zang) / 256
    mov     [Yt],bp

    mov     ax,[Xt]          ; Switch values
    mov     [X],ax
    mov     ax,[Yt]
    mov     [Y],ax

    ret
ENDP RotatePoint

PROC ShowPoint ; Calculates screenposition and plots the point on the screen.
               ; ...some naive speed optimizations by Maple Leaf...


    mov      di,-1

;    mov     ax,[Xoff]           ; Xoff*X / Z+Zoff = screen x
;    mov     bx,[X]
;    imul    bx

    mov     ax,[X]
    cwd
    shld    dx,ax,8
    shl     ax,8                ; X*256

    mov     bx,[Z]
    add     bx,[Zoff]           ; Distance
    idiv    bx
    add     ax,[Mx]             ; Center on screen

    jl      not_shown
    cmp     ax,319
    jge     not_shown
    mov     bp,ax

;    mov     ax,[Yoff]           ; Yoff*Y / Z+Zoff = screen y
;    mov     bx,[Y]
;    imul    bx

    mov     ax,[Y]
    cwd
    shld    dx,ax,8
    shl     ax,8                ; Y*256

    mov     bx,[Z]
    add     bx,[Zoff]           ; Distance
    idiv    bx
    add     ax,[My]             ; Center on screen

    jl      not_shown
    cmp     ax,199
    jge     not_shown

;    mov     bx,320
;    imul    bx

    shl     ax,6                ;
    mov     di,ax               ;
    shl     ax,2                ;
    add     di,ax               ;
    add     di,bp               ; di = (y*320)+x

    mov     ax,[Z]              ; Get color from Z
    add     ax,100d             ; (This piece of code could be improved)

if doubled ne 0
    mov     ah,al
    mov     [word ptr es:di],ax     ; Place a dot in doubled mode
    mov     [word ptr es:di+320],ax ;
else
    mov     [byte ptr es:di],al ; Place a dot
endif

not_shown:
    mov     [Erase+si],di       ; Save position for erase

    ret
ENDP ShowPoint

;=== "main program"... =======================================================

PROC MainProgram

    call    UpdateAngles        ; Calculate new angles
    call    SetRotation         ; Find sine & cosine of those angles

    xor     si,si               ; First 3d-point
    mov     cx,MaxPoints

ShowLoop:

    call    RotatePoint         ; Rotates the point
    call    ShowPoint           ; Shows the point
    add     si,3                ; Next 3d-point!
    dec     cx
    jnz     ShowLoop

if polled ne 0
    call    [dword ptr cs:poll] ; Right before waiting for vertical retrace
                                ; to start, we have a lot of dead time which
                                ; can be used by SDS to keep up the music.
                                ; This is done by invoking the poll routine.
endif

    call    Retrace             ; Wait for retrace

  ; The points have been drawn and shown onto the screen for a while, so
  ; it's now time to delete them. Since their offsets onto the screen have
  ; been kept up in some special buffer, all we have to do is to delete
  ; them using this buffer - much faster this way than erasing the whole
  ; screen again and again...

    xor     si,si               ; Starting with point 0
    mov     al,BackGround
    mov     ah,al
    mov     cx,MaxPoints
    mov     bx,3

Deletion:
    mov     di,[Erase+si]       ; di = vgapos old point

    cmp     di,-1
    je      @next               ; no deletion if offset is -1

if doubled ne 0
    mov     [word ptr es:di],ax ; Delete it in 2x2 (doubled) mode
    mov     [word ptr es:di+320],ax
else
    mov     [byte ptr es:di],al ; Delete it
endif

@next:
    add     si,bx                ; Next point
    dec     cx
    jnz     Deletion

    ret

ENDP MainProgram

;=== DATA ====================================================================

Credits   DB   "Sound Deluxe System 5, small demo example using poll mode.",13,10
          DB   "Original code by Vulture/Outlaw Triad (thanx!)",13,10
          DB   "Adapted version for SDS by Maple Leaf, 1997",13,10,"$"
no_sds    DB   "Sorry, a SDS session must be active. Run _ASSEMB!.BAT instead.",13,10,"$"

Label SinCos Word       ; 256 values
dw 0,6,13,19,25,31,38,44,50,56
dw 62,68,74,80,86,92,98,104,109,115
dw 121,126,132,137,142,147,152,157,162,167
dw 172,177,181,185,190,194,198,202,206,209
dw 213,216,220,223,226,229,231,234,237,239
dw 241,243,245,247,248,250,251,252,253,254
dw 255,255,256,256,256,256,256,255,255,254
dw 253,252,251,250,248,247,245,243,241,239
dw 237,234,231,229,226,223,220,216,213,209
dw 206,202,198,194,190,185,181,177,172,167
dw 162,157,152,147,142,137,132,126,121,115
dw 109,104,98,92,86,80,74,68,62,56
dw 50,44,38,31,25,19,13,6,0,-6
dw -13,-19,-25,-31,-38,-44,-50,-56,-62,-68
dw -74,-80,-86,-92,-98,-104,-109,-115,-121,-126
dw -132,-137,-142,-147,-152,-157,-162,-167,-172,-177
dw -181,-185,-190,-194,-198,-202,-206,-209,-213,-216
dw -220,-223,-226,-229,-231,-234,-237,-239,-241,-243
dw -245,-247,-248,-250,-251,-252,-253,-254,-255,-255
dw -256,-256,-256,-256,-256,-255,-255,-254,-253,-252
dw -251,-250,-248,-247,-245,-243,-241,-239,-237,-234
dw -231,-229,-226,-223,-220,-216,-213,-209,-206,-202
dw -198,-194,-190,-185,-181,-177,-172,-167,-162,-157
dw -152,-147,-142,-137,-132,-126,-121,-115,-109,-104
dw -98,-92,-86,-80,-74,-68,-62,-56,-50,-44
dw -38,-31,-25,-19,-13,-6

Label Cube Byte           ; The 3d points (343)
       c = -60
       rept 8
         b = -60
         rept 8
           a = -50
           rept 3
             db a,b,c
             a = a + 15
           endm
           b = b + 20
         endm
         c = c + 20
       endm

Label Palette Byte
       db 0,20,0
       d = 63
       rept 63
         db 63-d,63-d,d
         db 63-d,63-d,d
         db 63-d,63-d,d
         d = d - 1
       endm

X      DW ?             ; X variable for formula
Y      DW ?
Z      DW ?

Xt     DW ?             ; Temporary variable for x
Yt     DW ?
Zt     DW ?

XAngle DW 0             ; Angle to rotate around x
YAngle DW 0
ZAngle DW 0

DeltaX DW ?             ; Amound Xangle is increased each time
DeltaY DW ?
DeltaZ DW ?

Xoff   DW ?
Yoff   DW ?
Zoff   DW ?             ; Distance from viewer

XSin   DW ?             ; Sine and cosine of angle to rotate around
XCos   DW ?
YSin   DW ?
YCos   DW ?
ZSin   DW ?
ZCos   DW ?

Mx     DW 160            ; Middle of the screen
My     DW 100

poll   DD 0

MaxPoints  EQU 8*8*3        ; Number of 3d Points
BackGround EQU 0

Erase  DW MaxPoints DUP (?)     ; Array for deletion screenpoints

ENDS CODE                       ; End of codesegment
END START                       ; The definite end.... :)




; You may use this code in your own productions but
; give credit where credit is due. Only lamers steal
; code so try to create your own 3d-engine and use
; this code as an example.
; Thanx must go to Arno Brouwer and Ash for releasing
; example sources.
;
;    Ciao dudoz,
;
;         Vulture / Outlaw Triad

; I agree. I haven't stolen, I've just "reused" an old program. Thanx to
; Vulture for releasing this small 3d-dot routine, and I hope he doesn't
; mind because I've extended it and included it into SDS5 package.
;                                                       Maple Leaf
;                                                             1997
