COMMENT $

     /-----------------------------------------------------------------\
     |  Sound Deluxe System 5                                          |
     |  by Maple Leaf (a.k.a Gruian Radu), 1996-1997                   |
     |   Gravis UltraSound driver                                     |
     |  (update 1.17, 15 May 1997, parts marked with ';*')             |
     |  *the final update of this driver* (got tired of its bugs)      |
     \-----------------------------------------------------------------/
$

gusDesc   db       "Gravis UltraSound driver v1.17"
          db       " (GF1 hardware mixing), "
          db       "by Maple Leaf, 1997"

; Functions' offsets table 

gus_driver dw       offset gus_InitDriver       ;; 1
           dw       offset gus_DoneDriver       ;; 2
           dw       offset gus_StartMixer       ;; 3
           dw       offset gus_StopMixer        ;; 4
           dw       offset gus_SetVoiceVolume   ;; 5
           dw       offset mx_GetVoiceVolume    ;; 6
           dw       offset gus_SetVoicePanning  ;; 7
           dw       offset mx_GetVoicePanning   ;; 8
           dw       offset gus_SetVoiceFreq     ;; 9
           dw       offset mx_GetVoiceFreq      ;; 10
           dw       offset gus_PlayVoice        ;; 11
           dw       offset gus_StopVoice        ;; 12
           dw       offset mx_SetGlobalVolume   ;; 13 emulation
           dw       offset gus_NOP              ;; 14 set amplification - N/A
           dw       offset gus_DoPoll           ;; 15 poll
           dw       offset gus_NOP              ;; 16 set master volume - N/A
           dw       offset gus_TickAwaited      ;; 17

; Driver's internal data 

gusBase   dw       220h    ; dafault base, overwritten by SDS anyway

gusRate   dw       44100, 44100, 44100, 44100, 44100, 44100, 44100, 44100
          dw       44100, 44100, 44100, 44100, 44100, 44100, 41160, 38587
          dw       36317, 34300, 32494, 30870, 29400, 28063, 26843, 25725
          dw       24696, 23746, 22866, 22050, 21289, 20580, 19916, 19293

gusVol    dw	   00000h,08f10h,09f10h,0ab50h,0af10h,0b970h,0bb50h,0bd30h
	  dw	   0bf10h,0c880h,0c970h,0ca60h,0cb50h,0cc40h,0cd30h,0ce20h
	  dw	   0cf10h,0d800h,0d880h,0d8f0h,0d970h,0d9e0h,0da60h,0dad0h
	  dw	   0db50h,0dbc0h,0dc40h,0dcb0h,0dd30h,0dda0h,0de20h,0de90h
	  dw	   0df10h,0df80h,0e800h,0e840h,0e880h,0e8b0h,0e8f0h,0e930h
	  dw	   0e970h,0e9a0h,0e9e0h,0ea20h,0ea60h,0ea90h,0ead0h,0eb10h
	  dw	   0eb50h,0eb80h,0ebc0h,0ec00h,0ec40h,0ec70h,0ecb0h,0ecf0h
	  dw	   0ed30h,0ed60h,0eda0h,0ede0h,0ee20h,0ee50h,0ee90h,0eed0h
	  dw	   0ef00h

gus_NOP:retn

;*****************************************************************************
;   InitDriver (AH=Irq, AL=Dma, DX=Port)
;*****************************************************************************

nproc   gus_InitDriver
        mov      cs:mxPort,dx     ; not really necessarry
        mov      cs:gusBase,dx
;       call     gusDisableOutput ; preventing clicks
        mov      ax,14
        call     gusReset         ; reset the GUS, set the # of voices to 14
;       call     gusEnableOutput
        retn
nendp   gus_InitDriver

;*****************************************************************************
;   DoneDriver ()
;*****************************************************************************

nproc   gus_DoneDriver
        push      ax
;       call      gusDisableOutput
        mov       ax,14
        call      gusReset
;       call      gusEnableOutput
        pop       ax
        retn
nendp   gus_DoneDriver

;*****************************************************************************
;   StartMixer (DX=Mixing speed, AX=# of voices)
;*****************************************************************************
                              
nproc   gus_StartMixer ; here DX's initial value does not matter
        push     ax bx

        ClipVoices 14, 32  ; min 14 voices, max 32 voices

        mov      cs:mxVoices,ax        ; Store max # of active voices
        call     gusSetActiveVoices

        mov      bx,ax
        dec      bx
        add      bx,bx
        mov      dx,cs:gusRate[bx]     ; the replay rate depends on the # of voices
        mov      cs:cmixspd,dx         ; MUST be set! (used later by some routines)
        and      edx,0FFFFh
        add      edx,edx
        mov      cs:mxmixspd,edx       ; not really necessarry
        call     gusBuildPeriods       ; Build GUS's frequency counters (FC)
        call     mxInitVars_stereo     ; Init mixer internal variables
        pop      bx ax
        retn
nendp   gus_StartMixer

;*****************************************************************************
;   StopMixer ()
;*****************************************************************************

nproc   gus_StopMixer   ; shot down all voices
;       call     gusDisableOutput  ; anticlick
        push     ax cx
        mov      cx,cs:mxVoices
        mov      ax,0008h     
gusL3:  call     gus_StopVoice         ; stop voice #AH
        call     gus_SetVoicePanning   ; set its panning to MIDDLE (8)
        inc      ah           
        loop     gusL3    
        pop      cx ax
        retn
nendp   gus_StopMixer


;*****************************************************************************
;   RampVolume (AH=voice, CL=startvol, CH=endvol, BL=rampRate)
;*****************************************************************************

ifdef gus_enable_ramp

grmode  db       0
grold   db       0
groldw  dw       0

nproc   gus_RampVolume

        push     ax bx cx dx

        mov      cs:grmode,0

        cmp      cl,ch
        je       grvo

;       cmp      cl,ch
        jb       grve1                   ; Start MUST BE less than End !!!!

        xchg     cl,ch
        or       cs:grmode,40h           ; negative direction ramping

grve1:  cmp      cl,4    ; 64 >> 4       ;
        jae      grve2                   ; the limits cannot be under 64
        mov      cl,4                    ; or above 4032 (unwanted effects)
grve2:  cmp      ch,252  ; 4032 >> 4     ;
        jbe      grve3                   ;
        mov      ch,252                  ;

grve3:
        ; select voice
        mov      dx,cs:gusBase
        add      dx,102h
        mov      al,ah
        out      dx,al
        out      dx,al
        out      dx,al

        ; first stop any other ramp
        inc      dx
        mov      al,0dh
        out      dx,al
        add      dx,2
        mov      al,3
        out      dx,al     ; manually stop the old ramp
        call     gusDelay  ;
        call     gusDelay  ; give it some time....

ifndef gus_predefined_ramp
        ; VolumeRate register
        sub      dx,2 ; Base+103h
        mov      al,6
        out      dx,al

        ; write Rate
        add      dx,2 ; Base+105h
        mov      al,bl
        out      dx,al
endif

        ; VolStart register
        sub      dx,2 ; Base+103h
        mov      al,7
        out      dx,al

        ; write volStart
        add      dx,2 ; Base+105h
        mov      al,cl
        out      dx,al

        ; VolEnd register
        sub      dx,2 ; Base+103h
        mov      al,8
        out      dx,al

        ; write volEnd
        add      dx,2 ; Base+105h
        mov      al,ch
        out      dx,al

        ; Volume control register
        sub      dx,2 ; Base+103h
        mov      al,8Dh
        out      dx,al

        ; read register
        add      dx,2 ; Base+105h
        in       al,dx

        ; ramping mode (pos/neg)
        and      al,0BFh
        or       al,cs:grmode
        mov      bh,al

        ; Volume control register
        sub      dx,2 ; Base+103h
        mov      al,0Dh
        out      dx,al

        ; SET RAMPING MODE!
        add      dx,2  ; Base+105h
        mov      al,bh
        out      dx,al

        ; give it some time..
        call     gusDelay

        ; write it again
        out      dx,al

grvo:   pop      dx cx bx ax
        retn
nendp   gus_RampVolume

endif

;*****************************************************************************
;   SetVoiceVolume (AH=voice, AL=volume)
;*****************************************************************************

nproc   gus_SetVoiceVolume

        call     mx_SetVoiceVolume    ; set SDS internal volumes

     ; scale volume with global volume (GUS global volume emulation)
        push     cx ax
        mul      byte ptr cs:GlobalVolume
        shr      ax,6    ; actualVolume:=volume*globalVolume/64
        pop      cx
        mov      ah,ch   ; voice #
        pop      cx

        push     bx cx dx ax

     ; select voice
        mov      dx,cs:gusBase
        add      dx,102h
        mov      al,ah
        out      dx,al
        out      dx,al
        out      dx,al

ifdef gus_enable_ramp
     ; GetVolume register                    ;*
        inc      dx ; base+103h              ;*
        mov      al,89h                      ;*
        out      dx,al                       ;*
                                             ;*
     ; get old volume                        ;*
        inc      dx ; base+104h              ;*
        in       ax,dx                       ;*
        sub      dx,2                        ;*
        mov      cs:grold,ah                 ;*
        and      al,0F0h                     ;*
        mov      cs:groldw,ax                ;*
endif

     ; SetVolume register
        inc      dx  ; Base+103h
        mov      al,9
        out      dx,al

     ; extract gus logarithmic volume
        pop      bx
        push     bx
        mov      bh,0
        add      bx,bx
        mov      ax,cs:gusVol[bx]

ifdef gus_enable_ramp
        push     ax                 ;*
        mov      ax,cs:groldw       ;*
endif

     ; write logarithmic volume
        inc      dx     ; Base+104h
        out      dx,ax  ; write 16-bit volume

     ; a small delay ...
        call     gusDelay

     ; and write it again (avoid auto-modification)
        out      dx,ax

ifdef gus_enable_ramp
        pop      ax                 ;*  ; now some volume rampings....
                                    ;*  ; ultraclicks suck....
        mov      cl,cs:grold        ;*  ; START VOL
        mov      ch,ah              ;*  ; END VOL
        mov      bl,gus_RAMP_RATE   ;*  ; RATE
        pop      ax                 ;*  ; VOICE #
        push     ax                 ;*  ;
        call     gus_RampVolume     ;*  ;
                                    ;*
        call     gusDelay           ;*
        call     gusDelay           ;*
endif

        pop      ax dx cx bx
        retn
nendp   gus_SetVoiceVolume

;*****************************************************************************
;   SetVoicePanning (AH=voice, AL=balance)
;*****************************************************************************

nproc   gus_SetVoicePanning

        call     mx_SetVoicePanning  ; set SDS internal pannings

        push     dx ax

     ; select voice
        mov      dx,cs:gusBase
        add      dx,102h
        mov      al,ah
        out      dx,al
        out      dx,al
        out      dx,al

     ; Balance control register
        inc      dx   ; Base+103h
        mov      al,0Ch
        out      dx,al

     ; write new balance
        pop      ax
        add      dx,2  ; Base+105h
        out      dx,al   ; MUST be between 0-15 !!!

        call     gusDelay    ; delay and write it again...
        out      dx,al       ;

        pop      dx

        retn
nendp   gus_SetVoicePanning

;*****************************************************************************
;   SetVoiceFreq (AH=voice, CX=period)
;   Note: CX is the amiga period!
;   gus_freq=FreqTab[cx]  (see gusBuildPeriods for info)
;*****************************************************************************

nproc   gus_SetVoiceFreq

        call     mx_SetVoiceFreq  ; set SDS internal freq.

        push     dx ax bx

     ; select voice
        mov      dx,cs:gusBase
        add      dx,102h
        mov      al,ah
        out      dx,al
        out      dx,al
        out      dx,al

     ; Frequency control register
        inc      dx   ; Base+103h
        mov      al,1 ; FC register
        out      dx,al

     ; extract log. frequency and set it
        mov      bx,cx
        shl      bx,2
        mov      ax,word ptr cs:FreqTab[bx] ; here FreqTab table is used to keep the GUS frequency counters
        inc      dx    ; Base+104h
        out      dx,ax

        call     gusDelay  ; delay and write it again ...
        out      dx,ax     ;

        pop      bx ax dx

        retn
nendp   gus_SetVoiceFreq

;*****************************************************************************
;   PlayVoice (AH=voice, CX=size, DX=LoopStart, SI=LoopEnd, EDI=address,
;              AL=RelStartPos/256)
;     Notes  : For GUS: EDI=physical DRAM address
;                  : the loop is quite bad implemented yet... sorry
;*****************************************************************************

Cpos    dd       0
Cstart  dd       0
Cend    dd       0
C_ls    dd       0
C_le    dd       0

nproc   gus_PlayVoice

        push     eax

        push     bx
        movzx    bx,ah
        shl      bx,2
        cmp      si,0FFFFh   ; no loop ?
        je       guse80
        mov      cx,si
guse80: mov      word ptr cs:VoiceSize[bx],cx       ; Set size
        mov      word ptr cs:C_le,cx
        mov      word ptr cs:VoiceLoopStart[bx],dx  ; Set loop start
        mov      word ptr cs:C_ls,dx
        mov      word ptr cs:VoiceLoopEnd[bx],si    ; Set loop end
        mov      cs:VoiceSeg[bx],edi                ; Set DRAM address
        push     eax
        shl      eax,8+16
        mov      cs:VoicePos[bx],eax                ; Init position and carry-flag (for "set sample offset" command)
        pop      eax
        pop      bx

     ; select GUS voice
        mov      al,ah
        mov      dx,cs:gusBase
        add      dx,102h
        out      dx,al
        out      dx,al
        out      dx,al

     ; compute current position into DRAM and save it into Cpos
        pop      eax
        push     eax
        mov      ah,al
        and      eax,0000FF00h
        add      eax,edi
        mov      cs:Cpos,eax

     ; compute starting location into DRAM and save it into Cstart
        mov      eax,edi
        cmp      si,0FFFFh    ; no loop ?
        je       gusse55
        add      eax,cs:C_ls
gusse55:mov      cs:Cstart,eax

     ; compute ending location and save it into Cend
        mov      eax,edi
        add      eax,cs:C_le  ; loopend or size
        mov      cs:Cend,eax

     ; set current location HIGH
        mov      dx,cs:gusBase
        add      dx,103h      ; Base+103h
        mov      al,0Ah
        out      dx,al
        inc      dx           ; Base+104h
        mov      eax,cs:Cpos
        shr      eax,7
        and      eax,1FFFh
        out      dx,ax        ; set upper 13 bits of the address

     ; set current location LOW
        mov      al,0Bh
        dec      dx           ; Base+103h
        out      dx,al
        inc      dx           ; Base+104h
        mov      eax,cs:Cpos
        and      eax,7Fh
        shl      eax,9
        out      dx,ax        ; set lower 7 bits of the address

     ; a small delay and then write current location again
     ; (this must be done due to the fact that the actual location pointer
     ; may "jump" imediately after the operations above - see GUS SDK)
        call     gusDelay
        out      dx,ax
        mov      al,0Ah
        dec      dx           ; Base+103h
        out      dx,al
        inc      dx           ; Base+104h
        mov      eax,cs:Cpos
        shr      eax,7
        and      eax,1FFFh
        out      dx,ax        ; set upper 13 bits of the address

     ; set starting location HIGH
        mov      dx,cs:gusBase
        add      dx,103h      ; Base+103h
        mov      al,2
        out      dx,al
        inc      dx           ; Base+104h
        mov      eax,cs:Cstart
        shr      eax,7
        and      eax,1FFFh
        out      dx,ax        ; set upper 13 bits

     ; set starting location LOW
        dec      dx           ; Base+103h
        mov      al,3
        out      dx,al
        inc      dx           ; Base+104h
        mov      eax,cs:Cstart
        and      eax,7Fh
        shl      eax,9
        out      dx,ax        ; set lower 7 bits

     ; set ending location HIGH
        mov      dx,cs:gusBase
        add      dx,103h      ; Base+103h
        mov      al,4
        out      dx,al
        inc      dx           ; Base+104h
        mov      eax,cs:Cend
        shr      eax,7
        and      eax,1FFFh
        out      dx,ax        ; set upper 13 bits

     ; set ending location LOW
        dec      dx           ; Base+103h
        mov      al,5
        out      dx,al
        inc      dx           ; Base+104h
        mov      eax,cs:Cend
        and      eax,7Fh
        shl      eax,9
        out      dx,ax

     ; set Mode Bits
        mov      dx,cs:gusBase
        add      dx,103h      ; Base+103h
        xor      ah,ah        ; initially set to 0
        cmp      si,0FFFFh    ; no loop ?
        je       guse81
        or       ah,8         ; loop enabled
guse81: mov      al,0
        out      dx,al
        add      dx,2         ; Base+105h
        mov      al,ah
        out      dx,al        ; set mode (loop ON or OFF)

     ; start voice
        mov      dx,cs:gusBase
        mov      al,1
        out      dx,al
        add      dx,103h      ; Base+103h
        mov      al,4Ch       ; reset register
        out      dx,al
        add      dx,2         ; Base+105
        mov      al,3         ; DAC_Enable or Master_Reset = 2 or 1 = 3
        out      dx,al        ; do it

        pop      eax
        retn
nendp   gus_PlayVoice

;*****************************************************************************
;   StopVoice (AH=voice)
;*****************************************************************************

nproc   gus_StopVoice
        call     mx_StopVoice    ; set SDS internal data

        push     dx ax

     ; select voice
        mov      dx,cs:gusBase
        add      dx,102h
        mov      al,ah
        out      dx,al
        out      dx,al
        out      dx,al

     ; read Mode Bits
        inc      dx             ; Base+103h
        mov      al,80h
        out      dx,al
        add      dx,2           ; Base+105h
        in       al,dx
        mov      ah,al

     ; stop voice
        sub      dx,2           ; Base+103h
        mov      al,0
        out      dx,al
        add      dx,2           ; Base+105h
        mov      al,ah
        and      al,0DFh
        or       al,3           ; Bit 1 = Force Voice to Stop, bit 0 = Stop Status
        out      dx,al          ; stop ...

     ; do this shit twice after a short pause (some bits are self-modif.)

        call     gusDelay

        out      dx,al          ; stop it !!!

        pop      ax dx

        retn
nendp   gus_StopVoice

;*****************************************************************************
;   DoPoll ()
;*****************************************************************************

nproc   gus_DoPoll
        ; nothing to be done here...
        retn
nendp   gus_DoPoll

;*****************************************************************************
;   TickAwaited ()
;*****************************************************************************

nproc   gus_TickAwaited
        clc  ; yes, tick is always awaited for gus...
        retn
nendp   gus_TickAwaited

;-- Other routines (used internally)-----------------------------------------

nproc   gusDelay     ; small delay for about 7 cycles
        push     dx ax
        mov      dx,300h
        in       al,dx   ; (that's just one way of implementing GF1_Delay...)
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        pop      ax dx
        retn
nendp   gusDelay

nproc   gusOutB            ; in: AH = register, AL = data
        push     dx
        mov      dx,cs:gusBase
        add      dx,103h   ; Base+103h
        xchg     al,ah
        out      dx,al
        add      dx,2      ; Base+105h
        xchg     al,ah
        out      dx,al
        pop      dx
        retn
nendp   gusOutB

nproc   gusSetActiveVoices       ; In: AX=no of active voices
        push     ax
        dec      ax
        or       ax,0EC0h  ; ((voices-1) or C0h) to register 0Eh
        call     gusOutB
        pop      ax
        retn
nendp   gusSetActiveVoices

nproc   gusReset   ; in: AX=# of voices
        push     cx dx
        push     ax  ; number of voices (save it)

        mov      ax,4C01h
        call     gusOutB

        call     gusDelay
        call     gusDelay

     ; enable DACs, master reset, no IRQs
        mov      ax,4C07h   ; irq MUST be activated ? if yes: AL=7, no: AL=3
        call     gusOutB

     ; set number of active voices
        pop      ax    ; restore no. of voices (in ax)
        call     gusSetActiveVoices  ; set it

ifdef gus_enable_ramp
ifdef gus_predefined_ramp
        mov      cx,ax            ;*
grl1:   mov      dx,cs:gusBase    ;*
        add      dx,102h          ;*
        mov      al,cl            ;*
        dec      al               ;*     set voice
        out      dx,al            ;*
        out      dx,al            ;*
        out      dx,al            ;*
                                  ;*
        mov      ah,6             ;*
        mov      al,gus_RAMP_RATE ;*     set Volume Ramping Rate
        call     gusOutB          ;*
                                  ;*
        loop     grl1             ;*
endif
endif
        pop      dx cx
        retn
nendp   gusReset

nproc   gusEnableOutput
        push     dx ax
        mov      dx,cs:gusBase
        in       al,dx     ; read mix control register
        and      al,0FDh   ; clear bit 1 = enable output
        out      dx,al
        pop      ax dx
        retn
nendp   gusEnableOutput

nproc   gusDisableOutput
        push     dx ax
        mov      dx,cs:gusBase
        in       al,dx     ; read mix control register
        or       al,02h    ; set bit 1 = disable output
        out      dx,al
        pop      ax dx
        retn
nendp   gusDisableOutput


;


comment $

  The following routine computes all the frequency counters used by GUS for
  correctly sampling the sounds. The freq. counters (FC) are kept into
  FreqTab table (also used by the other DMA mixers). The formula used to
  compute the FC is taken from the GUS SDK:

     divisor  = 1000000/(1.619695497*active_voices) = MixingRate
     FC       = 2 * ((speed_hz shl 9)+(divisor shr 1))/divisor

  Knowing that the frequency in Hz of a sound whose Amiga period is given
  by amiga_period can be computed as:

     speed_hz = 7159090.5/(amiga_period*2)     (NTSC)
     speed_hz = 7093789.2/(amiga_period*2)     (PAL)

  we may then compute the FC value as:

     FC = ... = 1 + 1024*PALNTSC_magic/(2*divisor*amiga_period)

  where 'PALNTSC_magic' is 7159090.5 for NTSC std. and 7093789.2 for PAL std.,
  and 'divisor' is in fact GUS's internal mixing rate, depending on the number
  of active channels (see formula above).

  Of course, all the calculations are done with integers...

$

nproc   gusBuildPeriods

        push     es eax ebx ecx edx si di

        mov      bx,cs:FreqMod              ; PAL(0) or NTSC(1)
        shl      bx,2
        mov      eax,cs:FMod[bx]            ; PALNTSC_magic/2

        mov      dword ptr cs:FreqTab[0],0  ; 0 for period 0

        mov      si,1                     ; start with period 1
        mov      di,4                     ; ... offset 4 in the table
gusse4: push     eax
        xor      edx,edx
        shld     edx,eax,10               ;
        shl      eax,10                   ;  eax:=eax * 1024
        movzx    ecx,cs:cmixspd
        div      ecx                      ;
        xor      edx,edx                  ;  eax := (edx:eax) div MixFreq
        movzx    ecx,si
        div      ecx                      ;  eax := (edx:eax) div AmigaPeriod
        inc      eax                      ;  eax := eax + 1
        mov      cs:FreqTab[di],eax       ;  store it
        pop      eax
        inc      si
        add      di,4
        cmp      si,1800
        jb       gusse4

        pop      di si edx ecx ebx eax es

        retn
nendp   gusBuildPeriods

; dis driver is bullshit  :-(
