/****************************************************************************
 math3d.h, include file for math3d.c, ver 1.0 (08/07/1997)
 ----------------------------------------------------------------------------
 Written by Timur Davidenko (aka Adept/Esteem), 1997.
 Send any comments/suggestions to: adept@aquanet.co.il
 I`ll be glad to see any responses.
 ----------------------------------------------------------------------------
	Usefull 3D geometry routings.
 ----------------------------------------------------------------------------
																 CREDITS
 Huge thanks to follow people that helped me to get it done:
	 Torgeir Hagland (aka Xanthome),VOR,Wog,some others...

 References:
	"Quaternion Calculus and Fast Animation" -  Ken Shoemake,
	Notes for SIGGRAPH'87 course #10,
	"Computer Animation: 3D Motion Specification and Control".
	Graphics Gems sources collection.
 ----------------------------------------------------------------------------
																DISCALIMER
 I can not be held responsible for any damages this source may produce,
 Use it on your own risk.
 You are free to distribute,copy,use and modify this source code with one
 restriction do not distribute modified copy of this source without firstly
 asking me for permission.
****************************************************************************/


typedef	struct	{	// Vector
	float	w,x,y,z;
}		Vector;

typedef	struct	{	// Quaternion
	float	w,x,y,z;
}		Quat;

typedef	struct	{	// Matrix
	float xx,xy,xz;
	float	yx,yy,yz;
	float	zx,zy,zz;
}	Matrix;

//**************************** Quaternions **********************************
extern	void	qset( Quat *q,float w,float x,float y,float z );
extern	void	qscale( Quat q,float s,Quat *dest );	// Scale quaternion by value.
extern	float	qmod( Quat q );	// Returns modul of quaternion
extern	void	qunit( Quat q,Quat *dest );	// Normilize quaternion.
extern	float	qdot( Quat q1, Quat q2 );	// Returns dot product of q1*q2
extern	float	qdotunit( Quat q1, Quat q2 );
extern	void	qmul( Quat q1, Quat q2, Quat *dest );
extern	void	qinv( Quat q, Quat *dest );	//  Multiplicative inverse of q.
extern	void	qnegate( Quat *q );	// Negates q;
extern	void	qexp( Quat q, Quat *dest ); // Calculate quaternion`s exponent.
extern	void	qlog( Quat q, Quat *dest );	// Calculate quaternion`s logarithm.
extern	void	qlndif( Quat p, Quat q, Quat *dest );
extern	void	quat2matrix( Quat q,Matrix *M );
extern	void	quat2inverseMatrix( Quat q,Matrix *M );
extern	void	qAxisAngle2quat( float x,float y,float z,float angle,Quat *q );
extern	void	qAxisAngleDeg2quat( float x,float y,float z,float angle,Quat *q );
extern	void	quat2AngleAxis( Quat q, float *x,float *y,float *z,float *angle );
extern	void	matrix2quat( Matrix *m, Quat *q );
extern	void	qslerp( Quat a,Quat b, Quat *dest, float time,float spin );
extern	void	qslerplong( Quat a,Quat b, Quat *dest, float time,float spin );