  LOCALS
  .386p

b EQU byte ptr
w EQU word ptr
d EQU dword ptr
o EQU offset

dEXE_Header STRUC
    ex_magic       dw ?    ; .exe signature
    ex_Lpage       dw ?    ; .exe file size mod 512 bytes; < 512 bytes
    ex_Fpages      dw ?    ; .exe file size div 512 bytes; + 1 if Lpage > 0
    ex_relocitems  dw ?    ; number of relocation table items
    ex_hdrpara     dw ?    ; .exe header size in 16-byte paragraphs
    ex_minalloc    dw ?    ; min heap required in additional to .exe image
    ex_maxalloc    dw ?    ; extra heap desired beyond that required
                           ; to hold .exe's image
    ex_oss         dw ?    ; displacement of stack segment
    ex_osp         dw ?    ; initial SP register value
    ex_chk_sum     dw ?    ; complemented checksum
    ex_oip         dw ?    ; initial IP register value
    ex_ocs         dw ?    ; displacement of code segment
    ex_ofstbl      dw ?    ; offset to first relocation item
    ex_ovrnum      dw ?    ; overlay numbers
ENDS

Code SEGMENT PUBLIC USE16
  ASSUME CS:Code, DS:Code, SS:Code

;Ŀ;
; Program entry                                                             ;
;;
ORG 100h
Entry:

;*****************************************************************************;
  mov si,80h                    ; beginning of command line

  ; test if command line present
  lodsb
  or al,al
  jnz @@10
    mov dx,o NoCommandLine_MSG
    jmp Error_Exit
  @@10:

  ; scan for first non space
  @@20:
    lodsb
    cmp al,' '
    jz @@20

  ; copy command line into fName buffer
  mov di,o fInName
  @@30:
    stosb
    lodsb
    cmp al,0Dh
    jnz @@30

  ; zero last byte of fName
  mov b [di],0


;*****************************************************************************;
  ; open in file
  mov ax,3D02h
  mov dx,o fInName
  int 21h
  jc FileError_Exit
  mov fInHandle,ax

  ; read header
  mov dx,o EXE_Header
  mov cx,512
  mov bx,ax
  mov ah,3Fh
  int 21h

  ; create out file
  mov ax,3C02h
  mov cx,20h
  mov dx,o fOutName
  int 21h
  jc FileError_Exit
  mov fOutHandle,ax


;*****************************************************************************;
  ; valid header ?

  ; MZ style executable
  cmp EXE_Header.ex_magic,'ZM'
  jnz InvalidHeader_Exit

  ; 512 byte header?
  cmp EXE_Header.ex_hdrpara,20h
  jnz InvalidHeader_Exit

  ; 1 relocatable item?
  cmp EXE_Header.ex_relocitems,1
  jnz InvalidHeader_Exit


;*****************************************************************************;
  ; modify executable header

  ; copy relocatable item
  mov bx,EXE_Header.ex_ofstbl
  mov eax,d EXE_Header+bx
  mov d EXE_Header+1Ch,eax

  ; correct address of relocatable table
  mov EXE_Header.ex_ofstbl,1Ch    ; relocatable item is 32 bits
                                  ; 1Ch+4h = 1Fh  (for 32 byte header)

  ; header size in para is 2
  mov EXE_Header.ex_hdrpara,2

  ; para wanted is para needed + 20h
  mov ax,EXE_Header.ex_minalloc
  add ax,20h
  mov EXE_Header.ex_maxalloc,ax

  ; calculate new executable size
  mov ax,EXE_Header.ex_lpage
  add ax,1Fh                    ; add 31 bytes
  and ax,1FFh                   ; 512 bytes per page
  cmp ax,1Fh                    ; test for lpage overflow
  jbe @@40
    dec EXE_Header.ex_fpages    ; subtract 512 bytes
  @@40:
  inc ax                        ; add 1 byte so that Size=OldSize-512+32
  and ax,1FFh
  mov EXE_Header.ex_lpage,ax


;*****************************************************************************;
  ; write out new header
  mov dx,o EXE_Header
  mov cx,20h
  mov bx,fOutHandle
  mov ah,40h
  int 21h


;*****************************************************************************;
  ; copy executable

  @@FileCopyLoop:
    ; read block
    mov dx,o Disk_Buffer
    mov cx,32768
    mov bx,fInHandle
    mov ah,3Fh
    int 21h

    ; finished?
    or ax,ax
    jz @@FileCopyEnd

    ; write out buffer
    mov dx,o Disk_Buffer
    mov cx,ax
    mov bx,fOutHandle
    mov ah,40h
    int 21h

    jmp @@FileCopyLoop

  @@FileCopyEnd:



;*****************************************************************************;
  ; close both files
  mov bx,fInHandle
  mov ah,3Eh
  int 21h

  mov bx,fOutHandle
  mov ah,3Eh
  int 21h

  ; delete in file
  mov dx,o fInName
  mov ah,41h
  int 21h

  ; rename out file to original file
  mov dx,o fOutName
  mov di,o fInName
  mov ah,56h
  int 21h



;*****************************************************************************;
  ret                         ; terminate


;Ŀ;
; Error Exit                                                                ;
;;
Error_Exit:
  mov ah,9h
  int 21h
  ret


;Ŀ;
; File Error Exit                                                           ;
;;
FileError_Exit:
  mov dx,o FileError_MSG
  jmp Error_Exit


;Ŀ;
; Header is invalid for shrinking                                           ;
;;
InvalidHeader_Exit:
  mov dx,o InvalidHeader_MSG
  jmp Error_Exit



;Ŀ;
; Data                                                                      ;
;;

fOutName db 'header.$$$',0      ; temporary out file
fInName db 256 dup (?)          ; in file

fInHandle dw ?
fOutHandle dw ?

NoCommandLine_MSG LABEL
db 'Executable Header Shrinker.   By Maxwell Sayles.',0Dh,0Ah
db 'For use with small DPMI extender.',0Dh,0Ah,0Ah
db 'Usage:',0Dh,0Ah
db '      EHS filename.EXE',0Dh,0Ah,24h

InvalidHeader_MSG LABEL
db 'Executable header cannot be shrunk to 32 bytes.',0Dh,0Ah,24h

FileError_MSG LABEL
db 'File Error.',0Dh,0Ah,24h


;Ŀ;
; EXE Header                                                                ;
;;
EXE_Header LABEL dEXE_Header
  db 512 dup (?)


;Ŀ;
; Disk buffer for copy                                                      ;
;;
Disk_Buffer db 32768 dup (?)


Code ENDS

  END Entry
