
program Virtual1;
{ Muestra el empleo de una pantalla virtual para elminar el parpadeo }
{ Por: FAC productions }


uses Mode_13, Crt;


procedure Bloque(xpos : word; color : byte; where : word);
{ Dibuja un bloque de 40*40 pxels con su esquina superior izquierda en la
  coordenada (xpos, 10) }

var ypos : word;
begin
     for ypos := 10 to 50 do
         HLine(xpos, xpos+40, ypos, color, where);
end;



var VirtScreen : PTVirtual; { Apuntador a la pantalla virtual }
    VirtSeg, i : word;      { Segmento de la pantalla virtual }

begin
     clrscr;
     writeln;
     writeln('Este programa muestra cmo se reduce el parpadeo con una');
     writeln('pantalla virtual. Lo que se hace es mover un bloque de');
     writeln('tres formas diferentes:');
     writeln;
     writeln(' 1.- Simplemente se borra y se vuelve a dibujar el bloque');
     writeln(' 2.- Se inserta un VRetrace antes de mover el bloque');
     writeln(' 3.- Se dibuja el bloque en una pantalla virtual y luego');
     writeln('     se copia a la pantalla VGA en un retrazado vertical.');
     writeln;
     writeln('...');

     readkey;

     SetupVirtual(VirtScreen, VirtSeg); { Incializa la pantalla virtual }

     SetMode13; { incializa el modo de video }


     { Primera vez: Se dibuja y se borra el bloque }
     for i := 0 to 100 do { hace un ciclo para mover el bloque }
     begin
          Bloque(i*2, 15, VGA); { Dibuja el bloque }
          delay(15);            { Espera un poco }
          Bloque(i*2, 0, VGA);  { Borra el bloque }
     end;


     { Segunda vez: Se mueve el bloque cuando se da el retrazo vertical }
     for i := 0 to 100 do
     begin
          Bloque(i*2, 15, VGA); { Dibuja el bloque }
          VRetrace;             { Espera al retrazado vertical }
          Bloque(i*2, 0, VGA);  { Borra el bloque }
     end;


     { Tercera vez: Se usa una pantalla virtual }

     ClearScreen(0, VirtSeg); { Borra la pantalla virtual }

     for i := 0 to 100 do
     begin
          Bloque(i*2, 15, VirtSeg); { Dibuja el bloque en la p. virtual }
          VRetrace;                 { Espera al retrazado vertical }
          CopyScreen(VirtSeg, VGA); { Copia la p. virtual a la VGA }
          Bloque(i*2, 0, VirtSeg);  { Borra el bloque de la p. virtual }
     end;

     readkey;

     ShutDownVirtual(VirtScreen); { Destruye la pantalla virtual y libera
                                    la memoria que ocupaba. }
     SetTextMode; { regresa al modo texto y termina }
     clrscr;
end.
