
program Scroll1;
{ Programa que muestra cmo hacer el scrolling diagonal en el modo 13.
  Se desplazan dos lneas en cada ciclo para acelerar el efecto.

  Se recomienda ver primero los programas SCROLLV.PAS y SCROLLH.PAS

  Por: FAC productions.
}


uses Mode_13, Crt;

var VirScr : PTVirtual; { Apuntador a la pantalla virtual }
    VirSeg : word;      { Segmento de la pantalla virtual }


procedure DibujaFondo;
{ Dibuja un fondo ajedrezado en la pantalla virtual (sin comentarios) }
var x, y, i : word;
    color : byte;

begin
     color := 1;
     for y := 0 to 7 do
     begin
         for x := 0 to 9 do
         begin
              for i := 0 to 24 do
                  hline(x * 32, x * 32 + 31, y * 25 + i, color, VirSeg);
              inc(color);
              if color > 2 then color := 1;
         end;
         inc(color);
         if color > 2 then color := 1;
     end;
end;


procedure ScrollHaciaArriba;
{ Hace un scroll hacia arriba y mueve las dos lneas superiors
  a la parte inferior de la pantalla }

var buffer : array[0..639] of byte; { buffer temporal para guardar la }
    i : word;                       { lnea superior }

begin
     for i := 0 to 639 do buffer[i] := mem[VirSeg:i]; { Guarda las lneas
                                                        superiores }

     { El bffer ahora es de 640 bytes, ya que son dos lneas las que
       se almacenan en l. (2 * 320 = 640) }

     Move(mem[VirSeg:640], mem[VirSeg:0], 63360); { mueve la pantalla
                                                    una lnea hacia arriba }
     { Ntese que se desplazan nicamente 63360 bytes, eso es porque
       ahora son DOS lneas las que se desplazan, y por lo tanto tenemos
       que mover las otras 198 lneas (200 - 2 = 198) hacia arriba.
       (198 * 320 = 63360 bytes)
     }

     for i := 0 to 639 do mem[VirSeg:63360+i] := buffer[i];
     { copia las lneas superiores a la parte inferior }

     VRetrace; { Espera al retrazado vertical }
     CopyScreen(VirSeg, VGA); { Y copia la pantalla virtual a VGA }
end;


procedure ScrollHaciaAbajo;
{ Hace un scroll hacia abajo y mueve la lnea inferior a la superior }
{ La idea es la misma que en el procedimiento anterior }

var buffer : array[0..639] of byte;
    i : word;

begin
     for i := 0 to 639 do buffer[i] := mem[VirSeg:63360+i];
     Move(mem[VirSeg:0], mem[VirSeg:640], 63360);
     for i := 0 to 639 do mem[VirSeg:i] := buffer[i];
     VRetrace;
     CopyScreen(VirSeg, VGA);
end;



procedure ScrollIzquierda;
{ Hace un scroll hacia la izquierda y mueve las dos lneas de la izquierda
  a la parte derecha de la pantalla }

var buffer : array[0..1, 0..199] of byte; { buffer temporal para guardar las }
    i, j : word;                             { dos lneas de la izquierda }

begin
     for j := 0 to 1 do
         for i := 0 to 199 do buffer[j,i] := mem[VirSeg:i*320 + j];
         { Guarda las lneas de la izquierda }

     Move(mem[VirSeg:2], mem[VirSeg:0], 63998); { mueve la pantalla
                                                  dos lneas hacia la izq. }

     for j := 0 to 1 do
         for i := 0 to 199 do mem[VirSeg:i*320+318+j] := buffer[j,i];
     { copia la lneas de la izquierda a la derecha }

     VRetrace; { Espera al retrazado vertical }
     CopyScreen(VirSeg, VGA); { Y copia la pantalla virtual a VGA }
end;


procedure ScrollDerecha;
{ Hace un scroll hacia la derecha y mueve dos lneas de la derecha a la izq. }
{ La idea es la misma que en el procedimiento anterior }

var buffer : array[0..1, 0..199] of byte;
    i, j  : word;

begin
     for j := 0 to 1 do
         for i := 0 to 199 do buffer[j,i] := mem[VirSeg:i*320+318+j];
     Move(mem[VirSeg:0], mem[VirSeg:2], 63998);
     for j := 0 to 1 do
         for i := 0 to 199 do mem[VirSeg:i*320+j] := buffer[j,i];
     VRetrace;
     CopyScreen(VirSeg, VGA);
end;


var dir : byte; { Direccin del desplazamiento }
    key : char; { Tecla oprimida }


begin
     clrscr;
     writeln;
     writeln(' Programa de ejemplo de scroll de pantalla completa.');
     writeln;
     writeln(' El programa dibuja un fondo ajedrezado y luego hace un scroll');
     writeln(' de pantalla completa en diagonal.');
     writeln;
     writeln(' Adems, se acelera el proceso desplazando dos lneas a la vez.');
     writeln;
     writeln(' La direccin del desplazamiento se cambia al oprimir una tecla.');
     writeln(' Para salir del programa hay que oprimir ESC.');
     writeln;
     writeln(' Oprime una tecla...');
     readkey;


     SetupVirtual(VirScr, VirSeg); { inicializamos la pantalla virtual }

     DibujaFondo; { dibujamos el fondo ajedrezado (en la pantalla virtual) }

     SetMode13; { iniciamos el modo grfico }

     while keypressed do readkey; { Esto sirve para borrar el buffer
                                    del teclado (por si se haba oprimido
                                    alguna tecla) }

     dir := 0;
     key := ' ';

     while key <> #27 do { mientras no se oprima ESC, hacer lo siguiente: }
     begin
          case dir of
               0 : begin
                        ScrollHaciaAbajo;
                        ScrollDerecha;
                   end;
               1 : begin
                        ScrollHaciaArriba;
                        ScrollDerecha;
                   end;
               2 : begin
                        ScrollHaciaArriba;
                        ScrollIzquierda;
                   end;
               3 : begin
                        ScrollHaciaAbajo;
                        ScrollIzquierda;
                   end;
          end;

          if keypressed then { Si se oprime una tecla, entonces: }
          begin
               key := readkey; { Leemos y almacenamos esa tecla. }
               inc(dir);       { y cambiamos la direccin de movimiento }
               if dir > 3 then dir := 0;
          end;
     end;

     SetTextMode; { regresa al modo texto }
     ShutDownVirtual(VirScr); { y libera la memoria de la pantalla virtual }
     clrscr;
end.