
program TostadorShow;

{
        Ejemplo de animacin simple por cuadros
        por: FAC '97

        Versin con ensamblador (solamente la rutina de dibujo)

        Tostadores animados por FAC
        Fondo con nubes.... hmmm... creo que viene con el 3D Studio
}

uses Crt, Mode13; { <--- HEY! Estrenando unidad nueva! }
     { Prueben usando la vieja unidad Mode_13 y vern el cambio
       en velocidad que se obtiene con ensamblador y 32 bits }

const CambiaCuadro = 100; { Indica cada cuando se pasa al siguiente
                            cuadro de la animacin. Ajustar hasta obtener
                            la velocidad deseada. }
      NumSprites = 10; { Nmero de sprites en la pantalla al mismo tiempo }

type PToastPic = ^ToastPic; { Apuntador a imagen del tostador }

     ToastPic = array[0..27, 0..37] of byte;
     { Las imgenes de tostadores son de 38 * 28 pxels, as que las
       almacenamos en un arreglo de 28 * 38. Esto es para poder dibujar
       cada lnea horizontal ms rpidamente, ya que solo necesitamos
       calcular Y * 320 una vez por lnea }

     TSprite = record { datos de cada sprite }
                     x, y : integer; { coordenadas del sprite }
                     cuadro : byte;  { nmero de cuadro a dibujar }
                     velocidad : byte; { velocidad de cuadros }
                     cont : word; { contador para cambiar de cuadro }
                     velx, vely : integer; { velocidad de movimiento }
               end;


var Tostador : array[0..3] of PToastPic; { arreglo para 4 cuadros diferentes }
    Sprite : array[1..NumSprites] of TSprite; { arreglo de "sprites" }


procedure CargaImagenes;
{ Este procedimiento lee las imgenes de los tostadores desde el disco }
var x, y, i : integer;
    tempScr : PTVirtual; { pantalla virtual temporal }
    tempSeg : word;      { segmento de la p.v. temporal }
    tempPal : TPalette;  { paleta temporal (para almacenar basura) }
begin
     SetupVirtual(tempScr, tempSeg);
     for i := 0 to 3 do
     begin
          Tostador[i] := new(PToastPic);
          LoadPCX('toast'+chr(i+49)+'.pcx', tempSeg, 38, 28, 0, 0, tempPal);
          for y := 0 to 27 do
              for x := 0 to 37 do
                  Tostador[i]^[y, x] := GetPixel(x, y, tempSeg);
     end;
     { Lee el archivo 'toast?.pcx' donde ? es un nmero que va de 1 a 4
       y almacena la imagen en el arreglo Tostador[? - 1]^  }
     ShutDownVirtual(tempScr); { Libera la memoria de la p.v. }
end;


procedure DibujaTostadores(where : word);
var i : byte;
    spr : TSprite;
    cuadro : PToastPic;
begin
     for i := 1 to NumSprites do   { para cada sprite... }
     begin
          spr := Sprite[i];
          cuadro := Tostador[spr.cuadro];
          asm
             mov es, where
             mov bx, spr.y
             mov di, spr.x
             add bx, bx
             mov ax, word ptr [cuadro + 2]
             mov si, word ptr [cuadro]
             mov ch, 28
             add di, word ptr [YOffset + bx]
             push ds
             mov ds, ax

             @loopy:  mov cl, 38

             @loopx:  mov al, [si]
                      test al, $FF
                      jz @jump
                      mov es:[di], al

             @jump:   inc di
                      inc si
                      dec cl
                      jnz @loopx
                      add di, 282
                      dec ch
                      jnz @loopy
                      pop ds
          end;
     end;
end;

procedure MueveTostadores;
var i : byte;
begin
     for i := 1 to NumSprites do { para cada tostador... }
         with Sprite[i] do
         begin
              inc(cont, velocidad); { incrementamos el contador }
              if cont > CambiaCuadro then
              begin
              { si se pasa del valor de cambio, entonces... }
                   cont := 0;  { reseteamos el contador }
                   cuadro := (cuadro + 1) mod 4;
                   { y cambiamos al siguiente cuadro }
         { *** Ntese que:   cuadro := (cuadro + 1) mod 4
               nos da la secuencia 0, 1, 2, 3, 0, 1, 2, 3, 0, ...    }
              end;
              inc(x, velx); { modificamos la posicin en X }
              inc(y, vely); { modificamos la posicin en Y }
              if (x < 0) or (y > 176) then { y si se sale de la pantalla... }
              begin
                   y := 0; { Lo mandamos a la parte superior }
                   x := random(160) + 120; { con una X al azar }
              end;
         end;
end;

procedure IniciaTostadores;
var i : byte;
begin
     randomize;  { generamos una nueva semilla para nmeros aleatorios }
     for i := 1 to NumSprites do { y para cada sprite... }
         with Sprite[i] do
         begin
              x := random(160) + 120; { Obtenemos sus coordenadas al azar }
              y := random(170);       { pero que quede dentro de la pantalla }
              cuadro := random(4); { Elegimos el cuadro inicial al azar }
              cont := 0;    { Iniciamos el contador a cero }
              velocidad := (i mod 10) + 10; { Fijamos su velocidad de animacin }
              velx := -(i mod 2) - 1; { y su velocidad en X y en Y }
              vely := random(3) + 1;
         end;
end;


procedure DesechaTostadores;
{ Este procedimiento libera la memoria ocupada por las imgenes de
  los tostadores }
var i : byte;
begin
     for i := 0 to 3 do dispose(Tostador[i]);
end;


{ *** PROGRAMA PRINCIPAL *** }

var FondoScr, VirScr : PTVirtual; { Necesitamos 2 pantallas virtuales }
    FondoSeg, VirSeg : word;      { y sus segmentos correspondientes }
    pal : TPalette;     { Para almacenar la paleta }

begin
     clrscr;
     writeln;
     writeln('Ejemplo de animacin bsica por cuadros.');
     writeln;
     writeln('El programa utiliza dos pantallas virtuales, una para guardar');
     writeln('la imagen de fondo y otra para la construccin de la pantalla');
     writeln('final, la cual se copia a la VGA.');
     writeln;
     writeln('Se presenta una sencilla animacin de 4 cuadros. (El clsico');
     writeln('de los tostadores voladores) mostrando ', NumSprites, ' "sprites" al mismo');
     writeln('tiempo sobre un fondo esttico.');
     writeln;
     writeln('Presiona una tecla para continuar...');
     readkey;

     clrscr;
     writeln;
     writeln(' Iniciando datos de sprites');
     IniciaTostadores;

     writeln(' Cargando imgenes de sprites');
     CargaImagenes;

     writeln(' Cargando imagen de fondo');
     SetupVirtual(FondoScr, FondoSeg);
     SetupVirtual(VirScr, VirSeg);
     LoadPCX('sky.pcx', FondoSeg, 320, 200, 0, 0, pal);

     SetMode13;
     SetPalette(pal); { No olvidemos activar la paleta de la imagen }

     while not keypressed do { Mientras no se presione una tecla... }
     begin
          CopyScreen(FondoSeg, VirSeg);
          { Copiamos el fondo a la pantalla virtual }
          DibujaTostadores(VirSeg);
          { Dibujamos los tostadores en la pantalla virtual }
          VRetrace;
          { Esperamos al retrazado vertical para evitar temblores }
          CopyScreen(VirSeg, VGA);
          { Copiamos la pantalla virtual a la VGA }
          MueveTostadores;
          { Y cambiamos la posicin de cada tostador }
     end;
     readkey; { leemos y desechamos la tecla oprimida }
     FadeOut(0);

     SetTextMode; { Regresamos al modo texto y liberamos la memoria }
     DesechaTostadores;
     ShutDownVirtual(FondoScr);
     ShutDownVirtual(VirScr);
end.
