
// Programa PALETA3.PAS
// por FAC

// Este programa corresponde al segundo tutorial de grficos FAC

// Ejemplo de cmo usar la rotacin de paleta para obtener efecto de
// movimiento.


#include <iostream.h>    // cout
#include <conio.h>       // clrscr, getch
#include <stdlib.h>      // randomize, random
#include <math.h>        // sin
#include "mode13.h"
#include "mode13.cpp"

TPalette paleta;

void VLine(word x, word y1, word y2, byte color, word where)
{
     for (word i = y1; i <= y2; i++) PutPixel(x, i, color, where);
}

void DibujaTunel()
{
     word x, y;
     byte color, flag;

     color = 1;
     flag = 0;

     for (x = 9; x < 160; x++)
     {
          y = (int)(x / 3) + 6;
          VLine(160 - x, 140 - y, 140 + y, color, VGA);
          VLine(160 + x, 140 - y, 140 + y, color, VGA);
          HLine(160 - x, 160 + x, 140 + y, color, VGA);

          if ((++flag) > (x / 16))
          {
               color++;
               flag = 0;
          }
     }
}


void DibujaBarra()
{
     word i, j, pos;

     for (i = 0; i < 40; i++)
     {
          pos = i * 8;
          for (j = 0; j < 7; j++)
          {
               PutPixel(pos + j, 10, i + 161, VGA);
               PutPixel(pos + j, 11, i + 161, VGA);
               PutPixel(pos + j, 13, 200 - i, VGA);
               PutPixel(pos + j, 14, 200 - i, VGA);
          }
     }
}


void DibujaArbol()
{
     word i, j, x, y;

     for (i = 1; i <= 20; i++)
     {
          x = 160;
          y = 100;
          for (j = 1; j <= 40; j++)
          {
               PutPixel(x, y, 200 + j, VGA);
               x += random(7) - 3;
               y--;
               if (j > (42 - i)) y += 2;
          }
     }
}


void HacerPaleta()
{
     byte i, cambio;

     paleta[0][0] = paleta[0][1] = paleta[0][2] = 0;

     for (i = 1; i <= 160; i++)
     {
          cambio = i % 3;
          if (!cambio) cambio = 2;

          paleta[i][0] = paleta[i][1] = 0;
          paleta[i][2] = 63;

          paleta[i][cambio] = (byte)(sin(i * 3.14159265 / 80) * 24) + 38;
     }

     for (i = 161; i <= 200; i++)
     {
          paleta[i][0] = 8;
          paleta[i][1] = paleta[i][2] = 0;
     }

     paleta[180][0] = paleta[180][1] = 63;
     paleta[200][0] = 63;

     for (i = 201; i <= 240; i++)
         paleta[i][0] = paleta[i][1] = paleta[i][2] = 0;

     for (i = 1; i <= 8; i++)
         paleta[200 + i][1] = i * 8 - 1;
}


void main()
{
     clrscr();
     cout << "\nEste programa muestra los efectos que se pueden obtener\n"
          << "con la simple rotacin de la paleta de colores.\n"
          << "\nNingn pxel ha tenido que ser redibujado para obtener\n"
          << "las animaciones.\n"
          << "\nOprime cualquier tecla para continuar...\n";
     getch();

     randomize();

     SetMode13();
     HacerPaleta();
     SetPalette(paleta);
     DibujaTunel();
     DibujaBarra();
     DibujaArbol();

     while (!kbhit())
     {
          RotatePalette(paleta, 1, 160);
          RotatePalette(paleta, 161, 200);
          RotatePalette(paleta, 201, 240);

          VRetrace();
          SetPalette(paleta);
          delay(60);
     }

     SetTextMode();
}
